/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceRequest extends EcsRequest implements
        ToCopyableBuilder<CreateServiceRequest.Builder, CreateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::taskDefinition)).setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .getter(getter(CreateServiceRequest::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .getter(getter(CreateServiceRequest::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateServiceRequest::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateServiceRequest::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .getter(getter(CreateServiceRequest::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .getter(getter(CreateServiceRequest::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CreateServiceRequest::networkConfiguration))
            .setter(setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateServiceRequest::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::schedulingStrategyAsString)).setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build())
            .build();

    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField
            .<DeploymentController> builder(MarshallingType.SDK_POJO).getter(getter(CreateServiceRequest::deploymentController))
            .setter(setter(Builder::deploymentController)).constructor(DeploymentController::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateServiceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateServiceRequest::enableECSManagedTags)).setter(setter(Builder::enableECSManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build())
            .build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::propagateTagsAsString)).setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            SERVICE_NAME_FIELD, TASK_DEFINITION_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, DESIRED_COUNT_FIELD,
            CLIENT_TOKEN_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, ROLE_FIELD, DEPLOYMENT_CONFIGURATION_FIELD,
            PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD,
            ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD));

    private final String cluster;

    private final String serviceName;

    private final String taskDefinition;

    private final List<LoadBalancer> loadBalancers;

    private final List<ServiceRegistry> serviceRegistries;

    private final Integer desiredCount;

    private final String clientToken;

    private final String launchType;

    private final String platformVersion;

    private final String role;

    private final DeploymentConfiguration deploymentConfiguration;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final NetworkConfiguration networkConfiguration;

    private final Integer healthCheckGracePeriodSeconds;

    private final String schedulingStrategy;

    private final DeploymentController deploymentController;

    private final List<Tag> tags;

    private final Boolean enableECSManagedTags;

    private final String propagateTags;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.taskDefinition = builder.taskDefinition;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.desiredCount = builder.desiredCount;
        this.clientToken = builder.clientToken;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.role = builder.role;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service. If you do not
     * specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service. If you do
     *         not specify a cluster, the default cluster is assumed.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are
     * allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple
     * clusters within a Region or across multiple Regions.
     * </p>
     * 
     * @return The name of your service. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores
     *         are allowed. Service names must be unique within a cluster, but you can have similarly named services in
     *         multiple clusters within a Region or across multiple Regions.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     * definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code>
     * revision is used.
     * </p>
     * 
     * @return The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     *         definition to run in your service. If a <code>revision</code> is not specified, the latest
     *         <code>ACTIVE</code> revision is used.
     */
    public String taskDefinition() {
        return taskDefinition;
    }

    /**
     * <p>
     * A load balancer object representing the load balancer to use with your service.
     * </p>
     * <p>
     * If the service is using the <code>ECS</code> deployment controller, you are limited to one load balancer or
     * target group.
     * </p>
     * <p>
     * If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either
     * an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy deployment group, you
     * specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, AWS CodeDeploy
     * determines which task set in your service has the status <code>PRIMARY</code> and associates one target group
     * with it, and then associates the other target group with the replacement task set. The load balancer can also
     * have up to two listeners: a required listener for production traffic and an optional listener that allows you
     * perform validation tests with Lambda functions before routing production traffic to it.
     * </p>
     * <p>
     * After you create a service using the <code>ECS</code> deployment controller, the load balancer name or target
     * group ARN, container name, and container port specified in the service definition are immutable. If you are using
     * the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the service.
     * </p>
     * <p>
     * For Classic Load Balancers, this object must contain the load balancer name, the container name (as it appears in
     * a container definition), and the container port to access from the load balancer. When a task from this service
     * is placed on a container instance, the container instance is registered with the load balancer specified here.
     * </p>
     * <p>
     * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
     * group ARN, the container name (as it appears in a container definition), and the container port to access from
     * the load balancer. When a task from this service is placed on a container instance, the container instance and
     * port combination is registered as a target in the target group specified here.
     * </p>
     * <p>
     * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
     * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not
     * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
     * target type, not <code>instance</code>, because tasks that use the <code>awsvpc</code> network mode are
     * associated with an elastic network interface, not an Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A load balancer object representing the load balancer to use with your service.</p>
     *         <p>
     *         If the service is using the <code>ECS</code> deployment controller, you are limited to one load balancer
     *         or target group.
     *         </p>
     *         <p>
     *         If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to
     *         use either an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy
     *         deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a
     *         deployment, AWS CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>
     *         and associates one target group with it, and then associates the other target group with the replacement
     *         task set. The load balancer can also have up to two listeners: a required listener for production traffic
     *         and an optional listener that allows you perform validation tests with Lambda functions before routing
     *         production traffic to it.
     *         </p>
     *         <p>
     *         After you create a service using the <code>ECS</code> deployment controller, the load balancer name or
     *         target group ARN, container name, and container port specified in the service definition are immutable.
     *         If you are using the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when
     *         updating the service.
     *         </p>
     *         <p>
     *         For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
     *         appears in a container definition), and the container port to access from the load balancer. When a task
     *         from this service is placed on a container instance, the container instance is registered with the load
     *         balancer specified here.
     *         </p>
     *         <p>
     *         For Application Load Balancers and Network Load Balancers, this object must contain the load balancer
     *         target group ARN, the container name (as it appears in a container definition), and the container port to
     *         access from the load balancer. When a task from this service is placed on a container instance, the
     *         container instance and port combination is registered as a target in the target group specified here.
     *         </p>
     *         <p>
     *         Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate
     *         launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers
     *         are not supported. Also, when you create any target groups for these services, you must choose
     *         <code>ip</code> as the target type, not <code>instance</code>, because tasks that use the
     *         <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2
     *         instance.
     */
    public List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * <p>
     * The details of the service discovery registries to assign to this service. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.
     * </p>
     * <note>
     * <p>
     * Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later. For more
     * information, see <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS
     * Fargate Platform Versions</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details of the service discovery registries to assign to this service. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         Discovery</a>.</p> <note>
     *         <p>
     *         Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
     *         Platform Versions</a>.
     *         </p>
     */
    public List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The number of instantiations of the specified task definition to place and keep running on your cluster.
     * </p>
     * 
     * @return The number of instantiations of the specified task definition to place and keep running on your cluster.
     */
    public Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32 ASCII
     * characters are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32
     *         ASCII characters are allowed.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The launch type on which to run your service. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type on which to run your service. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
     *         Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */
    public LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type on which to run your service. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type on which to run your service. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
     *         Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */
    public String launchTypeAsString() {
        return launchType;
    }

    /**
     * <p>
     * The platform version on which your tasks in the service are running. A platform version is only specified for
     * tasks using the Fargate launch type. If one is not specified, the <code>LATEST</code> platform version is used by
     * default. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version on which your tasks in the service are running. A platform version is only specified
     *         for tasks using the Fargate launch type. If one is not specified, the <code>LATEST</code> platform
     *         version is used by default. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load
     * balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and
     * your task definition does not use the <code>awsvpc</code> network mode. If you specify the <code>role</code>
     * parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.
     * </p>
     * <important>
     * <p>
     * If your account has already created the Amazon ECS service-linked role, that role is used by default for your
     * service unless you specify a role here. The service-linked role is required if your task definition uses the
     * <code>awsvpc</code> network mode, in which case you should not specify a role here. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     * Service-Linked Roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this
     * is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has
     * a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
     * >Friendly Names and Paths</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your
     *         load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your
     *         service and your task definition does not use the <code>awsvpc</code> network mode. If you specify the
     *         <code>role</code> parameter, you must also specify a load balancer object with the
     *         <code>loadBalancers</code> parameter.</p> <important>
     *         <p>
     *         If your account has already created the Amazon ECS service-linked role, that role is used by default for
     *         your service unless you specify a role here. The service-linked role is required if your task definition
     *         uses the <code>awsvpc</code> network mode, in which case you should not specify a role here. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     *         Service-Linked Roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         If your specified role has a path other than <code>/</code>, then you must either specify the full role
     *         ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name
     *         <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the
     *         role name. For more information, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
     *         >Friendly Names and Paths</a> in the <i>IAM User Guide</i>.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.
     */
    public DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
     * constraints per task (this limit includes constraints in the task definition and those specified at runtime).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of placement constraint objects to use for tasks in your service. You can specify a maximum of
     *         10 constraints per task (this limit includes constraints in the task definition and those specified at
     *         runtime).
     */
    public List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * <p>
     * The placement strategy objects to use for tasks in your service. You can specify a maximum of five strategy rules
     * per service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The placement strategy objects to use for tasks in your service. You can specify a maximum of five
     *         strategy rules per service.
     */
    public List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The network configuration for the service. This parameter is required for task definitions that use the
     * <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for
     * other network modes. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
     * <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The network configuration for the service. This parameter is required for task definitions that use the
     *         <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported
     *         for other network modes. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
     *         Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic Load
     * Balancing target health checks after a task has first started. This is only valid if your service is configured
     * to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing
     * health checks, you can specify a health check grace period of up to 7,200 seconds. During that time, the ECS
     * service scheduler ignores health check status. This grace period can prevent the ECS service scheduler from
     * marking tasks as unhealthy and stopping them before they have time to come up.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic
     *         Load Balancing target health checks after a task has first started. This is only valid if your service is
     *         configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic
     *         Load Balancing health checks, you can specify a health check grace period of up to 7,200 seconds. During
     *         that time, the ECS service scheduler ignores health check status. This grace period can prevent the ECS
     *         service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
     */
    public Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions. This scheduler strategy is required if using
     * the <code>CODE_DEPLOY</code> deployment controller.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
     * that meets all of the task placement constraints that you specify in your cluster. When you are using this
     * strategy, there is no need to specify a desired number of tasks, a task placement strategy, or use Service Auto
     * Scaling policies.
     * </p>
     * <note>
     * <p>
     * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not support the
     * <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions. This scheduler
     *         strategy is required if using the <code>CODE_DEPLOY</code> deployment controller.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
     *         instance that meets all of the task placement constraints that you specify in your cluster. When you are
     *         using this strategy, there is no need to specify a desired number of tasks, a task placement strategy, or
     *         use Service Auto Scaling policies.
     *         </p>
     *         <note>
     *         <p>
     *         Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not support
     *         the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions. This scheduler strategy is required if using
     * the <code>CODE_DEPLOY</code> deployment controller.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
     * that meets all of the task placement constraints that you specify in your cluster. When you are using this
     * strategy, there is no need to specify a desired number of tasks, a task placement strategy, or use Service Auto
     * Scaling policies.
     * </p>
     * <note>
     * <p>
     * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not support the
     * <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions. This scheduler
     *         strategy is required if using the <code>CODE_DEPLOY</code> deployment controller.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
     *         instance that meets all of the task placement constraints that you specify in your cluster. When you are
     *         using this strategy, there is no need to specify a desired number of tasks, a task placement strategy, or
     *         use Service Auto Scaling policies.
     *         </p>
     *         <note>
     *         <p>
     *         Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not support
     *         the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The deployment controller to use for the service.
     * </p>
     * 
     * @return The deployment controller to use for the service.
     */
    public DeploymentController deploymentController() {
        return deploymentController;
    }

    /**
     * <p>
     * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key
     * and an optional value, both of which you define. When a service is deleted, the tags are deleted as well. Tag
     * keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256
     * characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metadata that you apply to the service to help you categorize and organize them. Each tag consists of
     *         a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as
     *         well. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum
     *         length of 256 characters.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For more information, see
     * <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
     * Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon
     *         ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public Boolean enableECSManagedTags() {
        return enableECSManagedTags;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the task definition or the service to the tasks. If no value is
     * specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during
     * service creation. To add tags to a task after service creation, use the <a>TagResource</a> API action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the task definition or the service to the tasks. If no value
     *         is specified, the tags are not propagated. Tags can only be propagated to the tasks within the service
     *         during service creation. To add tags to a task after service creation, use the <a>TagResource</a> API
     *         action.
     * @see PropagateTags
     */
    public PropagateTags propagateTags() {
        return PropagateTags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the task definition or the service to the tasks. If no value is
     * specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during
     * service creation. To add tags to a task after service creation, use the <a>TagResource</a> API action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the task definition or the service to the tasks. If no value
     *         is specified, the tags are not propagated. Tags can only be propagated to the tasks within the service
     *         during service creation. To add tags to a task after service creation, use the <a>TagResource</a> API
     *         action.
     * @see PropagateTags
     */
    public String propagateTagsAsString() {
        return propagateTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRegistries());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(placementStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && Objects.equals(loadBalancers(), other.loadBalancers())
                && Objects.equals(serviceRegistries(), other.serviceRegistries())
                && Objects.equals(desiredCount(), other.desiredCount()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && Objects.equals(platformVersion(), other.platformVersion()) && Objects.equals(role(), other.role())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString())
                && Objects.equals(deploymentController(), other.deploymentController()) && Objects.equals(tags(), other.tags())
                && Objects.equals(enableECSManagedTags(), other.enableECSManagedTags())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateServiceRequest").add("Cluster", cluster()).add("ServiceName", serviceName())
                .add("TaskDefinition", taskDefinition()).add("LoadBalancers", loadBalancers())
                .add("ServiceRegistries", serviceRegistries()).add("DesiredCount", desiredCount())
                .add("ClientToken", clientToken()).add("LaunchType", launchTypeAsString())
                .add("PlatformVersion", platformVersion()).add("Role", role())
                .add("DeploymentConfiguration", deploymentConfiguration()).add("PlacementConstraints", placementConstraints())
                .add("PlacementStrategy", placementStrategy()).add("NetworkConfiguration", networkConfiguration())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds())
                .add("SchedulingStrategy", schedulingStrategyAsString()).add("DeploymentController", deploymentController())
                .add("Tags", tags()).add("EnableECSManagedTags", enableECSManagedTags())
                .add("PropagateTags", propagateTagsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "role":
            return Optional.ofNullable(clazz.cast(role()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "schedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        case "deploymentController":
            return Optional.ofNullable(clazz.cast(deploymentController()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "enableECSManagedTags":
            return Optional.ofNullable(clazz.cast(enableECSManagedTags()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service. If you do not
         * specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service. If you
         *        do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are
         * allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple
         * clusters within a Region or across multiple Regions.
         * </p>
         * 
         * @param serviceName
         *        The name of your service. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and
         *        underscores are allowed. Service names must be unique within a cluster, but you can have similarly
         *        named services in multiple clusters within a Region or across multiple Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
         * definition to run in your service. If a <code>revision</code> is not specified, the latest
         * <code>ACTIVE</code> revision is used.
         * </p>
         * 
         * @param taskDefinition
         *        The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the
         *        task definition to run in your service. If a <code>revision</code> is not specified, the latest
         *        <code>ACTIVE</code> revision is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * A load balancer object representing the load balancer to use with your service.
         * </p>
         * <p>
         * If the service is using the <code>ECS</code> deployment controller, you are limited to one load balancer or
         * target group.
         * </p>
         * <p>
         * If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to use
         * either an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy deployment
         * group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment,
         * AWS CodeDeploy determines which task set in your service has the status <code>PRIMARY</code> and associates
         * one target group with it, and then associates the other target group with the replacement task set. The load
         * balancer can also have up to two listeners: a required listener for production traffic and an optional
         * listener that allows you perform validation tests with Lambda functions before routing production traffic to
         * it.
         * </p>
         * <p>
         * After you create a service using the <code>ECS</code> deployment controller, the load balancer name or target
         * group ARN, container name, and container port specified in the service definition are immutable. If you are
         * using the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
         * service.
         * </p>
         * <p>
         * For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
         * appears in a container definition), and the container port to access from the load balancer. When a task from
         * this service is placed on a container instance, the container instance is registered with the load balancer
         * specified here.
         * </p>
         * <p>
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
         * group ARN, the container name (as it appears in a container definition), and the container port to access
         * from the load balancer. When a task from this service is placed on a container instance, the container
         * instance and port combination is registered as a target in the target group specified here.
         * </p>
         * <p>
         * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
         * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not
         * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
         * target type, not <code>instance</code>, because tasks that use the <code>awsvpc</code> network mode are
         * associated with an elastic network interface, not an Amazon EC2 instance.
         * </p>
         * 
         * @param loadBalancers
         *        A load balancer object representing the load balancer to use with your service.</p>
         *        <p>
         *        If the service is using the <code>ECS</code> deployment controller, you are limited to one load
         *        balancer or target group.
         *        </p>
         *        <p>
         *        If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to
         *        use either an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy
         *        deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code>).
         *        During a deployment, AWS CodeDeploy determines which task set in your service has the status
         *        <code>PRIMARY</code> and associates one target group with it, and then associates the other target
         *        group with the replacement task set. The load balancer can also have up to two listeners: a required
         *        listener for production traffic and an optional listener that allows you perform validation tests with
         *        Lambda functions before routing production traffic to it.
         *        </p>
         *        <p>
         *        After you create a service using the <code>ECS</code> deployment controller, the load balancer name or
         *        target group ARN, container name, and container port specified in the service definition are
         *        immutable. If you are using the <code>CODE_DEPLOY</code> deployment controller, these values can be
         *        changed when updating the service.
         *        </p>
         *        <p>
         *        For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
         *        appears in a container definition), and the container port to access from the load balancer. When a
         *        task from this service is placed on a container instance, the container instance is registered with
         *        the load balancer specified here.
         *        </p>
         *        <p>
         *        For Application Load Balancers and Network Load Balancers, this object must contain the load balancer
         *        target group ARN, the container name (as it appears in a container definition), and the container port
         *        to access from the load balancer. When a task from this service is placed on a container instance, the
         *        container instance and port combination is registered as a target in the target group specified here.
         *        </p>
         *        <p>
         *        Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate
         *        launch type) only support Application Load Balancers and Network Load Balancers. Classic Load
         *        Balancers are not supported. Also, when you create any target groups for these services, you must
         *        choose <code>ip</code> as the target type, not <code>instance</code>, because tasks that use the
         *        <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * A load balancer object representing the load balancer to use with your service.
         * </p>
         * <p>
         * If the service is using the <code>ECS</code> deployment controller, you are limited to one load balancer or
         * target group.
         * </p>
         * <p>
         * If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to use
         * either an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy deployment
         * group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment,
         * AWS CodeDeploy determines which task set in your service has the status <code>PRIMARY</code> and associates
         * one target group with it, and then associates the other target group with the replacement task set. The load
         * balancer can also have up to two listeners: a required listener for production traffic and an optional
         * listener that allows you perform validation tests with Lambda functions before routing production traffic to
         * it.
         * </p>
         * <p>
         * After you create a service using the <code>ECS</code> deployment controller, the load balancer name or target
         * group ARN, container name, and container port specified in the service definition are immutable. If you are
         * using the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
         * service.
         * </p>
         * <p>
         * For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
         * appears in a container definition), and the container port to access from the load balancer. When a task from
         * this service is placed on a container instance, the container instance is registered with the load balancer
         * specified here.
         * </p>
         * <p>
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
         * group ARN, the container name (as it appears in a container definition), and the container port to access
         * from the load balancer. When a task from this service is placed on a container instance, the container
         * instance and port combination is registered as a target in the target group specified here.
         * </p>
         * <p>
         * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
         * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not
         * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
         * target type, not <code>instance</code>, because tasks that use the <code>awsvpc</code> network mode are
         * associated with an elastic network interface, not an Amazon EC2 instance.
         * </p>
         * 
         * @param loadBalancers
         *        A load balancer object representing the load balancer to use with your service.</p>
         *        <p>
         *        If the service is using the <code>ECS</code> deployment controller, you are limited to one load
         *        balancer or target group.
         *        </p>
         *        <p>
         *        If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to
         *        use either an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy
         *        deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code>).
         *        During a deployment, AWS CodeDeploy determines which task set in your service has the status
         *        <code>PRIMARY</code> and associates one target group with it, and then associates the other target
         *        group with the replacement task set. The load balancer can also have up to two listeners: a required
         *        listener for production traffic and an optional listener that allows you perform validation tests with
         *        Lambda functions before routing production traffic to it.
         *        </p>
         *        <p>
         *        After you create a service using the <code>ECS</code> deployment controller, the load balancer name or
         *        target group ARN, container name, and container port specified in the service definition are
         *        immutable. If you are using the <code>CODE_DEPLOY</code> deployment controller, these values can be
         *        changed when updating the service.
         *        </p>
         *        <p>
         *        For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
         *        appears in a container definition), and the container port to access from the load balancer. When a
         *        task from this service is placed on a container instance, the container instance is registered with
         *        the load balancer specified here.
         *        </p>
         *        <p>
         *        For Application Load Balancers and Network Load Balancers, this object must contain the load balancer
         *        target group ARN, the container name (as it appears in a container definition), and the container port
         *        to access from the load balancer. When a task from this service is placed on a container instance, the
         *        container instance and port combination is registered as a target in the target group specified here.
         *        </p>
         *        <p>
         *        Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate
         *        launch type) only support Application Load Balancers and Network Load Balancers. Classic Load
         *        Balancers are not supported. Also, when you create any target groups for these services, you must
         *        choose <code>ip</code> as the target type, not <code>instance</code>, because tasks that use the
         *        <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * A load balancer object representing the load balancer to use with your service.
         * </p>
         * <p>
         * If the service is using the <code>ECS</code> deployment controller, you are limited to one load balancer or
         * target group.
         * </p>
         * <p>
         * If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to use
         * either an Application Load Balancer or Network Load Balancer. When creating an AWS CodeDeploy deployment
         * group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment,
         * AWS CodeDeploy determines which task set in your service has the status <code>PRIMARY</code> and associates
         * one target group with it, and then associates the other target group with the replacement task set. The load
         * balancer can also have up to two listeners: a required listener for production traffic and an optional
         * listener that allows you perform validation tests with Lambda functions before routing production traffic to
         * it.
         * </p>
         * <p>
         * After you create a service using the <code>ECS</code> deployment controller, the load balancer name or target
         * group ARN, container name, and container port specified in the service definition are immutable. If you are
         * using the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
         * service.
         * </p>
         * <p>
         * For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
         * appears in a container definition), and the container port to access from the load balancer. When a task from
         * this service is placed on a container instance, the container instance is registered with the load balancer
         * specified here.
         * </p>
         * <p>
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
         * group ARN, the container name (as it appears in a container definition), and the container port to access
         * from the load balancer. When a task from this service is placed on a container instance, the container
         * instance and port combination is registered as a target in the target group specified here.
         * </p>
         * <p>
         * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
         * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not
         * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
         * target type, not <code>instance</code>, because tasks that use the <code>awsvpc</code> network mode are
         * associated with an elastic network interface, not an Amazon EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancer>.Builder} avoiding the need to
         * create one manually via {@link List<LoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancer>.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on {@link List<LoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(List<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * The details of the service discovery registries to assign to this service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <note>
         * <p>
         * Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
         * Versions</a>.
         * </p>
         * </note>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registries to assign to this service. For more information, see
         *        <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.</p> <note>
         *        <p>
         *        Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         *        Platform Versions</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registries to assign to this service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <note>
         * <p>
         * Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
         * Versions</a>.
         * </p>
         * </note>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registries to assign to this service. For more information, see
         *        <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.</p> <note>
         *        <p>
         *        Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         *        Platform Versions</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registries to assign to this service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <note>
         * <p>
         * Service discovery is supported for Fargate tasks if you are using platform version v1.1.0 or later. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
         * Versions</a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<ServiceRegistry>.Builder} avoiding
         * the need to create one manually via {@link List<ServiceRegistry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceRegistry>.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on {@link List<ServiceRegistry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(List<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The number of instantiations of the specified task definition to place and keep running on your cluster.
         * </p>
         * 
         * @param desiredCount
         *        The number of instantiations of the specified task definition to place and keep running on your
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32 ASCII
         * characters are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32
         *        ASCII characters are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The launch type on which to run your service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param launchType
         *        The launch type on which to run your service. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         *        Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type on which to run your service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param launchType
         *        The launch type on which to run your service. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         *        Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The platform version on which your tasks in the service are running. A platform version is only specified for
         * tasks using the Fargate launch type. If one is not specified, the <code>LATEST</code> platform version is
         * used by default. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
         * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version on which your tasks in the service are running. A platform version is only
         *        specified for tasks using the Fargate launch type. If one is not specified, the <code>LATEST</code>
         *        platform version is used by default. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load
         * balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service
         * and your task definition does not use the <code>awsvpc</code> network mode. If you specify the
         * <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code>
         * parameter.
         * </p>
         * <important>
         * <p>
         * If your account has already created the Amazon ECS service-linked role, that role is used by default for your
         * service unless you specify a role here. The service-linked role is required if your task definition uses the
         * <code>awsvpc</code> network mode, in which case you should not specify a role here. For more information, see
         * <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
         * Service-Linked Roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </important>
         * <p>
         * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN
         * (this is recommended) or prefix the role name with the path. For example, if a role with the name
         * <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role
         * name. For more information, see <a href=
         * "http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
         * >Friendly Names and Paths</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param role
         *        The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to
         *        your load balancer on your behalf. This parameter is only permitted if you are using a load balancer
         *        with your service and your task definition does not use the <code>awsvpc</code> network mode. If you
         *        specify the <code>role</code> parameter, you must also specify a load balancer object with the
         *        <code>loadBalancers</code> parameter.</p> <important>
         *        <p>
         *        If your account has already created the Amazon ECS service-linked role, that role is used by default
         *        for your service unless you specify a role here. The service-linked role is required if your task
         *        definition uses the <code>awsvpc</code> network mode, in which case you should not specify a role
         *        here. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html"
         *        >Using Service-Linked Roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer
         *        Guide</i>.
         *        </p>
         *        </important>
         *        <p>
         *        If your specified role has a path other than <code>/</code>, then you must either specify the full
         *        role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the
         *        name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as
         *        the role name. For more information, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
         *        >Friendly Names and Paths</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
         * constraints per task (this limit includes constraints in the task definition and those specified at runtime).
         * </p>
         * 
         * @param placementConstraints
         *        An array of placement constraint objects to use for tasks in your service. You can specify a maximum
         *        of 10 constraints per task (this limit includes constraints in the task definition and those specified
         *        at runtime).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
         * constraints per task (this limit includes constraints in the task definition and those specified at runtime).
         * </p>
         * 
         * @param placementConstraints
         *        An array of placement constraint objects to use for tasks in your service. You can specify a maximum
         *        of 10 constraints per task (this limit includes constraints in the task definition and those specified
         *        at runtime).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
         * constraints per task (this limit includes constraints in the task definition and those specified at runtime).
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementConstraint>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementConstraint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementConstraint>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on {@link List<PlacementConstraint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(List<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of five strategy
         * rules per service.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy objects to use for tasks in your service. You can specify a maximum of five
         *        strategy rules per service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of five strategy
         * rules per service.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy objects to use for tasks in your service. You can specify a maximum of five
         *        strategy rules per service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of five strategy
         * rules per service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementStrategy>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementStrategy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementStrategy>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on {@link List<PlacementStrategy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(List<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The network configuration for the service. This parameter is required for task definitions that use the
         * <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for
         * other network modes. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in
         * the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the service. This parameter is required for task definitions that use
         *        the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not
         *        supported for other network modes. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
         *        Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the service. This parameter is required for task definitions that use the
         * <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for
         * other network modes. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in
         * the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConfiguration.Builder} avoiding the need
         * to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic Load
         * Balancing target health checks after a task has first started. This is only valid if your service is
         * configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load
         * Balancing health checks, you can specify a health check grace period of up to 7,200 seconds. During that
         * time, the ECS service scheduler ignores health check status. This grace period can prevent the ECS service
         * scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic
         *        Load Balancing target health checks after a task has first started. This is only valid if your service
         *        is configured to use a load balancer. If your service's tasks take a while to start and respond to
         *        Elastic Load Balancing health checks, you can specify a health check grace period of up to 7,200
         *        seconds. During that time, the ECS service scheduler ignores health check status. This grace period
         *        can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they
         *        have time to come up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions. This scheduler strategy is
         * required if using the <code>CODE_DEPLOY</code> deployment controller.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
         * that meets all of the task placement constraints that you specify in your cluster. When you are using this
         * strategy, there is no need to specify a desired number of tasks, a task placement strategy, or use Service
         * Auto Scaling policies.
         * </p>
         * <note>
         * <p>
         * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not support the
         * <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions. This
         *        scheduler strategy is required if using the <code>CODE_DEPLOY</code> deployment controller.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         *        instance that meets all of the task placement constraints that you specify in your cluster. When you
         *        are using this strategy, there is no need to specify a desired number of tasks, a task placement
         *        strategy, or use Service Auto Scaling policies.
         *        </p>
         *        <note>
         *        <p>
         *        Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not
         *        support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions. This scheduler strategy is
         * required if using the <code>CODE_DEPLOY</code> deployment controller.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
         * that meets all of the task placement constraints that you specify in your cluster. When you are using this
         * strategy, there is no need to specify a desired number of tasks, a task placement strategy, or use Service
         * Auto Scaling policies.
         * </p>
         * <note>
         * <p>
         * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not support the
         * <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions. This
         *        scheduler strategy is required if using the <code>CODE_DEPLOY</code> deployment controller.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         *        instance that meets all of the task placement constraints that you specify in your cluster. When you
         *        are using this strategy, there is no need to specify a desired number of tasks, a task placement
         *        strategy, or use Service Auto Scaling policies.
         *        </p>
         *        <note>
         *        <p>
         *        Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> deploymenet controller do not
         *        support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(SchedulingStrategy schedulingStrategy);

        /**
         * <p>
         * The deployment controller to use for the service.
         * </p>
         * 
         * @param deploymentController
         *        The deployment controller to use for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentController(DeploymentController deploymentController);

        /**
         * <p>
         * The deployment controller to use for the service.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentController.Builder} avoiding the need
         * to create one manually via {@link DeploymentController#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentController.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentController(DeploymentController)}.
         * 
         * @param deploymentController
         *        a consumer that will call methods on {@link DeploymentController.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentController(DeploymentController)
         */
        default Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return deploymentController(DeploymentController.builder().applyMutation(deploymentController).build());
        }

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of
         * 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define. When a service is deleted, the tags are
         *        deleted as well. Tag keys can have a maximum character length of 128 characters, and tag values can
         *        have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of
         * 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define. When a service is deleted, the tags are
         *        deleted as well. Tag keys can have a maximum character length of 128 characters, and tag values can
         *        have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of
         * 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For more information,
         * see <a href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your
         * Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param enableECSManagedTags
         *        Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your
         *        Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableECSManagedTags(Boolean enableECSManagedTags);

        /**
         * <p>
         * Specifies whether to propagate the tags from the task definition or the service to the tasks. If no value is
         * specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during
         * service creation. To add tags to a task after service creation, use the <a>TagResource</a> API action.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the task definition or the service to the tasks. If no
         *        value is specified, the tags are not propagated. Tags can only be propagated to the tasks within the
         *        service during service creation. To add tags to a task after service creation, use the
         *        <a>TagResource</a> API action.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Specifies whether to propagate the tags from the task definition or the service to the tasks. If no value is
         * specified, the tags are not propagated. Tags can only be propagated to the tasks within the service during
         * service creation. To add tags to a task after service creation, use the <a>TagResource</a> API action.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the task definition or the service to the tasks. If no
         *        value is specified, the tags are not propagated. Tags can only be propagated to the tasks within the
         *        service during service creation. To add tags to a task after service creation, use the
         *        <a>TagResource</a> API action.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(PropagateTags propagateTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String serviceName;

        private String taskDefinition;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private Integer desiredCount;

        private String clientToken;

        private String launchType;

        private String platformVersion;

        private String role;

        private DeploymentConfiguration deploymentConfiguration;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private NetworkConfiguration networkConfiguration;

        private Integer healthCheckGracePeriodSeconds;

        private String schedulingStrategy;

        private DeploymentController deploymentController;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableECSManagedTags;

        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            cluster(model.cluster);
            serviceName(model.serviceName);
            taskDefinition(model.taskDefinition);
            loadBalancers(model.loadBalancers);
            serviceRegistries(model.serviceRegistries);
            desiredCount(model.desiredCount);
            clientToken(model.clientToken);
            launchType(model.launchType);
            platformVersion(model.platformVersion);
            role(model.role);
            deploymentConfiguration(model.deploymentConfiguration);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            networkConfiguration(model.networkConfiguration);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            schedulingStrategy(model.schedulingStrategy);
            deploymentController(model.deploymentController);
            tags(model.tags);
            enableECSManagedTags(model.enableECSManagedTags);
            propagateTags(model.propagateTags);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return loadBalancers != null ? loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<ServiceRegistry.Builder> getServiceRegistries() {
            return serviceRegistries != null ? serviceRegistries.stream().map(ServiceRegistry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getLaunchTypeAsString() {
            return launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            return placementConstraints != null ? placementConstraints.stream().map(PlacementConstraint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            return placementStrategy != null ? placementStrategy.stream().map(PlacementStrategy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        public final String getSchedulingStrategyAsString() {
            return schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy.toString());
            return this;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return deploymentController != null ? deploymentController.toBuilder() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableECSManagedTags() {
            return enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final String getPropagateTagsAsString() {
            return propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
