/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClustersRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeClustersRequest.Builder, DescribeClustersRequest> {
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClustersRequest::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClustersRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLUSTERS_FIELD, INCLUDE_FIELD));

    private final List<String> clusters;

    private final List<String> include;

    private DescribeClustersRequest(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.include = builder.include;
    }

    /**
     * <p>
     * A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a
     * cluster, the default cluster is assumed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not
     *         specify a cluster, the default cluster is assumed.
     */
    public List<String> clusters() {
        return clusters;
    }

    /**
     * <p>
     * Additional information about your clusters to be separated by launch type, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * runningEC2TasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * runningFargateTasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * pendingEC2TasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * pendingFargateTasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * activeEC2ServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * activeFargateServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * drainingEC2ServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * drainingFargateServiceCount
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional information about your clusters to be separated by launch type, including:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         runningEC2TasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         runningFargateTasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pendingEC2TasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pendingFargateTasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         activeEC2ServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         activeFargateServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         drainingEC2ServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         drainingFargateServiceCount
     *         </p>
     *         </li>
     */
    public List<ClusterField> include() {
        return TypeConverter.convert(include, ClusterField::fromValue);
    }

    /**
     * <p>
     * Additional information about your clusters to be separated by launch type, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * runningEC2TasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * runningFargateTasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * pendingEC2TasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * pendingFargateTasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * activeEC2ServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * activeFargateServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * drainingEC2ServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * drainingFargateServiceCount
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional information about your clusters to be separated by launch type, including:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         runningEC2TasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         runningFargateTasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pendingEC2TasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pendingFargateTasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         activeEC2ServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         activeFargateServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         drainingEC2ServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         drainingFargateServiceCount
     *         </p>
     *         </li>
     */
    public List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusters());
        hashCode = 31 * hashCode + Objects.hashCode(includeAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersRequest)) {
            return false;
        }
        DescribeClustersRequest other = (DescribeClustersRequest) obj;
        return Objects.equals(clusters(), other.clusters()) && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeClustersRequest").add("Clusters", clusters()).add("Include", includeAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersRequest, T> g) {
        return obj -> g.apply((DescribeClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClustersRequest> {
        /**
         * <p>
         * A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a
         * cluster, the default cluster is assumed.
         * </p>
         * 
         * @param clusters
         *        A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not
         *        specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<String> clusters);

        /**
         * <p>
         * A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a
         * cluster, the default cluster is assumed.
         * </p>
         * 
         * @param clusters
         *        A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not
         *        specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(String... clusters);

        /**
         * <p>
         * Additional information about your clusters to be separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * runningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * 
         * @param include
         *        Additional information about your clusters to be separated by launch type, including:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        runningEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        runningFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeFargateServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingFargateServiceCount
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Additional information about your clusters to be separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * runningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * 
         * @param include
         *        Additional information about your clusters to be separated by launch type, including:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        runningEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        runningFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeFargateServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingFargateServiceCount
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Additional information about your clusters to be separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * runningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * 
         * @param include
         *        Additional information about your clusters to be separated by launch type, including:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        runningEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        runningFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeFargateServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingFargateServiceCount
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<ClusterField> include);

        /**
         * <p>
         * Additional information about your clusters to be separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * runningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * 
         * @param include
         *        Additional information about your clusters to be separated by launch type, including:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        runningEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        runningFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeFargateServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingFargateServiceCount
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(ClusterField... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersRequest model) {
            super(model);
            clusters(model.clusters);
            includeWithStrings(model.include);
        }

        public final Collection<String> getClusters() {
            return clusters;
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
        }

        public final Collection<String> getIncludeAsStrings() {
            return include;
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ClusterFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<ClusterField> include) {
            this.include = ClusterFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ClusterField... include) {
            include(Arrays.asList(include));
            return this;
        }

        public final void setIncludeWithStrings(Collection<String> include) {
            this.include = ClusterFieldListCopier.copy(include);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClustersRequest build() {
            return new DescribeClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
