/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServicesResponse extends EcsResponse implements
        ToCopyableBuilder<DescribeServicesResponse.Builder, DescribeServicesResponse> {
    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField
            .<List<Service>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServicesResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Service> builder(MarshallingType.SDK_POJO)
                                            .constructor(Service::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField
            .<List<Failure>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServicesResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failure> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICES_FIELD, FAILURES_FIELD));

    private final List<Service> services;

    private final List<Failure> failures;

    private DescribeServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.failures = builder.failures;
    }

    /**
     * <p>
     * The list of services described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of services described.
     */
    public List<Service> services() {
        return services;
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public List<Failure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(services());
        hashCode = 31 * hashCode + Objects.hashCode(failures());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse) obj;
        return Objects.equals(services(), other.services()) && Objects.equals(failures(), other.failures());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeServicesResponse").add("Services", services()).add("Failures", failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServicesResponse, T> g) {
        return obj -> g.apply((DescribeServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServicesResponse> {
        /**
         * <p>
         * The list of services described.
         * </p>
         * 
         * @param services
         *        The list of services described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<Service> services);

        /**
         * <p>
         * The list of services described.
         * </p>
         * 
         * @param services
         *        The list of services described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Service... services);

        /**
         * <p>
         * The list of services described.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Service>.Builder} avoiding the need to
         * create one manually via {@link List<Service>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Service>.Builder#build()} is called immediately and its
         * result is passed to {@link #services(List<Service>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<Service>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<Service>)
         */
        Builder services(Consumer<Service.Builder>... services);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Failure>.Builder} avoiding the need to
         * create one manually via {@link List<Failure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Failure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<Failure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<Failure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<Failure>)
         */
        Builder failures(Consumer<Failure.Builder>... failures);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();

        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            super(model);
            services(model.services);
            failures(model.failures);
        }

        public final Collection<Service.Builder> getServices() {
            return services != null ? services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder>... services) {
            services(Stream.of(services).map(c -> Service.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServicesCopier.copyFromBuilder(services);
        }

        public final Collection<Failure.Builder> getFailures() {
            return failures != null ? failures.stream().map(Failure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
