/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This parameter is specified when you are using Docker volumes. Docker volumes are only supported when you are using
 * the EC2 launch type. Windows containers only support the use of the <code>local</code> driver. To use bind mounts,
 * specify a <code>host</code> instead.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DockerVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DockerVolumeConfiguration.Builder, DockerVolumeConfiguration> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DockerVolumeConfiguration::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<Boolean> AUTOPROVISION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DockerVolumeConfiguration::autoprovision)).setter(setter(Builder::autoprovision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoprovision").build()).build();

    private static final SdkField<String> DRIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DockerVolumeConfiguration::driver)).setter(setter(Builder::driver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driver").build()).build();

    private static final SdkField<Map<String, String>> DRIVER_OPTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DockerVolumeConfiguration::driverOpts))
            .setter(setter(Builder::driverOpts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driverOpts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DockerVolumeConfiguration::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            AUTOPROVISION_FIELD, DRIVER_FIELD, DRIVER_OPTS_FIELD, LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scope;

    private final Boolean autoprovision;

    private final String driver;

    private final Map<String, String> driverOpts;

    private final Map<String, String> labels;

    private DockerVolumeConfiguration(BuilderImpl builder) {
        this.scope = builder.scope;
        this.autoprovision = builder.autoprovision;
        this.driver = builder.driver;
        this.driverOpts = builder.driverOpts;
        this.labels = builder.labels;
    }

    /**
     * <p>
     * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops. Docker
     * volumes that are scoped as <code>shared</code> persist after the task stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     *         <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
     *         Docker volumes that are scoped as <code>shared</code> persist after the task stops.
     * @see Scope
     */
    public Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops. Docker
     * volumes that are scoped as <code>shared</code> persist after the task stops.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
     *         <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
     *         Docker volumes that are scoped as <code>shared</code> persist after the task stops.
     * @see Scope
     */
    public String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * If this value is <code>true</code>, the Docker volume is created if it does not already exist.
     * </p>
     * <note>
     * <p>
     * This field is only used if the <code>scope</code> is <code>shared</code>.
     * </p>
     * </note>
     * 
     * @return If this value is <code>true</code>, the Docker volume is created if it does not already exist.</p> <note>
     *         <p>
     *         This field is only used if the <code>scope</code> is <code>shared</code>.
     *         </p>
     */
    public Boolean autoprovision() {
        return autoprovision;
    }

    /**
     * <p>
     * The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is
     * used for task placement. If the driver was installed using the Docker plugin CLI, use
     * <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was
     * installed using another method, use Docker plugin discovery to retrieve the driver name. For more information,
     * see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker plugin discovery</a>.
     * This parameter maps to <code>Driver</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxdriver</code> option to <a
     * href="https://docs.docker.com/engine/reference/commandline/volume_create/"> <code>docker volume create</code>
     * </a>.
     * </p>
     * 
     * @return The Docker volume driver to use. The driver value must match the driver name provided by Docker because
     *         it is used for task placement. If the driver was installed using the Docker plugin CLI, use
     *         <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was
     *         installed using another method, use Docker plugin discovery to retrieve the driver name. For more
     *         information, see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker
     *         plugin discovery</a>. This parameter maps to <code>Driver</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of
     *         the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>xxdriver</code> option to <a
     *         href="https://docs.docker.com/engine/reference/commandline/volume_create/">
     *         <code>docker volume create</code> </a>.
     */
    public String driver() {
        return driver;
    }

    /**
     * <p>
     * A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxopt</code> option to <a
     * href="https://docs.docker.com/engine/reference/commandline/volume_create/"> <code>docker volume create</code>
     * </a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code> in
     *         the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a>
     *         section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>xxopt</code> option to <a
     *         href="https://docs.docker.com/engine/reference/commandline/volume_create/">
     *         <code>docker volume create</code> </a>.
     */
    public Map<String, String> driverOpts() {
        return driverOpts;
    }

    /**
     * <p>
     * Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxlabel</code> option to <a
     * href="https://docs.docker.com/engine/reference/commandline/volume_create/"> <code>docker volume create</code>
     * </a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of
     *         the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
     *         <code>xxlabel</code> option to <a
     *         href="https://docs.docker.com/engine/reference/commandline/volume_create/">
     *         <code>docker volume create</code> </a>.
     */
    public Map<String, String> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoprovision());
        hashCode = 31 * hashCode + Objects.hashCode(driver());
        hashCode = 31 * hashCode + Objects.hashCode(driverOpts());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DockerVolumeConfiguration)) {
            return false;
        }
        DockerVolumeConfiguration other = (DockerVolumeConfiguration) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(autoprovision(), other.autoprovision())
                && Objects.equals(driver(), other.driver()) && Objects.equals(driverOpts(), other.driverOpts())
                && Objects.equals(labels(), other.labels());
    }

    @Override
    public String toString() {
        return ToString.builder("DockerVolumeConfiguration").add("Scope", scopeAsString()).add("Autoprovision", autoprovision())
                .add("Driver", driver()).add("DriverOpts", driverOpts()).add("Labels", labels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "autoprovision":
            return Optional.ofNullable(clazz.cast(autoprovision()));
        case "driver":
            return Optional.ofNullable(clazz.cast(driver()));
        case "driverOpts":
            return Optional.ofNullable(clazz.cast(driverOpts()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DockerVolumeConfiguration, T> g) {
        return obj -> g.apply((DockerVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DockerVolumeConfiguration> {
        /**
         * <p>
         * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
         * Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * </p>
         * 
         * @param scope
         *        The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         *        <code>task</code> are automatically provisioned when the task starts and destroyed when the task
         *        stops. Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         * <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops.
         * Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * </p>
         * 
         * @param scope
         *        The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         *        <code>task</code> are automatically provisioned when the task starts and destroyed when the task
         *        stops. Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * If this value is <code>true</code>, the Docker volume is created if it does not already exist.
         * </p>
         * <note>
         * <p>
         * This field is only used if the <code>scope</code> is <code>shared</code>.
         * </p>
         * </note>
         * 
         * @param autoprovision
         *        If this value is <code>true</code>, the Docker volume is created if it does not already exist.</p>
         *        <note>
         *        <p>
         *        This field is only used if the <code>scope</code> is <code>shared</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoprovision(Boolean autoprovision);

        /**
         * <p>
         * The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is
         * used for task placement. If the driver was installed using the Docker plugin CLI, use
         * <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was
         * installed using another method, use Docker plugin discovery to retrieve the driver name. For more
         * information, see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker plugin
         * discovery</a>. This parameter maps to <code>Driver</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxdriver</code> option
         * to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">
         * <code>docker volume create</code> </a>.
         * </p>
         * 
         * @param driver
         *        The Docker volume driver to use. The driver value must match the driver name provided by Docker
         *        because it is used for task placement. If the driver was installed using the Docker plugin CLI, use
         *        <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver
         *        was installed using another method, use Docker plugin discovery to retrieve the driver name. For more
         *        information, see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker
         *        plugin discovery</a>. This parameter maps to <code>Driver</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>xxdriver</code> option to <a
         *        href="https://docs.docker.com/engine/reference/commandline/volume_create/">
         *        <code>docker volume create</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driver(String driver);

        /**
         * <p>
         * A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code> in the
         * <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
         * <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxopt</code> option
         * to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">
         * <code>docker volume create</code> </a>.
         * </p>
         * 
         * @param driverOpts
         *        A map of Docker driver-specific options passed through. This parameter maps to <code>DriverOpts</code>
         *        in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>xxopt</code> option to <a
         *        href="https://docs.docker.com/engine/reference/commandline/volume_create/">
         *        <code>docker volume create</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driverOpts(Map<String, String> driverOpts);

        /**
         * <p>
         * Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxlabel</code> option to
         * <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">
         * <code>docker volume create</code> </a>.
         * </p>
         * 
         * @param labels
         *        Custom metadata to add to your Docker volume. This parameter maps to <code>Labels</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
         *        <code>xxlabel</code> option to <a
         *        href="https://docs.docker.com/engine/reference/commandline/volume_create/">
         *        <code>docker volume create</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);
    }

    static final class BuilderImpl implements Builder {
        private String scope;

        private Boolean autoprovision;

        private String driver;

        private Map<String, String> driverOpts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DockerVolumeConfiguration model) {
            scope(model.scope);
            autoprovision(model.autoprovision);
            driver(model.driver);
            driverOpts(model.driverOpts);
            labels(model.labels);
        }

        public final String getScopeAsString() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Boolean getAutoprovision() {
            return autoprovision;
        }

        @Override
        public final Builder autoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
            return this;
        }

        public final void setAutoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
        }

        public final String getDriver() {
            return driver;
        }

        @Override
        public final Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public final void setDriver(String driver) {
            this.driver = driver;
        }

        public final Map<String, String> getDriverOpts() {
            return driverOpts;
        }

        @Override
        public final Builder driverOpts(Map<String, String> driverOpts) {
            this.driverOpts = StringMapCopier.copy(driverOpts);
            return this;
        }

        public final void setDriverOpts(Map<String, String> driverOpts) {
            this.driverOpts = StringMapCopier.copy(driverOpts);
        }

        public final Map<String, String> getLabels() {
            return labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = StringMapCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = StringMapCopier.copy(labels);
        }

        @Override
        public DockerVolumeConfiguration build() {
            return new DockerVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
