/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersResponse extends EcsResponse implements
        ToCopyableBuilder<ListClustersResponse.Builder, ListClustersResponse> {
    private static final SdkField<List<String>> CLUSTER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListClustersResponse::clusterArns))
            .setter(setter(Builder::clusterArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> clusterArns;

    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArns = builder.clusterArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of full Amazon Resource Name (ARN) entries for each cluster associated with your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of full Amazon Resource Name (ARN) entries for each cluster associated with your account.
     */
    public List<String> clusterArns() {
        return clusterArns;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a
     * <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
     * page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the
     *         results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse) obj;
        return Objects.equals(clusterArns(), other.clusterArns()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListClustersResponse").add("ClusterArns", clusterArns()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArns":
            return Optional.ofNullable(clazz.cast(clusterArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersResponse> {
        /**
         * <p>
         * The list of full Amazon Resource Name (ARN) entries for each cluster associated with your account.
         * </p>
         * 
         * @param clusterArns
         *        The list of full Amazon Resource Name (ARN) entries for each cluster associated with your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArns(Collection<String> clusterArns);

        /**
         * <p>
         * The list of full Amazon Resource Name (ARN) entries for each cluster associated with your account.
         * </p>
         * 
         * @param clusterArns
         *        The list of full Amazon Resource Name (ARN) entries for each cluster associated with your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArns(String... clusterArns);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results
         * of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the
         * next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the
         *        results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used
         *        to retrieve the next page of results. This value is <code>null</code> when there are no more results
         *        to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<String> clusterArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            clusterArns(model.clusterArns);
            nextToken(model.nextToken);
        }

        public final Collection<String> getClusterArns() {
            return clusterArns;
        }

        @Override
        public final Builder clusterArns(Collection<String> clusterArns) {
            this.clusterArns = StringListCopier.copy(clusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterArns(String... clusterArns) {
            clusterArns(Arrays.asList(clusterArns));
            return this;
        }

        public final void setClusterArns(Collection<String> clusterArns) {
            this.clusterArns = StringListCopier.copy(clusterArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
