/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesRequest extends EcsRequest implements
        ToCopyableBuilder<ListServicesRequest.Builder, ListServicesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServicesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListServicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServicesRequest::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServicesRequest::schedulingStrategyAsString)).setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LAUNCH_TYPE_FIELD, SCHEDULING_STRATEGY_FIELD));

    private final String cluster;

    private final String nextToken;

    private final Integer maxResults;

    private final String launchType;

    private final String schedulingStrategy;

    private ListServicesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.launchType = builder.launchType;
        this.schedulingStrategy = builder.schedulingStrategy;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the services to list. If you do not
     * specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the services to list. If you
     *         do not specify a cluster, the default cluster is assumed.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListServices</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListServices</code> request
     *         where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of service results returned by <code>ListServices</code> in paginated output. When this
     * parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page along
     * with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>ListServices</code> request with the returned <code>nextToken</code> value. This value can
     * be between 1 and 100. If this parameter is not used, then <code>ListServices</code> returns up to 10 results and
     * a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of service results returned by <code>ListServices</code> in paginated output. When
     *         this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a
     *         single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>ListServices</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
     *         <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The launch type for the services to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type for the services to list.
     * @see LaunchType
     */
    public LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type for the services to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type for the services to list.
     * @see LaunchType
     */
    public String launchTypeAsString() {
        return launchType;
    }

    /**
     * <p>
     * The scheduling strategy for services to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy for services to list.
     * @see SchedulingStrategy
     */
    public SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The scheduling strategy for services to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy for services to list.
     * @see SchedulingStrategy
     */
    public String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ListServicesRequest").add("Cluster", cluster()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("LaunchType", launchTypeAsString())
                .add("SchedulingStrategy", schedulingStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "schedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesRequest, T> g) {
        return obj -> g.apply((ListServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the services to list. If you do
         * not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the services to list. If
         *        you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListServices</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListServices</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of service results returned by <code>ListServices</code> in paginated output. When this
         * parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page
         * along with a <code>nextToken</code> response element. The remaining results of the initial request can be
         * seen by sending another <code>ListServices</code> request with the returned <code>nextToken</code> value.
         * This value can be between 1 and 100. If this parameter is not used, then <code>ListServices</code> returns up
         * to 10 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of service results returned by <code>ListServices</code> in paginated output. When
         *        this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a
         *        single page along with a <code>nextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another <code>ListServices</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
         *        <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The launch type for the services to list.
         * </p>
         * 
         * @param launchType
         *        The launch type for the services to list.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type for the services to list.
         * </p>
         * 
         * @param launchType
         *        The launch type for the services to list.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The scheduling strategy for services to list.
         * </p>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy for services to list.
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The scheduling strategy for services to list.
         * </p>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy for services to list.
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(SchedulingStrategy schedulingStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String nextToken;

        private Integer maxResults;

        private String launchType;

        private String schedulingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesRequest model) {
            super(model);
            cluster(model.cluster);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            launchType(model.launchType);
            schedulingStrategy(model.schedulingStrategy);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getLaunchTypeAsString() {
            return launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getSchedulingStrategyAsString() {
            return schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy.toString());
            return this;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServicesRequest build() {
            return new ListServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
