/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountSettingResponse extends EcsResponse implements
        ToCopyableBuilder<PutAccountSettingResponse.Builder, PutAccountSettingResponse> {
    private static final SdkField<Setting> SETTING_FIELD = SdkField.<Setting> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutAccountSettingResponse::setting)).setter(setter(Builder::setting)).constructor(Setting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTING_FIELD));

    private final Setting setting;

    private PutAccountSettingResponse(BuilderImpl builder) {
        super(builder);
        this.setting = builder.setting;
    }

    /**
     * <p>
     * The current account setting for a resource.
     * </p>
     * 
     * @return The current account setting for a resource.
     */
    public Setting setting() {
        return setting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(setting());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountSettingResponse)) {
            return false;
        }
        PutAccountSettingResponse other = (PutAccountSettingResponse) obj;
        return Objects.equals(setting(), other.setting());
    }

    @Override
    public String toString() {
        return ToString.builder("PutAccountSettingResponse").add("Setting", setting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "setting":
            return Optional.ofNullable(clazz.cast(setting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountSettingResponse, T> g) {
        return obj -> g.apply((PutAccountSettingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountSettingResponse> {
        /**
         * <p>
         * The current account setting for a resource.
         * </p>
         * 
         * @param setting
         *        The current account setting for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setting(Setting setting);

        /**
         * <p>
         * The current account setting for a resource.
         * </p>
         * This is a convenience that creates an instance of the {@link Setting.Builder} avoiding the need to create one
         * manually via {@link Setting#builder()}.
         *
         * When the {@link Consumer} completes, {@link Setting.Builder#build()} is called immediately and its result is
         * passed to {@link #setting(Setting)}.
         * 
         * @param setting
         *        a consumer that will call methods on {@link Setting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setting(Setting)
         */
        default Builder setting(Consumer<Setting.Builder> setting) {
            return setting(Setting.builder().applyMutation(setting).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private Setting setting;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountSettingResponse model) {
            super(model);
            setting(model.setting);
        }

        public final Setting.Builder getSetting() {
            return setting != null ? setting.toBuilder() : null;
        }

        @Override
        public final Builder setting(Setting setting) {
            this.setting = setting;
            return this;
        }

        public final void setSetting(Setting.BuilderImpl setting) {
            this.setting = setting != null ? setting.build() : null;
        }

        @Override
        public PutAccountSettingResponse build() {
            return new PutAccountSettingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
