/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the secret to expose to your container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Secret implements SdkPojo, Serializable, ToCopyableBuilder<Secret.Builder, Secret> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Secret::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Secret::valueFrom)).setter(setter(Builder::valueFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FROM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String valueFrom;

    private Secret(BuilderImpl builder) {
        this.name = builder.name;
        this.valueFrom = builder.valueFrom;
    }

    /**
     * <p>
     * The value to set as the environment variable on the container.
     * </p>
     * 
     * @return The value to set as the environment variable on the container.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The secret to expose to the container. Supported values are either the full ARN or the name of the parameter in
     * the AWS Systems Manager Parameter Store.
     * </p>
     * 
     * @return The secret to expose to the container. Supported values are either the full ARN or the name of the
     *         parameter in the AWS Systems Manager Parameter Store.
     */
    public String valueFrom() {
        return valueFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueFrom());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Secret)) {
            return false;
        }
        Secret other = (Secret) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(valueFrom(), other.valueFrom());
    }

    @Override
    public String toString() {
        return ToString.builder("Secret").add("Name", name()).add("ValueFrom", valueFrom()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "valueFrom":
            return Optional.ofNullable(clazz.cast(valueFrom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Secret, T> g) {
        return obj -> g.apply((Secret) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Secret> {
        /**
         * <p>
         * The value to set as the environment variable on the container.
         * </p>
         * 
         * @param name
         *        The value to set as the environment variable on the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The secret to expose to the container. Supported values are either the full ARN or the name of the parameter
         * in the AWS Systems Manager Parameter Store.
         * </p>
         * 
         * @param valueFrom
         *        The secret to expose to the container. Supported values are either the full ARN or the name of the
         *        parameter in the AWS Systems Manager Parameter Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueFrom(String valueFrom);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String valueFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(Secret model) {
            name(model.name);
            valueFrom(model.valueFrom);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValueFrom() {
            return valueFrom;
        }

        @Override
        public final Builder valueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
            return this;
        }

        public final void setValueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
        }

        @Override
        public Secret build() {
            return new Secret(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
