/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopTaskRequest extends EcsRequest implements ToCopyableBuilder<StopTaskRequest.Builder, StopTaskRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopTaskRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopTaskRequest::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopTaskRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD,
            REASON_FIELD));

    private final String cluster;

    private final String task;

    private final String reason;

    private StopTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not
     * specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do
     *         not specify a cluster, the default cluster is assumed.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The task ID or full ARN entry of the task to stop.
     * </p>
     * 
     * @return The task ID or full ARN entry of the task to stop.
     */
    public String task() {
        return task;
    }

    /**
     * <p>
     * An optional message specified when a task is stopped. For example, if you are using a custom scheduler, you can
     * use this parameter to specify the reason for stopping the task here, and the message appears in subsequent
     * <a>DescribeTasks</a> API operations on this task. Up to 255 characters are allowed in this message.
     * </p>
     * 
     * @return An optional message specified when a task is stopped. For example, if you are using a custom scheduler,
     *         you can use this parameter to specify the reason for stopping the task here, and the message appears in
     *         subsequent <a>DescribeTasks</a> API operations on this task. Up to 255 characters are allowed in this
     *         message.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopTaskRequest)) {
            return false;
        }
        StopTaskRequest other = (StopTaskRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(task(), other.task())
                && Objects.equals(reason(), other.reason());
    }

    @Override
    public String toString() {
        return ToString.builder("StopTaskRequest").add("Cluster", cluster()).add("Task", task()).add("Reason", reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopTaskRequest, T> g) {
        return obj -> g.apply((StopTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopTaskRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not
         * specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you
         *        do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The task ID or full ARN entry of the task to stop.
         * </p>
         * 
         * @param task
         *        The task ID or full ARN entry of the task to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * An optional message specified when a task is stopped. For example, if you are using a custom scheduler, you
         * can use this parameter to specify the reason for stopping the task here, and the message appears in
         * subsequent <a>DescribeTasks</a> API operations on this task. Up to 255 characters are allowed in this
         * message.
         * </p>
         * 
         * @param reason
         *        An optional message specified when a task is stopped. For example, if you are using a custom
         *        scheduler, you can use this parameter to specify the reason for stopping the task here, and the
         *        message appears in subsequent <a>DescribeTasks</a> API operations on this task. Up to 255 characters
         *        are allowed in this message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String task;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopTaskRequest model) {
            super(model);
            cluster(model.cluster);
            task(model.task);
            reason(model.reason);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getTask() {
            return task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopTaskRequest build() {
            return new StopTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
