/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The overrides associated with a task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskOverride implements SdkPojo, Serializable, ToCopyableBuilder<TaskOverride.Builder, TaskOverride> {
    private static final SdkField<List<ContainerOverride>> CONTAINER_OVERRIDES_FIELD = SdkField
            .<List<ContainerOverride>> builder(MarshallingType.LIST)
            .getter(getter(TaskOverride::containerOverrides))
            .setter(setter(Builder::containerOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskOverride::taskRoleArn)).setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TaskOverride::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_OVERRIDES_FIELD,
            TASK_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ContainerOverride> containerOverrides;

    private final String taskRoleArn;

    private final String executionRoleArn;

    private TaskOverride(BuilderImpl builder) {
        this.containerOverrides = builder.containerOverrides;
        this.taskRoleArn = builder.taskRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
    }

    /**
     * <p>
     * One or more container overrides sent to a task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more container overrides sent to a task.
     */
    public List<ContainerOverride> containerOverrides() {
        return containerOverrides;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this
     * task are granted the permissions that are specified in this role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
     *         this task are granted the permissions that are specified in this role.
     */
    public String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution role that the Amazon ECS container agent and the Docker
     * daemon can assume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution role that the Amazon ECS container agent and the
     *         Docker daemon can assume.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskOverride)) {
            return false;
        }
        TaskOverride other = (TaskOverride) obj;
        return Objects.equals(containerOverrides(), other.containerOverrides())
                && Objects.equals(taskRoleArn(), other.taskRoleArn())
                && Objects.equals(executionRoleArn(), other.executionRoleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("TaskOverride").add("ContainerOverrides", containerOverrides()).add("TaskRoleArn", taskRoleArn())
                .add("ExecutionRoleArn", executionRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerOverrides":
            return Optional.ofNullable(clazz.cast(containerOverrides()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskOverride, T> g) {
        return obj -> g.apply((TaskOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskOverride> {
        /**
         * <p>
         * One or more container overrides sent to a task.
         * </p>
         * 
         * @param containerOverrides
         *        One or more container overrides sent to a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(Collection<ContainerOverride> containerOverrides);

        /**
         * <p>
         * One or more container overrides sent to a task.
         * </p>
         * 
         * @param containerOverrides
         *        One or more container overrides sent to a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverride... containerOverrides);

        /**
         * <p>
         * One or more container overrides sent to a task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerOverride>.Builder} avoiding the
         * need to create one manually via {@link List<ContainerOverride>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerOverride>.Builder#build()} is called immediately
         * and its result is passed to {@link #containerOverrides(List<ContainerOverride>)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link List<ContainerOverride>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(List<ContainerOverride>)
         */
        Builder containerOverrides(Consumer<ContainerOverride.Builder>... containerOverrides);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
         * this task are granted the permissions that are specified in this role.
         * </p>
         * 
         * @param taskRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers
         *        in this task are granted the permissions that are specified in this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution role that the Amazon ECS container agent and the Docker
         * daemon can assume.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the task execution role that the Amazon ECS container agent and the
         *        Docker daemon can assume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<ContainerOverride> containerOverrides = DefaultSdkAutoConstructList.getInstance();

        private String taskRoleArn;

        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskOverride model) {
            containerOverrides(model.containerOverrides);
            taskRoleArn(model.taskRoleArn);
            executionRoleArn(model.executionRoleArn);
        }

        public final Collection<ContainerOverride.Builder> getContainerOverrides() {
            return containerOverrides != null ? containerOverrides.stream().map(ContainerOverride::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerOverrides(Collection<ContainerOverride> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copy(containerOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(ContainerOverride... containerOverrides) {
            containerOverrides(Arrays.asList(containerOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(Consumer<ContainerOverride.Builder>... containerOverrides) {
            containerOverrides(Stream.of(containerOverrides).map(c -> ContainerOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContainerOverrides(Collection<ContainerOverride.BuilderImpl> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copyFromBuilder(containerOverrides);
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public TaskOverride build() {
            return new TaskOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
