/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContainerAgentRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateContainerAgentRequest.Builder, UpdateContainerAgentRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContainerAgentRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> CONTAINER_INSTANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContainerAgentRequest::containerInstance)).setter(setter(Builder::containerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            CONTAINER_INSTANCE_FIELD));

    private final String cluster;

    private final String containerInstance;

    private UpdateContainerAgentRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstance = builder.containerInstance;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running on. If
     * you do not specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running
     *         on. If you do not specify a cluster, the default cluster is assumed.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The container instance ID or full ARN entries for the container instance on which you would like to update the
     * Amazon ECS container agent.
     * </p>
     * 
     * @return The container instance ID or full ARN entries for the container instance on which you would like to
     *         update the Amazon ECS container agent.
     */
    public String containerInstance() {
        return containerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(containerInstance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerAgentRequest)) {
            return false;
        }
        UpdateContainerAgentRequest other = (UpdateContainerAgentRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(containerInstance(), other.containerInstance());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateContainerAgentRequest").add("Cluster", cluster())
                .add("ContainerInstance", containerInstance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "containerInstance":
            return Optional.ofNullable(clazz.cast(containerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContainerAgentRequest, T> g) {
        return obj -> g.apply((UpdateContainerAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContainerAgentRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running on.
         * If you do not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is
         *        running on. If you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The container instance ID or full ARN entries for the container instance on which you would like to update
         * the Amazon ECS container agent.
         * </p>
         * 
         * @param containerInstance
         *        The container instance ID or full ARN entries for the container instance on which you would like to
         *        update the Amazon ECS container agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstance(String containerInstance);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String containerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContainerAgentRequest model) {
            super(model);
            cluster(model.cluster);
            containerInstance(model.containerInstance);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getContainerInstance() {
            return containerInstance;
        }

        @Override
        public final Builder containerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
            return this;
        }

        public final void setContainerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContainerAgentRequest build() {
            return new UpdateContainerAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
