/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.HealthStatus;
import software.amazon.awssdk.services.ecs.model.NetworkBinding;
import software.amazon.awssdk.services.ecs.model.NetworkBindingsCopier;
import software.amazon.awssdk.services.ecs.model.NetworkInterface;
import software.amazon.awssdk.services.ecs.model.NetworkInterfacesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Container
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Container> {
    private static final SdkField<String> CONTAINER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::containerArn)).setter(Container.setter(Builder::containerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerArn").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::taskArn)).setter(Container.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::name)).setter(Container.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::lastStatus)).setter(Container.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Container.getter(Container::exitCode)).setter(Container.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::reason)).setter(Container.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<NetworkBinding>> NETWORK_BINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Container.getter(Container::networkBindings)).setter(Container.setter(Builder::networkBindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkBindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkBinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Container.getter(Container::networkInterfaces)).setter(Container.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Container.getter(Container::healthStatusAsString)).setter(Container.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_ARN_FIELD, TASK_ARN_FIELD, NAME_FIELD, LAST_STATUS_FIELD, EXIT_CODE_FIELD, REASON_FIELD, NETWORK_BINDINGS_FIELD, NETWORK_INTERFACES_FIELD, HEALTH_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerArn;
    private final String taskArn;
    private final String name;
    private final String lastStatus;
    private final Integer exitCode;
    private final String reason;
    private final List<NetworkBinding> networkBindings;
    private final List<NetworkInterface> networkInterfaces;
    private final String healthStatus;

    private Container(BuilderImpl builder) {
        this.containerArn = builder.containerArn;
        this.taskArn = builder.taskArn;
        this.name = builder.name;
        this.lastStatus = builder.lastStatus;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.networkBindings = builder.networkBindings;
        this.networkInterfaces = builder.networkInterfaces;
        this.healthStatus = builder.healthStatus;
    }

    public String containerArn() {
        return this.containerArn;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String name() {
        return this.name;
    }

    public String lastStatus() {
        return this.lastStatus;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public String reason() {
        return this.reason;
    }

    public List<NetworkBinding> networkBindings() {
        return this.networkBindings;
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public HealthStatus healthStatus() {
        return HealthStatus.fromValue(this.healthStatus);
    }

    public String healthStatusAsString() {
        return this.healthStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.containerArn(), other.containerArn()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lastStatus(), other.lastStatus()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.networkBindings(), other.networkBindings()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"Container").add("ContainerArn", (Object)this.containerArn()).add("TaskArn", (Object)this.taskArn()).add("Name", (Object)this.name()).add("LastStatus", (Object)this.lastStatus()).add("ExitCode", (Object)this.exitCode()).add("Reason", (Object)this.reason()).add("NetworkBindings", this.networkBindings()).add("NetworkInterfaces", this.networkInterfaces()).add("HealthStatus", (Object)this.healthStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerArn": {
                return Optional.ofNullable(clazz.cast(this.containerArn()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatus()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "networkBindings": {
                return Optional.ofNullable(clazz.cast(this.networkBindings()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerArn;
        private String taskArn;
        private String name;
        private String lastStatus;
        private Integer exitCode;
        private String reason;
        private List<NetworkBinding> networkBindings = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.containerArn(model.containerArn);
            this.taskArn(model.taskArn);
            this.name(model.name);
            this.lastStatus(model.lastStatus);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.networkBindings(model.networkBindings);
            this.networkInterfaces(model.networkInterfaces);
            this.healthStatus(model.healthStatus);
        }

        public final String getContainerArn() {
            return this.containerArn;
        }

        @Override
        public final Builder containerArn(String containerArn) {
            this.containerArn = containerArn;
            return this;
        }

        public final void setContainerArn(String containerArn) {
            this.containerArn = containerArn;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<NetworkBinding.Builder> getNetworkBindings() {
            return this.networkBindings != null ? (Collection)this.networkBindings.stream().map(NetworkBinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkBindings(Collection<NetworkBinding> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copy(networkBindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(NetworkBinding ... networkBindings) {
            this.networkBindings(Arrays.asList(networkBindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(Consumer<NetworkBinding.Builder> ... networkBindings) {
            this.networkBindings(Stream.of(networkBindings).map(c -> (NetworkBinding)((NetworkBinding.Builder)NetworkBinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkBindings(Collection<NetworkBinding.BuilderImpl> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copyFromBuilder(networkBindings);
        }

        public final Collection<NetworkInterface.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(NetworkInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getHealthStatusAsString() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public Container build() {
            return new Container(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Container> {
        public Builder containerArn(String var1);

        public Builder taskArn(String var1);

        public Builder name(String var1);

        public Builder lastStatus(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder networkBindings(Collection<NetworkBinding> var1);

        public Builder networkBindings(NetworkBinding ... var1);

        public Builder networkBindings(Consumer<NetworkBinding.Builder> ... var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatus var1);
    }
}

