/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionField;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTaskDefinitionRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeTaskDefinitionRequest> {
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskDefinitionRequest.getter(DescribeTaskDefinitionRequest::taskDefinition)).setter(DescribeTaskDefinitionRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTaskDefinitionRequest.getter(DescribeTaskDefinitionRequest::includeAsStrings)).setter(DescribeTaskDefinitionRequest.setter(Builder::includeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_FIELD, INCLUDE_FIELD));
    private final String taskDefinition;
    private final List<String> include;

    private DescribeTaskDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.taskDefinition = builder.taskDefinition;
        this.include = builder.include;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public List<TaskDefinitionField> include() {
        return TypeConverter.convert(this.include, TaskDefinitionField::fromValue);
    }

    public List<String> includeAsStrings() {
        return this.include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskDefinitionRequest)) {
            return false;
        }
        DescribeTaskDefinitionRequest other = (DescribeTaskDefinitionRequest)((Object)obj);
        return Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.includeAsStrings(), other.includeAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTaskDefinitionRequest").add("TaskDefinition", (Object)this.taskDefinition()).add("Include", this.includeAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "include": {
                return Optional.ofNullable(clazz.cast(this.includeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskDefinitionRequest, T> g) {
        return obj -> g.apply((DescribeTaskDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String taskDefinition;
        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskDefinitionRequest model) {
            super(model);
            this.taskDefinition(model.taskDefinition);
            this.includeWithStrings(model.include);
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Collection<String> getIncludeAsStrings() {
            return this.include;
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = TaskDefinitionFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String ... include) {
            this.includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<TaskDefinitionField> include) {
            this.include = TaskDefinitionFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(TaskDefinitionField ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        public final void setIncludeWithStrings(Collection<String> include) {
            this.include = TaskDefinitionFieldListCopier.copy(include);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTaskDefinitionRequest build() {
            return new DescribeTaskDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTaskDefinitionRequest> {
        public Builder taskDefinition(String var1);

        public Builder includeWithStrings(Collection<String> var1);

        public Builder includeWithStrings(String ... var1);

        public Builder include(Collection<TaskDefinitionField> var1);

        public Builder include(TaskDefinitionField ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

