/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverPollEndpointRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DiscoverPollEndpointRequest> {
    private static final SdkField<String> CONTAINER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverPollEndpointRequest.getter(DiscoverPollEndpointRequest::containerInstance)).setter(DiscoverPollEndpointRequest.setter(Builder::containerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstance").build()}).build();
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverPollEndpointRequest.getter(DiscoverPollEndpointRequest::cluster)).setter(DiscoverPollEndpointRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_FIELD, CLUSTER_FIELD));
    private final String containerInstance;
    private final String cluster;

    private DiscoverPollEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.containerInstance = builder.containerInstance;
        this.cluster = builder.cluster;
    }

    public String containerInstance() {
        return this.containerInstance;
    }

    public String cluster() {
        return this.cluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverPollEndpointRequest)) {
            return false;
        }
        DiscoverPollEndpointRequest other = (DiscoverPollEndpointRequest)((Object)obj);
        return Objects.equals(this.containerInstance(), other.containerInstance()) && Objects.equals(this.cluster(), other.cluster());
    }

    public String toString() {
        return ToString.builder((String)"DiscoverPollEndpointRequest").add("ContainerInstance", (Object)this.containerInstance()).add("Cluster", (Object)this.cluster()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerInstance": {
                return Optional.ofNullable(clazz.cast(this.containerInstance()));
            }
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverPollEndpointRequest, T> g) {
        return obj -> g.apply((DiscoverPollEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String containerInstance;
        private String cluster;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverPollEndpointRequest model) {
            super(model);
            this.containerInstance(model.containerInstance);
            this.cluster(model.cluster);
        }

        public final String getContainerInstance() {
            return this.containerInstance;
        }

        @Override
        public final Builder containerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
            return this;
        }

        public final void setContainerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverPollEndpointRequest build() {
            return new DiscoverPollEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverPollEndpointRequest> {
        public Builder containerInstance(String var1);

        public Builder cluster(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

