/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostEntry> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HostEntry.getter(HostEntry::hostname)).setter(HostEntry.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HostEntry.getter(HostEntry::ipAddress)).setter(HostEntry.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, IP_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final String ipAddress;

    private HostEntry(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.ipAddress = builder.ipAddress;
    }

    public String hostname() {
        return this.hostname;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostEntry)) {
            return false;
        }
        HostEntry other = (HostEntry)obj;
        return Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.ipAddress(), other.ipAddress());
    }

    public String toString() {
        return ToString.builder((String)"HostEntry").add("Hostname", (Object)this.hostname()).add("IpAddress", (Object)this.ipAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostEntry, T> g) {
        return obj -> g.apply((HostEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostname;
        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(HostEntry model) {
            this.hostname(model.hostname);
            this.ipAddress(model.ipAddress);
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public HostEntry build() {
            return new HostEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostEntry> {
        public Builder hostname(String var1);

        public Builder ipAddress(String var1);
    }
}

