/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.SchedulingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicesRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListServicesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListServicesRequest.getter(ListServicesRequest::cluster)).setter(ListServicesRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListServicesRequest.getter(ListServicesRequest::nextToken)).setter(ListServicesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListServicesRequest.getter(ListServicesRequest::maxResults)).setter(ListServicesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListServicesRequest.getter(ListServicesRequest::launchTypeAsString)).setter(ListServicesRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListServicesRequest.getter(ListServicesRequest::schedulingStrategyAsString)).setter(ListServicesRequest.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LAUNCH_TYPE_FIELD, SCHEDULING_STRATEGY_FIELD));
    private final String cluster;
    private final String nextToken;
    private final Integer maxResults;
    private final String launchType;
    private final String schedulingStrategy;

    private ListServicesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.launchType = builder.launchType;
        this.schedulingStrategy = builder.schedulingStrategy;
    }

    public String cluster() {
        return this.cluster;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListServicesRequest").add("Cluster", (Object)this.cluster()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("LaunchType", (Object)this.launchTypeAsString()).add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "schedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesRequest, T> g) {
        return obj -> g.apply((ListServicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String nextToken;
        private Integer maxResults;
        private String launchType;
        private String schedulingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.launchType(model.launchType);
            this.schedulingStrategy(model.schedulingStrategy);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getLaunchTypeAsString() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getSchedulingStrategyAsString() {
            return this.schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy.toString());
            return this;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServicesRequest build() {
            return new ListServicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicesRequest> {
        public Builder cluster(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(SchedulingStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

