/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ecs.model.LogConfigurationOptionsMapCopier;
import software.amazon.awssdk.services.ecs.model.LogDriver;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfiguration> {
    private static final SdkField<String> LOG_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogConfiguration.getter(LogConfiguration::logDriverAsString)).setter(LogConfiguration.setter(Builder::logDriver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDriver").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(LogConfiguration.getter(LogConfiguration::options)).setter(LogConfiguration.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DRIVER_FIELD, OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logDriver;
    private final Map<String, String> options;

    private LogConfiguration(BuilderImpl builder) {
        this.logDriver = builder.logDriver;
        this.options = builder.options;
    }

    public LogDriver logDriver() {
        return LogDriver.fromValue(this.logDriver);
    }

    public String logDriverAsString() {
        return this.logDriver;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logDriverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return Objects.equals(this.logDriverAsString(), other.logDriverAsString()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"LogConfiguration").add("LogDriver", (Object)this.logDriverAsString()).add("Options", this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logDriver": {
                return Optional.ofNullable(clazz.cast(this.logDriverAsString()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logDriver;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            this.logDriver(model.logDriver);
            this.options(model.options);
        }

        public final String getLogDriverAsString() {
            return this.logDriver;
        }

        @Override
        public final Builder logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        @Override
        public final Builder logDriver(LogDriver logDriver) {
            this.logDriver(logDriver.toString());
            return this;
        }

        public final void setLogDriver(String logDriver) {
            this.logDriver = logDriver;
        }

        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = LogConfigurationOptionsMapCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = LogConfigurationOptionsMapCopier.copy(options);
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfiguration> {
        public Builder logDriver(String var1);

        public Builder logDriver(LogDriver var1);

        public Builder options(Map<String, String> var1);
    }
}

