/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LogDriver {
    JSON_FILE("json-file"),
    SYSLOG("syslog"),
    JOURNALD("journald"),
    GELF("gelf"),
    FLUENTD("fluentd"),
    AWSLOGS("awslogs"),
    SPLUNK("splunk"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LogDriver(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogDriver fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LogDriver.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogDriver> knownValues() {
        return Stream.of(LogDriver.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

