/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.TransportProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkBinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkBinding> {
    private static final SdkField<String> BIND_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkBinding.getter(NetworkBinding::bindIP)).setter(NetworkBinding.setter(Builder::bindIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindIP").build()}).build();
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(NetworkBinding.getter(NetworkBinding::containerPort)).setter(NetworkBinding.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final SdkField<Integer> HOST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(NetworkBinding.getter(NetworkBinding::hostPort)).setter(NetworkBinding.setter(Builder::hostPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkBinding.getter(NetworkBinding::protocolAsString)).setter(NetworkBinding.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIND_IP_FIELD, CONTAINER_PORT_FIELD, HOST_PORT_FIELD, PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bindIP;
    private final Integer containerPort;
    private final Integer hostPort;
    private final String protocol;

    private NetworkBinding(BuilderImpl builder) {
        this.bindIP = builder.bindIP;
        this.containerPort = builder.containerPort;
        this.hostPort = builder.hostPort;
        this.protocol = builder.protocol;
    }

    public String bindIP() {
        return this.bindIP;
    }

    public Integer containerPort() {
        return this.containerPort;
    }

    public Integer hostPort() {
        return this.hostPort;
    }

    public TransportProtocol protocol() {
        return TransportProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bindIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkBinding)) {
            return false;
        }
        NetworkBinding other = (NetworkBinding)obj;
        return Objects.equals(this.bindIP(), other.bindIP()) && Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.hostPort(), other.hostPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public String toString() {
        return ToString.builder((String)"NetworkBinding").add("BindIP", (Object)this.bindIP()).add("ContainerPort", (Object)this.containerPort()).add("HostPort", (Object)this.hostPort()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bindIP": {
                return Optional.ofNullable(clazz.cast(this.bindIP()));
            }
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "hostPort": {
                return Optional.ofNullable(clazz.cast(this.hostPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkBinding, T> g) {
        return obj -> g.apply((NetworkBinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bindIP;
        private Integer containerPort;
        private Integer hostPort;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkBinding model) {
            this.bindIP(model.bindIP);
            this.containerPort(model.containerPort);
            this.hostPort(model.hostPort);
            this.protocol(model.protocol);
        }

        public final String getBindIP() {
            return this.bindIP;
        }

        @Override
        public final Builder bindIP(String bindIP) {
            this.bindIP = bindIP;
            return this;
        }

        public final void setBindIP(String bindIP) {
            this.bindIP = bindIP;
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        public final Integer getHostPort() {
            return this.hostPort;
        }

        @Override
        public final Builder hostPort(Integer hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        public final void setHostPort(Integer hostPort) {
            this.hostPort = hostPort;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TransportProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public NetworkBinding build() {
            return new NetworkBinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkBinding> {
        public Builder bindIP(String var1);

        public Builder containerPort(Integer var1);

        public Builder hostPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(TransportProtocol var1);
    }
}

