/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attachment;
import software.amazon.awssdk.services.ecs.model.AttachmentsCopier;
import software.amazon.awssdk.services.ecs.model.Connectivity;
import software.amazon.awssdk.services.ecs.model.Container;
import software.amazon.awssdk.services.ecs.model.ContainersCopier;
import software.amazon.awssdk.services.ecs.model.HealthStatus;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskOverride;
import software.amazon.awssdk.services.ecs.model.TaskStopCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Task
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Task> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::taskArn)).setter(Task.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::clusterArn)).setter(Task.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::taskDefinitionArn)).setter(Task.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::containerInstanceArn)).setter(Task.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<TaskOverride> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Task.getter(Task::overrides)).setter(Task.setter(Builder::overrides)).constructor(TaskOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::lastStatus)).setter(Task.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<String> DESIRED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::desiredStatus)).setter(Task.setter(Builder::desiredStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredStatus").build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::cpu)).setter(Task.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::memory)).setter(Task.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Task.getter(Task::containers)).setter(Task.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::startedBy)).setter(Task.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(Task.getter(Task::version)).setter(Task.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> STOPPED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::stoppedReason)).setter(Task.setter(Builder::stoppedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedReason").build()}).build();
    private static final SdkField<String> STOP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::stopCodeAsString)).setter(Task.setter(Builder::stopCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopCode").build()}).build();
    private static final SdkField<String> CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::connectivityAsString)).setter(Task.setter(Builder::connectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivity").build()}).build();
    private static final SdkField<Instant> CONNECTIVITY_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::connectivityAt)).setter(Task.setter(Builder::connectivityAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityAt").build()}).build();
    private static final SdkField<Instant> PULL_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::pullStartedAt)).setter(Task.setter(Builder::pullStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStartedAt").build()}).build();
    private static final SdkField<Instant> PULL_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::pullStoppedAt)).setter(Task.setter(Builder::pullStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStoppedAt").build()}).build();
    private static final SdkField<Instant> EXECUTION_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::executionStoppedAt)).setter(Task.setter(Builder::executionStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStoppedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::createdAt)).setter(Task.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::startedAt)).setter(Task.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> STOPPING_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::stoppingAt)).setter(Task.setter(Builder::stoppingAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingAt").build()}).build();
    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Task.getter(Task::stoppedAt)).setter(Task.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::group)).setter(Task.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::launchTypeAsString)).setter(Task.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::platformVersion)).setter(Task.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Task.getter(Task::attachments)).setter(Task.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Task.getter(Task::healthStatusAsString)).setter(Task.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Task.getter(Task::tags)).setter(Task.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, CLUSTER_ARN_FIELD, TASK_DEFINITION_ARN_FIELD, CONTAINER_INSTANCE_ARN_FIELD, OVERRIDES_FIELD, LAST_STATUS_FIELD, DESIRED_STATUS_FIELD, CPU_FIELD, MEMORY_FIELD, CONTAINERS_FIELD, STARTED_BY_FIELD, VERSION_FIELD, STOPPED_REASON_FIELD, STOP_CODE_FIELD, CONNECTIVITY_FIELD, CONNECTIVITY_AT_FIELD, PULL_STARTED_AT_FIELD, PULL_STOPPED_AT_FIELD, EXECUTION_STOPPED_AT_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, STOPPING_AT_FIELD, STOPPED_AT_FIELD, GROUP_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, ATTACHMENTS_FIELD, HEALTH_STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskArn;
    private final String clusterArn;
    private final String taskDefinitionArn;
    private final String containerInstanceArn;
    private final TaskOverride overrides;
    private final String lastStatus;
    private final String desiredStatus;
    private final String cpu;
    private final String memory;
    private final List<Container> containers;
    private final String startedBy;
    private final Long version;
    private final String stoppedReason;
    private final String stopCode;
    private final String connectivity;
    private final Instant connectivityAt;
    private final Instant pullStartedAt;
    private final Instant pullStoppedAt;
    private final Instant executionStoppedAt;
    private final Instant createdAt;
    private final Instant startedAt;
    private final Instant stoppingAt;
    private final Instant stoppedAt;
    private final String group;
    private final String launchType;
    private final String platformVersion;
    private final List<Attachment> attachments;
    private final String healthStatus;
    private final List<Tag> tags;

    private Task(BuilderImpl builder) {
        this.taskArn = builder.taskArn;
        this.clusterArn = builder.clusterArn;
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.overrides = builder.overrides;
        this.lastStatus = builder.lastStatus;
        this.desiredStatus = builder.desiredStatus;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.containers = builder.containers;
        this.startedBy = builder.startedBy;
        this.version = builder.version;
        this.stoppedReason = builder.stoppedReason;
        this.stopCode = builder.stopCode;
        this.connectivity = builder.connectivity;
        this.connectivityAt = builder.connectivityAt;
        this.pullStartedAt = builder.pullStartedAt;
        this.pullStoppedAt = builder.pullStoppedAt;
        this.executionStoppedAt = builder.executionStoppedAt;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.stoppingAt = builder.stoppingAt;
        this.stoppedAt = builder.stoppedAt;
        this.group = builder.group;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.attachments = builder.attachments;
        this.healthStatus = builder.healthStatus;
        this.tags = builder.tags;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public TaskOverride overrides() {
        return this.overrides;
    }

    public String lastStatus() {
        return this.lastStatus;
    }

    public String desiredStatus() {
        return this.desiredStatus;
    }

    public String cpu() {
        return this.cpu;
    }

    public String memory() {
        return this.memory;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public String startedBy() {
        return this.startedBy;
    }

    public Long version() {
        return this.version;
    }

    public String stoppedReason() {
        return this.stoppedReason;
    }

    public TaskStopCode stopCode() {
        return TaskStopCode.fromValue(this.stopCode);
    }

    public String stopCodeAsString() {
        return this.stopCode;
    }

    public Connectivity connectivity() {
        return Connectivity.fromValue(this.connectivity);
    }

    public String connectivityAsString() {
        return this.connectivity;
    }

    public Instant connectivityAt() {
        return this.connectivityAt;
    }

    public Instant pullStartedAt() {
        return this.pullStartedAt;
    }

    public Instant pullStoppedAt() {
        return this.pullStoppedAt;
    }

    public Instant executionStoppedAt() {
        return this.executionStoppedAt;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public Instant stoppingAt() {
        return this.stoppingAt;
    }

    public Instant stoppedAt() {
        return this.stoppedAt;
    }

    public String group() {
        return this.group;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public List<Attachment> attachments() {
        return this.attachments;
    }

    public HealthStatus healthStatus() {
        return HealthStatus.fromValue(this.healthStatus);
    }

    public String healthStatusAsString() {
        return this.healthStatus;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.containers());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.lastStatus(), other.lastStatus()) && Objects.equals(this.desiredStatus(), other.desiredStatus()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.stoppedReason(), other.stoppedReason()) && Objects.equals(this.stopCodeAsString(), other.stopCodeAsString()) && Objects.equals(this.connectivityAsString(), other.connectivityAsString()) && Objects.equals(this.connectivityAt(), other.connectivityAt()) && Objects.equals(this.pullStartedAt(), other.pullStartedAt()) && Objects.equals(this.pullStoppedAt(), other.pullStoppedAt()) && Objects.equals(this.executionStoppedAt(), other.executionStoppedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppingAt(), other.stoppingAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Task").add("TaskArn", (Object)this.taskArn()).add("ClusterArn", (Object)this.clusterArn()).add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("Overrides", (Object)this.overrides()).add("LastStatus", (Object)this.lastStatus()).add("DesiredStatus", (Object)this.desiredStatus()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("Containers", this.containers()).add("StartedBy", (Object)this.startedBy()).add("Version", (Object)this.version()).add("StoppedReason", (Object)this.stoppedReason()).add("StopCode", (Object)this.stopCodeAsString()).add("Connectivity", (Object)this.connectivityAsString()).add("ConnectivityAt", (Object)this.connectivityAt()).add("PullStartedAt", (Object)this.pullStartedAt()).add("PullStoppedAt", (Object)this.pullStoppedAt()).add("ExecutionStoppedAt", (Object)this.executionStoppedAt()).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("StoppingAt", (Object)this.stoppingAt()).add("StoppedAt", (Object)this.stoppedAt()).add("Group", (Object)this.group()).add("LaunchType", (Object)this.launchTypeAsString()).add("PlatformVersion", (Object)this.platformVersion()).add("Attachments", this.attachments()).add("HealthStatus", (Object)this.healthStatusAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "taskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatus()));
            }
            case "desiredStatus": {
                return Optional.ofNullable(clazz.cast(this.desiredStatus()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "stoppedReason": {
                return Optional.ofNullable(clazz.cast(this.stoppedReason()));
            }
            case "stopCode": {
                return Optional.ofNullable(clazz.cast(this.stopCodeAsString()));
            }
            case "connectivity": {
                return Optional.ofNullable(clazz.cast(this.connectivityAsString()));
            }
            case "connectivityAt": {
                return Optional.ofNullable(clazz.cast(this.connectivityAt()));
            }
            case "pullStartedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStartedAt()));
            }
            case "pullStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStoppedAt()));
            }
            case "executionStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.executionStoppedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppingAt": {
                return Optional.ofNullable(clazz.cast(this.stoppingAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Task, T> g) {
        return obj -> g.apply((Task)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskArn;
        private String clusterArn;
        private String taskDefinitionArn;
        private String containerInstanceArn;
        private TaskOverride overrides;
        private String lastStatus;
        private String desiredStatus;
        private String cpu;
        private String memory;
        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();
        private String startedBy;
        private Long version;
        private String stoppedReason;
        private String stopCode;
        private String connectivity;
        private Instant connectivityAt;
        private Instant pullStartedAt;
        private Instant pullStoppedAt;
        private Instant executionStoppedAt;
        private Instant createdAt;
        private Instant startedAt;
        private Instant stoppingAt;
        private Instant stoppedAt;
        private String group;
        private String launchType;
        private String platformVersion;
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String healthStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            this.taskArn(model.taskArn);
            this.clusterArn(model.clusterArn);
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.containerInstanceArn(model.containerInstanceArn);
            this.overrides(model.overrides);
            this.lastStatus(model.lastStatus);
            this.desiredStatus(model.desiredStatus);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.containers(model.containers);
            this.startedBy(model.startedBy);
            this.version(model.version);
            this.stoppedReason(model.stoppedReason);
            this.stopCode(model.stopCode);
            this.connectivity(model.connectivity);
            this.connectivityAt(model.connectivityAt);
            this.pullStartedAt(model.pullStartedAt);
            this.pullStoppedAt(model.pullStoppedAt);
            this.executionStoppedAt(model.executionStoppedAt);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.stoppingAt(model.stoppingAt);
            this.stoppedAt(model.stoppedAt);
            this.group(model.group);
            this.launchType(model.launchType);
            this.platformVersion(model.platformVersion);
            this.attachments(model.attachments);
            this.healthStatus(model.healthStatus);
            this.tags(model.tags);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final TaskOverride.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(TaskOverride overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(TaskOverride.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getDesiredStatus() {
            return this.desiredStatus;
        }

        @Override
        public final Builder desiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
            return this;
        }

        public final void setDesiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
        }

        public final String getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final String getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final Collection<Container.Builder> getContainers() {
            return this.containers != null ? (Collection)this.containers.stream().map(Container::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (Container)((Container.Builder)Container.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getStoppedReason() {
            return this.stoppedReason;
        }

        @Override
        public final Builder stoppedReason(String stoppedReason) {
            this.stoppedReason = stoppedReason;
            return this;
        }

        public final void setStoppedReason(String stoppedReason) {
            this.stoppedReason = stoppedReason;
        }

        public final String getStopCodeAsString() {
            return this.stopCode;
        }

        @Override
        public final Builder stopCode(String stopCode) {
            this.stopCode = stopCode;
            return this;
        }

        @Override
        public final Builder stopCode(TaskStopCode stopCode) {
            this.stopCode(stopCode.toString());
            return this;
        }

        public final void setStopCode(String stopCode) {
            this.stopCode = stopCode;
        }

        public final String getConnectivityAsString() {
            return this.connectivity;
        }

        @Override
        public final Builder connectivity(String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public final Builder connectivity(Connectivity connectivity) {
            this.connectivity(connectivity.toString());
            return this;
        }

        public final void setConnectivity(String connectivity) {
            this.connectivity = connectivity;
        }

        public final Instant getConnectivityAt() {
            return this.connectivityAt;
        }

        @Override
        public final Builder connectivityAt(Instant connectivityAt) {
            this.connectivityAt = connectivityAt;
            return this;
        }

        public final void setConnectivityAt(Instant connectivityAt) {
            this.connectivityAt = connectivityAt;
        }

        public final Instant getPullStartedAt() {
            return this.pullStartedAt;
        }

        @Override
        public final Builder pullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
            return this;
        }

        public final void setPullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
        }

        public final Instant getPullStoppedAt() {
            return this.pullStoppedAt;
        }

        @Override
        public final Builder pullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
            return this;
        }

        public final void setPullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
        }

        public final Instant getExecutionStoppedAt() {
            return this.executionStoppedAt;
        }

        @Override
        public final Builder executionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
            return this;
        }

        public final void setExecutionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getStoppingAt() {
            return this.stoppingAt;
        }

        @Override
        public final Builder stoppingAt(Instant stoppingAt) {
            this.stoppingAt = stoppingAt;
            return this;
        }

        public final void setStoppingAt(Instant stoppingAt) {
            this.stoppingAt = stoppingAt;
        }

        public final Instant getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getLaunchTypeAsString() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final Collection<Attachment.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(Attachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        public final String getHealthStatusAsString() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public Task build() {
            return new Task(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Task> {
        public Builder taskArn(String var1);

        public Builder clusterArn(String var1);

        public Builder taskDefinitionArn(String var1);

        public Builder containerInstanceArn(String var1);

        public Builder overrides(TaskOverride var1);

        default public Builder overrides(Consumer<TaskOverride.Builder> overrides) {
            return this.overrides((TaskOverride)((TaskOverride.Builder)TaskOverride.builder().applyMutation(overrides)).build());
        }

        public Builder lastStatus(String var1);

        public Builder desiredStatus(String var1);

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder containers(Collection<Container> var1);

        public Builder containers(Container ... var1);

        public Builder containers(Consumer<Container.Builder> ... var1);

        public Builder startedBy(String var1);

        public Builder version(Long var1);

        public Builder stoppedReason(String var1);

        public Builder stopCode(String var1);

        public Builder stopCode(TaskStopCode var1);

        public Builder connectivity(String var1);

        public Builder connectivity(Connectivity var1);

        public Builder connectivityAt(Instant var1);

        public Builder pullStartedAt(Instant var1);

        public Builder pullStoppedAt(Instant var1);

        public Builder executionStoppedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder stoppingAt(Instant var1);

        public Builder stoppedAt(Instant var1);

        public Builder group(String var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder platformVersion(String var1);

        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);

        public Builder attachments(Consumer<Attachment.Builder> ... var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

