/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.Compatibility;
import software.amazon.awssdk.services.ecs.model.CompatibilityListCopier;
import software.amazon.awssdk.services.ecs.model.ContainerDefinition;
import software.amazon.awssdk.services.ecs.model.ContainerDefinitionsCopier;
import software.amazon.awssdk.services.ecs.model.IpcMode;
import software.amazon.awssdk.services.ecs.model.NetworkMode;
import software.amazon.awssdk.services.ecs.model.PidMode;
import software.amazon.awssdk.services.ecs.model.RequiresAttributesCopier;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionPlacementConstraint;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionPlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus;
import software.amazon.awssdk.services.ecs.model.Volume;
import software.amazon.awssdk.services.ecs.model.VolumeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskDefinition> {
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::taskDefinitionArn)).setter(TaskDefinition.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()}).build();
    private static final SdkField<List<ContainerDefinition>> CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskDefinition.getter(TaskDefinition::containerDefinitions)).setter(TaskDefinition.setter(Builder::containerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::family)).setter(TaskDefinition.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::taskRoleArn)).setter(TaskDefinition.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::executionRoleArn)).setter(TaskDefinition.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::networkModeAsString)).setter(TaskDefinition.setter(Builder::networkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkMode").build()}).build();
    private static final SdkField<Integer> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TaskDefinition.getter(TaskDefinition::revision)).setter(TaskDefinition.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskDefinition.getter(TaskDefinition::volumes)).setter(TaskDefinition.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::statusAsString)).setter(TaskDefinition.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<Attribute>> REQUIRES_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskDefinition.getter(TaskDefinition::requiresAttributes)).setter(TaskDefinition.setter(Builder::requiresAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TaskDefinitionPlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskDefinition.getter(TaskDefinition::placementConstraints)).setter(TaskDefinition.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskDefinitionPlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMPATIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskDefinition.getter(TaskDefinition::compatibilitiesAsStrings)).setter(TaskDefinition.setter(Builder::compatibilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRES_COMPATIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskDefinition.getter(TaskDefinition::requiresCompatibilitiesAsStrings)).setter(TaskDefinition.setter(Builder::requiresCompatibilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresCompatibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::cpu)).setter(TaskDefinition.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::memory)).setter(TaskDefinition.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<String> PID_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::pidModeAsString)).setter(TaskDefinition.setter(Builder::pidMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidMode").build()}).build();
    private static final SdkField<String> IPC_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskDefinition.getter(TaskDefinition::ipcModeAsString)).setter(TaskDefinition.setter(Builder::ipcMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipcMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_ARN_FIELD, CONTAINER_DEFINITIONS_FIELD, FAMILY_FIELD, TASK_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_MODE_FIELD, REVISION_FIELD, VOLUMES_FIELD, STATUS_FIELD, REQUIRES_ATTRIBUTES_FIELD, PLACEMENT_CONSTRAINTS_FIELD, COMPATIBILITIES_FIELD, REQUIRES_COMPATIBILITIES_FIELD, CPU_FIELD, MEMORY_FIELD, PID_MODE_FIELD, IPC_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskDefinitionArn;
    private final List<ContainerDefinition> containerDefinitions;
    private final String family;
    private final String taskRoleArn;
    private final String executionRoleArn;
    private final String networkMode;
    private final Integer revision;
    private final List<Volume> volumes;
    private final String status;
    private final List<Attribute> requiresAttributes;
    private final List<TaskDefinitionPlacementConstraint> placementConstraints;
    private final List<String> compatibilities;
    private final List<String> requiresCompatibilities;
    private final String cpu;
    private final String memory;
    private final String pidMode;
    private final String ipcMode;

    private TaskDefinition(BuilderImpl builder) {
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.containerDefinitions = builder.containerDefinitions;
        this.family = builder.family;
        this.taskRoleArn = builder.taskRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkMode = builder.networkMode;
        this.revision = builder.revision;
        this.volumes = builder.volumes;
        this.status = builder.status;
        this.requiresAttributes = builder.requiresAttributes;
        this.placementConstraints = builder.placementConstraints;
        this.compatibilities = builder.compatibilities;
        this.requiresCompatibilities = builder.requiresCompatibilities;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.pidMode = builder.pidMode;
        this.ipcMode = builder.ipcMode;
    }

    public String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public List<ContainerDefinition> containerDefinitions() {
        return this.containerDefinitions;
    }

    public String family() {
        return this.family;
    }

    public String taskRoleArn() {
        return this.taskRoleArn;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public NetworkMode networkMode() {
        return NetworkMode.fromValue(this.networkMode);
    }

    public String networkModeAsString() {
        return this.networkMode;
    }

    public Integer revision() {
        return this.revision;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public TaskDefinitionStatus status() {
        return TaskDefinitionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<Attribute> requiresAttributes() {
        return this.requiresAttributes;
    }

    public List<TaskDefinitionPlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public List<Compatibility> compatibilities() {
        return TypeConverter.convert(this.compatibilities, Compatibility::fromValue);
    }

    public List<String> compatibilitiesAsStrings() {
        return this.compatibilities;
    }

    public List<Compatibility> requiresCompatibilities() {
        return TypeConverter.convert(this.requiresCompatibilities, Compatibility::fromValue);
    }

    public List<String> requiresCompatibilitiesAsStrings() {
        return this.requiresCompatibilities;
    }

    public String cpu() {
        return this.cpu;
    }

    public String memory() {
        return this.memory;
    }

    public PidMode pidMode() {
        return PidMode.fromValue(this.pidMode);
    }

    public String pidModeAsString() {
        return this.pidMode;
    }

    public IpcMode ipcMode() {
        return IpcMode.fromValue(this.ipcMode);
    }

    public String ipcModeAsString() {
        return this.ipcMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresCompatibilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.pidModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipcModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskDefinition)) {
            return false;
        }
        TaskDefinition other = (TaskDefinition)obj;
        return Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.containerDefinitions(), other.containerDefinitions()) && Objects.equals(this.family(), other.family()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.networkModeAsString(), other.networkModeAsString()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.requiresAttributes(), other.requiresAttributes()) && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.compatibilitiesAsStrings(), other.compatibilitiesAsStrings()) && Objects.equals(this.requiresCompatibilitiesAsStrings(), other.requiresCompatibilitiesAsStrings()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.pidModeAsString(), other.pidModeAsString()) && Objects.equals(this.ipcModeAsString(), other.ipcModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TaskDefinition").add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("ContainerDefinitions", this.containerDefinitions()).add("Family", (Object)this.family()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("NetworkMode", (Object)this.networkModeAsString()).add("Revision", (Object)this.revision()).add("Volumes", this.volumes()).add("Status", (Object)this.statusAsString()).add("RequiresAttributes", this.requiresAttributes()).add("PlacementConstraints", this.placementConstraints()).add("Compatibilities", this.compatibilitiesAsStrings()).add("RequiresCompatibilities", this.requiresCompatibilitiesAsStrings()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("PidMode", (Object)this.pidModeAsString()).add("IpcMode", (Object)this.ipcModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "containerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerDefinitions()));
            }
            case "family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "networkMode": {
                return Optional.ofNullable(clazz.cast(this.networkModeAsString()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "requiresAttributes": {
                return Optional.ofNullable(clazz.cast(this.requiresAttributes()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "compatibilities": {
                return Optional.ofNullable(clazz.cast(this.compatibilitiesAsStrings()));
            }
            case "requiresCompatibilities": {
                return Optional.ofNullable(clazz.cast(this.requiresCompatibilitiesAsStrings()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "pidMode": {
                return Optional.ofNullable(clazz.cast(this.pidModeAsString()));
            }
            case "ipcMode": {
                return Optional.ofNullable(clazz.cast(this.ipcModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskDefinition, T> g) {
        return obj -> g.apply((TaskDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskDefinitionArn;
        private List<ContainerDefinition> containerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String family;
        private String taskRoleArn;
        private String executionRoleArn;
        private String networkMode;
        private Integer revision;
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private List<Attribute> requiresAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<TaskDefinitionPlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<String> compatibilities = DefaultSdkAutoConstructList.getInstance();
        private List<String> requiresCompatibilities = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private String memory;
        private String pidMode;
        private String ipcMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskDefinition model) {
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.containerDefinitions(model.containerDefinitions);
            this.family(model.family);
            this.taskRoleArn(model.taskRoleArn);
            this.executionRoleArn(model.executionRoleArn);
            this.networkMode(model.networkMode);
            this.revision(model.revision);
            this.volumes(model.volumes);
            this.status(model.status);
            this.requiresAttributes(model.requiresAttributes);
            this.placementConstraints(model.placementConstraints);
            this.compatibilitiesWithStrings(model.compatibilities);
            this.requiresCompatibilitiesWithStrings(model.requiresCompatibilities);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.pidMode(model.pidMode);
            this.ipcMode(model.ipcMode);
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Collection<ContainerDefinition.Builder> getContainerDefinitions() {
            return this.containerDefinitions != null ? (Collection)this.containerDefinitions.stream().map(ContainerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinition ... containerDefinitions) {
            this.containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... containerDefinitions) {
            this.containerDefinitions(Stream.of(containerDefinitions).map(c -> (ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinition.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copyFromBuilder(containerDefinitions);
        }

        public final String getFamily() {
            return this.family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getNetworkModeAsString() {
            return this.networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public final Builder networkMode(NetworkMode networkMode) {
            this.networkMode(networkMode.toString());
            return this;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public final Collection<Volume.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumeListCopier.copyFromBuilder(volumes);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskDefinitionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<Attribute.Builder> getRequiresAttributes() {
            return this.requiresAttributes != null ? (Collection)this.requiresAttributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requiresAttributes(Collection<Attribute> requiresAttributes) {
            this.requiresAttributes = RequiresAttributesCopier.copy(requiresAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresAttributes(Attribute ... requiresAttributes) {
            this.requiresAttributes(Arrays.asList(requiresAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresAttributes(Consumer<Attribute.Builder> ... requiresAttributes) {
            this.requiresAttributes(Stream.of(requiresAttributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequiresAttributes(Collection<Attribute.BuilderImpl> requiresAttributes) {
            this.requiresAttributes = RequiresAttributesCopier.copyFromBuilder(requiresAttributes);
        }

        public final Collection<TaskDefinitionPlacementConstraint.Builder> getPlacementConstraints() {
            return this.placementConstraints != null ? (Collection)this.placementConstraints.stream().map(TaskDefinitionPlacementConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(TaskDefinitionPlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (TaskDefinitionPlacementConstraint)((TaskDefinitionPlacementConstraint.Builder)TaskDefinitionPlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<String> getCompatibilitiesAsStrings() {
            return this.compatibilities;
        }

        @Override
        public final Builder compatibilitiesWithStrings(Collection<String> compatibilities) {
            this.compatibilities = CompatibilityListCopier.copy(compatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibilitiesWithStrings(String ... compatibilities) {
            this.compatibilitiesWithStrings(Arrays.asList(compatibilities));
            return this;
        }

        @Override
        public final Builder compatibilities(Collection<Compatibility> compatibilities) {
            this.compatibilities = CompatibilityListCopier.copyEnumToString(compatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibilities(Compatibility ... compatibilities) {
            this.compatibilities(Arrays.asList(compatibilities));
            return this;
        }

        public final void setCompatibilitiesWithStrings(Collection<String> compatibilities) {
            this.compatibilities = CompatibilityListCopier.copy(compatibilities);
        }

        public final Collection<String> getRequiresCompatibilitiesAsStrings() {
            return this.requiresCompatibilities;
        }

        @Override
        public final Builder requiresCompatibilitiesWithStrings(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilitiesWithStrings(String ... requiresCompatibilities) {
            this.requiresCompatibilitiesWithStrings(Arrays.asList(requiresCompatibilities));
            return this;
        }

        @Override
        public final Builder requiresCompatibilities(Collection<Compatibility> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copyEnumToString(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilities(Compatibility ... requiresCompatibilities) {
            this.requiresCompatibilities(Arrays.asList(requiresCompatibilities));
            return this;
        }

        public final void setRequiresCompatibilitiesWithStrings(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
        }

        public final String getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final String getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final String getPidModeAsString() {
            return this.pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        @Override
        public final Builder pidMode(PidMode pidMode) {
            this.pidMode(pidMode.toString());
            return this;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        public final String getIpcModeAsString() {
            return this.ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        @Override
        public final Builder ipcMode(IpcMode ipcMode) {
            this.ipcMode(ipcMode.toString());
            return this;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        public TaskDefinition build() {
            return new TaskDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskDefinition> {
        public Builder taskDefinitionArn(String var1);

        public Builder containerDefinitions(Collection<ContainerDefinition> var1);

        public Builder containerDefinitions(ContainerDefinition ... var1);

        public Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... var1);

        public Builder family(String var1);

        public Builder taskRoleArn(String var1);

        public Builder executionRoleArn(String var1);

        public Builder networkMode(String var1);

        public Builder networkMode(NetworkMode var1);

        public Builder revision(Integer var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TaskDefinitionStatus var1);

        public Builder requiresAttributes(Collection<Attribute> var1);

        public Builder requiresAttributes(Attribute ... var1);

        public Builder requiresAttributes(Consumer<Attribute.Builder> ... var1);

        public Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> var1);

        public Builder placementConstraints(TaskDefinitionPlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder> ... var1);

        public Builder compatibilitiesWithStrings(Collection<String> var1);

        public Builder compatibilitiesWithStrings(String ... var1);

        public Builder compatibilities(Collection<Compatibility> var1);

        public Builder compatibilities(Compatibility ... var1);

        public Builder requiresCompatibilitiesWithStrings(Collection<String> var1);

        public Builder requiresCompatibilitiesWithStrings(String ... var1);

        public Builder requiresCompatibilities(Collection<Compatibility> var1);

        public Builder requiresCompatibilities(Compatibility ... var1);

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder pidMode(String var1);

        public Builder pidMode(PidMode var1);

        public Builder ipcMode(String var1);

        public Builder ipcMode(IpcMode var1);
    }
}

