/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::cluster)).setter(UpdateServiceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::service)).setter(UpdateServiceRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateServiceRequest.getter(UpdateServiceRequest::desiredCount)).setter(UpdateServiceRequest.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::taskDefinition)).setter(UpdateServiceRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateServiceRequest.getter(UpdateServiceRequest::deploymentConfiguration)).setter(UpdateServiceRequest.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateServiceRequest.getter(UpdateServiceRequest::networkConfiguration)).setter(UpdateServiceRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceRequest.getter(UpdateServiceRequest::platformVersion)).setter(UpdateServiceRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<Boolean> FORCE_NEW_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateServiceRequest.getter(UpdateServiceRequest::forceNewDeployment)).setter(UpdateServiceRequest.setter(Builder::forceNewDeployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceNewDeployment").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateServiceRequest.getter(UpdateServiceRequest::healthCheckGracePeriodSeconds)).setter(UpdateServiceRequest.setter(Builder::healthCheckGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD, DESIRED_COUNT_FIELD, TASK_DEFINITION_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, PLATFORM_VERSION_FIELD, FORCE_NEW_DEPLOYMENT_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD));
    private final String cluster;
    private final String service;
    private final Integer desiredCount;
    private final String taskDefinition;
    private final DeploymentConfiguration deploymentConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final String platformVersion;
    private final Boolean forceNewDeployment;
    private final Integer healthCheckGracePeriodSeconds;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.desiredCount = builder.desiredCount;
        this.taskDefinition = builder.taskDefinition;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.platformVersion = builder.platformVersion;
        this.forceNewDeployment = builder.forceNewDeployment;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
    }

    public String cluster() {
        return this.cluster;
    }

    public String service() {
        return this.service;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public Boolean forceNewDeployment() {
        return this.forceNewDeployment;
    }

    public Integer healthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceNewDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriodSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.forceNewDeployment(), other.forceNewDeployment()) && Objects.equals(this.healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds());
    }

    public String toString() {
        return ToString.builder((String)"UpdateServiceRequest").add("Cluster", (Object)this.cluster()).add("Service", (Object)this.service()).add("DesiredCount", (Object)this.desiredCount()).add("TaskDefinition", (Object)this.taskDefinition()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PlatformVersion", (Object)this.platformVersion()).add("ForceNewDeployment", (Object)this.forceNewDeployment()).add("HealthCheckGracePeriodSeconds", (Object)this.healthCheckGracePeriodSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "forceNewDeployment": {
                return Optional.ofNullable(clazz.cast(this.forceNewDeployment()));
            }
            case "healthCheckGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriodSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String service;
        private Integer desiredCount;
        private String taskDefinition;
        private DeploymentConfiguration deploymentConfiguration;
        private NetworkConfiguration networkConfiguration;
        private String platformVersion;
        private Boolean forceNewDeployment;
        private Integer healthCheckGracePeriodSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.service(model.service);
            this.desiredCount(model.desiredCount);
            this.taskDefinition(model.taskDefinition);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.networkConfiguration(model.networkConfiguration);
            this.platformVersion(model.platformVersion);
            this.forceNewDeployment(model.forceNewDeployment);
            this.healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final Boolean getForceNewDeployment() {
            return this.forceNewDeployment;
        }

        @Override
        public final Builder forceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
            return this;
        }

        public final void setForceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return this.healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceRequest> {
        public Builder cluster(String var1);

        public Builder service(String var1);

        public Builder desiredCount(Integer var1);

        public Builder taskDefinition(String var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder platformVersion(String var1);

        public Builder forceNewDeployment(Boolean var1);

        public Builder healthCheckGracePeriodSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

