/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VersionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VersionInfo> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VersionInfo.getter(VersionInfo::agentVersion)).setter(VersionInfo.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final SdkField<String> AGENT_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VersionInfo.getter(VersionInfo::agentHash)).setter(VersionInfo.setter(Builder::agentHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHash").build()}).build();
    private static final SdkField<String> DOCKER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VersionInfo.getter(VersionInfo::dockerVersion)).setter(VersionInfo.setter(Builder::dockerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD, AGENT_HASH_FIELD, DOCKER_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentVersion;
    private final String agentHash;
    private final String dockerVersion;

    private VersionInfo(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.agentHash = builder.agentHash;
        this.dockerVersion = builder.dockerVersion;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public String agentHash() {
        return this.agentHash;
    }

    public String dockerVersion() {
        return this.dockerVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)obj;
        return Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.agentHash(), other.agentHash()) && Objects.equals(this.dockerVersion(), other.dockerVersion());
    }

    public String toString() {
        return ToString.builder((String)"VersionInfo").add("AgentVersion", (Object)this.agentVersion()).add("AgentHash", (Object)this.agentHash()).add("DockerVersion", (Object)this.dockerVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "agentHash": {
                return Optional.ofNullable(clazz.cast(this.agentHash()));
            }
            case "dockerVersion": {
                return Optional.ofNullable(clazz.cast(this.dockerVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VersionInfo, T> g) {
        return obj -> g.apply((VersionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentVersion;
        private String agentHash;
        private String dockerVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionInfo model) {
            this.agentVersion(model.agentVersion);
            this.agentHash(model.agentHash);
            this.dockerVersion(model.dockerVersion);
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getAgentHash() {
            return this.agentHash;
        }

        @Override
        public final Builder agentHash(String agentHash) {
            this.agentHash = agentHash;
            return this;
        }

        public final void setAgentHash(String agentHash) {
            this.agentHash = agentHash;
        }

        public final String getDockerVersion() {
            return this.dockerVersion;
        }

        @Override
        public final Builder dockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
            return this;
        }

        public final void setDockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
        }

        public VersionInfo build() {
            return new VersionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VersionInfo> {
        public Builder agentVersion(String var1);

        public Builder agentHash(String var1);

        public Builder dockerVersion(String var1);
    }
}

