/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.ListServicesRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesResponse;

public class ListServicesPublisher
implements SdkPublisher<ListServicesResponse> {
    private final EcsAsyncClient client;
    private final ListServicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicesPublisher(EcsAsyncClient client, ListServicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicesPublisher(EcsAsyncClient client, ListServicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> serviceArns() {
        Function<ListServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceArns() != null) {
                return response.serviceArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListServicesPublisher resume(ListServicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListServicesPublisher(this.client, (ListServicesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListServicesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListServicesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListServicesResponseFetcher
    implements AsyncPageFetcher<ListServicesResponse> {
        private ListServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicesResponse> nextPage(ListServicesResponse previousPage) {
            if (previousPage == null) {
                return ListServicesPublisher.this.client.listServices(ListServicesPublisher.this.firstRequest);
            }
            return ListServicesPublisher.this.client.listServices((ListServicesRequest)((Object)ListServicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

