/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a container instance or task attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attachment implements SdkPojo, Serializable, ToCopyableBuilder<Attachment.Builder, Attachment> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Attachment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Attachment::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Attachment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<KeyValuePair>> DETAILS_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .memberName("details")
            .getter(getter(Attachment::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            STATUS_FIELD, DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String status;

    private final List<KeyValuePair> details;

    private Attachment(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.details = builder.details;
    }

    /**
     * <p>
     * The unique identifier for the attachment.
     * </p>
     * 
     * @return The unique identifier for the attachment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the attachment, such as <code>ElasticNetworkInterface</code>, <code>Service Connect</code>, and
     * <code>AmazonElasticBlockStorage</code>.
     * </p>
     * 
     * @return The type of the attachment, such as <code>ElasticNetworkInterface</code>, <code>Service Connect</code>,
     *         and <code>AmazonElasticBlockStorage</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The status of the attachment. Valid values are <code>PRECREATED</code>, <code>CREATED</code>,
     * <code>ATTACHING</code>, <code>ATTACHED</code>, <code>DETACHING</code>, <code>DETACHED</code>,
     * <code>DELETED</code>, and <code>FAILED</code>.
     * </p>
     * 
     * @return The status of the attachment. Valid values are <code>PRECREATED</code>, <code>CREATED</code>,
     *         <code>ATTACHING</code>, <code>ATTACHED</code>, <code>DETACHING</code>, <code>DETACHED</code>,
     *         <code>DELETED</code>, and <code>FAILED</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the attachment.
     * </p>
     * <p>
     * For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet ID, and the
     * private IPv4 address.
     * </p>
     * <p>
     * For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
     * <code>discoveryName</code>, and <code>ingressPortOverride</code>.
     * </p>
     * <p>
     * For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
     * <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the attachment fails to
     * create or attach).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return Details of the attachment.</p>
     *         <p>
     *         For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet ID,
     *         and the private IPv4 address.
     *         </p>
     *         <p>
     *         For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
     *         <code>discoveryName</code>, and <code>ingressPortOverride</code>.
     *         </p>
     *         <p>
     *         For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
     *         <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the attachment
     *         fails to create or attach).
     */
    public final List<KeyValuePair> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(type(), other.type())
                && Objects.equals(status(), other.status()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attachment").add("Id", id()).add("Type", type()).add("Status", status())
                .add("Details", hasDetails() ? details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attachment> {
        /**
         * <p>
         * The unique identifier for the attachment.
         * </p>
         * 
         * @param id
         *        The unique identifier for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the attachment, such as <code>ElasticNetworkInterface</code>, <code>Service Connect</code>, and
         * <code>AmazonElasticBlockStorage</code>.
         * </p>
         * 
         * @param type
         *        The type of the attachment, such as <code>ElasticNetworkInterface</code>, <code>Service Connect</code>
         *        , and <code>AmazonElasticBlockStorage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The status of the attachment. Valid values are <code>PRECREATED</code>, <code>CREATED</code>,
         * <code>ATTACHING</code>, <code>ATTACHED</code>, <code>DETACHING</code>, <code>DETACHED</code>,
         * <code>DELETED</code>, and <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the attachment. Valid values are <code>PRECREATED</code>, <code>CREATED</code>,
         *        <code>ATTACHING</code>, <code>ATTACHED</code>, <code>DETACHING</code>, <code>DETACHED</code>,
         *        <code>DELETED</code>, and <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Details of the attachment.
         * </p>
         * <p>
         * For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet ID, and
         * the private IPv4 address.
         * </p>
         * <p>
         * For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
         * <code>discoveryName</code>, and <code>ingressPortOverride</code>.
         * </p>
         * <p>
         * For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
         * <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the attachment fails
         * to create or attach).
         * </p>
         * 
         * @param details
         *        Details of the attachment.</p>
         *        <p>
         *        For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet
         *        ID, and the private IPv4 address.
         *        </p>
         *        <p>
         *        For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
         *        <code>discoveryName</code>, and <code>ingressPortOverride</code>.
         *        </p>
         *        <p>
         *        For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
         *        <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the
         *        attachment fails to create or attach).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<KeyValuePair> details);

        /**
         * <p>
         * Details of the attachment.
         * </p>
         * <p>
         * For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet ID, and
         * the private IPv4 address.
         * </p>
         * <p>
         * For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
         * <code>discoveryName</code>, and <code>ingressPortOverride</code>.
         * </p>
         * <p>
         * For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
         * <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the attachment fails
         * to create or attach).
         * </p>
         * 
         * @param details
         *        Details of the attachment.</p>
         *        <p>
         *        For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet
         *        ID, and the private IPv4 address.
         *        </p>
         *        <p>
         *        For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
         *        <code>discoveryName</code>, and <code>ingressPortOverride</code>.
         *        </p>
         *        <p>
         *        For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
         *        <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the
         *        attachment fails to create or attach).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(KeyValuePair... details);

        /**
         * <p>
         * Details of the attachment.
         * </p>
         * <p>
         * For elastic network interfaces, this includes the network interface ID, the MAC address, the subnet ID, and
         * the private IPv4 address.
         * </p>
         * <p>
         * For Service Connect services, this includes <code>portName</code>, <code>clientAliases</code>,
         * <code>discoveryName</code>, and <code>ingressPortOverride</code>.
         * </p>
         * <p>
         * For Elastic Block Storage, this includes <code>roleArn</code>, <code>deleteOnTermination</code>,
         * <code>volumeName</code>, <code>volumeId</code>, and <code>statusReason</code> (only when the attachment fails
         * to create or attach).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.KeyValuePair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.KeyValuePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.KeyValuePair.Builder#build()} is called immediately and its
         * result is passed to {@link #details(List<KeyValuePair>)}.
         * 
         * @param details
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.KeyValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(java.util.Collection<KeyValuePair>)
         */
        Builder details(Consumer<KeyValuePair.Builder>... details);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String status;

        private List<KeyValuePair> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            id(model.id);
            type(model.type);
            status(model.status);
            details(model.details);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final List<KeyValuePair.Builder> getDetails() {
            List<KeyValuePair.Builder> result = AttachmentDetailsCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<KeyValuePair.BuilderImpl> details) {
            this.details = AttachmentDetailsCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<KeyValuePair> details) {
            this.details = AttachmentDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(KeyValuePair... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<KeyValuePair.Builder>... details) {
            details(Stream.of(details).map(c -> KeyValuePair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Attachment build() {
            return new Attachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
