/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EnvironmentFile;
import software.amazon.awssdk.services.ecs.model.EnvironmentFilesCopier;
import software.amazon.awssdk.services.ecs.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.ResourceRequirement;
import software.amazon.awssdk.services.ecs.model.ResourceRequirementsCopier;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerOverride> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ContainerOverride.getter(ContainerOverride::name)).setter(ContainerOverride.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(ContainerOverride.getter(ContainerOverride::command)).setter(ContainerOverride.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environment").getter(ContainerOverride.getter(ContainerOverride::environment)).setter(ContainerOverride.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentFile>> ENVIRONMENT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentFiles").getter(ContainerOverride.getter(ContainerOverride::environmentFiles)).setter(ContainerOverride.setter(Builder::environmentFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpu").getter(ContainerOverride.getter(ContainerOverride::cpu)).setter(ContainerOverride.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(ContainerOverride.getter(ContainerOverride::memory)).setter(ContainerOverride.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memoryReservation").getter(ContainerOverride.getter(ContainerOverride::memoryReservation)).setter(ContainerOverride.setter(Builder::memoryReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()}).build();
    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceRequirements").getter(ContainerOverride.getter(ContainerOverride::resourceRequirements)).setter(ContainerOverride.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COMMAND_FIELD, ENVIRONMENT_FIELD, ENVIRONMENT_FILES_FIELD, CPU_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD, RESOURCE_REQUIREMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> command;
    private final List<KeyValuePair> environment;
    private final List<EnvironmentFile> environmentFiles;
    private final Integer cpu;
    private final Integer memory;
    private final Integer memoryReservation;
    private final List<ResourceRequirement> resourceRequirements;

    private ContainerOverride(BuilderImpl builder) {
        this.name = builder.name;
        this.command = builder.command;
        this.environment = builder.environment;
        this.environmentFiles = builder.environmentFiles;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.resourceRequirements = builder.resourceRequirements;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> environment() {
        return this.environment;
    }

    public final boolean hasEnvironmentFiles() {
        return this.environmentFiles != null && !(this.environmentFiles instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentFile> environmentFiles() {
        return this.environmentFiles;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Integer memoryReservation() {
        return this.memoryReservation;
    }

    public final boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public final List<ResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentFiles() ? this.environmentFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequirements() ? this.resourceRequirements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerOverride)) {
            return false;
        }
        ContainerOverride other = (ContainerOverride)obj;
        return Objects.equals(this.name(), other.name()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && this.hasEnvironmentFiles() == other.hasEnvironmentFiles() && Objects.equals(this.environmentFiles(), other.environmentFiles()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.memoryReservation(), other.memoryReservation()) && this.hasResourceRequirements() == other.hasResourceRequirements() && Objects.equals(this.resourceRequirements(), other.resourceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerOverride").add("Name", (Object)this.name()).add("Command", this.hasCommand() ? this.command() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("EnvironmentFiles", this.hasEnvironmentFiles() ? this.environmentFiles() : null).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("MemoryReservation", (Object)this.memoryReservation()).add("ResourceRequirements", this.hasResourceRequirements() ? this.resourceRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "environmentFiles": {
                return Optional.ofNullable(clazz.cast(this.environmentFiles()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "memoryReservation": {
                return Optional.ofNullable(clazz.cast(this.memoryReservation()));
            }
            case "resourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("environmentFiles", ENVIRONMENT_FILES_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("memoryReservation", MEMORY_RESERVATION_FIELD);
        map.put("resourceRequirements", RESOURCE_REQUIREMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerOverride, T> g) {
        return obj -> g.apply((ContainerOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private List<EnvironmentFile> environmentFiles = DefaultSdkAutoConstructList.getInstance();
        private Integer cpu;
        private Integer memory;
        private Integer memoryReservation;
        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerOverride model) {
            this.name(model.name);
            this.command(model.command);
            this.environment(model.environment);
            this.environmentFiles(model.environmentFiles);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.memoryReservation(model.memoryReservation);
            this.resourceRequirements(model.resourceRequirements);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final List<KeyValuePair.Builder> getEnvironment() {
            List<KeyValuePair.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EnvironmentFile.Builder> getEnvironmentFiles() {
            List<EnvironmentFile.Builder> result = EnvironmentFilesCopier.copyToBuilder(this.environmentFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFiles(Collection<EnvironmentFile.BuilderImpl> environmentFiles) {
            this.environmentFiles = EnvironmentFilesCopier.copyFromBuilder(environmentFiles);
        }

        @Override
        public final Builder environmentFiles(Collection<EnvironmentFile> environmentFiles) {
            this.environmentFiles = EnvironmentFilesCopier.copy(environmentFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(EnvironmentFile ... environmentFiles) {
            this.environmentFiles(Arrays.asList(environmentFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(Consumer<EnvironmentFile.Builder> ... environmentFiles) {
            this.environmentFiles(Stream.of(environmentFiles).map(c -> (EnvironmentFile)((EnvironmentFile.Builder)EnvironmentFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return this.memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final List<ResourceRequirement.Builder> getResourceRequirements() {
            List<ResourceRequirement.Builder> result = ResourceRequirementsCopier.copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (ResourceRequirement)((ResourceRequirement.Builder)ResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContainerOverride build() {
            return new ContainerOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerOverride> {
        public Builder name(String var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder environmentFiles(Collection<EnvironmentFile> var1);

        public Builder environmentFiles(EnvironmentFile ... var1);

        public Builder environmentFiles(Consumer<EnvironmentFile.Builder> ... var1);

        public Builder cpu(Integer var1);

        public Builder memory(Integer var1);

        public Builder memoryReservation(Integer var1);

        public Builder resourceRequirements(Collection<ResourceRequirement> var1);

        public Builder resourceRequirements(ResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... var1);
    }
}

