/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult;
import software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResultListCopier;
import software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerInstanceHealthStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerInstanceHealthStatus> {
    private static final SdkField<String> OVERALL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overallStatus").getter(ContainerInstanceHealthStatus.getter(ContainerInstanceHealthStatus::overallStatusAsString)).setter(ContainerInstanceHealthStatus.setter(Builder::overallStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overallStatus").build()}).build();
    private static final SdkField<List<InstanceHealthCheckResult>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("details").getter(ContainerInstanceHealthStatus.getter(ContainerInstanceHealthStatus::details)).setter(ContainerInstanceHealthStatus.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceHealthCheckResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERALL_STATUS_FIELD, DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerInstanceHealthStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String overallStatus;
    private final List<InstanceHealthCheckResult> details;

    private ContainerInstanceHealthStatus(BuilderImpl builder) {
        this.overallStatus = builder.overallStatus;
        this.details = builder.details;
    }

    public final InstanceHealthCheckState overallStatus() {
        return InstanceHealthCheckState.fromValue(this.overallStatus);
    }

    public final String overallStatusAsString() {
        return this.overallStatus;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<InstanceHealthCheckResult> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.overallStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInstanceHealthStatus)) {
            return false;
        }
        ContainerInstanceHealthStatus other = (ContainerInstanceHealthStatus)obj;
        return Objects.equals(this.overallStatusAsString(), other.overallStatusAsString()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerInstanceHealthStatus").add("OverallStatus", (Object)this.overallStatusAsString()).add("Details", this.hasDetails() ? this.details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "overallStatus": {
                return Optional.ofNullable(clazz.cast(this.overallStatusAsString()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("overallStatus", OVERALL_STATUS_FIELD);
        map.put("details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerInstanceHealthStatus, T> g) {
        return obj -> g.apply((ContainerInstanceHealthStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String overallStatus;
        private List<InstanceHealthCheckResult> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInstanceHealthStatus model) {
            this.overallStatus(model.overallStatus);
            this.details(model.details);
        }

        public final String getOverallStatus() {
            return this.overallStatus;
        }

        public final void setOverallStatus(String overallStatus) {
            this.overallStatus = overallStatus;
        }

        @Override
        public final Builder overallStatus(String overallStatus) {
            this.overallStatus = overallStatus;
            return this;
        }

        @Override
        public final Builder overallStatus(InstanceHealthCheckState overallStatus) {
            this.overallStatus(overallStatus == null ? null : overallStatus.toString());
            return this;
        }

        public final List<InstanceHealthCheckResult.Builder> getDetails() {
            List<InstanceHealthCheckResult.Builder> result = InstanceHealthCheckResultListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<InstanceHealthCheckResult.BuilderImpl> details) {
            this.details = InstanceHealthCheckResultListCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<InstanceHealthCheckResult> details) {
            this.details = InstanceHealthCheckResultListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(InstanceHealthCheckResult ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<InstanceHealthCheckResult.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (InstanceHealthCheckResult)((InstanceHealthCheckResult.Builder)InstanceHealthCheckResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContainerInstanceHealthStatus build() {
            return new ContainerInstanceHealthStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerInstanceHealthStatus> {
        public Builder overallStatus(String var1);

        public Builder overallStatus(InstanceHealthCheckState var1);

        public Builder details(Collection<InstanceHealthCheckResult> var1);

        public Builder details(InstanceHealthCheckResult ... var1);

        public Builder details(Consumer<InstanceHealthCheckResult.Builder> ... var1);
    }
}

