/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttributesRequest extends EcsRequest implements
        ToCopyableBuilder<ListAttributesRequest.Builder, ListAttributesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(ListAttributesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(ListAttributesRequest::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeName").getter(getter(ListAttributesRequest::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeValue").getter(getter(ListAttributesRequest::attributeValue))
            .setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeValue").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAttributesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAttributesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            TARGET_TYPE_FIELD, ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cluster;

    private final String targetType;

    private final String attributeName;

    private final String attributeValue;

    private final String nextToken;

    private final Integer maxResults;

    private ListAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.targetType = builder.targetType;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a
     * cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not
     *         specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The type of the target to list attributes with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the target to list attributes with.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of the target to list attributes with.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the target to list attributes with.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The name of the attribute to filter the results with.
     * </p>
     * 
     * @return The name of the attribute to filter the results with.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The value of the attribute to filter results with. You must also specify an attribute name to use this parameter.
     * </p>
     * 
     * @return The value of the attribute to filter results with. You must also specify an attribute name to use this
     *         parameter.
     */
    public final String attributeValue() {
        return attributeValue;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that more results
     * are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's
     * possible the number of results to be fewer than <code>maxResults</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that more
     *         results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was
     *         provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output. When this
     * parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results in a single page
     * along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>ListAttributes</code> request with the returned <code>nextToken</code> value. This value
     * can be between 1 and 100. If this parameter isn't used, then <code>ListAttributes</code> returns up to 100
     * results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output. When
     *         this parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results in a
     *         single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>ListAttributes</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
     *         <code>ListAttributes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttributesRequest)) {
            return false;
        }
        ListAttributesRequest other = (ListAttributesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeValue(), other.attributeValue()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttributesRequest").add("Cluster", cluster()).add("TargetType", targetTypeAsString())
                .add("AttributeName", attributeName()).add("AttributeValue", attributeValue()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "attributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "attributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("attributeName", ATTRIBUTE_NAME_FIELD);
        map.put("attributeValue", ATTRIBUTE_VALUE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAttributesRequest, T> g) {
        return obj -> g.apply((ListAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAttributesRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a
         * cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not
         *        specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The type of the target to list attributes with.
         * </p>
         * 
         * @param targetType
         *        The type of the target to list attributes with.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of the target to list attributes with.
         * </p>
         * 
         * @param targetType
         *        The type of the target to list attributes with.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        /**
         * <p>
         * The name of the attribute to filter the results with.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute to filter the results with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The value of the attribute to filter results with. You must also specify an attribute name to use this
         * parameter.
         * </p>
         * 
         * @param attributeValue
         *        The value of the attribute to filter results with. You must also specify an attribute name to use this
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that more
         * results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was
         * provided, it's possible the number of results to be fewer than <code>maxResults</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that
         *        more results are available to fulfill the request and further calls are needed. If
         *        <code>maxResults</code> was provided, it's possible the number of results to be fewer than
         *        <code>maxResults</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output. When
         * this parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results in a single
         * page along with a <code>nextToken</code> response element. The remaining results of the initial request can
         * be seen by sending another <code>ListAttributes</code> request with the returned <code>nextToken</code>
         * value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListAttributes</code>
         * returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output.
         *        When this parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results
         *        in a single page along with a <code>nextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>ListAttributes</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         *        <code>ListAttributes</code> returns up to 100 results and a <code>nextToken</code> value if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String targetType;

        private String attributeName;

        private String attributeValue;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttributesRequest model) {
            super(model);
            cluster(model.cluster);
            targetType(model.targetType);
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAttributesRequest build() {
            return new ListAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
