/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceRequest extends EcsRequest implements
        ToCopyableBuilder<CreateServiceRequest.Builder, CreateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(CreateServiceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(CreateServiceRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinition").getter(getter(CreateServiceRequest::taskDefinition))
            .setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_REBALANCING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneRebalancing")
            .getter(getter(CreateServiceRequest::availabilityZoneRebalancingAsString))
            .setter(setter(Builder::availabilityZoneRebalancing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneRebalancing")
                    .build()).build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .memberName("loadBalancers")
            .getter(getter(CreateServiceRequest::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .memberName("serviceRegistries")
            .getter(getter(CreateServiceRequest::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCount").getter(getter(CreateServiceRequest::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreateServiceRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchType").getter(getter(CreateServiceRequest::launchTypeAsString))
            .setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("capacityProviderStrategy")
            .getter(getter(CreateServiceRequest::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(CreateServiceRequest::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(CreateServiceRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(CreateServiceRequest::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .memberName("placementConstraints")
            .getter(getter(CreateServiceRequest::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .memberName("placementStrategy")
            .getter(getter(CreateServiceRequest::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(CreateServiceRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthCheckGracePeriodSeconds")
            .getter(getter(CreateServiceRequest::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schedulingStrategy").getter(getter(CreateServiceRequest::schedulingStrategyAsString))
            .setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build())
            .build();

    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField
            .<DeploymentController> builder(MarshallingType.SDK_POJO).memberName("deploymentController")
            .getter(getter(CreateServiceRequest::deploymentController)).setter(setter(Builder::deploymentController))
            .constructor(DeploymentController::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateServiceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableECSManagedTags").getter(getter(CreateServiceRequest::enableECSManagedTags))
            .setter(setter(Builder::enableECSManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build())
            .build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propagateTags").getter(getter(CreateServiceRequest::propagateTagsAsString))
            .setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableExecuteCommand").getter(getter(CreateServiceRequest::enableExecuteCommand))
            .setter(setter(Builder::enableExecuteCommand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build())
            .build();

    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField
            .<ServiceConnectConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serviceConnectConfiguration")
            .getter(getter(CreateServiceRequest::serviceConnectConfiguration))
            .setter(setter(Builder::serviceConnectConfiguration))
            .constructor(ServiceConnectConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration")
                    .build()).build();

    private static final SdkField<List<ServiceVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField
            .<List<ServiceVolumeConfiguration>> builder(MarshallingType.LIST)
            .memberName("volumeConfigurations")
            .getter(getter(CreateServiceRequest::volumeConfigurations))
            .setter(setter(Builder::volumeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceVolumeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceVolumeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VpcLatticeConfiguration>> VPC_LATTICE_CONFIGURATIONS_FIELD = SdkField
            .<List<VpcLatticeConfiguration>> builder(MarshallingType.LIST)
            .memberName("vpcLatticeConfigurations")
            .getter(getter(CreateServiceRequest::vpcLatticeConfigurations))
            .setter(setter(Builder::vpcLatticeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLatticeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcLatticeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcLatticeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            SERVICE_NAME_FIELD, TASK_DEFINITION_FIELD, AVAILABILITY_ZONE_REBALANCING_FIELD, LOAD_BALANCERS_FIELD,
            SERVICE_REGISTRIES_FIELD, DESIRED_COUNT_FIELD, CLIENT_TOKEN_FIELD, LAUNCH_TYPE_FIELD,
            CAPACITY_PROVIDER_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, ROLE_FIELD, DEPLOYMENT_CONFIGURATION_FIELD,
            PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD,
            ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD,
            SERVICE_CONNECT_CONFIGURATION_FIELD, VOLUME_CONFIGURATIONS_FIELD, VPC_LATTICE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cluster;

    private final String serviceName;

    private final String taskDefinition;

    private final String availabilityZoneRebalancing;

    private final List<LoadBalancer> loadBalancers;

    private final List<ServiceRegistry> serviceRegistries;

    private final Integer desiredCount;

    private final String clientToken;

    private final String launchType;

    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;

    private final String platformVersion;

    private final String role;

    private final DeploymentConfiguration deploymentConfiguration;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final NetworkConfiguration networkConfiguration;

    private final Integer healthCheckGracePeriodSeconds;

    private final String schedulingStrategy;

    private final DeploymentController deploymentController;

    private final List<Tag> tags;

    private final Boolean enableECSManagedTags;

    private final String propagateTags;

    private final Boolean enableExecuteCommand;

    private final ServiceConnectConfiguration serviceConnectConfiguration;

    private final List<ServiceVolumeConfiguration> volumeConfigurations;

    private final List<VpcLatticeConfiguration> vpcLatticeConfigurations;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.taskDefinition = builder.taskDefinition;
        this.availabilityZoneRebalancing = builder.availabilityZoneRebalancing;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.desiredCount = builder.desiredCount;
        this.clientToken = builder.clientToken;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.role = builder.role;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.vpcLatticeConfigurations = builder.vpcLatticeConfigurations;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not
     * specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do
     *         not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
     * allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple
     * clusters within a Region or across multiple Regions.
     * </p>
     * 
     * @return The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens
     *         are allowed. Service names must be unique within a cluster, but you can have similarly named services in
     *         multiple clusters within a Region or across multiple Regions.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     * definition to run in your service. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code>
     * revision is used.
     * </p>
     * <p>
     * A task definition must be specified if the service uses either the <code>ECS</code> or <code>CODE_DEPLOY</code>
     * deployment controllers.
     * </p>
     * <p>
     * For more information about deployment types, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a>.
     * </p>
     * 
     * @return The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     *         definition to run in your service. If a <code>revision</code> isn't specified, the latest
     *         <code>ACTIVE</code> revision is used.</p>
     *         <p>
     *         A task definition must be specified if the service uses either the <code>ECS</code> or
     *         <code>CODE_DEPLOY</code> deployment controllers.
     *         </p>
     *         <p>
     *         For more information about deployment types, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS
     *         deployment types</a>.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    /**
     * <p>
     * Indicates whether to use Availability Zone rebalancing for the service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an Amazon
     * ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i>
     * </i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityZoneRebalancing} will return {@link AvailabilityZoneRebalancing#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #availabilityZoneRebalancingAsString}.
     * </p>
     * 
     * @return Indicates whether to use Availability Zone rebalancing for the service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
     *         Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
     *         Guide</i> </i>.
     * @see AvailabilityZoneRebalancing
     */
    public final AvailabilityZoneRebalancing availabilityZoneRebalancing() {
        return AvailabilityZoneRebalancing.fromValue(availabilityZoneRebalancing);
    }

    /**
     * <p>
     * Indicates whether to use Availability Zone rebalancing for the service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an Amazon
     * ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i>
     * </i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityZoneRebalancing} will return {@link AvailabilityZoneRebalancing#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #availabilityZoneRebalancingAsString}.
     * </p>
     * 
     * @return Indicates whether to use Availability Zone rebalancing for the service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
     *         Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
     *         Guide</i> </i>.
     * @see AvailabilityZoneRebalancing
     */
    public final String availabilityZoneRebalancingAsString() {
        return availabilityZoneRebalancing;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A load balancer object representing the load balancers to use with your service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service load
     * balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an Application
     * Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach to the service.
     * The service-linked role is required for services that use multiple target groups. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either an
     * Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you specify two
     * target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy determines which
     * task set in your service has the status <code>PRIMARY</code>, and it associates one target group with it. Then,
     * it also associates the other target group with the replacement task set. The load balancer can also have up to
     * two listeners: a required listener for production traffic and an optional listener that you can use to perform
     * validation tests with Lambda functions before routing production traffic to it.
     * </p>
     * <p>
     * If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
     * service.
     * </p>
     * <p>
     * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
     * group ARN, the container name, and the container port to access from the load balancer. The container name must
     * be as it appears in a container definition. The load balancer name parameter must be omitted. When a task from
     * this service is placed on a container instance, the container instance and port combination is registered as a
     * target in the target group that's specified here.
     * </p>
     * <p>
     * For Classic Load Balancers, this object must contain the load balancer name, the container name , and the
     * container port to access from the load balancer. The container name must be as it appears in a container
     * definition. The target group ARN parameter must be omitted. When a task from this service is placed on a
     * container instance, the container instance is registered with the load balancer that's specified here.
     * </p>
     * <p>
     * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
     * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't
     * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
     * target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode are
     * associated with an elastic network interface, not an Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return A load balancer object representing the load balancers to use with your service. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service
     *         load balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an
     *         Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to
     *         attach to the service. The service-linked role is required for services that use multiple target groups.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     *         service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use
     *         either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment
     *         group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a
     *         deployment, CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>, and
     *         it associates one target group with it. Then, it also associates the other target group with the
     *         replacement task set. The load balancer can also have up to two listeners: a required listener for
     *         production traffic and an optional listener that you can use to perform validation tests with Lambda
     *         functions before routing production traffic to it.
     *         </p>
     *         <p>
     *         If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating
     *         the service.
     *         </p>
     *         <p>
     *         For Application Load Balancers and Network Load Balancers, this object must contain the load balancer
     *         target group ARN, the container name, and the container port to access from the load balancer. The
     *         container name must be as it appears in a container definition. The load balancer name parameter must be
     *         omitted. When a task from this service is placed on a container instance, the container instance and port
     *         combination is registered as a target in the target group that's specified here.
     *         </p>
     *         <p>
     *         For Classic Load Balancers, this object must contain the load balancer name, the container name , and the
     *         container port to access from the load balancer. The container name must be as it appears in a container
     *         definition. The target group ARN parameter must be omitted. When a task from this service is placed on a
     *         container instance, the container instance is registered with the load balancer that's specified here.
     *         </p>
     *         <p>
     *         Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate
     *         launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers
     *         aren't supported. Also, when you create any target groups for these services, you must choose
     *         <code>ip</code> as the target type, not <code>instance</code>. This is because tasks that use the
     *         <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2
     *         instance.
     */
    public final List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceRegistries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceRegistries() {
        return serviceRegistries != null && !(serviceRegistries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the service discovery registry to associate with this service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a>.
     * </p>
     * <note>
     * <p>
     * Each service may be associated with one service registry. Multiple service registries for each service isn't
     * supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceRegistries} method.
     * </p>
     * 
     * @return The details of the service discovery registry to associate with this service. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         discovery</a>.</p> <note>
     *         <p>
     *         Each service may be associated with one service registry. Multiple service registries for each service
     *         isn't supported.
     *         </p>
     */
    public final List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The number of instantiations of the specified task definition to place and keep running in your service.
     * </p>
     * <p>
     * This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If
     * <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.
     * </p>
     * 
     * @return The number of instantiations of the specified task definition to place and keep running in your
     *         service.</p>
     *         <p>
     *         This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If
     *         <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.
     */
    public final Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive.
     * Up to 36 ASCII characters in the range of 33-126 (inclusive) are allowed.
     * </p>
     * 
     * @return An identifier that you provide to ensure the idempotency of the request. It must be unique and is case
     *         sensitive. Up to 36 ASCII characters in the range of 33-126 (inclusive) are allowed.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The infrastructure that you run your service on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
     * </p>
     * <note>
     * <p>
     * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html">Fargate
     * capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
     * </p>
     * <p>
     * The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity
     * registered to your cluster.
     * </p>
     * <p>
     * A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is
     * specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The infrastructure that you run your service on. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *         types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
     *         </p>
     *         <note>
     *         <p>
     *         Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html"
     *         >Fargate capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
     *         </p>
     *         <p>
     *         The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM)
     *         capacity registered to your cluster.
     *         </p>
     *         <p>
     *         A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is
     *         specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
     * @see LaunchType
     */
    public final LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The infrastructure that you run your service on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
     * </p>
     * <note>
     * <p>
     * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html">Fargate
     * capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
     * </p>
     * <p>
     * The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity
     * registered to your cluster.
     * </p>
     * <p>
     * A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is
     * specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The infrastructure that you run your service on. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *         types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
     *         </p>
     *         <note>
     *         <p>
     *         Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html"
     *         >Fargate capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
     *         </p>
     *         <p>
     *         The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM)
     *         capacity registered to your cluster.
     *         </p>
     *         <p>
     *         A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is
     *         specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
     * @see LaunchType
     */
    public final String launchTypeAsString() {
        return launchType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviderStrategy property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy to use for the service.
     * </p>
     * <p>
     * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted.
     * If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
     * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     * </p>
     * <p>
     * A capacity provider strategy can contain a maximum of 20 capacity providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviderStrategy} method.
     * </p>
     * 
     * @return The capacity provider strategy to use for the service.</p>
     *         <p>
     *         If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
     *         omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
     *         <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     *         </p>
     *         <p>
     *         A capacity provider strategy can contain a maximum of 20 capacity providers.
     */
    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * The platform version that your tasks in the service are running on. A platform version is specified only for
     * tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
     * versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version that your tasks in the service are running on. A platform version is specified only
     *         for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version
     *         is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
     *         platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load
     * balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and
     * your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code>
     * parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.
     * </p>
     * <important>
     * <p>
     * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless
     * you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code>
     * network mode or if the service is configured to use service discovery, an external deployment controller,
     * multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this
     * is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has
     * a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
     * >Friendly names and paths</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your
     *         load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your
     *         service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the
     *         <code>role</code> parameter, you must also specify a load balancer object with the
     *         <code>loadBalancers</code> parameter.</p> <important>
     *         <p>
     *         If your account has already created the Amazon ECS service-linked role, that role is used for your
     *         service unless you specify a role here. The service-linked role is required if your task definition uses
     *         the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an
     *         external deployment controller, multiple target groups, or Elastic Inference accelerators in which case
     *         you don't specify a role here. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     *         service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         If your specified role has a path other than <code>/</code>, then you must either specify the full role
     *         ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name
     *         <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the
     *         role name. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
     *         >Friendly names and paths</a> in the <i>IAM User Guide</i>.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
     * constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementConstraints} method.
     * </p>
     * 
     * @return An array of placement constraint objects to use for tasks in your service. You can specify a maximum of
     *         10 constraints for each task. This limit includes constraints in the task definition and those specified
     *         at runtime.
     */
    public final List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementStrategy property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementStrategy() {
        return placementStrategy != null && !(placementStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy rules
     * for each service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementStrategy} method.
     * </p>
     * 
     * @return The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy
     *         rules for each service.
     */
    public final List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The network configuration for the service. This parameter is required for task definitions that use the
     * <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other
     * network modes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The network configuration for the service. This parameter is required for task definitions that use the
     *         <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported
     *         for other network modes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
     *         networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing,
     * VPC Lattice, and container health checks after a task has first started. If you don't specify a health check
     * grace period value, the default value of <code>0</code> is used. If you don't use any of the health checks, then
     * <code>healthCheckGracePeriodSeconds</code> is unused.
     * </p>
     * <p>
     * If your service's tasks take a while to start and respond to health checks, you can specify a health check grace
     * period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler
     * ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy
     * and stopping them before they have time to come up.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
     *         Balancing, VPC Lattice, and container health checks after a task has first started. If you don't specify
     *         a health check grace period value, the default value of <code>0</code> is used. If you don't use any of
     *         the health checks, then <code>healthCheckGracePeriodSeconds</code> is unused.</p>
     *         <p>
     *         If your service's tasks take a while to start and respond to health checks, you can specify a health
     *         check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS
     *         service scheduler ignores health check status. This grace period can prevent the service scheduler from
     *         marking tasks as unhealthy and stopping them before they have time to come up.
     */
    public final Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions. This scheduler strategy is required if the
     * service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
     * that meets all of the task placement constraints that you specify in your cluster. The service scheduler also
     * evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement
     * constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task
     * placement strategy, or use Service Auto Scaling policies.
     * </p>
     * <note>
     * <p>
     * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
     * controller types don't support the <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions. This scheduler
     *         strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
     *         controller types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
     *         instance that meets all of the task placement constraints that you specify in your cluster. The service
     *         scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't
     *         meet the placement constraints. When you're using this strategy, you don't need to specify a desired
     *         number of tasks, a task placement strategy, or use Service Auto Scaling policies.
     *         </p>
     *         <note>
     *         <p>
     *         Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
     *         controller types don't support the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public final SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions. This scheduler strategy is required if the
     * service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
     * that meets all of the task placement constraints that you specify in your cluster. The service scheduler also
     * evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement
     * constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task
     * placement strategy, or use Service Auto Scaling policies.
     * </p>
     * <note>
     * <p>
     * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
     * controller types don't support the <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions. This scheduler
     *         strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
     *         controller types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
     *         instance that meets all of the task placement constraints that you specify in your cluster. The service
     *         scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't
     *         meet the placement constraints. When you're using this strategy, you don't need to specify a desired
     *         number of tasks, a task placement strategy, or use Service Auto Scaling policies.
     *         </p>
     *         <note>
     *         <p>
     *         Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
     *         controller types don't support the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public final String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The deployment controller to use for the service. If no deployment controller is specified, the default value of
     * <code>ECS</code> is used.
     * </p>
     * 
     * @return The deployment controller to use for the service. If no deployment controller is specified, the default
     *         value of <code>ECS</code> is used.
     */
    public final DeploymentController deploymentController() {
        return deploymentController;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key
     * and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the service to help you categorize and organize them. Each tag consists of
     *         a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as
     *         well.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS
     * resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * When you use Amazon ECS managed tags, you need to set the <code>propagateTags</code> request parameter.
     * </p>
     * 
     * @return Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your
     *         Amazon ECS resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         When you use Amazon ECS managed tags, you need to set the <code>propagateTags</code> request parameter.
     */
    public final Boolean enableECSManagedTags() {
        return enableECSManagedTags;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags
     * aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task
     * creation, use the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API action.
     * </p>
     * <p>
     * You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
     * reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * The default is <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the task definition to the task. If no value is specified,
     *         the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to
     *         a task after task creation, use the <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API
     *         action.</p>
     *         <p>
     *         You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
     *         reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         The default is <code>NONE</code>.
     * @see PropagateTags
     */
    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags
     * aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task
     * creation, use the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API action.
     * </p>
     * <p>
     * You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
     * reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * The default is <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the task definition to the task. If no value is specified,
     *         the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to
     *         a task after task creation, use the <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API
     *         action.</p>
     *         <p>
     *         You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
     *         reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         The default is <code>NONE</code>.
     * @see PropagateTags
     */
    public final String propagateTagsAsString() {
        return propagateTags;
    }

    /**
     * <p>
     * Determines whether the execute command functionality is turned on for the service. If <code>true</code>, this
     * enables execute command functionality on all containers in the service tasks.
     * </p>
     * 
     * @return Determines whether the execute command functionality is turned on for the service. If <code>true</code>,
     *         this enables execute command functionality on all containers in the service tasks.
     */
    public final Boolean enableExecuteCommand() {
        return enableExecuteCommand;
    }

    /**
     * <p>
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from,
     * other services within a namespace.
     * </p>
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to
     * services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
     * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported
     * with Service Connect. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The configuration for this service to discover and connect to services, and be discovered by, and
     *         connected from, other services within a namespace.</p>
     *         <p>
     *         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
     *         connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
     *         container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
     *         services create are supported with Service Connect. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
     *         Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return serviceConnectConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeConfigurations() {
        return volumeConfigurations != null && !(volumeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
     * Currently, the only supported volume type is an Amazon EBS volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeConfigurations} method.
     * </p>
     * 
     * @return The configuration for a volume specified in the task definition as a volume that is configured at launch
     *         time. Currently, the only supported volume type is an Amazon EBS volume.
     */
    public final List<ServiceVolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcLatticeConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcLatticeConfigurations() {
        return vpcLatticeConfigurations != null && !(vpcLatticeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC Lattice configuration for the service being created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcLatticeConfigurations} method.
     * </p>
     * 
     * @return The VPC Lattice configuration for the service being created.
     */
    public final List<VpcLatticeConfiguration> vpcLatticeConfigurations() {
        return vpcLatticeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneRebalancingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceRegistries() ? serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviderStrategy() ? capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementStrategy() ? placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(serviceConnectConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeConfigurations() ? volumeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcLatticeConfigurations() ? vpcLatticeConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && Objects.equals(availabilityZoneRebalancingAsString(), other.availabilityZoneRebalancingAsString())
                && hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(loadBalancers(), other.loadBalancers())
                && hasServiceRegistries() == other.hasServiceRegistries()
                && Objects.equals(serviceRegistries(), other.serviceRegistries())
                && Objects.equals(desiredCount(), other.desiredCount()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy()
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(platformVersion(), other.platformVersion()) && Objects.equals(role(), other.role())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasPlacementStrategy() == other.hasPlacementStrategy()
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString())
                && Objects.equals(deploymentController(), other.deploymentController()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(enableECSManagedTags(), other.enableECSManagedTags())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString())
                && Objects.equals(enableExecuteCommand(), other.enableExecuteCommand())
                && Objects.equals(serviceConnectConfiguration(), other.serviceConnectConfiguration())
                && hasVolumeConfigurations() == other.hasVolumeConfigurations()
                && Objects.equals(volumeConfigurations(), other.volumeConfigurations())
                && hasVpcLatticeConfigurations() == other.hasVpcLatticeConfigurations()
                && Objects.equals(vpcLatticeConfigurations(), other.vpcLatticeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceRequest").add("Cluster", cluster()).add("ServiceName", serviceName())
                .add("TaskDefinition", taskDefinition())
                .add("AvailabilityZoneRebalancing", availabilityZoneRebalancingAsString())
                .add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null)
                .add("ServiceRegistries", hasServiceRegistries() ? serviceRegistries() : null)
                .add("DesiredCount", desiredCount()).add("ClientToken", clientToken()).add("LaunchType", launchTypeAsString())
                .add("CapacityProviderStrategy", hasCapacityProviderStrategy() ? capacityProviderStrategy() : null)
                .add("PlatformVersion", platformVersion()).add("Role", role())
                .add("DeploymentConfiguration", deploymentConfiguration())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("PlacementStrategy", hasPlacementStrategy() ? placementStrategy() : null)
                .add("NetworkConfiguration", networkConfiguration())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds())
                .add("SchedulingStrategy", schedulingStrategyAsString()).add("DeploymentController", deploymentController())
                .add("Tags", hasTags() ? tags() : null).add("EnableECSManagedTags", enableECSManagedTags())
                .add("PropagateTags", propagateTagsAsString()).add("EnableExecuteCommand", enableExecuteCommand())
                .add("ServiceConnectConfiguration", serviceConnectConfiguration())
                .add("VolumeConfigurations", hasVolumeConfigurations() ? volumeConfigurations() : null)
                .add("VpcLatticeConfigurations", hasVpcLatticeConfigurations() ? vpcLatticeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "availabilityZoneRebalancing":
            return Optional.ofNullable(clazz.cast(availabilityZoneRebalancingAsString()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "capacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "role":
            return Optional.ofNullable(clazz.cast(role()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "schedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        case "deploymentController":
            return Optional.ofNullable(clazz.cast(deploymentController()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "enableECSManagedTags":
            return Optional.ofNullable(clazz.cast(enableECSManagedTags()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        case "enableExecuteCommand":
            return Optional.ofNullable(clazz.cast(enableExecuteCommand()));
        case "serviceConnectConfiguration":
            return Optional.ofNullable(clazz.cast(serviceConnectConfiguration()));
        case "volumeConfigurations":
            return Optional.ofNullable(clazz.cast(volumeConfigurations()));
        case "vpcLatticeConfigurations":
            return Optional.ofNullable(clazz.cast(vpcLatticeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("taskDefinition", TASK_DEFINITION_FIELD);
        map.put("availabilityZoneRebalancing", AVAILABILITY_ZONE_REBALANCING_FIELD);
        map.put("loadBalancers", LOAD_BALANCERS_FIELD);
        map.put("serviceRegistries", SERVICE_REGISTRIES_FIELD);
        map.put("desiredCount", DESIRED_COUNT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("launchType", LAUNCH_TYPE_FIELD);
        map.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
        map.put("platformVersion", PLATFORM_VERSION_FIELD);
        map.put("role", ROLE_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("placementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
        map.put("placementStrategy", PLACEMENT_STRATEGY_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("healthCheckGracePeriodSeconds", HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD);
        map.put("schedulingStrategy", SCHEDULING_STRATEGY_FIELD);
        map.put("deploymentController", DEPLOYMENT_CONTROLLER_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("enableECSManagedTags", ENABLE_ECS_MANAGED_TAGS_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        map.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
        map.put("serviceConnectConfiguration", SERVICE_CONNECT_CONFIGURATION_FIELD);
        map.put("volumeConfigurations", VOLUME_CONFIGURATIONS_FIELD);
        map.put("vpcLatticeConfigurations", VPC_LATTICE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not
         * specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you
         *        do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
         * allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple
         * clusters within a Region or across multiple Regions.
         * </p>
         * 
         * @param serviceName
         *        The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and
         *        hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named
         *        services in multiple clusters within a Region or across multiple Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
         * definition to run in your service. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code>
         * revision is used.
         * </p>
         * <p>
         * A task definition must be specified if the service uses either the <code>ECS</code> or
         * <code>CODE_DEPLOY</code> deployment controllers.
         * </p>
         * <p>
         * For more information about deployment types, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS
         * deployment types</a>.
         * </p>
         * 
         * @param taskDefinition
         *        The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the
         *        task definition to run in your service. If a <code>revision</code> isn't specified, the latest
         *        <code>ACTIVE</code> revision is used.</p>
         *        <p>
         *        A task definition must be specified if the service uses either the <code>ECS</code> or
         *        <code>CODE_DEPLOY</code> deployment controllers.
         *        </p>
         *        <p>
         *        For more information about deployment types, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS
         *        deployment types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * Indicates whether to use Availability Zone rebalancing for the service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
         * Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
         * Guide</i> </i>.
         * </p>
         * 
         * @param availabilityZoneRebalancing
         *        Indicates whether to use Availability Zone rebalancing for the service.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing
         *        an Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service
         *        Developer Guide</i> </i>.
         * @see AvailabilityZoneRebalancing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneRebalancing
         */
        Builder availabilityZoneRebalancing(String availabilityZoneRebalancing);

        /**
         * <p>
         * Indicates whether to use Availability Zone rebalancing for the service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
         * Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service Developer
         * Guide</i> </i>.
         * </p>
         * 
         * @param availabilityZoneRebalancing
         *        Indicates whether to use Availability Zone rebalancing for the service.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing
         *        an Amazon ECS service across Availability Zones</a> in the <i> <i>Amazon Elastic Container Service
         *        Developer Guide</i> </i>.
         * @see AvailabilityZoneRebalancing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneRebalancing
         */
        Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing);

        /**
         * <p>
         * A load balancer object representing the load balancers to use with your service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service load
         * balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an
         * Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach
         * to the service. The service-linked role is required for services that use multiple target groups. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
         * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either
         * an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you
         * specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy
         * determines which task set in your service has the status <code>PRIMARY</code>, and it associates one target
         * group with it. Then, it also associates the other target group with the replacement task set. The load
         * balancer can also have up to two listeners: a required listener for production traffic and an optional
         * listener that you can use to perform validation tests with Lambda functions before routing production traffic
         * to it.
         * </p>
         * <p>
         * If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
         * service.
         * </p>
         * <p>
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
         * group ARN, the container name, and the container port to access from the load balancer. The container name
         * must be as it appears in a container definition. The load balancer name parameter must be omitted. When a
         * task from this service is placed on a container instance, the container instance and port combination is
         * registered as a target in the target group that's specified here.
         * </p>
         * <p>
         * For Classic Load Balancers, this object must contain the load balancer name, the container name , and the
         * container port to access from the load balancer. The container name must be as it appears in a container
         * definition. The target group ARN parameter must be omitted. When a task from this service is placed on a
         * container instance, the container instance is registered with the load balancer that's specified here.
         * </p>
         * <p>
         * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
         * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't
         * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
         * target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode
         * are associated with an elastic network interface, not an Amazon EC2 instance.
         * </p>
         * 
         * @param loadBalancers
         *        A load balancer object representing the load balancers to use with your service. For more information,
         *        see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">
         *        Service load balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an
         *        Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to
         *        attach to the service. The service-linked role is required for services that use multiple target
         *        groups. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html"
         *        >Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer
         *        Guide</i>.
         *        </p>
         *        <p>
         *        If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use
         *        either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment
         *        group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a
         *        deployment, CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>,
         *        and it associates one target group with it. Then, it also associates the other target group with the
         *        replacement task set. The load balancer can also have up to two listeners: a required listener for
         *        production traffic and an optional listener that you can use to perform validation tests with Lambda
         *        functions before routing production traffic to it.
         *        </p>
         *        <p>
         *        If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when
         *        updating the service.
         *        </p>
         *        <p>
         *        For Application Load Balancers and Network Load Balancers, this object must contain the load balancer
         *        target group ARN, the container name, and the container port to access from the load balancer. The
         *        container name must be as it appears in a container definition. The load balancer name parameter must
         *        be omitted. When a task from this service is placed on a container instance, the container instance
         *        and port combination is registered as a target in the target group that's specified here.
         *        </p>
         *        <p>
         *        For Classic Load Balancers, this object must contain the load balancer name, the container name , and
         *        the container port to access from the load balancer. The container name must be as it appears in a
         *        container definition. The target group ARN parameter must be omitted. When a task from this service is
         *        placed on a container instance, the container instance is registered with the load balancer that's
         *        specified here.
         *        </p>
         *        <p>
         *        Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate
         *        launch type) only support Application Load Balancers and Network Load Balancers. Classic Load
         *        Balancers aren't supported. Also, when you create any target groups for these services, you must
         *        choose <code>ip</code> as the target type, not <code>instance</code>. This is because tasks that use
         *        the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon
         *        EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * A load balancer object representing the load balancers to use with your service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service load
         * balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an
         * Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach
         * to the service. The service-linked role is required for services that use multiple target groups. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
         * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either
         * an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you
         * specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy
         * determines which task set in your service has the status <code>PRIMARY</code>, and it associates one target
         * group with it. Then, it also associates the other target group with the replacement task set. The load
         * balancer can also have up to two listeners: a required listener for production traffic and an optional
         * listener that you can use to perform validation tests with Lambda functions before routing production traffic
         * to it.
         * </p>
         * <p>
         * If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
         * service.
         * </p>
         * <p>
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
         * group ARN, the container name, and the container port to access from the load balancer. The container name
         * must be as it appears in a container definition. The load balancer name parameter must be omitted. When a
         * task from this service is placed on a container instance, the container instance and port combination is
         * registered as a target in the target group that's specified here.
         * </p>
         * <p>
         * For Classic Load Balancers, this object must contain the load balancer name, the container name , and the
         * container port to access from the load balancer. The container name must be as it appears in a container
         * definition. The target group ARN parameter must be omitted. When a task from this service is placed on a
         * container instance, the container instance is registered with the load balancer that's specified here.
         * </p>
         * <p>
         * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
         * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't
         * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
         * target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode
         * are associated with an elastic network interface, not an Amazon EC2 instance.
         * </p>
         * 
         * @param loadBalancers
         *        A load balancer object representing the load balancers to use with your service. For more information,
         *        see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">
         *        Service load balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an
         *        Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to
         *        attach to the service. The service-linked role is required for services that use multiple target
         *        groups. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html"
         *        >Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer
         *        Guide</i>.
         *        </p>
         *        <p>
         *        If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use
         *        either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment
         *        group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a
         *        deployment, CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>,
         *        and it associates one target group with it. Then, it also associates the other target group with the
         *        replacement task set. The load balancer can also have up to two listeners: a required listener for
         *        production traffic and an optional listener that you can use to perform validation tests with Lambda
         *        functions before routing production traffic to it.
         *        </p>
         *        <p>
         *        If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when
         *        updating the service.
         *        </p>
         *        <p>
         *        For Application Load Balancers and Network Load Balancers, this object must contain the load balancer
         *        target group ARN, the container name, and the container port to access from the load balancer. The
         *        container name must be as it appears in a container definition. The load balancer name parameter must
         *        be omitted. When a task from this service is placed on a container instance, the container instance
         *        and port combination is registered as a target in the target group that's specified here.
         *        </p>
         *        <p>
         *        For Classic Load Balancers, this object must contain the load balancer name, the container name , and
         *        the container port to access from the load balancer. The container name must be as it appears in a
         *        container definition. The target group ARN parameter must be omitted. When a task from this service is
         *        placed on a container instance, the container instance is registered with the load balancer that's
         *        specified here.
         *        </p>
         *        <p>
         *        Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate
         *        launch type) only support Application Load Balancers and Network Load Balancers. Classic Load
         *        Balancers aren't supported. Also, when you create any target groups for these services, you must
         *        choose <code>ip</code> as the target type, not <code>instance</code>. This is because tasks that use
         *        the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon
         *        EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * A load balancer object representing the load balancers to use with your service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service load
         * balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an
         * Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach
         * to the service. The service-linked role is required for services that use multiple target groups. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
         * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either
         * an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you
         * specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy
         * determines which task set in your service has the status <code>PRIMARY</code>, and it associates one target
         * group with it. Then, it also associates the other target group with the replacement task set. The load
         * balancer can also have up to two listeners: a required listener for production traffic and an optional
         * listener that you can use to perform validation tests with Lambda functions before routing production traffic
         * to it.
         * </p>
         * <p>
         * If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the
         * service.
         * </p>
         * <p>
         * For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target
         * group ARN, the container name, and the container port to access from the load balancer. The container name
         * must be as it appears in a container definition. The load balancer name parameter must be omitted. When a
         * task from this service is placed on a container instance, the container instance and port combination is
         * registered as a target in the target group that's specified here.
         * </p>
         * <p>
         * For Classic Load Balancers, this object must contain the load balancer name, the container name , and the
         * container port to access from the load balancer. The container name must be as it appears in a container
         * definition. The target group ARN parameter must be omitted. When a task from this service is placed on a
         * container instance, the container instance is registered with the load balancer that's specified here.
         * </p>
         * <p>
         * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch
         * type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't
         * supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the
         * target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode
         * are associated with an elastic network interface, not an Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.LoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * The details of the service discovery registry to associate with this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * discovery</a>.
         * </p>
         * <note>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't
         * supported.
         * </p>
         * </note>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registry to associate with this service. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        discovery</a>.</p> <note>
         *        <p>
         *        Each service may be associated with one service registry. Multiple service registries for each service
         *        isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registry to associate with this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * discovery</a>.
         * </p>
         * <note>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't
         * supported.
         * </p>
         * </note>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registry to associate with this service. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        discovery</a>.</p> <note>
         *        <p>
         *        Each service may be associated with one service registry. Multiple service registries for each service
         *        isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registry to associate with this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * discovery</a>.
         * </p>
         * <note>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't
         * supported.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(java.util.Collection<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The number of instantiations of the specified task definition to place and keep running in your service.
         * </p>
         * <p>
         * This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If
         * <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.
         * </p>
         * 
         * @param desiredCount
         *        The number of instantiations of the specified task definition to place and keep running in your
         *        service.</p>
         *        <p>
         *        This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If
         *        <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * An identifier that you provide to ensure the idempotency of the request. It must be unique and is case
         * sensitive. Up to 36 ASCII characters in the range of 33-126 (inclusive) are allowed.
         * </p>
         * 
         * @param clientToken
         *        An identifier that you provide to ensure the idempotency of the request. It must be unique and is case
         *        sensitive. Up to 36 ASCII characters in the range of 33-126 (inclusive) are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The infrastructure that you run your service on. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
         * </p>
         * <note>
         * <p>
         * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html">Fargate
         * capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * </note>
         * <p>
         * The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
         * </p>
         * <p>
         * The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM)
         * capacity registered to your cluster.
         * </p>
         * <p>
         * A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is
         * specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
         * </p>
         * 
         * @param launchType
         *        The infrastructure that you run your service on. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
         *        </p>
         *        <note>
         *        <p>
         *        Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html"
         *        >Fargate capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        </note>
         *        <p>
         *        The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
         *        </p>
         *        <p>
         *        The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine
         *        (VM) capacity registered to your cluster.
         *        </p>
         *        <p>
         *        A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code>
         *        is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The infrastructure that you run your service on. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
         * </p>
         * <note>
         * <p>
         * Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html">Fargate
         * capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * </note>
         * <p>
         * The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
         * </p>
         * <p>
         * The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM)
         * capacity registered to your cluster.
         * </p>
         * <p>
         * A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is
         * specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
         * </p>
         * 
         * @param launchType
         *        The infrastructure that you run your service on. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.
         *        </p>
         *        <note>
         *        <p>
         *        Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html"
         *        >Fargate capacity providers</a> in the <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        </note>
         *        <p>
         *        The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.
         *        </p>
         *        <p>
         *        The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine
         *        (VM) capacity registered to your cluster.
         *        </p>
         *        <p>
         *        A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code>
         *        is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The capacity provider strategy to use for the service.
         * </p>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         * omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * </p>
         * <p>
         * A capacity provider strategy can contain a maximum of 20 capacity providers.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to use for the service.</p>
         *        <p>
         *        If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         *        omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         *        <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         *        </p>
         *        <p>
         *        A capacity provider strategy can contain a maximum of 20 capacity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to use for the service.
         * </p>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         * omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * </p>
         * <p>
         * A capacity provider strategy can contain a maximum of 20 capacity providers.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to use for the service.</p>
         *        <p>
         *        If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         *        omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         *        <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         *        </p>
         *        <p>
         *        A capacity provider strategy can contain a maximum of 20 capacity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to use for the service.
         * </p>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         * omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * </p>
         * <p>
         * A capacity provider strategy can contain a maximum of 20 capacity providers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(java.util.Collection<CapacityProviderStrategyItem>)
         */
        Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * The platform version that your tasks in the service are running on. A platform version is specified only for
         * tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is
         * used. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
         * versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version that your tasks in the service are running on. A platform version is specified
         *        only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform
         *        version is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
         *        platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load
         * balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service
         * and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the
         * <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code>
         * parameter.
         * </p>
         * <important>
         * <p>
         * If your account has already created the Amazon ECS service-linked role, that role is used for your service
         * unless you specify a role here. The service-linked role is required if your task definition uses the
         * <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external
         * deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't
         * specify a role here. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
         * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </important>
         * <p>
         * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN
         * (this is recommended) or prefix the role name with the path. For example, if a role with the name
         * <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role
         * name. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
         * >Friendly names and paths</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param role
         *        The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to
         *        your load balancer on your behalf. This parameter is only permitted if you are using a load balancer
         *        with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you
         *        specify the <code>role</code> parameter, you must also specify a load balancer object with the
         *        <code>loadBalancers</code> parameter.</p> <important>
         *        <p>
         *        If your account has already created the Amazon ECS service-linked role, that role is used for your
         *        service unless you specify a role here. The service-linked role is required if your task definition
         *        uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an
         *        external deployment controller, multiple target groups, or Elastic Inference accelerators in which
         *        case you don't specify a role here. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html"
         *        >Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer
         *        Guide</i>.
         *        </p>
         *        </important>
         *        <p>
         *        If your specified role has a path other than <code>/</code>, then you must either specify the full
         *        role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the
         *        name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as
         *        the role name. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names"
         *        >Friendly names and paths</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
         * constraints for each task. This limit includes constraints in the task definition and those specified at
         * runtime.
         * </p>
         * 
         * @param placementConstraints
         *        An array of placement constraint objects to use for tasks in your service. You can specify a maximum
         *        of 10 constraints for each task. This limit includes constraints in the task definition and those
         *        specified at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
         * constraints for each task. This limit includes constraints in the task definition and those specified at
         * runtime.
         * </p>
         * 
         * @param placementConstraints
         *        An array of placement constraint objects to use for tasks in your service. You can specify a maximum
         *        of 10 constraints for each task. This limit includes constraints in the task definition and those
         *        specified at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10
         * constraints for each task. This limit includes constraints in the task definition and those specified at
         * runtime.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(java.util.Collection<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy
         * rules for each service.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy objects to use for tasks in your service. You can specify a maximum of 5
         *        strategy rules for each service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy
         * rules for each service.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy objects to use for tasks in your service. You can specify a maximum of 5
         *        strategy rules for each service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy
         * rules for each service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder#build()} is called immediately and
         * its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(java.util.Collection<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The network configuration for the service. This parameter is required for task definitions that use the
         * <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for
         * other network modes. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the service. This parameter is required for task definitions that use
         *        the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't
         *        supported for other network modes. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
         *        networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the service. This parameter is required for task definitions that use the
         * <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for
         * other network modes. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         * Balancing, VPC Lattice, and container health checks after a task has first started. If you don't specify a
         * health check grace period value, the default value of <code>0</code> is used. If you don't use any of the
         * health checks, then <code>healthCheckGracePeriodSeconds</code> is unused.
         * </p>
         * <p>
         * If your service's tasks take a while to start and respond to health checks, you can specify a health check
         * grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service
         * scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks
         * as unhealthy and stopping them before they have time to come up.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         *        Balancing, VPC Lattice, and container health checks after a task has first started. If you don't
         *        specify a health check grace period value, the default value of <code>0</code> is used. If you don't
         *        use any of the health checks, then <code>healthCheckGracePeriodSeconds</code> is unused.</p>
         *        <p>
         *        If your service's tasks take a while to start and respond to health checks, you can specify a health
         *        check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS
         *        service scheduler ignores health check status. This grace period can prevent the service scheduler
         *        from marking tasks as unhealthy and stopping them before they have time to come up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions. This scheduler strategy is
         * required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
         * types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
         * that meets all of the task placement constraints that you specify in your cluster. The service scheduler also
         * evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement
         * constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task
         * placement strategy, or use Service Auto Scaling policies.
         * </p>
         * <note>
         * <p>
         * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
         * controller types don't support the <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions. This
         *        scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or
         *        <code>EXTERNAL</code> deployment controller types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         *        instance that meets all of the task placement constraints that you specify in your cluster. The
         *        service scheduler also evaluates the task placement constraints for running tasks and will stop tasks
         *        that don't meet the placement constraints. When you're using this strategy, you don't need to specify
         *        a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.
         *        </p>
         *        <note>
         *        <p>
         *        Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code>
         *        deployment controller types don't support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions. This scheduler strategy is
         * required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
         * types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance
         * that meets all of the task placement constraints that you specify in your cluster. The service scheduler also
         * evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement
         * constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task
         * placement strategy, or use Service Auto Scaling policies.
         * </p>
         * <note>
         * <p>
         * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment
         * controller types don't support the <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions. This
         *        scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or
         *        <code>EXTERNAL</code> deployment controller types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         *        instance that meets all of the task placement constraints that you specify in your cluster. The
         *        service scheduler also evaluates the task placement constraints for running tasks and will stop tasks
         *        that don't meet the placement constraints. When you're using this strategy, you don't need to specify
         *        a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.
         *        </p>
         *        <note>
         *        <p>
         *        Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code>
         *        deployment controller types don't support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(SchedulingStrategy schedulingStrategy);

        /**
         * <p>
         * The deployment controller to use for the service. If no deployment controller is specified, the default value
         * of <code>ECS</code> is used.
         * </p>
         * 
         * @param deploymentController
         *        The deployment controller to use for the service. If no deployment controller is specified, the
         *        default value of <code>ECS</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentController(DeploymentController deploymentController);

        /**
         * <p>
         * The deployment controller to use for the service. If no deployment controller is specified, the default value
         * of <code>ECS</code> is used.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentController.Builder} avoiding
         * the need to create one manually via {@link DeploymentController#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentController.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentController(DeploymentController)}.
         * 
         * @param deploymentController
         *        a consumer that will call methods on {@link DeploymentController.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentController(DeploymentController)
         */
        default Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return deploymentController(DeploymentController.builder().applyMutation(deploymentController).build());
        }

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define. When a service is deleted, the tags are
         *        deleted as well.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define. When a service is deleted, the tags are
         *        deleted as well.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your
         * Amazon ECS resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * When you use Amazon ECS managed tags, you need to set the <code>propagateTags</code> request parameter.
         * </p>
         * 
         * @param enableECSManagedTags
         *        Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your
         *        Amazon ECS resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        When you use Amazon ECS managed tags, you need to set the <code>propagateTags</code> request
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableECSManagedTags(Boolean enableECSManagedTags);

        /**
         * <p>
         * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the
         * tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task
         * after task creation, use the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API
         * action.
         * </p>
         * <p>
         * You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
         * reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * The default is <code>NONE</code>.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the task definition to the task. If no value is
         *        specified, the tags aren't propagated. Tags can only be propagated to the task during task creation.
         *        To add tags to a task after task creation, use the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a>
         *        API action.</p>
         *        <p>
         *        You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
         *        reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        The default is <code>NONE</code>.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the
         * tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task
         * after task creation, use the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API
         * action.
         * </p>
         * <p>
         * You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
         * reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * The default is <code>NONE</code>.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the task definition to the task. If no value is
         *        specified, the tags aren't propagated. Tags can only be propagated to the task during task creation.
         *        To add tags to a task after task creation, use the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a>
         *        API action.</p>
         *        <p>
         *        You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage
         *        reports</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        The default is <code>NONE</code>.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(PropagateTags propagateTags);

        /**
         * <p>
         * Determines whether the execute command functionality is turned on for the service. If <code>true</code>, this
         * enables execute command functionality on all containers in the service tasks.
         * </p>
         * 
         * @param enableExecuteCommand
         *        Determines whether the execute command functionality is turned on for the service. If
         *        <code>true</code>, this enables execute command functionality on all containers in the service tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExecuteCommand(Boolean enableExecuteCommand);

        /**
         * <p>
         * The configuration for this service to discover and connect to services, and be discovered by, and connected
         * from, other services within a namespace.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param serviceConnectConfiguration
         *        The configuration for this service to discover and connect to services, and be discovered by, and
         *        connected from, other services within a namespace.</p>
         *        <p>
         *        Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
         *        connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
         *        container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
         *        services create are supported with Service Connect. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         *        Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration);

        /**
         * <p>
         * The configuration for this service to discover and connect to services, and be discovered by, and connected
         * from, other services within a namespace.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceConnectConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServiceConnectConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceConnectConfiguration(ServiceConnectConfiguration)}.
         * 
         * @param serviceConnectConfiguration
         *        a consumer that will call methods on {@link ServiceConnectConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConnectConfiguration(ServiceConnectConfiguration)
         */
        default Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return serviceConnectConfiguration(ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration for a volume specified in the task definition as a volume that is configured at launch
         * time. Currently, the only supported volume type is an Amazon EBS volume.
         * </p>
         * 
         * @param volumeConfigurations
         *        The configuration for a volume specified in the task definition as a volume that is configured at
         *        launch time. Currently, the only supported volume type is an Amazon EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * The configuration for a volume specified in the task definition as a volume that is configured at launch
         * time. Currently, the only supported volume type is an Amazon EBS volume.
         * </p>
         * 
         * @param volumeConfigurations
         *        The configuration for a volume specified in the task definition as a volume that is configured at
         *        launch time. Currently, the only supported volume type is an Amazon EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(ServiceVolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * The configuration for a volume specified in the task definition as a volume that is configured at launch
         * time. Currently, the only supported volume type is an Amazon EBS volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #volumeConfigurations(List<ServiceVolumeConfiguration>)}.
         * 
         * @param volumeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeConfigurations(java.util.Collection<ServiceVolumeConfiguration>)
         */
        Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder>... volumeConfigurations);

        /**
         * <p>
         * The VPC Lattice configuration for the service being created.
         * </p>
         * 
         * @param vpcLatticeConfigurations
         *        The VPC Lattice configuration for the service being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> vpcLatticeConfigurations);

        /**
         * <p>
         * The VPC Lattice configuration for the service being created.
         * </p>
         * 
         * @param vpcLatticeConfigurations
         *        The VPC Lattice configuration for the service being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLatticeConfigurations(VpcLatticeConfiguration... vpcLatticeConfigurations);

        /**
         * <p>
         * The VPC Lattice configuration for the service being created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcLatticeConfigurations(List<VpcLatticeConfiguration>)}.
         * 
         * @param vpcLatticeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcLatticeConfigurations(java.util.Collection<VpcLatticeConfiguration>)
         */
        Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder>... vpcLatticeConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String serviceName;

        private String taskDefinition;

        private String availabilityZoneRebalancing;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private Integer desiredCount;

        private String clientToken;

        private String launchType;

        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private String role;

        private DeploymentConfiguration deploymentConfiguration;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private NetworkConfiguration networkConfiguration;

        private Integer healthCheckGracePeriodSeconds;

        private String schedulingStrategy;

        private DeploymentController deploymentController;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableECSManagedTags;

        private String propagateTags;

        private Boolean enableExecuteCommand;

        private ServiceConnectConfiguration serviceConnectConfiguration;

        private List<ServiceVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<VpcLatticeConfiguration> vpcLatticeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            cluster(model.cluster);
            serviceName(model.serviceName);
            taskDefinition(model.taskDefinition);
            availabilityZoneRebalancing(model.availabilityZoneRebalancing);
            loadBalancers(model.loadBalancers);
            serviceRegistries(model.serviceRegistries);
            desiredCount(model.desiredCount);
            clientToken(model.clientToken);
            launchType(model.launchType);
            capacityProviderStrategy(model.capacityProviderStrategy);
            platformVersion(model.platformVersion);
            role(model.role);
            deploymentConfiguration(model.deploymentConfiguration);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            networkConfiguration(model.networkConfiguration);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            schedulingStrategy(model.schedulingStrategy);
            deploymentController(model.deploymentController);
            tags(model.tags);
            enableECSManagedTags(model.enableECSManagedTags);
            propagateTags(model.propagateTags);
            enableExecuteCommand(model.enableExecuteCommand);
            serviceConnectConfiguration(model.serviceConnectConfiguration);
            volumeConfigurations(model.volumeConfigurations);
            vpcLatticeConfigurations(model.vpcLatticeConfigurations);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final String getAvailabilityZoneRebalancing() {
            return availabilityZoneRebalancing;
        }

        public final void setAvailabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
        }

        @Override
        public final Builder availabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
            return this;
        }

        @Override
        public final Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing(availabilityZoneRebalancing == null ? null : availabilityZoneRebalancing.toString());
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier
                    .copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final String getSchedulingStrategy() {
            return schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return deploymentController != null ? deploymentController.toBuilder() : null;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final String getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return serviceConnectConfiguration != null ? serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public final List<ServiceVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<ServiceVolumeConfiguration.Builder> result = ServiceVolumeConfigurationsCopier
                    .copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<ServiceVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(ServiceVolumeConfiguration... volumeConfigurations) {
            volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder>... volumeConfigurations) {
            volumeConfigurations(Stream.of(volumeConfigurations)
                    .map(c -> ServiceVolumeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcLatticeConfiguration.Builder> getVpcLatticeConfigurations() {
            List<VpcLatticeConfiguration.Builder> result = VpcLatticeConfigurationsCopier
                    .copyToBuilder(this.vpcLatticeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcLatticeConfigurations(Collection<VpcLatticeConfiguration.BuilderImpl> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copyFromBuilder(vpcLatticeConfigurations);
        }

        @Override
        public final Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copy(vpcLatticeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(VpcLatticeConfiguration... vpcLatticeConfigurations) {
            vpcLatticeConfigurations(Arrays.asList(vpcLatticeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder>... vpcLatticeConfigurations) {
            vpcLatticeConfigurations(Stream.of(vpcLatticeConfigurations)
                    .map(c -> VpcLatticeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
