/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the result of a container instance health status check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceHealthCheckResult implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceHealthCheckResult.Builder, InstanceHealthCheckResult> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(InstanceHealthCheckResult::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(InstanceHealthCheckResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(InstanceHealthCheckResult::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatusChange").getter(getter(InstanceHealthCheckResult::lastStatusChange))
            .setter(setter(Builder::lastStatusChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD,
            LAST_UPDATED_FIELD, LAST_STATUS_CHANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String status;

    private final Instant lastUpdated;

    private final Instant lastStatusChange;

    private InstanceHealthCheckResult(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.lastUpdated = builder.lastUpdated;
        this.lastStatusChange = builder.lastStatusChange;
    }

    /**
     * <p>
     * The type of container instance health status that was verified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InstanceHealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of container instance health status that was verified.
     * @see InstanceHealthCheckType
     */
    public final InstanceHealthCheckType type() {
        return InstanceHealthCheckType.fromValue(type);
    }

    /**
     * <p>
     * The type of container instance health status that was verified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InstanceHealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of container instance health status that was verified.
     * @see InstanceHealthCheckType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The container instance health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceHealthCheckState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The container instance health status.
     * @see InstanceHealthCheckState
     */
    public final InstanceHealthCheckState status() {
        return InstanceHealthCheckState.fromValue(status);
    }

    /**
     * <p>
     * The container instance health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceHealthCheckState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The container instance health status.
     * @see InstanceHealthCheckState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Unix timestamp for when the container instance health status was last updated.
     * </p>
     * 
     * @return The Unix timestamp for when the container instance health status was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The Unix timestamp for when the container instance health status last changed.
     * </p>
     * 
     * @return The Unix timestamp for when the container instance health status last changed.
     */
    public final Instant lastStatusChange() {
        return lastStatusChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHealthCheckResult)) {
            return false;
        }
        InstanceHealthCheckResult other = (InstanceHealthCheckResult) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(lastStatusChange(), other.lastStatusChange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceHealthCheckResult").add("Type", typeAsString()).add("Status", statusAsString())
                .add("LastUpdated", lastUpdated()).add("LastStatusChange", lastStatusChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "lastStatusChange":
            return Optional.ofNullable(clazz.cast(lastStatusChange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdated", LAST_UPDATED_FIELD);
        map.put("lastStatusChange", LAST_STATUS_CHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceHealthCheckResult, T> g) {
        return obj -> g.apply((InstanceHealthCheckResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceHealthCheckResult> {
        /**
         * <p>
         * The type of container instance health status that was verified.
         * </p>
         * 
         * @param type
         *        The type of container instance health status that was verified.
         * @see InstanceHealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthCheckType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of container instance health status that was verified.
         * </p>
         * 
         * @param type
         *        The type of container instance health status that was verified.
         * @see InstanceHealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthCheckType
         */
        Builder type(InstanceHealthCheckType type);

        /**
         * <p>
         * The container instance health status.
         * </p>
         * 
         * @param status
         *        The container instance health status.
         * @see InstanceHealthCheckState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthCheckState
         */
        Builder status(String status);

        /**
         * <p>
         * The container instance health status.
         * </p>
         * 
         * @param status
         *        The container instance health status.
         * @see InstanceHealthCheckState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthCheckState
         */
        Builder status(InstanceHealthCheckState status);

        /**
         * <p>
         * The Unix timestamp for when the container instance health status was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The Unix timestamp for when the container instance health status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The Unix timestamp for when the container instance health status last changed.
         * </p>
         * 
         * @param lastStatusChange
         *        The Unix timestamp for when the container instance health status last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(Instant lastStatusChange);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String status;

        private Instant lastUpdated;

        private Instant lastStatusChange;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHealthCheckResult model) {
            type(model.type);
            status(model.status);
            lastUpdated(model.lastUpdated);
            lastStatusChange(model.lastStatusChange);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InstanceHealthCheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceHealthCheckState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Instant getLastStatusChange() {
            return lastStatusChange;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        @Override
        public InstanceHealthCheckResult build() {
            return new InstanceHealthCheckResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
