/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service deployment properties that are retured when you call <code>ListServiceDeployments</code>.
 * </p>
 * <p>
 * This provides a high-level overview of the service deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceDeploymentBrief implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceDeploymentBrief.Builder, ServiceDeploymentBrief> {
    private static final SdkField<String> SERVICE_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceDeploymentArn").getter(getter(ServiceDeploymentBrief::serviceDeploymentArn))
            .setter(setter(Builder::serviceDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeploymentArn").build())
            .build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceArn").getter(getter(ServiceDeploymentBrief::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(ServiceDeploymentBrief::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(ServiceDeploymentBrief::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ServiceDeploymentBrief::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("finishedAt").getter(getter(ServiceDeploymentBrief::finishedAt)).setter(setter(Builder::finishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedAt").build()).build();

    private static final SdkField<String> TARGET_SERVICE_REVISION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetServiceRevisionArn").getter(getter(ServiceDeploymentBrief::targetServiceRevisionArn))
            .setter(setter(Builder::targetServiceRevisionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetServiceRevisionArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ServiceDeploymentBrief::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(ServiceDeploymentBrief::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENT_ARN_FIELD,
            SERVICE_ARN_FIELD, CLUSTER_ARN_FIELD, STARTED_AT_FIELD, CREATED_AT_FIELD, FINISHED_AT_FIELD,
            TARGET_SERVICE_REVISION_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceDeploymentArn;

    private final String serviceArn;

    private final String clusterArn;

    private final Instant startedAt;

    private final Instant createdAt;

    private final Instant finishedAt;

    private final String targetServiceRevisionArn;

    private final String status;

    private final String statusReason;

    private ServiceDeploymentBrief(BuilderImpl builder) {
        this.serviceDeploymentArn = builder.serviceDeploymentArn;
        this.serviceArn = builder.serviceArn;
        this.clusterArn = builder.clusterArn;
        this.startedAt = builder.startedAt;
        this.createdAt = builder.createdAt;
        this.finishedAt = builder.finishedAt;
        this.targetServiceRevisionArn = builder.targetServiceRevisionArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The ARN of the service deployment.
     * </p>
     * 
     * @return The ARN of the service deployment.
     */
    public final String serviceDeploymentArn() {
        return serviceDeploymentArn;
    }

    /**
     * <p>
     * The ARN of the service for this service deployment.
     * </p>
     * 
     * @return The ARN of the service for this service deployment.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The ARN of the cluster that hosts the service.
     * </p>
     * 
     * @return The ARN of the cluster that hosts the service.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The time that the service deployment statred. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     * </p>
     * 
     * @return The time that the service deployment statred. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time that the service deployment was created. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     * </p>
     * 
     * @return The time that the service deployment was created. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time that the service deployment completed. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     * </p>
     * 
     * @return The time that the service deployment completed. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     */
    public final Instant finishedAt() {
        return finishedAt;
    }

    /**
     * <p>
     * The ARN of the service revision being deplyed.
     * </p>
     * 
     * @return The ARN of the service revision being deplyed.
     */
    public final String targetServiceRevisionArn() {
        return targetServiceRevisionArn;
    }

    /**
     * <p>
     * The status of the service deployment
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service deployment
     * @see ServiceDeploymentStatus
     */
    public final ServiceDeploymentStatus status() {
        return ServiceDeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the service deployment
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service deployment
     * @see ServiceDeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about why the service deployment is in the current status. For example, the circuit breaker detected
     * a deployment failure.
     * </p>
     * 
     * @return Information about why the service deployment is in the current status. For example, the circuit breaker
     *         detected a deployment failure.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(targetServiceRevisionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDeploymentBrief)) {
            return false;
        }
        ServiceDeploymentBrief other = (ServiceDeploymentBrief) obj;
        return Objects.equals(serviceDeploymentArn(), other.serviceDeploymentArn())
                && Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(finishedAt(), other.finishedAt())
                && Objects.equals(targetServiceRevisionArn(), other.targetServiceRevisionArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceDeploymentBrief").add("ServiceDeploymentArn", serviceDeploymentArn())
                .add("ServiceArn", serviceArn()).add("ClusterArn", clusterArn()).add("StartedAt", startedAt())
                .add("CreatedAt", createdAt()).add("FinishedAt", finishedAt())
                .add("TargetServiceRevisionArn", targetServiceRevisionArn()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceDeploymentArn":
            return Optional.ofNullable(clazz.cast(serviceDeploymentArn()));
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "finishedAt":
            return Optional.ofNullable(clazz.cast(finishedAt()));
        case "targetServiceRevisionArn":
            return Optional.ofNullable(clazz.cast(targetServiceRevisionArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceDeploymentArn", SERVICE_DEPLOYMENT_ARN_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("finishedAt", FINISHED_AT_FIELD);
        map.put("targetServiceRevisionArn", TARGET_SERVICE_REVISION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDeploymentBrief, T> g) {
        return obj -> g.apply((ServiceDeploymentBrief) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceDeploymentBrief> {
        /**
         * <p>
         * The ARN of the service deployment.
         * </p>
         * 
         * @param serviceDeploymentArn
         *        The ARN of the service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeploymentArn(String serviceDeploymentArn);

        /**
         * <p>
         * The ARN of the service for this service deployment.
         * </p>
         * 
         * @param serviceArn
         *        The ARN of the service for this service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The ARN of the cluster that hosts the service.
         * </p>
         * 
         * @param clusterArn
         *        The ARN of the cluster that hosts the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The time that the service deployment statred. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * </p>
         * 
         * @param startedAt
         *        The time that the service deployment statred. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time that the service deployment was created. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * </p>
         * 
         * @param createdAt
         *        The time that the service deployment was created. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time that the service deployment completed. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * </p>
         * 
         * @param finishedAt
         *        The time that the service deployment completed. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * <p>
         * The ARN of the service revision being deplyed.
         * </p>
         * 
         * @param targetServiceRevisionArn
         *        The ARN of the service revision being deplyed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetServiceRevisionArn(String targetServiceRevisionArn);

        /**
         * <p>
         * The status of the service deployment
         * </p>
         * 
         * @param status
         *        The status of the service deployment
         * @see ServiceDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceDeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service deployment
         * </p>
         * 
         * @param status
         *        The status of the service deployment
         * @see ServiceDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceDeploymentStatus
         */
        Builder status(ServiceDeploymentStatus status);

        /**
         * <p>
         * Information about why the service deployment is in the current status. For example, the circuit breaker
         * detected a deployment failure.
         * </p>
         * 
         * @param statusReason
         *        Information about why the service deployment is in the current status. For example, the circuit
         *        breaker detected a deployment failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String serviceDeploymentArn;

        private String serviceArn;

        private String clusterArn;

        private Instant startedAt;

        private Instant createdAt;

        private Instant finishedAt;

        private String targetServiceRevisionArn;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDeploymentBrief model) {
            serviceDeploymentArn(model.serviceDeploymentArn);
            serviceArn(model.serviceArn);
            clusterArn(model.clusterArn);
            startedAt(model.startedAt);
            createdAt(model.createdAt);
            finishedAt(model.finishedAt);
            targetServiceRevisionArn(model.targetServiceRevisionArn);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getServiceDeploymentArn() {
            return serviceDeploymentArn;
        }

        public final void setServiceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
        }

        @Override
        public final Builder serviceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final String getTargetServiceRevisionArn() {
            return targetServiceRevisionArn;
        }

        public final void setTargetServiceRevisionArn(String targetServiceRevisionArn) {
            this.targetServiceRevisionArn = targetServiceRevisionArn;
        }

        @Override
        public final Builder targetServiceRevisionArn(String targetServiceRevisionArn) {
            this.targetServiceRevisionArn = targetServiceRevisionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public ServiceDeploymentBrief build() {
            return new ServiceDeploymentBrief(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
