/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the number of requested, pending, and running tasks for a service revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceRevisionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceRevisionSummary.Builder, ServiceRevisionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ServiceRevisionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> REQUESTED_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("requestedTaskCount").getter(getter(ServiceRevisionSummary::requestedTaskCount))
            .setter(setter(Builder::requestedTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTaskCount").build())
            .build();

    private static final SdkField<Integer> RUNNING_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("runningTaskCount").getter(getter(ServiceRevisionSummary::runningTaskCount))
            .setter(setter(Builder::runningTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTaskCount").build()).build();

    private static final SdkField<Integer> PENDING_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pendingTaskCount").getter(getter(ServiceRevisionSummary::pendingTaskCount))
            .setter(setter(Builder::pendingTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTaskCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            REQUESTED_TASK_COUNT_FIELD, RUNNING_TASK_COUNT_FIELD, PENDING_TASK_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Integer requestedTaskCount;

    private final Integer runningTaskCount;

    private final Integer pendingTaskCount;

    private ServiceRevisionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.requestedTaskCount = builder.requestedTaskCount;
        this.runningTaskCount = builder.runningTaskCount;
        this.pendingTaskCount = builder.pendingTaskCount;
    }

    /**
     * <p>
     * The ARN of the service revision.
     * </p>
     * 
     * @return The ARN of the service revision.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of requested tasks for the service revision.
     * </p>
     * 
     * @return The number of requested tasks for the service revision.
     */
    public final Integer requestedTaskCount() {
        return requestedTaskCount;
    }

    /**
     * <p>
     * The number of running tasks for the service revision.
     * </p>
     * 
     * @return The number of running tasks for the service revision.
     */
    public final Integer runningTaskCount() {
        return runningTaskCount;
    }

    /**
     * <p>
     * The number of pending tasks for the service revision.
     * </p>
     * 
     * @return The number of pending tasks for the service revision.
     */
    public final Integer pendingTaskCount() {
        return pendingTaskCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(requestedTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingTaskCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceRevisionSummary)) {
            return false;
        }
        ServiceRevisionSummary other = (ServiceRevisionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(requestedTaskCount(), other.requestedTaskCount())
                && Objects.equals(runningTaskCount(), other.runningTaskCount())
                && Objects.equals(pendingTaskCount(), other.pendingTaskCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceRevisionSummary").add("Arn", arn()).add("RequestedTaskCount", requestedTaskCount())
                .add("RunningTaskCount", runningTaskCount()).add("PendingTaskCount", pendingTaskCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "requestedTaskCount":
            return Optional.ofNullable(clazz.cast(requestedTaskCount()));
        case "runningTaskCount":
            return Optional.ofNullable(clazz.cast(runningTaskCount()));
        case "pendingTaskCount":
            return Optional.ofNullable(clazz.cast(pendingTaskCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("requestedTaskCount", REQUESTED_TASK_COUNT_FIELD);
        map.put("runningTaskCount", RUNNING_TASK_COUNT_FIELD);
        map.put("pendingTaskCount", PENDING_TASK_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceRevisionSummary, T> g) {
        return obj -> g.apply((ServiceRevisionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceRevisionSummary> {
        /**
         * <p>
         * The ARN of the service revision.
         * </p>
         * 
         * @param arn
         *        The ARN of the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of requested tasks for the service revision.
         * </p>
         * 
         * @param requestedTaskCount
         *        The number of requested tasks for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedTaskCount(Integer requestedTaskCount);

        /**
         * <p>
         * The number of running tasks for the service revision.
         * </p>
         * 
         * @param runningTaskCount
         *        The number of running tasks for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningTaskCount(Integer runningTaskCount);

        /**
         * <p>
         * The number of pending tasks for the service revision.
         * </p>
         * 
         * @param pendingTaskCount
         *        The number of pending tasks for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingTaskCount(Integer pendingTaskCount);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Integer requestedTaskCount;

        private Integer runningTaskCount;

        private Integer pendingTaskCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceRevisionSummary model) {
            arn(model.arn);
            requestedTaskCount(model.requestedTaskCount);
            runningTaskCount(model.runningTaskCount);
            pendingTaskCount(model.pendingTaskCount);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getRequestedTaskCount() {
            return requestedTaskCount;
        }

        public final void setRequestedTaskCount(Integer requestedTaskCount) {
            this.requestedTaskCount = requestedTaskCount;
        }

        @Override
        public final Builder requestedTaskCount(Integer requestedTaskCount) {
            this.requestedTaskCount = requestedTaskCount;
            return this;
        }

        public final Integer getRunningTaskCount() {
            return runningTaskCount;
        }

        public final void setRunningTaskCount(Integer runningTaskCount) {
            this.runningTaskCount = runningTaskCount;
        }

        @Override
        public final Builder runningTaskCount(Integer runningTaskCount) {
            this.runningTaskCount = runningTaskCount;
            return this;
        }

        public final Integer getPendingTaskCount() {
            return pendingTaskCount;
        }

        public final void setPendingTaskCount(Integer pendingTaskCount) {
            this.pendingTaskCount = pendingTaskCount;
        }

        @Override
        public final Builder pendingTaskCount(Integer pendingTaskCount) {
            this.pendingTaskCount = pendingTaskCount;
            return this;
        }

        @Override
        public ServiceRevisionSummary build() {
            return new ServiceRevisionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
