/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ulimit</code> settings to pass to the container.
 * </p>
 * <p>
 * Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the
 * exception of the <code>nofile</code> resource limit parameter which Fargate overrides. The <code>nofile</code>
 * resource limit sets a restriction on the number of open files that a container can use. The default
 * <code>nofile</code> soft limit is <code> 65535</code> and the default hard limit is <code>65535</code>.
 * </p>
 * <p>
 * You can specify the <code>ulimit</code> settings for a container in a task definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ulimit implements SdkPojo, Serializable, ToCopyableBuilder<Ulimit.Builder, Ulimit> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Ulimit::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> SOFT_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("softLimit").getter(getter(Ulimit::softLimit)).setter(setter(Builder::softLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softLimit").build()).build();

    private static final SdkField<Integer> HARD_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("hardLimit").getter(getter(Ulimit::hardLimit)).setter(setter(Builder::hardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOFT_LIMIT_FIELD,
            HARD_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer softLimit;

    private final Integer hardLimit;

    private Ulimit(BuilderImpl builder) {
        this.name = builder.name;
        this.softLimit = builder.softLimit;
        this.hardLimit = builder.hardLimit;
    }

    /**
     * <p>
     * The <code>type</code> of the <code>ulimit</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link UlimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The <code>type</code> of the <code>ulimit</code>.
     * @see UlimitName
     */
    public final UlimitName name() {
        return UlimitName.fromValue(name);
    }

    /**
     * <p>
     * The <code>type</code> of the <code>ulimit</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link UlimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The <code>type</code> of the <code>ulimit</code>.
     * @see UlimitName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The soft limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a count,
     * depending on the <code>type</code> of the <code>ulimit</code>.
     * </p>
     * 
     * @return The soft limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a
     *         count, depending on the <code>type</code> of the <code>ulimit</code>.
     */
    public final Integer softLimit() {
        return softLimit;
    }

    /**
     * <p>
     * The hard limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a count,
     * depending on the <code>type</code> of the <code>ulimit</code>.
     * </p>
     * 
     * @return The hard limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a
     *         count, depending on the <code>type</code> of the <code>ulimit</code>.
     */
    public final Integer hardLimit() {
        return hardLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(softLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hardLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ulimit)) {
            return false;
        }
        Ulimit other = (Ulimit) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(softLimit(), other.softLimit())
                && Objects.equals(hardLimit(), other.hardLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ulimit").add("Name", nameAsString()).add("SoftLimit", softLimit()).add("HardLimit", hardLimit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "softLimit":
            return Optional.ofNullable(clazz.cast(softLimit()));
        case "hardLimit":
            return Optional.ofNullable(clazz.cast(hardLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("softLimit", SOFT_LIMIT_FIELD);
        map.put("hardLimit", HARD_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ulimit, T> g) {
        return obj -> g.apply((Ulimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ulimit> {
        /**
         * <p>
         * The <code>type</code> of the <code>ulimit</code>.
         * </p>
         * 
         * @param name
         *        The <code>type</code> of the <code>ulimit</code>.
         * @see UlimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UlimitName
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>type</code> of the <code>ulimit</code>.
         * </p>
         * 
         * @param name
         *        The <code>type</code> of the <code>ulimit</code>.
         * @see UlimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UlimitName
         */
        Builder name(UlimitName name);

        /**
         * <p>
         * The soft limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a count,
         * depending on the <code>type</code> of the <code>ulimit</code>.
         * </p>
         * 
         * @param softLimit
         *        The soft limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a
         *        count, depending on the <code>type</code> of the <code>ulimit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softLimit(Integer softLimit);

        /**
         * <p>
         * The hard limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a count,
         * depending on the <code>type</code> of the <code>ulimit</code>.
         * </p>
         * 
         * @param hardLimit
         *        The hard limit for the <code>ulimit</code> type. The value can be specified in bytes, seconds, or as a
         *        count, depending on the <code>type</code> of the <code>ulimit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardLimit(Integer hardLimit);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer softLimit;

        private Integer hardLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Ulimit model) {
            name(model.name);
            softLimit(model.softLimit);
            hardLimit(model.hardLimit);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(UlimitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Integer getSoftLimit() {
            return softLimit;
        }

        public final void setSoftLimit(Integer softLimit) {
            this.softLimit = softLimit;
        }

        @Override
        public final Builder softLimit(Integer softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public final Integer getHardLimit() {
            return hardLimit;
        }

        public final void setHardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
        }

        @Override
        public final Builder hardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        @Override
        public Ulimit build() {
            return new Ulimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
