/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogDriver {
    JSON_FILE("json-file"),
    SYSLOG("syslog"),
    JOURNALD("journald"),
    GELF("gelf"),
    FLUENTD("fluentd"),
    AWSLOGS("awslogs"),
    SPLUNK("splunk"),
    AWSFIRELENS("awsfirelens"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogDriver> VALUE_MAP;
    private final String value;

    private LogDriver(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogDriver fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogDriver> knownValues() {
        EnumSet<LogDriver> knownValues = EnumSet.allOf(LogDriver.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogDriver.class, LogDriver::toString);
    }
}

