/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the service deployment rollback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rollback implements SdkPojo, Serializable, ToCopyableBuilder<Rollback.Builder, Rollback> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(Rollback::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(Rollback::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> SERVICE_REVISION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRevisionArn").getter(getter(Rollback::serviceRevisionArn))
            .setter(setter(Builder::serviceRevisionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRevisionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            STARTED_AT_FIELD, SERVICE_REVISION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final Instant startedAt;

    private final String serviceRevisionArn;

    private Rollback(BuilderImpl builder) {
        this.reason = builder.reason;
        this.startedAt = builder.startedAt;
        this.serviceRevisionArn = builder.serviceRevisionArn;
    }

    /**
     * <p>
     * The reason the rollback happened. For example, the circuit breaker initiated the rollback operation.
     * </p>
     * 
     * @return The reason the rollback happened. For example, the circuit breaker initiated the rollback operation.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * Time time that the rollback started. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     * </p>
     * 
     * @return Time time that the rollback started. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The ARN of the service revision deployed as part of the rollback.
     * </p>
     * 
     * @return The ARN of the service revision deployed as part of the rollback.
     */
    public final String serviceRevisionArn() {
        return serviceRevisionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRevisionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rollback)) {
            return false;
        }
        Rollback other = (Rollback) obj;
        return Objects.equals(reason(), other.reason()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(serviceRevisionArn(), other.serviceRevisionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rollback").add("Reason", reason()).add("StartedAt", startedAt())
                .add("ServiceRevisionArn", serviceRevisionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "serviceRevisionArn":
            return Optional.ofNullable(clazz.cast(serviceRevisionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reason", REASON_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("serviceRevisionArn", SERVICE_REVISION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rollback, T> g) {
        return obj -> g.apply((Rollback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rollback> {
        /**
         * <p>
         * The reason the rollback happened. For example, the circuit breaker initiated the rollback operation.
         * </p>
         * 
         * @param reason
         *        The reason the rollback happened. For example, the circuit breaker initiated the rollback operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * Time time that the rollback started. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * </p>
         * 
         * @param startedAt
         *        Time time that the rollback started. The format is yyyy-MM-dd HH:mm:ss.SSSSSS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The ARN of the service revision deployed as part of the rollback.
         * </p>
         * 
         * @param serviceRevisionArn
         *        The ARN of the service revision deployed as part of the rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRevisionArn(String serviceRevisionArn);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private Instant startedAt;

        private String serviceRevisionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Rollback model) {
            reason(model.reason);
            startedAt(model.startedAt);
            serviceRevisionArn(model.serviceRevisionArn);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getServiceRevisionArn() {
            return serviceRevisionArn;
        }

        public final void setServiceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
        }

        @Override
        public final Builder serviceRevisionArn(String serviceRevisionArn) {
            this.serviceRevisionArn = serviceRevisionArn;
            return this;
        }

        @Override
        public Rollback build() {
            return new Rollback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
