/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.CreateClusterRequest;
import software.amazon.awssdk.services.ecs.model.CreateClusterResponse;
import software.amazon.awssdk.services.ecs.model.CreateServiceRequest;
import software.amazon.awssdk.services.ecs.model.CreateServiceResponse;
import software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest;
import software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse;
import software.amazon.awssdk.services.ecs.model.DeleteAttributesRequest;
import software.amazon.awssdk.services.ecs.model.DeleteAttributesResponse;
import software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.DeleteClusterRequest;
import software.amazon.awssdk.services.ecs.model.DeleteClusterResponse;
import software.amazon.awssdk.services.ecs.model.DeleteServiceRequest;
import software.amazon.awssdk.services.ecs.model.DeleteServiceResponse;
import software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse;
import software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest;
import software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse;
import software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse;
import software.amazon.awssdk.services.ecs.model.DescribeClustersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeClustersResponse;
import software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServicesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTasksRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTasksResponse;
import software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest;
import software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse;
import software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest;
import software.amazon.awssdk.services.ecs.model.GetTaskProtectionResponse;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse;
import software.amazon.awssdk.services.ecs.model.ListAttributesRequest;
import software.amazon.awssdk.services.ecs.model.ListAttributesResponse;
import software.amazon.awssdk.services.ecs.model.ListClustersRequest;
import software.amazon.awssdk.services.ecs.model.ListClustersResponse;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse;
import software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsRequest;
import software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsResponse;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse;
import software.amazon.awssdk.services.ecs.model.ListServicesRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesResponse;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse;
import software.amazon.awssdk.services.ecs.model.ListTasksRequest;
import software.amazon.awssdk.services.ecs.model.ListTasksResponse;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse;
import software.amazon.awssdk.services.ecs.model.PutAttributesRequest;
import software.amazon.awssdk.services.ecs.model.PutAttributesResponse;
import software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest;
import software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersResponse;
import software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest;
import software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse;
import software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.RunTaskRequest;
import software.amazon.awssdk.services.ecs.model.RunTaskResponse;
import software.amazon.awssdk.services.ecs.model.StartTaskRequest;
import software.amazon.awssdk.services.ecs.model.StartTaskResponse;
import software.amazon.awssdk.services.ecs.model.StopServiceDeploymentRequest;
import software.amazon.awssdk.services.ecs.model.StopServiceDeploymentResponse;
import software.amazon.awssdk.services.ecs.model.StopTaskRequest;
import software.amazon.awssdk.services.ecs.model.StopTaskResponse;
import software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest;
import software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse;
import software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest;
import software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse;
import software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest;
import software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse;
import software.amazon.awssdk.services.ecs.model.TagResourceRequest;
import software.amazon.awssdk.services.ecs.model.TagResourceResponse;
import software.amazon.awssdk.services.ecs.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecs.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.UpdateClusterRequest;
import software.amazon.awssdk.services.ecs.model.UpdateClusterResponse;
import software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest;
import software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse;
import software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest;
import software.amazon.awssdk.services.ecs.model.UpdateContainerAgentResponse;
import software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest;
import software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse;
import software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.UpdateServiceRequest;
import software.amazon.awssdk.services.ecs.model.UpdateServiceResponse;
import software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest;
import software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse;
import software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.UpdateTaskSetResponse;
import software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListAttributesPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListServicesByNamespacePublisher;
import software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher;
import software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher;
import software.amazon.awssdk.services.ecs.waiters.EcsAsyncWaiter;

/**
 * Service client for accessing Amazon ECS asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon Elastic Container Service</fullname>
 * <p>
 * Amazon Elastic Container Service (Amazon ECS) is a highly scalable, fast, container management service. It makes it
 * easy to run, stop, and manage Docker containers. You can host your cluster on a serverless infrastructure that's
 * managed by Amazon ECS by launching your services or tasks on Fargate. For more control, you can host your tasks on a
 * cluster of Amazon Elastic Compute Cloud (Amazon EC2) or External (on-premises) instances that you manage.
 * </p>
 * <p>
 * Amazon ECS makes it easy to launch and stop container-based applications with simple API calls. This makes it easy to
 * get the state of your cluster from a centralized service, and gives you access to many familiar Amazon EC2 features.
 * </p>
 * <p>
 * You can use Amazon ECS to schedule the placement of containers across your cluster based on your resource needs,
 * isolation policies, and availability requirements. With Amazon ECS, you don't need to operate your own cluster
 * management and configuration management systems. You also don't need to worry about scaling your management
 * infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EcsAsyncClient extends AwsClient {
    String SERVICE_NAME = "ecs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ecs";

    /**
     * <p>
     * Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in
     * capacity provider strategies to facilitate cluster auto scaling.
     * </p>
     * <p>
     * Only capacity providers that use an Auto Scaling group can be created. Amazon ECS tasks on Fargate use the
     * <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers. These providers are available to all
     * accounts in the Amazon Web Services Regions that Fargate supports.
     * </p>
     *
     * @param createCapacityProviderRequest
     * @return A Java Future containing the result of the CreateCapacityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>LimitExceededException The limit for the resource was exceeded.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateCapacityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCapacityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCapacityProviderResponse> createCapacityProvider(
            CreateCapacityProviderRequest createCapacityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in
     * capacity provider strategies to facilitate cluster auto scaling.
     * </p>
     * <p>
     * Only capacity providers that use an Auto Scaling group can be created. Amazon ECS tasks on Fargate use the
     * <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers. These providers are available to all
     * accounts in the Amazon Web Services Regions that Fargate supports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapacityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCapacityProviderRequest#builder()}
     * </p>
     *
     * @param createCapacityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCapacityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>LimitExceededException The limit for the resource was exceeded.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateCapacityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCapacityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCapacityProviderResponse> createCapacityProvider(
            Consumer<CreateCapacityProviderRequest.Builder> createCapacityProviderRequest) {
        return createCapacityProvider(CreateCapacityProviderRequest.builder().applyMutation(createCapacityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new Amazon ECS cluster. By default, your account receives a <code>default</code> cluster when you
     * launch your first container instance. However, you can create your own cluster with a unique name.
     * </p>
     * <note>
     * <p>
     * When you call the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCluster.html">CreateCluster</a> API
     * operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account. This is so that it
     * can manage required resources in other Amazon Web Services services on your behalf. However, if the user that
     * makes the call doesn't have permissions to create the service-linked role, it isn't created. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon ECS cluster. By default, your account receives a <code>default</code> cluster when you
     * launch your first container instance. However, you can create your own cluster with a unique name.
     * </p>
     * <note>
     * <p>
     * When you call the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCluster.html">CreateCluster</a> API
     * operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account. This is so that it
     * can manage required resources in other Amazon Web Services services on your behalf. However, if the user that
     * makes the call doesn't have permissions to create the service-linked role, it isn't created. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.CreateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon ECS cluster. By default, your account receives a <code>default</code> cluster when you
     * launch your first container instance. However, you can create your own cluster with a unique name.
     * </p>
     * <note>
     * <p>
     * When you call the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCluster.html">CreateCluster</a> API
     * operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account. This is so that it
     * can manage required resources in other Amazon Web Services services on your behalf. However, if the user that
     * makes the call doesn't have permissions to create the service-linked role, it isn't created. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster() {
        return createCluster(CreateClusterRequest.builder().build());
    }

    /**
     * <p>
     * Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running
     * in a service drops below the <code>desiredCount</code>, Amazon ECS runs another copy of the task in the specified
     * cluster. To update an existing service, use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Elastic Inference (EI) is no longer available to customers.
     * </p>
     * </note>
     * <p>
     * In addition to maintaining the desired count of tasks in your service, you can optionally run your service behind
     * one or more load balancers. The load balancers distribute traffic across the tasks that are associated with the
     * service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service load
     * balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a
     * service. <code>volumeConfigurations</code> is only supported for REPLICA service and not DAEMON service. For more
     * infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Tasks for services that don't use a load balancer are considered healthy if they're in the <code>RUNNING</code>
     * state. Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code>
     * state and are reported as healthy by the load balancer.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code> - The replica scheduling strategy places and maintains your desired number of tasks across
     * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
     * placement strategies and constraints to customize task placement decisions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Service scheduler
     * concepts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code> - The daemon scheduling strategy deploys exactly one task on each active container instance
     * that meets all of the task placement constraints that you specify in your cluster. The service scheduler also
     * evaluates the task placement constraints for running tasks. It also stops tasks that don't meet the placement
     * constraints. When using this strategy, you don't need to specify a desired number of tasks, a task placement
     * strategy, or use Service Auto Scaling policies. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Service scheduler
     * concepts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can optionally specify a deployment configuration for your service. The deployment is initiated by changing
     * properties. For example, the deployment might be initiated by the task definition or by your desired count of a
     * service. You can use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>. The
     * default value for a replica service for <code>minimumHealthyPercent</code> is 100%. The default value for a
     * daemon service for <code>minimumHealthyPercent</code> is 0%.
     * </p>
     * <p>
     * If a service uses the <code>ECS</code> deployment controller, the minimum healthy percent represents a lower
     * limit on the number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment.
     * Specifically, it represents it as a percentage of your desired number of tasks (rounded up to the nearest
     * integer). This happens when any of your container instances are in the <code>DRAINING</code> state if the service
     * contains tasks using the EC2 launch type. Using this parameter, you can deploy without using additional cluster
     * capacity. For example, if you set your service to have desired number of four tasks and a minimum healthy percent
     * of 50%, the scheduler might stop two existing tasks to free up cluster capacity before starting two new tasks. If
     * they're in the <code>RUNNING</code> state, tasks for services that don't use a load balancer are considered
     * healthy . If they're in the <code>RUNNING</code> state and reported as healthy by the load balancer, tasks for
     * services that <i>do</i> use a load balancer are considered healthy . The default value for minimum healthy
     * percent is 100%.
     * </p>
     * <p>
     * If a service uses the <code>ECS</code> deployment controller, the <b>maximum percent</b> parameter represents an
     * upper limit on the number of tasks in a service that are allowed in the <code>RUNNING</code> or
     * <code>PENDING</code> state during a deployment. Specifically, it represents it as a percentage of the desired
     * number of tasks (rounded down to the nearest integer). This happens when any of your container instances are in
     * the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Using this parameter,
     * you can define the deployment batch size. For example, if your service has a desired number of four tasks and a
     * maximum percent value of 200%, the scheduler may start four new tasks before stopping the four older tasks
     * (provided that the cluster resources required to do this are available). The default value for maximum percent is
     * 200%.
     * </p>
     * <p>
     * If a service uses either the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types and
     * tasks that use the EC2 launch type, the <b>minimum healthy percent</b> and <b>maximum percent</b> values are used
     * only to define the lower and upper limit on the number of the tasks in the service that remain in the
     * <code>RUNNING</code> state. This is while the container instances are in the <code>DRAINING</code> state. If the
     * tasks in the service use the Fargate launch type, the minimum healthy percent and maximum percent values aren't
     * used. This is the case even if they're currently visible when describing your service.
     * </p>
     * <p>
     * When creating a service that uses the <code>EXTERNAL</code> deployment controller, you can specify only
     * parameters that aren't controlled at the task set level. The only required parameter is the service name. You
     * control your services using the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * When the service scheduler launches new tasks, it determines task placement. For information about task placement
     * and task placement strategies, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement.html">Amazon ECS task
     * placement</a> in the <i>Amazon Elastic Container Service Developer Guide</i>
     * </p>
     *
     * @param createServiceRequest
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(CreateServiceRequest createServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running
     * in a service drops below the <code>desiredCount</code>, Amazon ECS runs another copy of the task in the specified
     * cluster. To update an existing service, use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Elastic Inference (EI) is no longer available to customers.
     * </p>
     * </note>
     * <p>
     * In addition to maintaining the desired count of tasks in your service, you can optionally run your service behind
     * one or more load balancers. The load balancers distribute traffic across the tasks that are associated with the
     * service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service load
     * balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a
     * service. <code>volumeConfigurations</code> is only supported for REPLICA service and not DAEMON service. For more
     * infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Tasks for services that don't use a load balancer are considered healthy if they're in the <code>RUNNING</code>
     * state. Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code>
     * state and are reported as healthy by the load balancer.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code> - The replica scheduling strategy places and maintains your desired number of tasks across
     * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
     * placement strategies and constraints to customize task placement decisions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Service scheduler
     * concepts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code> - The daemon scheduling strategy deploys exactly one task on each active container instance
     * that meets all of the task placement constraints that you specify in your cluster. The service scheduler also
     * evaluates the task placement constraints for running tasks. It also stops tasks that don't meet the placement
     * constraints. When using this strategy, you don't need to specify a desired number of tasks, a task placement
     * strategy, or use Service Auto Scaling policies. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Service scheduler
     * concepts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can optionally specify a deployment configuration for your service. The deployment is initiated by changing
     * properties. For example, the deployment might be initiated by the task definition or by your desired count of a
     * service. You can use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>. The
     * default value for a replica service for <code>minimumHealthyPercent</code> is 100%. The default value for a
     * daemon service for <code>minimumHealthyPercent</code> is 0%.
     * </p>
     * <p>
     * If a service uses the <code>ECS</code> deployment controller, the minimum healthy percent represents a lower
     * limit on the number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment.
     * Specifically, it represents it as a percentage of your desired number of tasks (rounded up to the nearest
     * integer). This happens when any of your container instances are in the <code>DRAINING</code> state if the service
     * contains tasks using the EC2 launch type. Using this parameter, you can deploy without using additional cluster
     * capacity. For example, if you set your service to have desired number of four tasks and a minimum healthy percent
     * of 50%, the scheduler might stop two existing tasks to free up cluster capacity before starting two new tasks. If
     * they're in the <code>RUNNING</code> state, tasks for services that don't use a load balancer are considered
     * healthy . If they're in the <code>RUNNING</code> state and reported as healthy by the load balancer, tasks for
     * services that <i>do</i> use a load balancer are considered healthy . The default value for minimum healthy
     * percent is 100%.
     * </p>
     * <p>
     * If a service uses the <code>ECS</code> deployment controller, the <b>maximum percent</b> parameter represents an
     * upper limit on the number of tasks in a service that are allowed in the <code>RUNNING</code> or
     * <code>PENDING</code> state during a deployment. Specifically, it represents it as a percentage of the desired
     * number of tasks (rounded down to the nearest integer). This happens when any of your container instances are in
     * the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Using this parameter,
     * you can define the deployment batch size. For example, if your service has a desired number of four tasks and a
     * maximum percent value of 200%, the scheduler may start four new tasks before stopping the four older tasks
     * (provided that the cluster resources required to do this are available). The default value for maximum percent is
     * 200%.
     * </p>
     * <p>
     * If a service uses either the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types and
     * tasks that use the EC2 launch type, the <b>minimum healthy percent</b> and <b>maximum percent</b> values are used
     * only to define the lower and upper limit on the number of the tasks in the service that remain in the
     * <code>RUNNING</code> state. This is while the container instances are in the <code>DRAINING</code> state. If the
     * tasks in the service use the Fargate launch type, the minimum healthy percent and maximum percent values aren't
     * used. This is the case even if they're currently visible when describing your service.
     * </p>
     * <p>
     * When creating a service that uses the <code>EXTERNAL</code> deployment controller, you can specify only
     * parameters that aren't controlled at the task set level. The only required parameter is the service name. You
     * control your services using the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * When the service scheduler launches new tasks, it determines task placement. For information about task placement
     * and task placement strategies, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement.html">Amazon ECS task
     * placement</a> in the <i>Amazon Elastic Container Service Developer Guide</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServiceRequest#builder()}
     * </p>
     *
     * @param createServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.CreateServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(Consumer<CreateServiceRequest.Builder> createServiceRequest) {
        return createService(CreateServiceRequest.builder().applyMutation(createServiceRequest).build());
    }

    /**
     * <p>
     * Create a task set in the specified cluster and service. This is used when a service uses the
     * <code>EXTERNAL</code> deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note>
     * <p>
     * For information about the maximum number of task sets and other quotas, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-quotas.html">Amazon ECS service
     * quotas</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param createTaskSetRequest
     * @return A Java Future containing the result of the CreateTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateTaskSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTaskSetResponse> createTaskSet(CreateTaskSetRequest createTaskSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a task set in the specified cluster and service. This is used when a service uses the
     * <code>EXTERNAL</code> deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note>
     * <p>
     * For information about the maximum number of task sets and other quotas, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-quotas.html">Amazon ECS service
     * quotas</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTaskSetRequest#builder()}
     * </p>
     *
     * @param createTaskSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.CreateTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateTaskSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTaskSetResponse> createTaskSet(Consumer<CreateTaskSetRequest.Builder> createTaskSetRequest) {
        return createTaskSet(CreateTaskSetRequest.builder().applyMutation(createTaskSetRequest).build());
    }

    /**
     * <p>
     * Disables an account setting for a specified user, role, or the root user for an account.
     * </p>
     *
     * @param deleteAccountSettingRequest
     * @return A Java Future containing the result of the DeleteAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountSettingResponse> deleteAccountSetting(
            DeleteAccountSettingRequest deleteAccountSettingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables an account setting for a specified user, role, or the root user for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountSettingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccountSettingRequest#builder()}
     * </p>
     *
     * @param deleteAccountSettingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountSettingResponse> deleteAccountSetting(
            Consumer<DeleteAccountSettingRequest.Builder> deleteAccountSettingRequest) {
        return deleteAccountSetting(DeleteAccountSettingRequest.builder().applyMutation(deleteAccountSettingRequest).build());
    }

    /**
     * <p>
     * Deletes one or more custom attributes from an Amazon ECS resource.
     * </p>
     *
     * @param deleteAttributesRequest
     * @return A Java Future containing the result of the DeleteAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>TargetNotFoundException The specified target wasn't found. You can view your available container
     *         instances with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListContainerInstances.html"
     *         >ListContainerInstances</a>. Amazon ECS container instances are cluster-specific and Region-specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAttributesResponse> deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more custom attributes from an Amazon ECS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAttributesRequest#builder()}
     * </p>
     *
     * @param deleteAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>TargetNotFoundException The specified target wasn't found. You can view your available container
     *         instances with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListContainerInstances.html"
     *         >ListContainerInstances</a>. Amazon ECS container instances are cluster-specific and Region-specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAttributesResponse> deleteAttributes(
            Consumer<DeleteAttributesRequest.Builder> deleteAttributesRequest) {
        return deleteAttributes(DeleteAttributesRequest.builder().applyMutation(deleteAttributesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified capacity provider.
     * </p>
     * <note>
     * <p>
     * The <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers are reserved and can't be deleted. You
     * can disassociate them from a cluster using either <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     * >PutClusterCapacityProviders</a> or by deleting the cluster.
     * </p>
     * </note>
     * <p>
     * Prior to a capacity provider being deleted, the capacity provider must be removed from the capacity provider
     * strategy from all services. The <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a> API can
     * be used to remove a capacity provider from a service's capacity provider strategy. When updating a service, the
     * <code>forceNewDeployment</code> option can be used to ensure that any tasks using the Amazon EC2 instance
     * capacity provided by the capacity provider are transitioned to use the capacity from the remaining capacity
     * providers. Only capacity providers that aren't associated with a cluster can be deleted. To remove a capacity
     * provider from a cluster, you can either use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     * >PutClusterCapacityProviders</a> or delete the cluster.
     * </p>
     *
     * @param deleteCapacityProviderRequest
     * @return A Java Future containing the result of the DeleteCapacityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteCapacityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCapacityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCapacityProviderResponse> deleteCapacityProvider(
            DeleteCapacityProviderRequest deleteCapacityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified capacity provider.
     * </p>
     * <note>
     * <p>
     * The <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers are reserved and can't be deleted. You
     * can disassociate them from a cluster using either <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     * >PutClusterCapacityProviders</a> or by deleting the cluster.
     * </p>
     * </note>
     * <p>
     * Prior to a capacity provider being deleted, the capacity provider must be removed from the capacity provider
     * strategy from all services. The <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a> API can
     * be used to remove a capacity provider from a service's capacity provider strategy. When updating a service, the
     * <code>forceNewDeployment</code> option can be used to ensure that any tasks using the Amazon EC2 instance
     * capacity provided by the capacity provider are transitioned to use the capacity from the remaining capacity
     * providers. Only capacity providers that aren't associated with a cluster can be deleted. To remove a capacity
     * provider from a cluster, you can either use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     * >PutClusterCapacityProviders</a> or delete the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCapacityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCapacityProviderRequest#builder()}
     * </p>
     *
     * @param deleteCapacityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCapacityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteCapacityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCapacityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCapacityProviderResponse> deleteCapacityProvider(
            Consumer<DeleteCapacityProviderRequest.Builder> deleteCapacityProviderRequest) {
        return deleteCapacityProvider(DeleteCapacityProviderRequest.builder().applyMutation(deleteCapacityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified cluster. The cluster transitions to the <code>INACTIVE</code> state. Clusters with an
     * <code>INACTIVE</code> status might remain discoverable in your account for a period of time. However, this
     * behavior is subject to change in the future. We don't recommend that you rely on <code>INACTIVE</code> clusters
     * persisting.
     * </p>
     * <p>
     * You must deregister all container instances from this cluster before you may delete it. You can list the
     * container instances in a cluster with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListContainerInstances.html"
     * >ListContainerInstances</a> and deregister them with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterContainerInstance.html"
     * >DeregisterContainerInstance</a>.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ClusterContainsContainerInstancesException You can't delete a cluster that has registered container
     *         instances. First, deregister the container instances before you can delete the cluster. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterContainerInstance.html"
     *         >DeregisterContainerInstance</a>.</li>
     *         <li>ClusterContainsServicesException You can't delete a cluster that contains services. First, update the
     *         service to reduce its desired task count to 0, and then delete the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>
     *         and <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteService.html">DeleteService
     *         </a>.</li>
     *         <li>ClusterContainsTasksException You can't delete a cluster that has active tasks.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified cluster. The cluster transitions to the <code>INACTIVE</code> state. Clusters with an
     * <code>INACTIVE</code> status might remain discoverable in your account for a period of time. However, this
     * behavior is subject to change in the future. We don't recommend that you rely on <code>INACTIVE</code> clusters
     * persisting.
     * </p>
     * <p>
     * You must deregister all container instances from this cluster before you may delete it. You can list the
     * container instances in a cluster with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListContainerInstances.html"
     * >ListContainerInstances</a> and deregister them with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterContainerInstance.html"
     * >DeregisterContainerInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ClusterContainsContainerInstancesException You can't delete a cluster that has registered container
     *         instances. First, deregister the container instances before you can delete the cluster. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterContainerInstance.html"
     *         >DeregisterContainerInstance</a>.</li>
     *         <li>ClusterContainsServicesException You can't delete a cluster that contains services. First, update the
     *         service to reduce its desired task count to 0, and then delete the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>
     *         and <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteService.html">DeleteService
     *         </a>.</li>
     *         <li>ClusterContainsTasksException You can't delete a cluster that has active tasks.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a specified service within a cluster. You can delete a service if you have no running tasks in it and the
     * desired task count is zero. If the service is actively maintaining tasks, you can't delete it, and you must
     * update the service to a desired task count of zero. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * <note>
     * <p>
     * When you delete a service, if there are still running tasks that require cleanup, the service status moves from
     * <code>ACTIVE</code> to <code>DRAINING</code>, and the service is no longer visible in the console or in the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a> API
     * operation. After all tasks have transitioned to either <code>STOPPING</code> or <code>STOPPED</code> status, the
     * service status moves from <code>DRAINING</code> to <code>INACTIVE</code>. Services in the <code>DRAINING</code>
     * or <code>INACTIVE</code> status can still be viewed with the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServices.html">DescribeServices</a>
     * API operation. However, in the future, <code>INACTIVE</code> services may be cleaned up and purged from Amazon
     * ECS record keeping, and <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServices.html">DescribeServices</a>
     * calls on those services return a <code>ServiceNotFoundException</code> error.
     * </p>
     * </note> <important>
     * <p>
     * If you attempt to create a new service with the same name as an existing service in either <code>ACTIVE</code> or
     * <code>DRAINING</code> status, you receive an error.
     * </p>
     * </important>
     *
     * @param deleteServiceRequest
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(DeleteServiceRequest deleteServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified service within a cluster. You can delete a service if you have no running tasks in it and the
     * desired task count is zero. If the service is actively maintaining tasks, you can't delete it, and you must
     * update the service to a desired task count of zero. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * <note>
     * <p>
     * When you delete a service, if there are still running tasks that require cleanup, the service status moves from
     * <code>ACTIVE</code> to <code>DRAINING</code>, and the service is no longer visible in the console or in the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a> API
     * operation. After all tasks have transitioned to either <code>STOPPING</code> or <code>STOPPED</code> status, the
     * service status moves from <code>DRAINING</code> to <code>INACTIVE</code>. Services in the <code>DRAINING</code>
     * or <code>INACTIVE</code> status can still be viewed with the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServices.html">DescribeServices</a>
     * API operation. However, in the future, <code>INACTIVE</code> services may be cleaned up and purged from Amazon
     * ECS record keeping, and <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServices.html">DescribeServices</a>
     * calls on those services return a <code>ServiceNotFoundException</code> error.
     * </p>
     * </note> <important>
     * <p>
     * If you attempt to create a new service with the same name as an existing service in either <code>ACTIVE</code> or
     * <code>DRAINING</code> status, you receive an error.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServiceRequest#builder()}
     * </p>
     *
     * @param deleteServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest) {
        return deleteService(DeleteServiceRequest.builder().applyMutation(deleteServiceRequest).build());
    }

    /**
     * <p>
     * Deletes one or more task definitions.
     * </p>
     * <p>
     * You must deregister a task definition revision before you delete it. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterTaskDefinition.html"
     * >DeregisterTaskDefinition</a>.
     * </p>
     * <p>
     * When you delete a task definition revision, it is immediately transitions from the <code>INACTIVE</code> to
     * <code>DELETE_IN_PROGRESS</code>. Existing tasks and services that reference a <code>DELETE_IN_PROGRESS</code>
     * task definition revision continue to run without disruption. Existing services that reference a
     * <code>DELETE_IN_PROGRESS</code> task definition revision can still scale up or down by modifying the service's
     * desired count.
     * </p>
     * <p>
     * You can't use a <code>DELETE_IN_PROGRESS</code> task definition revision to run new tasks or create new services.
     * You also can't update an existing service to reference a <code>DELETE_IN_PROGRESS</code> task definition
     * revision.
     * </p>
     * <p>
     * A task definition revision will stay in <code>DELETE_IN_PROGRESS</code> status until all the associated tasks and
     * services have been terminated.
     * </p>
     * <p>
     * When you delete all <code>INACTIVE</code> task definition revisions, the task definition name is not displayed in
     * the console and not returned in the API. If a task definition revisions are in the
     * <code>DELETE_IN_PROGRESS</code> state, the task definition name is displayed in the console and returned in the
     * API. The task definition name is retained by Amazon ECS and the revision is incremented the next time you create
     * a task definition with that name.
     * </p>
     *
     * @param deleteTaskDefinitionsRequest
     * @return A Java Future containing the result of the DeleteTaskDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTaskDefinitionsResponse> deleteTaskDefinitions(
            DeleteTaskDefinitionsRequest deleteTaskDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more task definitions.
     * </p>
     * <p>
     * You must deregister a task definition revision before you delete it. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterTaskDefinition.html"
     * >DeregisterTaskDefinition</a>.
     * </p>
     * <p>
     * When you delete a task definition revision, it is immediately transitions from the <code>INACTIVE</code> to
     * <code>DELETE_IN_PROGRESS</code>. Existing tasks and services that reference a <code>DELETE_IN_PROGRESS</code>
     * task definition revision continue to run without disruption. Existing services that reference a
     * <code>DELETE_IN_PROGRESS</code> task definition revision can still scale up or down by modifying the service's
     * desired count.
     * </p>
     * <p>
     * You can't use a <code>DELETE_IN_PROGRESS</code> task definition revision to run new tasks or create new services.
     * You also can't update an existing service to reference a <code>DELETE_IN_PROGRESS</code> task definition
     * revision.
     * </p>
     * <p>
     * A task definition revision will stay in <code>DELETE_IN_PROGRESS</code> status until all the associated tasks and
     * services have been terminated.
     * </p>
     * <p>
     * When you delete all <code>INACTIVE</code> task definition revisions, the task definition name is not displayed in
     * the console and not returned in the API. If a task definition revisions are in the
     * <code>DELETE_IN_PROGRESS</code> state, the task definition name is displayed in the console and returned in the
     * API. The task definition name is retained by Amazon ECS and the revision is incremented the next time you create
     * a task definition with that name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaskDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param deleteTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTaskDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTaskDefinitionsResponse> deleteTaskDefinitions(
            Consumer<DeleteTaskDefinitionsRequest.Builder> deleteTaskDefinitionsRequest) {
        return deleteTaskDefinitions(DeleteTaskDefinitionsRequest.builder().applyMutation(deleteTaskDefinitionsRequest).build());
    }

    /**
     * <p>
     * Deletes a specified task set within a service. This is used when a service uses the <code>EXTERNAL</code>
     * deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param deleteTaskSetRequest
     * @return A Java Future containing the result of the DeleteTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>TaskSetNotFoundException The specified task set wasn't found. You can view your available task sets
     *         with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTaskSets.html">
     *         DescribeTaskSets</a>. Task sets are specific to each cluster, service and Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteTaskSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTaskSetResponse> deleteTaskSet(DeleteTaskSetRequest deleteTaskSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified task set within a service. This is used when a service uses the <code>EXTERNAL</code>
     * deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment
     * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaskSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTaskSetRequest#builder()}
     * </p>
     *
     * @param deleteTaskSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>TaskSetNotFoundException The specified task set wasn't found. You can view your available task sets
     *         with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTaskSets.html">
     *         DescribeTaskSets</a>. Task sets are specific to each cluster, service and Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeleteTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteTaskSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTaskSetResponse> deleteTaskSet(Consumer<DeleteTaskSetRequest.Builder> deleteTaskSetRequest) {
        return deleteTaskSet(DeleteTaskSetRequest.builder().applyMutation(deleteTaskSetRequest).build());
    }

    /**
     * <p>
     * Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to
     * run tasks.
     * </p>
     * <p>
     * If you intend to use the container instance for some other purpose after deregistration, we recommend that you
     * stop all of the tasks running on the container instance before deregistration. That prevents any orphaned tasks
     * from consuming resources.
     * </p>
     * <p>
     * Deregistering a container instance removes the instance from a cluster, but it doesn't terminate the EC2
     * instance. If you are finished using the instance, be sure to terminate it in the Amazon EC2 console to stop
     * billing.
     * </p>
     * <note>
     * <p>
     * If you terminate a running container instance, Amazon ECS automatically deregisters the instance from your
     * cluster (stopped container instances or instances with disconnected agents aren't automatically deregistered when
     * terminated).
     * </p>
     * </note>
     *
     * @param deregisterContainerInstanceRequest
     * @return A Java Future containing the result of the DeregisterContainerInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeregisterContainerInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterContainerInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterContainerInstanceResponse> deregisterContainerInstance(
            DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to
     * run tasks.
     * </p>
     * <p>
     * If you intend to use the container instance for some other purpose after deregistration, we recommend that you
     * stop all of the tasks running on the container instance before deregistration. That prevents any orphaned tasks
     * from consuming resources.
     * </p>
     * <p>
     * Deregistering a container instance removes the instance from a cluster, but it doesn't terminate the EC2
     * instance. If you are finished using the instance, be sure to terminate it in the Amazon EC2 console to stop
     * billing.
     * </p>
     * <note>
     * <p>
     * If you terminate a running container instance, Amazon ECS automatically deregisters the instance from your
     * cluster (stopped container instances or instances with disconnected agents aren't automatically deregistered when
     * terminated).
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterContainerInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterContainerInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterContainerInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterContainerInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeregisterContainerInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterContainerInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterContainerInstanceResponse> deregisterContainerInstance(
            Consumer<DeregisterContainerInstanceRequest.Builder> deregisterContainerInstanceRequest) {
        return deregisterContainerInstance(DeregisterContainerInstanceRequest.builder()
                .applyMutation(deregisterContainerInstanceRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified task definition by family and revision. Upon deregistration, the task definition is
     * marked as <code>INACTIVE</code>. Existing tasks and services that reference an <code>INACTIVE</code> task
     * definition continue to run without disruption. Existing services that reference an <code>INACTIVE</code> task
     * definition can still scale up or down by modifying the service's desired count. If you want to delete a task
     * definition revision, you must first deregister the task definition revision.
     * </p>
     * <p>
     * You can't use an <code>INACTIVE</code> task definition to run new tasks or create new services, and you can't
     * update an existing service to reference an <code>INACTIVE</code> task definition. However, there may be up to a
     * 10-minute window following deregistration where these restrictions have not yet taken effect.
     * </p>
     * <note>
     * <p>
     * At this time, <code>INACTIVE</code> task definitions remain discoverable in your account indefinitely. However,
     * this behavior is subject to change in the future. We don't recommend that you rely on <code>INACTIVE</code> task
     * definitions persisting beyond the lifecycle of any associated tasks and services.
     * </p>
     * </note>
     * <p>
     * You must deregister a task definition revision before you delete it. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteTaskDefinitions.html"
     * >DeleteTaskDefinitions</a>.
     * </p>
     *
     * @param deregisterTaskDefinitionRequest
     * @return A Java Future containing the result of the DeregisterTaskDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeregisterTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterTaskDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTaskDefinitionResponse> deregisterTaskDefinition(
            DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified task definition by family and revision. Upon deregistration, the task definition is
     * marked as <code>INACTIVE</code>. Existing tasks and services that reference an <code>INACTIVE</code> task
     * definition continue to run without disruption. Existing services that reference an <code>INACTIVE</code> task
     * definition can still scale up or down by modifying the service's desired count. If you want to delete a task
     * definition revision, you must first deregister the task definition revision.
     * </p>
     * <p>
     * You can't use an <code>INACTIVE</code> task definition to run new tasks or create new services, and you can't
     * update an existing service to reference an <code>INACTIVE</code> task definition. However, there may be up to a
     * 10-minute window following deregistration where these restrictions have not yet taken effect.
     * </p>
     * <note>
     * <p>
     * At this time, <code>INACTIVE</code> task definitions remain discoverable in your account indefinitely. However,
     * this behavior is subject to change in the future. We don't recommend that you rely on <code>INACTIVE</code> task
     * definitions persisting beyond the lifecycle of any associated tasks and services.
     * </p>
     * </note>
     * <p>
     * You must deregister a task definition revision before you delete it. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteTaskDefinitions.html"
     * >DeleteTaskDefinitions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTaskDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param deregisterTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterTaskDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DeregisterTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeregisterTaskDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTaskDefinitionResponse> deregisterTaskDefinition(
            Consumer<DeregisterTaskDefinitionRequest.Builder> deregisterTaskDefinitionRequest) {
        return deregisterTaskDefinition(DeregisterTaskDefinitionRequest.builder().applyMutation(deregisterTaskDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more of your capacity providers.
     * </p>
     *
     * @param describeCapacityProvidersRequest
     * @return A Java Future containing the result of the DescribeCapacityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeCapacityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeCapacityProviders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityProvidersResponse> describeCapacityProviders(
            DescribeCapacityProvidersRequest describeCapacityProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your capacity providers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCapacityProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCapacityProvidersRequest#builder()}
     * </p>
     *
     * @param describeCapacityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCapacityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeCapacityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeCapacityProviders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCapacityProvidersResponse> describeCapacityProviders(
            Consumer<DescribeCapacityProvidersRequest.Builder> describeCapacityProvidersRequest) {
        return describeCapacityProviders(DescribeCapacityProvidersRequest.builder()
                .applyMutation(describeCapacityProvidersRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your clusters.
     * </p>
     * <p>
     * For CLI examples, see <a
     * href="https://github.com/aws/aws-cli/blob/develop/awscli/examples/ecs/describe-clusters.rst"
     * >describe-clusters.rst</a> on GitHub.
     * </p>
     *
     * @param describeClustersRequest
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your clusters.
     * </p>
     * <p>
     * For CLI examples, see <a
     * href="https://github.com/aws/aws-cli/blob/develop/awscli/examples/ecs/describe-clusters.rst"
     * >describe-clusters.rst</a> on GitHub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(
            Consumer<DescribeClustersRequest.Builder> describeClustersRequest) {
        return describeClusters(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your clusters.
     * </p>
     * <p>
     * For CLI examples, see <a
     * href="https://github.com/aws/aws-cli/blob/develop/awscli/examples/ecs/describe-clusters.rst"
     * >describe-clusters.rst</a> on GitHub.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters() {
        return describeClusters(DescribeClustersRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more container instances. Returns metadata about each container instance requested.
     * </p>
     *
     * @param describeContainerInstancesRequest
     * @return A Java Future containing the result of the DescribeContainerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContainerInstancesResponse> describeContainerInstances(
            DescribeContainerInstancesRequest describeContainerInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more container instances. Returns metadata about each container instance requested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContainerInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContainerInstancesRequest#builder()}
     * </p>
     *
     * @param describeContainerInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContainerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContainerInstancesResponse> describeContainerInstances(
            Consumer<DescribeContainerInstancesRequest.Builder> describeContainerInstancesRequest) {
        return describeContainerInstances(DescribeContainerInstancesRequest.builder()
                .applyMutation(describeContainerInstancesRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your service deployments.
     * </p>
     * <p>
     * A service deployment happens when you release a software update for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-deployment.html">View service history
     * using Amazon ECS service deployments</a>.
     * </p>
     *
     * @param describeServiceDeploymentsRequest
     * @return A Java Future containing the result of the DescribeServiceDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeServiceDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServiceDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceDeploymentsResponse> describeServiceDeployments(
            DescribeServiceDeploymentsRequest describeServiceDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your service deployments.
     * </p>
     * <p>
     * A service deployment happens when you release a software update for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-deployment.html">View service history
     * using Amazon ECS service deployments</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceDeploymentsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeServiceDeploymentsRequest#builder()}
     * </p>
     *
     * @param describeServiceDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeServiceDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeServiceDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServiceDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceDeploymentsResponse> describeServiceDeployments(
            Consumer<DescribeServiceDeploymentsRequest.Builder> describeServiceDeploymentsRequest) {
        return describeServiceDeployments(DescribeServiceDeploymentsRequest.builder()
                .applyMutation(describeServiceDeploymentsRequest).build());
    }

    /**
     * <p>
     * Describes one or more service revisions.
     * </p>
     * <p>
     * A service revision is a version of the service that includes the values for the Amazon ECS resources (for
     * example, task definition) and the environment resources (for example, load balancers, subnets, and security
     * groups). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-revision.html">Amazon ECS service
     * revisions</a>.
     * </p>
     * <p>
     * You can't describe a service revision that was created before October 25, 2024.
     * </p>
     *
     * @param describeServiceRevisionsRequest
     * @return A Java Future containing the result of the DescribeServiceRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeServiceRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServiceRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeServiceRevisionsResponse> describeServiceRevisions(
            DescribeServiceRevisionsRequest describeServiceRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more service revisions.
     * </p>
     * <p>
     * A service revision is a version of the service that includes the values for the Amazon ECS resources (for
     * example, task definition) and the environment resources (for example, load balancers, subnets, and security
     * groups). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-revision.html">Amazon ECS service
     * revisions</a>.
     * </p>
     * <p>
     * You can't describe a service revision that was created before October 25, 2024.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeServiceRevisionsRequest#builder()}
     * </p>
     *
     * @param describeServiceRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeServiceRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeServiceRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServiceRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeServiceRevisionsResponse> describeServiceRevisions(
            Consumer<DescribeServiceRevisionsRequest.Builder> describeServiceRevisionsRequest) {
        return describeServiceRevisions(DescribeServiceRevisionsRequest.builder().applyMutation(describeServiceRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified services running in your cluster.
     * </p>
     *
     * @param describeServicesRequest
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices(DescribeServicesRequest describeServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified services running in your cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServicesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeServicesRequest#builder()}
     * </p>
     *
     * @param describeServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices(
            Consumer<DescribeServicesRequest.Builder> describeServicesRequest) {
        return describeServices(DescribeServicesRequest.builder().applyMutation(describeServicesRequest).build());
    }

    /**
     * <p>
     * Describes a task definition. You can specify a <code>family</code> and <code>revision</code> to find information
     * about a specific task definition, or you can simply specify the family to find the latest <code>ACTIVE</code>
     * revision in that family.
     * </p>
     * <note>
     * <p>
     * You can only describe <code>INACTIVE</code> task definitions while an active task or service references them.
     * </p>
     * </note>
     *
     * @param describeTaskDefinitionRequest
     * @return A Java Future containing the result of the DescribeTaskDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTaskDefinitionResponse> describeTaskDefinition(
            DescribeTaskDefinitionRequest describeTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a task definition. You can specify a <code>family</code> and <code>revision</code> to find information
     * about a specific task definition, or you can simply specify the family to find the latest <code>ACTIVE</code>
     * revision in that family.
     * </p>
     * <note>
     * <p>
     * You can only describe <code>INACTIVE</code> task definitions while an active task or service references them.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param describeTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTaskDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTaskDefinitionResponse> describeTaskDefinition(
            Consumer<DescribeTaskDefinitionRequest.Builder> describeTaskDefinitionRequest) {
        return describeTaskDefinition(DescribeTaskDefinitionRequest.builder().applyMutation(describeTaskDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Describes the task sets in the specified cluster and service. This is used when a service uses the
     * <code>EXTERNAL</code> deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment
     * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param describeTaskSetsRequest
     * @return A Java Future containing the result of the DescribeTaskSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeTaskSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTaskSetsResponse> describeTaskSets(DescribeTaskSetsRequest describeTaskSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the task sets in the specified cluster and service. This is used when a service uses the
     * <code>EXTERNAL</code> deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment
     * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskSetsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTaskSetsRequest#builder()}
     * </p>
     *
     * @param describeTaskSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTaskSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeTaskSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTaskSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTaskSetsResponse> describeTaskSets(
            Consumer<DescribeTaskSetsRequest.Builder> describeTaskSetsRequest) {
        return describeTaskSets(DescribeTaskSetsRequest.builder().applyMutation(describeTaskSetsRequest).build());
    }

    /**
     * <p>
     * Describes a specified task or tasks.
     * </p>
     * <p>
     * Currently, stopped tasks appear in the returned results for at least one hour.
     * </p>
     * <p>
     * If you have tasks with tags, and then delete the cluster, the tagged tasks are returned in the response. If you
     * create a new cluster with the same name as the deleted cluster, the tagged tasks are not included in the
     * response.
     * </p>
     *
     * @param describeTasksRequest
     * @return A Java Future containing the result of the DescribeTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTasksResponse> describeTasks(DescribeTasksRequest describeTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specified task or tasks.
     * </p>
     * <p>
     * Currently, stopped tasks appear in the returned results for at least one hour.
     * </p>
     * <p>
     * If you have tasks with tags, and then delete the cluster, the tagged tasks are returned in the response. If you
     * create a new cluster with the same name as the deleted cluster, the tagged tasks are not included in the
     * response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTasksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTasksRequest#builder()}
     * </p>
     *
     * @param describeTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DescribeTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DescribeTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTasksResponse> describeTasks(Consumer<DescribeTasksRequest.Builder> describeTasksRequest) {
        return describeTasks(DescribeTasksRequest.builder().applyMutation(describeTasksRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Returns an endpoint for the Amazon ECS agent to poll for updates.
     * </p>
     *
     * @param discoverPollEndpointRequest
     * @return A Java Future containing the result of the DiscoverPollEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DiscoverPollEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DiscoverPollEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DiscoverPollEndpointResponse> discoverPollEndpoint(
            DiscoverPollEndpointRequest discoverPollEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Returns an endpoint for the Amazon ECS agent to poll for updates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DiscoverPollEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DiscoverPollEndpointRequest#builder()}
     * </p>
     *
     * @param discoverPollEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DiscoverPollEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.DiscoverPollEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DiscoverPollEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DiscoverPollEndpointResponse> discoverPollEndpoint(
            Consumer<DiscoverPollEndpointRequest.Builder> discoverPollEndpointRequest) {
        return discoverPollEndpoint(DiscoverPollEndpointRequest.builder().applyMutation(discoverPollEndpointRequest).build());
    }

    /**
     * <p>
     * Runs a command remotely on a container within a task.
     * </p>
     * <p>
     * If you use a condition key in your IAM policy to refine the conditions for the policy statement, for example
     * limit the actions to a specific cluster, you receive an <code>AccessDeniedException</code> when there is a
     * mismatch between the condition key value and the corresponding parameter value.
     * </p>
     * <p>
     * For information about required permissions and considerations, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html">Using Amazon ECS Exec for
     * debugging</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     *
     * @param executeCommandRequest
     * @return A Java Future containing the result of the ExecuteCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>TargetNotConnectedException The execute command cannot run. This error can be caused by any of the
     *         following configuration issues:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Incorrect IAM permissions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The SSM agent is not installed or is not running
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an interface Amazon VPC endpoint for Amazon ECS, but there is not one for Systems Manager
     *         Session Manager
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about how to troubleshoot the issues, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html">Troubleshooting issues
     *         with ECS Exec</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ExecuteCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ExecuteCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteCommandResponse> executeCommand(ExecuteCommandRequest executeCommandRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a command remotely on a container within a task.
     * </p>
     * <p>
     * If you use a condition key in your IAM policy to refine the conditions for the policy statement, for example
     * limit the actions to a specific cluster, you receive an <code>AccessDeniedException</code> when there is a
     * mismatch between the condition key value and the corresponding parameter value.
     * </p>
     * <p>
     * For information about required permissions and considerations, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html">Using Amazon ECS Exec for
     * debugging</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteCommandRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteCommandRequest#builder()}
     * </p>
     *
     * @param executeCommandRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExecuteCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>TargetNotConnectedException The execute command cannot run. This error can be caused by any of the
     *         following configuration issues:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Incorrect IAM permissions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The SSM agent is not installed or is not running
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an interface Amazon VPC endpoint for Amazon ECS, but there is not one for Systems Manager
     *         Session Manager
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about how to troubleshoot the issues, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html">Troubleshooting issues
     *         with ECS Exec</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ExecuteCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ExecuteCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteCommandResponse> executeCommand(Consumer<ExecuteCommandRequest.Builder> executeCommandRequest) {
        return executeCommand(ExecuteCommandRequest.builder().applyMutation(executeCommandRequest).build());
    }

    /**
     * <p>
     * Retrieves the protection status of tasks in an Amazon ECS service.
     * </p>
     *
     * @param getTaskProtectionRequest
     * @return A Java Future containing the result of the GetTaskProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.GetTaskProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/GetTaskProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTaskProtectionResponse> getTaskProtection(GetTaskProtectionRequest getTaskProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the protection status of tasks in an Amazon ECS service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaskProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link GetTaskProtectionRequest#builder()}
     * </p>
     *
     * @param getTaskProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTaskProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.GetTaskProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/GetTaskProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTaskProtectionResponse> getTaskProtection(
            Consumer<GetTaskProtectionRequest.Builder> getTaskProtectionRequest) {
        return getTaskProtection(GetTaskProtectionRequest.builder().applyMutation(getTaskProtectionRequest).build());
    }

    /**
     * <p>
     * Lists the account settings for a specified principal.
     * </p>
     *
     * @param listAccountSettingsRequest
     * @return A Java Future containing the result of the ListAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountSettingsResponse> listAccountSettings(
            ListAccountSettingsRequest listAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the account settings for a specified principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountSettingsRequest#builder()}
     * </p>
     *
     * @param listAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountSettingsResponse> listAccountSettings(
            Consumer<ListAccountSettingsRequest.Builder> listAccountSettingsRequest) {
        return listAccountSettings(ListAccountSettingsRequest.builder().applyMutation(listAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the account settings for a specified principal.
     * </p>
     *
     * @return A Java Future containing the result of the ListAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountSettingsResponse> listAccountSettings() {
        return listAccountSettings(ListAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountSettings(software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher publisher = client.listAccountSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher publisher = client.listAccountSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountSettings(software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountSettingsPublisher listAccountSettingsPaginator() {
        return listAccountSettingsPaginator(ListAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountSettings(software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher publisher = client.listAccountSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher publisher = client.listAccountSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountSettings(software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest)} operation.</b>
     * </p>
     *
     * @param listAccountSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountSettingsPublisher listAccountSettingsPaginator(ListAccountSettingsRequest listAccountSettingsRequest) {
        return new ListAccountSettingsPublisher(this, listAccountSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountSettings(software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher publisher = client.listAccountSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAccountSettingsPublisher publisher = client.listAccountSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountSettings(software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountSettingsRequest#builder()}
     * </p>
     *
     * @param listAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountSettingsPublisher listAccountSettingsPaginator(
            Consumer<ListAccountSettingsRequest.Builder> listAccountSettingsRequest) {
        return listAccountSettingsPaginator(ListAccountSettingsRequest.builder().applyMutation(listAccountSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a
     * target type and cluster, <code>ListAttributes</code> returns a list of attribute objects, one for each attribute
     * on each resource. You can filter the list of results to a single attribute name to only return results that have
     * that name. You can also filter the results by attribute name and value. You can do this, for example, to see
     * which container instances in a cluster are running a Linux AMI (<code>ecs.os-type=linux</code>).
     * </p>
     *
     * @param listAttributesRequest
     * @return A Java Future containing the result of the ListAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttributesResponse> listAttributes(ListAttributesRequest listAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a
     * target type and cluster, <code>ListAttributes</code> returns a list of attribute objects, one for each attribute
     * on each resource. You can filter the list of results to a single attribute name to only return results that have
     * that name. You can also filter the results by attribute name and value. You can do this, for example, to see
     * which container instances in a cluster are running a Linux AMI (<code>ecs.os-type=linux</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttributesRequest#builder()}
     * </p>
     *
     * @param listAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttributesResponse> listAttributes(Consumer<ListAttributesRequest.Builder> listAttributesRequest) {
        return listAttributes(ListAttributesRequest.builder().applyMutation(listAttributesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAttributes(software.amazon.awssdk.services.ecs.model.ListAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAttributesPublisher publisher = client.listAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAttributesPublisher publisher = client.listAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributes(software.amazon.awssdk.services.ecs.model.ListAttributesRequest)} operation.</b>
     * </p>
     *
     * @param listAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttributesPublisher listAttributesPaginator(ListAttributesRequest listAttributesRequest) {
        return new ListAttributesPublisher(this, listAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAttributes(software.amazon.awssdk.services.ecs.model.ListAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAttributesPublisher publisher = client.listAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListAttributesPublisher publisher = client.listAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributes(software.amazon.awssdk.services.ecs.model.ListAttributesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttributesRequest#builder()}
     * </p>
     *
     * @param listAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListAttributesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttributesPublisher listAttributesPaginator(Consumer<ListAttributesRequest.Builder> listAttributesRequest) {
        return listAttributesPaginator(ListAttributesRequest.builder().applyMutation(listAttributesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing clusters.
     * </p>
     *
     * @param listClustersRequest
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing clusters.
     * </p>
     *
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters() {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.ecs.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.ecs.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator() {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.ecs.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.ecs.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(ListClustersRequest listClustersRequest) {
        return new ListClustersPublisher(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.ecs.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.ecs.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListClustersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of container instances in a specified cluster. You can filter the results of a
     * <code>ListContainerInstances</code> operation with cluster query language statements inside the
     * <code>filter</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
     * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param listContainerInstancesRequest
     * @return A Java Future containing the result of the ListContainerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListContainerInstancesResponse> listContainerInstances(
            ListContainerInstancesRequest listContainerInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of container instances in a specified cluster. You can filter the results of a
     * <code>ListContainerInstances</code> operation with cluster query language statements inside the
     * <code>filter</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
     * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContainerInstancesRequest#builder()}
     * </p>
     *
     * @param listContainerInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListContainerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListContainerInstancesResponse> listContainerInstances(
            Consumer<ListContainerInstancesRequest.Builder> listContainerInstancesRequest) {
        return listContainerInstances(ListContainerInstancesRequest.builder().applyMutation(listContainerInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of container instances in a specified cluster. You can filter the results of a
     * <code>ListContainerInstances</code> operation with cluster query language statements inside the
     * <code>filter</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
     * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the ListContainerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListContainerInstancesResponse> listContainerInstances() {
        return listContainerInstances(ListContainerInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContainerInstances(software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher publisher = client.listContainerInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher publisher = client.listContainerInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerInstances(software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContainerInstancesPublisher listContainerInstancesPaginator() {
        return listContainerInstancesPaginator(ListContainerInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContainerInstances(software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher publisher = client.listContainerInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher publisher = client.listContainerInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerInstances(software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContainerInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContainerInstancesPublisher listContainerInstancesPaginator(
            ListContainerInstancesRequest listContainerInstancesRequest) {
        return new ListContainerInstancesPublisher(this, listContainerInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContainerInstances(software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher publisher = client.listContainerInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListContainerInstancesPublisher publisher = client.listContainerInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerInstances(software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContainerInstancesRequest#builder()}
     * </p>
     *
     * @param listContainerInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListContainerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListContainerInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContainerInstancesPublisher listContainerInstancesPaginator(
            Consumer<ListContainerInstancesRequest.Builder> listContainerInstancesRequest) {
        return listContainerInstancesPaginator(ListContainerInstancesRequest.builder()
                .applyMutation(listContainerInstancesRequest).build());
    }

    /**
     * <p>
     * This operation lists all the service deployments that meet the specified filter criteria.
     * </p>
     * <p>
     * A service deployment happens when you release a software update for the service. You route traffic from the
     * running service revisions to the new service revison and control the number of running tasks.
     * </p>
     * <p>
     * This API returns the values that you use for the request parameters in <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServiceRevisions.html"
     * >DescribeServiceRevisions</a>.
     * </p>
     *
     * @param listServiceDeploymentsRequest
     * @return A Java Future containing the result of the ListServiceDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServiceDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServiceDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServiceDeploymentsResponse> listServiceDeployments(
            ListServiceDeploymentsRequest listServiceDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists all the service deployments that meet the specified filter criteria.
     * </p>
     * <p>
     * A service deployment happens when you release a software update for the service. You route traffic from the
     * running service revisions to the new service revison and control the number of running tasks.
     * </p>
     * <p>
     * This API returns the values that you use for the request parameters in <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeServiceRevisions.html"
     * >DescribeServiceRevisions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceDeploymentsRequest#builder()}
     * </p>
     *
     * @param listServiceDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServiceDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServiceDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServiceDeploymentsResponse> listServiceDeployments(
            Consumer<ListServiceDeploymentsRequest.Builder> listServiceDeploymentsRequest) {
        return listServiceDeployments(ListServiceDeploymentsRequest.builder().applyMutation(listServiceDeploymentsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.
     * </p>
     *
     * @param listServicesRequest
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.
     * </p>
     *
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices() {
        return listServices(ListServicesRequest.builder().build());
    }

    /**
     * <p>
     * This operation lists all of the services that are associated with a Cloud Map namespace. This list might include
     * services in different clusters. In contrast, <code>ListServices</code> can only list services in one cluster at a
     * time. If you need to filter the list of services in a single cluster by various parameters, use
     * <code>ListServices</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param listServicesByNamespaceRequest
     * @return A Java Future containing the result of the ListServicesByNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServicesByNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServicesByNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesByNamespaceResponse> listServicesByNamespace(
            ListServicesByNamespaceRequest listServicesByNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists all of the services that are associated with a Cloud Map namespace. This list might include
     * services in different clusters. In contrast, <code>ListServices</code> can only list services in one cluster at a
     * time. If you need to filter the list of services in a single cluster by various parameters, use
     * <code>ListServices</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesByNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link ListServicesByNamespaceRequest#builder()}
     * </p>
     *
     * @param listServicesByNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServicesByNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServicesByNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServicesByNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesByNamespaceResponse> listServicesByNamespace(
            Consumer<ListServicesByNamespaceRequest.Builder> listServicesByNamespaceRequest) {
        return listServicesByNamespace(ListServicesByNamespaceRequest.builder().applyMutation(listServicesByNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServicesByNamespace(software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesByNamespacePublisher publisher = client.listServicesByNamespacePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesByNamespacePublisher publisher = client.listServicesByNamespacePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicesByNamespace(software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServicesByNamespaceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServicesByNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServicesByNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesByNamespacePublisher listServicesByNamespacePaginator(
            ListServicesByNamespaceRequest listServicesByNamespaceRequest) {
        return new ListServicesByNamespacePublisher(this, listServicesByNamespaceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServicesByNamespace(software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesByNamespacePublisher publisher = client.listServicesByNamespacePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesByNamespacePublisher publisher = client.listServicesByNamespacePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServicesByNamespace(software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesByNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link ListServicesByNamespaceRequest#builder()}
     * </p>
     *
     * @param listServicesByNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServicesByNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServicesByNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesByNamespacePublisher listServicesByNamespacePaginator(
            Consumer<ListServicesByNamespaceRequest.Builder> listServicesByNamespaceRequest) {
        return listServicesByNamespacePaginator(ListServicesByNamespaceRequest.builder()
                .applyMutation(listServicesByNamespaceRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.ecs.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.ecs.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator() {
        return listServicesPaginator(ListServicesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.ecs.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.ecs.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(ListServicesRequest listServicesRequest) {
        return new ListServicesPublisher(this, listServicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.ecs.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.ecs.model.ListServicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListServicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * List the tags for an Amazon ECS resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an Amazon ECS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of task definition families that are registered to your account. This list includes task
     * definition families that no longer have any <code>ACTIVE</code> task definition revisions.
     * </p>
     * <p>
     * You can filter out task definition families that don't contain any <code>ACTIVE</code> task definition revisions
     * by setting the <code>status</code> parameter to <code>ACTIVE</code>. You can also filter the results with the
     * <code>familyPrefix</code> parameter.
     * </p>
     *
     * @param listTaskDefinitionFamiliesRequest
     * @return A Java Future containing the result of the ListTaskDefinitionFamilies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitionFamilies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTaskDefinitionFamiliesResponse> listTaskDefinitionFamilies(
            ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of task definition families that are registered to your account. This list includes task
     * definition families that no longer have any <code>ACTIVE</code> task definition revisions.
     * </p>
     * <p>
     * You can filter out task definition families that don't contain any <code>ACTIVE</code> task definition revisions
     * by setting the <code>status</code> parameter to <code>ACTIVE</code>. You can also filter the results with the
     * <code>familyPrefix</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskDefinitionFamiliesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTaskDefinitionFamiliesRequest#builder()}
     * </p>
     *
     * @param listTaskDefinitionFamiliesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTaskDefinitionFamilies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitionFamilies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTaskDefinitionFamiliesResponse> listTaskDefinitionFamilies(
            Consumer<ListTaskDefinitionFamiliesRequest.Builder> listTaskDefinitionFamiliesRequest) {
        return listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest.builder()
                .applyMutation(listTaskDefinitionFamiliesRequest).build());
    }

    /**
     * <p>
     * Returns a list of task definition families that are registered to your account. This list includes task
     * definition families that no longer have any <code>ACTIVE</code> task definition revisions.
     * </p>
     * <p>
     * You can filter out task definition families that don't contain any <code>ACTIVE</code> task definition revisions
     * by setting the <code>status</code> parameter to <code>ACTIVE</code>. You can also filter the results with the
     * <code>familyPrefix</code> parameter.
     * </p>
     *
     * @return A Java Future containing the result of the ListTaskDefinitionFamilies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitionFamilies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTaskDefinitionFamiliesResponse> listTaskDefinitionFamilies() {
        return listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskDefinitionFamilies(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher publisher = client.listTaskDefinitionFamiliesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher publisher = client.listTaskDefinitionFamiliesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskDefinitionFamilies(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitionFamilies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaskDefinitionFamiliesPublisher listTaskDefinitionFamiliesPaginator() {
        return listTaskDefinitionFamiliesPaginator(ListTaskDefinitionFamiliesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskDefinitionFamilies(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher publisher = client.listTaskDefinitionFamiliesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher publisher = client.listTaskDefinitionFamiliesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskDefinitionFamilies(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTaskDefinitionFamiliesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitionFamilies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaskDefinitionFamiliesPublisher listTaskDefinitionFamiliesPaginator(
            ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) {
        return new ListTaskDefinitionFamiliesPublisher(this, listTaskDefinitionFamiliesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskDefinitionFamilies(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher publisher = client.listTaskDefinitionFamiliesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionFamiliesPublisher publisher = client.listTaskDefinitionFamiliesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskDefinitionFamilies(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskDefinitionFamiliesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTaskDefinitionFamiliesRequest#builder()}
     * </p>
     *
     * @param listTaskDefinitionFamiliesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitionFamilies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitionFamilies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaskDefinitionFamiliesPublisher listTaskDefinitionFamiliesPaginator(
            Consumer<ListTaskDefinitionFamiliesRequest.Builder> listTaskDefinitionFamiliesRequest) {
        return listTaskDefinitionFamiliesPaginator(ListTaskDefinitionFamiliesRequest.builder()
                .applyMutation(listTaskDefinitionFamiliesRequest).build());
    }

    /**
     * <p>
     * Returns a list of task definitions that are registered to your account. You can filter the results by family name
     * with the <code>familyPrefix</code> parameter or by status with the <code>status</code> parameter.
     * </p>
     *
     * @param listTaskDefinitionsRequest
     * @return A Java Future containing the result of the ListTaskDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTaskDefinitionsResponse> listTaskDefinitions(
            ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of task definitions that are registered to your account. You can filter the results by family name
     * with the <code>familyPrefix</code> parameter or by status with the <code>status</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param listTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTaskDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTaskDefinitionsResponse> listTaskDefinitions(
            Consumer<ListTaskDefinitionsRequest.Builder> listTaskDefinitionsRequest) {
        return listTaskDefinitions(ListTaskDefinitionsRequest.builder().applyMutation(listTaskDefinitionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of task definitions that are registered to your account. You can filter the results by family name
     * with the <code>familyPrefix</code> parameter or by status with the <code>status</code> parameter.
     * </p>
     *
     * @return A Java Future containing the result of the ListTaskDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTaskDefinitionsResponse> listTaskDefinitions() {
        return listTaskDefinitions(ListTaskDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskDefinitions(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher publisher = client.listTaskDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher publisher = client.listTaskDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskDefinitions(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTaskDefinitionsPublisher listTaskDefinitionsPaginator() {
        return listTaskDefinitionsPaginator(ListTaskDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskDefinitions(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher publisher = client.listTaskDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher publisher = client.listTaskDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskDefinitions(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest)} operation.</b>
     * </p>
     *
     * @param listTaskDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTaskDefinitionsPublisher listTaskDefinitionsPaginator(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        return new ListTaskDefinitionsPublisher(this, listTaskDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskDefinitions(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher publisher = client.listTaskDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTaskDefinitionsPublisher publisher = client.listTaskDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskDefinitions(software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaskDefinitionsRequest#builder()}
     * </p>
     *
     * @param listTaskDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTaskDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTaskDefinitions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTaskDefinitionsPublisher listTaskDefinitionsPaginator(
            Consumer<ListTaskDefinitionsRequest.Builder> listTaskDefinitionsRequest) {
        return listTaskDefinitionsPaginator(ListTaskDefinitionsRequest.builder().applyMutation(listTaskDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tasks. You can filter the results by cluster, task definition family, container instance,
     * launch type, what IAM principal started the task, or by the desired status of the task.
     * </p>
     * <p>
     * Recently stopped tasks might appear in the returned results.
     * </p>
     *
     * @param listTasksRequest
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(ListTasksRequest listTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tasks. You can filter the results by cluster, task definition family, container instance,
     * launch type, what IAM principal started the task, or by the desired status of the task.
     * </p>
     * <p>
     * Recently stopped tasks might appear in the returned results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Returns a list of tasks. You can filter the results by cluster, task definition family, container instance,
     * launch type, what IAM principal started the task, or by the desired status of the task.
     * </p>
     * <p>
     * Recently stopped tasks might appear in the returned results.
     * </p>
     *
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks() {
        return listTasks(ListTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.ecs.model.ListTasksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.ecs.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator() {
        return listTasksPaginator(ListTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.ecs.model.ListTasksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.ecs.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(ListTasksRequest listTasksRequest) {
        return new ListTasksPublisher(this, listTasksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTasks(software.amazon.awssdk.services.ecs.model.ListTasksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecs.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecs.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecs.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.ecs.model.ListTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.ListTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ListTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Modifies an account setting. Account settings are set on a per-Region basis.
     * </p>
     * <p>
     * If you change the root user account setting, the default settings are reset for users and roles that do not have
     * specified individual account settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html">Account Settings</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param putAccountSettingRequest
     * @return A Java Future containing the result of the PutAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountSettingResponse> putAccountSetting(PutAccountSettingRequest putAccountSettingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an account setting. Account settings are set on a per-Region basis.
     * </p>
     * <p>
     * If you change the root user account setting, the default settings are reset for users and roles that do not have
     * specified individual account settings. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html">Account Settings</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSettingRequest.Builder} avoiding the need
     * to create one manually via {@link PutAccountSettingRequest#builder()}
     * </p>
     *
     * @param putAccountSettingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountSettingResponse> putAccountSetting(
            Consumer<PutAccountSettingRequest.Builder> putAccountSettingRequest) {
        return putAccountSetting(PutAccountSettingRequest.builder().applyMutation(putAccountSettingRequest).build());
    }

    /**
     * <p>
     * Modifies an account setting for all users on an account for whom no individual account setting has been
     * specified. Account settings are set on a per-Region basis.
     * </p>
     *
     * @param putAccountSettingDefaultRequest
     * @return A Java Future containing the result of the PutAccountSettingDefault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutAccountSettingDefault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingDefault" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccountSettingDefaultResponse> putAccountSettingDefault(
            PutAccountSettingDefaultRequest putAccountSettingDefaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an account setting for all users on an account for whom no individual account setting has been
     * specified. Account settings are set on a per-Region basis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSettingDefaultRequest.Builder} avoiding
     * the need to create one manually via {@link PutAccountSettingDefaultRequest#builder()}
     * </p>
     *
     * @param putAccountSettingDefaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAccountSettingDefault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutAccountSettingDefault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingDefault" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccountSettingDefaultResponse> putAccountSettingDefault(
            Consumer<PutAccountSettingDefaultRequest.Builder> putAccountSettingDefaultRequest) {
        return putAccountSettingDefault(PutAccountSettingDefaultRequest.builder().applyMutation(putAccountSettingDefaultRequest)
                .build());
    }

    /**
     * <p>
     * Create or update an attribute on an Amazon ECS resource. If the attribute doesn't exist, it's created. If the
     * attribute exists, its value is replaced with the specified value. To delete an attribute, use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteAttributes.html">DeleteAttributes</a>.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes"
     * >Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param putAttributesRequest
     * @return A Java Future containing the result of the PutAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>TargetNotFoundException The specified target wasn't found. You can view your available container
     *         instances with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListContainerInstances.html"
     *         >ListContainerInstances</a>. Amazon ECS container instances are cluster-specific and Region-specific.</li>
     *         <li>AttributeLimitExceededException You can apply up to 10 custom attributes for each resource. You can
     *         view the attributes of a resource with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListAttributes.html"
     *         >ListAttributes</a>. You can remove existing attributes on a resource with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteAttributes.html"
     *         >DeleteAttributes</a>.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAttributesResponse> putAttributes(PutAttributesRequest putAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update an attribute on an Amazon ECS resource. If the attribute doesn't exist, it's created. If the
     * attribute exists, its value is replaced with the specified value. To delete an attribute, use <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteAttributes.html">DeleteAttributes</a>.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes"
     * >Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAttributesRequest.Builder} avoiding the need to
     * create one manually via {@link PutAttributesRequest#builder()}
     * </p>
     *
     * @param putAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.PutAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>TargetNotFoundException The specified target wasn't found. You can view your available container
     *         instances with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListContainerInstances.html"
     *         >ListContainerInstances</a>. Amazon ECS container instances are cluster-specific and Region-specific.</li>
     *         <li>AttributeLimitExceededException You can apply up to 10 custom attributes for each resource. You can
     *         view the attributes of a resource with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListAttributes.html"
     *         >ListAttributes</a>. You can remove existing attributes on a resource with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteAttributes.html"
     *         >DeleteAttributes</a>.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAttributesResponse> putAttributes(Consumer<PutAttributesRequest.Builder> putAttributesRequest) {
        return putAttributes(PutAttributesRequest.builder().applyMutation(putAttributesRequest).build());
    }

    /**
     * <p>
     * Modifies the available capacity providers and the default capacity provider strategy for a cluster.
     * </p>
     * <p>
     * You must specify both the available capacity providers and a default capacity provider strategy for the cluster.
     * If the specified cluster has existing capacity providers associated with it, you must specify all existing
     * capacity providers in addition to any new ones you want to add. Any existing capacity providers that are
     * associated with a cluster that are omitted from a <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     * >PutClusterCapacityProviders</a> API call will be disassociated with the cluster. You can only disassociate an
     * existing capacity provider from a cluster if it's not being used by any existing tasks.
     * </p>
     * <p>
     * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified, then
     * the cluster's default capacity provider strategy is used. We recommend that you define a default capacity
     * provider strategy for your cluster. However, you must specify an empty array (<code>[]</code>) to bypass defining
     * a default strategy.
     * </p>
     *
     * @param putClusterCapacityProvidersRequest
     * @return A Java Future containing the result of the PutClusterCapacityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ResourceInUseException The specified resource is in-use and can't be removed.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutClusterCapacityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutClusterCapacityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutClusterCapacityProvidersResponse> putClusterCapacityProviders(
            PutClusterCapacityProvidersRequest putClusterCapacityProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the available capacity providers and the default capacity provider strategy for a cluster.
     * </p>
     * <p>
     * You must specify both the available capacity providers and a default capacity provider strategy for the cluster.
     * If the specified cluster has existing capacity providers associated with it, you must specify all existing
     * capacity providers in addition to any new ones you want to add. Any existing capacity providers that are
     * associated with a cluster that are omitted from a <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     * >PutClusterCapacityProviders</a> API call will be disassociated with the cluster. You can only disassociate an
     * existing capacity provider from a cluster if it's not being used by any existing tasks.
     * </p>
     * <p>
     * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified, then
     * the cluster's default capacity provider strategy is used. We recommend that you define a default capacity
     * provider strategy for your cluster. However, you must specify an empty array (<code>[]</code>) to bypass defining
     * a default strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutClusterCapacityProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link PutClusterCapacityProvidersRequest#builder()}
     * </p>
     *
     * @param putClusterCapacityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutClusterCapacityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ResourceInUseException The specified resource is in-use and can't be removed.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.PutClusterCapacityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutClusterCapacityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutClusterCapacityProvidersResponse> putClusterCapacityProviders(
            Consumer<PutClusterCapacityProvidersRequest.Builder> putClusterCapacityProvidersRequest) {
        return putClusterCapacityProviders(PutClusterCapacityProvidersRequest.builder()
                .applyMutation(putClusterCapacityProvidersRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Registers an EC2 instance into the specified cluster. This instance becomes available to place containers on.
     * </p>
     *
     * @param registerContainerInstanceRequest
     * @return A Java Future containing the result of the RegisterContainerInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.RegisterContainerInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterContainerInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterContainerInstanceResponse> registerContainerInstance(
            RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Registers an EC2 instance into the specified cluster. This instance becomes available to place containers on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterContainerInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterContainerInstanceRequest#builder()}
     * </p>
     *
     * @param registerContainerInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterContainerInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.RegisterContainerInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterContainerInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterContainerInstanceResponse> registerContainerInstance(
            Consumer<RegisterContainerInstanceRequest.Builder> registerContainerInstanceRequest) {
        return registerContainerInstance(RegisterContainerInstanceRequest.builder()
                .applyMutation(registerContainerInstanceRequest).build());
    }

    /**
     * <p>
     * Registers a new task definition from the supplied <code>family</code> and <code>containerDefinitions</code>.
     * Optionally, you can add data volumes to your containers with the <code>volumes</code> parameter. For more
     * information about task definition parameters and defaults, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task
     * Definitions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can specify a role for your task with the <code>taskRoleArn</code> parameter. When you specify a role for a
     * task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the Amazon Web
     * Services services that are specified in the policy that's associated with the role. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can specify a Docker networking mode for the containers in your task definition with the
     * <code>networkMode</code> parameter. If you specify the <code>awsvpc</code> network mode, the task is allocated an
     * elastic network interface, and you must specify a <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html"
     * >NetworkConfiguration</a> when you create a service or run a task with the task definition. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
     * Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param registerTaskDefinitionRequest
     * @return A Java Future containing the result of the RegisterTaskDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.RegisterTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTaskDefinitionResponse> registerTaskDefinition(
            RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new task definition from the supplied <code>family</code> and <code>containerDefinitions</code>.
     * Optionally, you can add data volumes to your containers with the <code>volumes</code> parameter. For more
     * information about task definition parameters and defaults, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task
     * Definitions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can specify a role for your task with the <code>taskRoleArn</code> parameter. When you specify a role for a
     * task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the Amazon Web
     * Services services that are specified in the policy that's associated with the role. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can specify a Docker networking mode for the containers in your task definition with the
     * <code>networkMode</code> parameter. If you specify the <code>awsvpc</code> network mode, the task is allocated an
     * elastic network interface, and you must specify a <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html"
     * >NetworkConfiguration</a> when you create a service or run a task with the task definition. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task
     * Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTaskDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterTaskDefinitionRequest#builder()}
     * </p>
     *
     * @param registerTaskDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterTaskDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.RegisterTaskDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTaskDefinitionResponse> registerTaskDefinition(
            Consumer<RegisterTaskDefinitionRequest.Builder> registerTaskDefinitionRequest) {
        return registerTaskDefinition(RegisterTaskDefinitionRequest.builder().applyMutation(registerTaskDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Starts a new task using the specified task definition.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Elastic Inference (EI) is no longer available to customers.
     * </p>
     * </note>
     * <p>
     * You can allow Amazon ECS to place tasks for you, or you can customize how Amazon ECS places tasks using placement
     * constraints and placement strategies. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html">Scheduling Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Alternatively, you can use <code>StartTask</code> to use your own scheduler or place tasks manually on specific
     * container instances.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a
     * service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * The Amazon ECS API follows an eventual consistency model. This is because of the distributed nature of the system
     * supporting the API. This means that the result of an API command you run that affects your Amazon ECS resources
     * might not be immediately visible to all subsequent commands you run. Keep this in mind when you carry out an API
     * command that immediately follows a previous API command.
     * </p>
     * <p>
     * To manage eventual consistency, you can do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Confirm the state of the resource before you run a command to modify it. Run the DescribeTasks command using an
     * exponential backoff algorithm to ensure that you allow enough time for the previous command to propagate through
     * the system. To do this, run the DescribeTasks command repeatedly, starting with a couple of seconds of wait time
     * and increasing gradually up to five minutes of wait time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Add wait time between subsequent commands, even if the DescribeTasks command returns an accurate response. Apply
     * an exponential backoff algorithm starting with a couple of seconds of wait time, and increase gradually up to
     * about five minutes of wait time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you get a <code>ConflictException</code> error, the <code>RunTask</code> request could not be processed due to
     * conflicts. The provided <code>clientToken</code> is already in use with a different <code>RunTask</code> request.
     * The <code>resourceIds</code> are the existing task ARNs which are already associated with the
     * <code>clientToken</code>.
     * </p>
     * <p>
     * To fix this issue:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Run <code>RunTask</code> with a unique <code>clientToken</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>RunTask</code> with the <code>clientToken</code> and the original set of parameters
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you get a <code>ClientException</code>error, the <code>RunTask</code> could not be processed because you use
     * managed scaling and there is a capacity error because the quota of tasks in the <code>PROVISIONING</code> per
     * cluster has been reached. For information about the service quotas, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-quotas.html">Amazon ECS service
     * quotas</a>.
     * </p>
     *
     * @param runTaskRequest
     * @return A Java Future containing the result of the RunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>BlockedException Your Amazon Web Services account was blocked. For more information, contact <a
     *         href="http://aws.amazon.com/contact-us/"> Amazon Web ServicesSupport</a>.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.RunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RunTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RunTaskResponse> runTask(RunTaskRequest runTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new task using the specified task definition.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Elastic Inference (EI) is no longer available to customers.
     * </p>
     * </note>
     * <p>
     * You can allow Amazon ECS to place tasks for you, or you can customize how Amazon ECS places tasks using placement
     * constraints and placement strategies. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html">Scheduling Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Alternatively, you can use <code>StartTask</code> to use your own scheduler or place tasks manually on specific
     * container instances.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a
     * service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * The Amazon ECS API follows an eventual consistency model. This is because of the distributed nature of the system
     * supporting the API. This means that the result of an API command you run that affects your Amazon ECS resources
     * might not be immediately visible to all subsequent commands you run. Keep this in mind when you carry out an API
     * command that immediately follows a previous API command.
     * </p>
     * <p>
     * To manage eventual consistency, you can do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Confirm the state of the resource before you run a command to modify it. Run the DescribeTasks command using an
     * exponential backoff algorithm to ensure that you allow enough time for the previous command to propagate through
     * the system. To do this, run the DescribeTasks command repeatedly, starting with a couple of seconds of wait time
     * and increasing gradually up to five minutes of wait time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Add wait time between subsequent commands, even if the DescribeTasks command returns an accurate response. Apply
     * an exponential backoff algorithm starting with a couple of seconds of wait time, and increase gradually up to
     * about five minutes of wait time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you get a <code>ConflictException</code> error, the <code>RunTask</code> request could not be processed due to
     * conflicts. The provided <code>clientToken</code> is already in use with a different <code>RunTask</code> request.
     * The <code>resourceIds</code> are the existing task ARNs which are already associated with the
     * <code>clientToken</code>.
     * </p>
     * <p>
     * To fix this issue:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Run <code>RunTask</code> with a unique <code>clientToken</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>RunTask</code> with the <code>clientToken</code> and the original set of parameters
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you get a <code>ClientException</code>error, the <code>RunTask</code> could not be processed because you use
     * managed scaling and there is a capacity error because the quota of tasks in the <code>PROVISIONING</code> per
     * cluster has been reached. For information about the service quotas, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-quotas.html">Amazon ECS service
     * quotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RunTaskRequest.Builder} avoiding the need to create
     * one manually via {@link RunTaskRequest#builder()}
     * </p>
     *
     * @param runTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.RunTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>BlockedException Your Amazon Web Services account was blocked. For more information, contact <a
     *         href="http://aws.amazon.com/contact-us/"> Amazon Web ServicesSupport</a>.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.RunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RunTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RunTaskResponse> runTask(Consumer<RunTaskRequest.Builder> runTaskRequest) {
        return runTask(RunTaskRequest.builder().applyMutation(runTaskRequest).build());
    }

    /**
     * <p>
     * Starts a new task from the specified task definition on the specified container instance or instances.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Elastic Inference (EI) is no longer available to customers.
     * </p>
     * </note>
     * <p>
     * Alternatively, you can use<code>RunTask</code> to place tasks for you. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html">Scheduling Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a
     * service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param startTaskRequest
     * @return A Java Future containing the result of the StartTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.StartTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StartTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTaskResponse> startTask(StartTaskRequest startTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new task from the specified task definition on the specified container instance or instances.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Elastic Inference (EI) is no longer available to customers.
     * </p>
     * </note>
     * <p>
     * Alternatively, you can use<code>RunTask</code> to place tasks for you. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html">Scheduling Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a
     * service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTaskRequest.Builder} avoiding the need to
     * create one manually via {@link StartTaskRequest#builder()}
     * </p>
     *
     * @param startTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.StartTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.StartTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StartTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTaskResponse> startTask(Consumer<StartTaskRequest.Builder> startTaskRequest) {
        return startTask(StartTaskRequest.builder().applyMutation(startTaskRequest).build());
    }

    /**
     * <p>
     * Stops an ongoing service deployment.
     * </p>
     * <p>
     * The following stop types are avaiable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ROLLBACK - This option rolls back the service deployment to the previous service revision.
     * </p>
     * <p>
     * You can use this option even if you didn't configure the service deployment for the rollback option.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stop-service-deployment.html">Stopping Amazon
     * ECS service deployments</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param stopServiceDeploymentRequest
     * @return A Java Future containing the result of the StopServiceDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceDeploymentNotFoundException The service deploy ARN that you specified in the
     *         <code>StopServiceDeployment</code> doesn't exist. You can use <code>ListServiceDeployments</code> to
     *         retrieve the service deployment ARNs.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.StopServiceDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopServiceDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopServiceDeploymentResponse> stopServiceDeployment(
            StopServiceDeploymentRequest stopServiceDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an ongoing service deployment.
     * </p>
     * <p>
     * The following stop types are avaiable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ROLLBACK - This option rolls back the service deployment to the previous service revision.
     * </p>
     * <p>
     * You can use this option even if you didn't configure the service deployment for the rollback option.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stop-service-deployment.html">Stopping Amazon
     * ECS service deployments</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopServiceDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StopServiceDeploymentRequest#builder()}
     * </p>
     *
     * @param stopServiceDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.StopServiceDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopServiceDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ServiceDeploymentNotFoundException The service deploy ARN that you specified in the
     *         <code>StopServiceDeployment</code> doesn't exist. You can use <code>ListServiceDeployments</code> to
     *         retrieve the service deployment ARNs.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.StopServiceDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopServiceDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopServiceDeploymentResponse> stopServiceDeployment(
            Consumer<StopServiceDeploymentRequest.Builder> stopServiceDeploymentRequest) {
        return stopServiceDeployment(StopServiceDeploymentRequest.builder().applyMutation(stopServiceDeploymentRequest).build());
    }

    /**
     * <p>
     * Stops a running task. Any tags associated with the task will be deleted.
     * </p>
     * <p>
     * When you call <code>StopTask</code> on a task, the equivalent of <code>docker stop</code> is issued to the
     * containers running in the task. This results in a <code>SIGTERM</code> value and a default 30-second timeout,
     * after which the <code>SIGKILL</code> value is sent and the containers are forcibly stopped. If the container
     * handles the <code>SIGTERM</code> value gracefully and exits within 30 seconds from receiving it, no
     * <code>SIGKILL</code> value is sent.
     * </p>
     * <p>
     * For Windows containers, POSIX signals do not work and runtime stops the container by sending a
     * <code>CTRL_SHUTDOWN_EVENT</code>. For more information, see <a
     * href="https://github.com/moby/moby/issues/25982">Unable to react to graceful shutdown of (Windows) container
     * #25982</a> on GitHub.
     * </p>
     * <note>
     * <p>
     * The default 30-second timeout can be configured on the Amazon ECS container agent with the
     * <code>ECS_CONTAINER_STOP_TIMEOUT</code> variable. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
     * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param stopTaskRequest
     * @return A Java Future containing the result of the StopTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.StopTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopTaskResponse> stopTask(StopTaskRequest stopTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running task. Any tags associated with the task will be deleted.
     * </p>
     * <p>
     * When you call <code>StopTask</code> on a task, the equivalent of <code>docker stop</code> is issued to the
     * containers running in the task. This results in a <code>SIGTERM</code> value and a default 30-second timeout,
     * after which the <code>SIGKILL</code> value is sent and the containers are forcibly stopped. If the container
     * handles the <code>SIGTERM</code> value gracefully and exits within 30 seconds from receiving it, no
     * <code>SIGKILL</code> value is sent.
     * </p>
     * <p>
     * For Windows containers, POSIX signals do not work and runtime stops the container by sending a
     * <code>CTRL_SHUTDOWN_EVENT</code>. For more information, see <a
     * href="https://github.com/moby/moby/issues/25982">Unable to react to graceful shutdown of (Windows) container
     * #25982</a> on GitHub.
     * </p>
     * <note>
     * <p>
     * The default 30-second timeout can be configured on the Amazon ECS container agent with the
     * <code>ECS_CONTAINER_STOP_TIMEOUT</code> variable. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
     * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTaskRequest.Builder} avoiding the need to
     * create one manually via {@link StopTaskRequest#builder()}
     * </p>
     *
     * @param stopTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.StopTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.StopTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/StopTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopTaskResponse> stopTask(Consumer<StopTaskRequest.Builder> stopTaskRequest) {
        return stopTask(StopTaskRequest.builder().applyMutation(stopTaskRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Sent to acknowledge that an attachment changed states.
     * </p>
     *
     * @param submitAttachmentStateChangesRequest
     * @return A Java Future containing the result of the SubmitAttachmentStateChanges operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.SubmitAttachmentStateChanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitAttachmentStateChanges"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitAttachmentStateChangesResponse> submitAttachmentStateChanges(
            SubmitAttachmentStateChangesRequest submitAttachmentStateChangesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Sent to acknowledge that an attachment changed states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitAttachmentStateChangesRequest.Builder}
     * avoiding the need to create one manually via {@link SubmitAttachmentStateChangesRequest#builder()}
     * </p>
     *
     * @param submitAttachmentStateChangesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SubmitAttachmentStateChanges operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.SubmitAttachmentStateChanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitAttachmentStateChanges"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitAttachmentStateChangesResponse> submitAttachmentStateChanges(
            Consumer<SubmitAttachmentStateChangesRequest.Builder> submitAttachmentStateChangesRequest) {
        return submitAttachmentStateChanges(SubmitAttachmentStateChangesRequest.builder()
                .applyMutation(submitAttachmentStateChangesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Sent to acknowledge that a container changed states.
     * </p>
     *
     * @param submitContainerStateChangeRequest
     * @return A Java Future containing the result of the SubmitContainerStateChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.SubmitContainerStateChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitContainerStateChangeResponse> submitContainerStateChange(
            SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Sent to acknowledge that a container changed states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitContainerStateChangeRequest.Builder} avoiding
     * the need to create one manually via {@link SubmitContainerStateChangeRequest#builder()}
     * </p>
     *
     * @param submitContainerStateChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SubmitContainerStateChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.SubmitContainerStateChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitContainerStateChangeResponse> submitContainerStateChange(
            Consumer<SubmitContainerStateChangeRequest.Builder> submitContainerStateChangeRequest) {
        return submitContainerStateChange(SubmitContainerStateChangeRequest.builder()
                .applyMutation(submitContainerStateChangeRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Sent to acknowledge that a task changed states.
     * </p>
     *
     * @param submitTaskStateChangeRequest
     * @return A Java Future containing the result of the SubmitTaskStateChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.SubmitTaskStateChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitTaskStateChange" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubmitTaskStateChangeResponse> submitTaskStateChange(
            SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     * </p>
     * </note>
     * <p>
     * Sent to acknowledge that a task changed states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitTaskStateChangeRequest.Builder} avoiding the
     * need to create one manually via {@link SubmitTaskStateChangeRequest#builder()}
     * </p>
     *
     * @param submitTaskStateChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SubmitTaskStateChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.SubmitTaskStateChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitTaskStateChange" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubmitTaskStateChangeResponse> submitTaskStateChange(
            Consumer<SubmitTaskStateChangeRequest.Builder> submitTaskStateChangeRequest) {
        return submitTaskStateChange(SubmitTaskStateChangeRequest.builder().applyMutation(submitTaskStateChangeRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * that are associated with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags
     * that are associated with that resource are deleted as well.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters for a capacity provider.
     * </p>
     *
     * @param updateCapacityProviderRequest
     * @return A Java Future containing the result of the UpdateCapacityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateCapacityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCapacityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCapacityProviderResponse> updateCapacityProvider(
            UpdateCapacityProviderRequest updateCapacityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters for a capacity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCapacityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCapacityProviderRequest#builder()}
     * </p>
     *
     * @param updateCapacityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCapacityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateCapacityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCapacityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCapacityProviderResponse> updateCapacityProvider(
            Consumer<UpdateCapacityProviderRequest.Builder> updateCapacityProviderRequest) {
        return updateCapacityProvider(UpdateCapacityProviderRequest.builder().applyMutation(updateCapacityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates the cluster.
     * </p>
     *
     * @param updateClusterRequest
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the settings to use for a cluster.
     * </p>
     *
     * @param updateClusterSettingsRequest
     * @return A Java Future containing the result of the UpdateClusterSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateClusterSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateClusterSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterSettingsResponse> updateClusterSettings(
            UpdateClusterSettingsRequest updateClusterSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings to use for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateClusterSettingsRequest#builder()}
     * </p>
     *
     * @param updateClusterSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateClusterSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateClusterSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateClusterSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterSettingsResponse> updateClusterSettings(
            Consumer<UpdateClusterSettingsRequest.Builder> updateClusterSettingsRequest) {
        return updateClusterSettings(UpdateClusterSettingsRequest.builder().applyMutation(updateClusterSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent
     * doesn't interrupt running tasks or services on the container instance. The process for updating the agent differs
     * depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating
     * system.
     * </p>
     * <note>
     * <p>
     * The <code>UpdateContainerAgent</code> API isn't supported for container instances using the Amazon ECS-optimized
     * Amazon Linux 2 (arm64) AMI. To update the container agent, you can update the <code>ecs-init</code> package. This
     * updates the agent. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/agent-update-ecs-ami.html">Updating the Amazon
     * ECS container agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Agent updates with the <code>UpdateContainerAgent</code> API operation do not apply to Windows container
     * instances. We recommend that you launch new container instances to update the agent version in your Windows
     * clusters.
     * </p>
     * </note>
     * <p>
     * The <code>UpdateContainerAgent</code> API requires an Amazon ECS-optimized AMI or Amazon Linux AMI with the
     * <code>ecs-init</code> service installed and running. For help updating the Amazon ECS container agent on other
     * operating systems, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent"
     * >Manually updating the Amazon ECS container agent</a> in the <i>Amazon Elastic Container Service Developer
     * Guide</i>.
     * </p>
     *
     * @param updateContainerAgentRequest
     * @return A Java Future containing the result of the UpdateContainerAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>NoUpdateAvailableException There's no update available for this Amazon ECS container agent. This
     *         might be because the agent is already running the latest version or because it's so old that there's no
     *         update path to the current version.</li>
     *         <li>MissingVersionException Amazon ECS can't determine the current version of the Amazon ECS container
     *         agent on the container instance and doesn't have enough information to proceed with an update. This could
     *         be because the agent running on the container instance is a previous or custom version that doesn't use
     *         our version information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateContainerAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContainerAgentResponse> updateContainerAgent(
            UpdateContainerAgentRequest updateContainerAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent
     * doesn't interrupt running tasks or services on the container instance. The process for updating the agent differs
     * depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating
     * system.
     * </p>
     * <note>
     * <p>
     * The <code>UpdateContainerAgent</code> API isn't supported for container instances using the Amazon ECS-optimized
     * Amazon Linux 2 (arm64) AMI. To update the container agent, you can update the <code>ecs-init</code> package. This
     * updates the agent. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/agent-update-ecs-ami.html">Updating the Amazon
     * ECS container agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Agent updates with the <code>UpdateContainerAgent</code> API operation do not apply to Windows container
     * instances. We recommend that you launch new container instances to update the agent version in your Windows
     * clusters.
     * </p>
     * </note>
     * <p>
     * The <code>UpdateContainerAgent</code> API requires an Amazon ECS-optimized AMI or Amazon Linux AMI with the
     * <code>ecs-init</code> service installed and running. For help updating the Amazon ECS container agent on other
     * operating systems, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent"
     * >Manually updating the Amazon ECS container agent</a> in the <i>Amazon Elastic Container Service Developer
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContainerAgentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateContainerAgentRequest#builder()}
     * </p>
     *
     * @param updateContainerAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateContainerAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UpdateInProgressException There's already a current Amazon ECS container agent update in progress on
     *         the container instance that's specified. If the container agent becomes disconnected while it's in a
     *         transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update process can get
     *         stuck in that state. However, when the agent reconnects, it resumes where it stopped previously.</li>
     *         <li>NoUpdateAvailableException There's no update available for this Amazon ECS container agent. This
     *         might be because the agent is already running the latest version or because it's so old that there's no
     *         update path to the current version.</li>
     *         <li>MissingVersionException Amazon ECS can't determine the current version of the Amazon ECS container
     *         agent on the container instance and doesn't have enough information to proceed with an update. This could
     *         be because the agent running on the container instance is a previous or custom version that doesn't use
     *         our version information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateContainerAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContainerAgentResponse> updateContainerAgent(
            Consumer<UpdateContainerAgentRequest.Builder> updateContainerAgentRequest) {
        return updateContainerAgent(UpdateContainerAgentRequest.builder().applyMutation(updateContainerAgentRequest).build());
    }

    /**
     * <p>
     * Modifies the status of an Amazon ECS container instance.
     * </p>
     * <p>
     * Once a container instance has reached an <code>ACTIVE</code> state, you can change the status of a container
     * instance to <code>DRAINING</code> to manually remove an instance from a cluster, for example to perform system
     * updates, update the Docker daemon, or scale down the cluster size.
     * </p>
     * <important>
     * <p>
     * A container instance can't be changed to <code>DRAINING</code> until it has reached an <code>ACTIVE</code>
     * status. If the instance is in any other status, an error will be received.
     * </p>
     * </important>
     * <p>
     * When you set a container instance to <code>DRAINING</code>, Amazon ECS prevents new tasks from being scheduled
     * for placement on the container instance and replacement service tasks are started on other container instances in
     * the cluster if the resources are available. Service tasks on the container instance that are in the
     * <code>PENDING</code> state are stopped immediately.
     * </p>
     * <p>
     * Service tasks on the container instance that are in the <code>RUNNING</code> state are stopped and replaced
     * according to the service's deployment configuration parameters, <code>minimumHealthyPercent</code> and
     * <code>maximumPercent</code>. You can change the deployment configuration of your service using <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>minimumHealthyPercent</code> is below 100%, the scheduler can ignore <code>desiredCount</code>
     * temporarily during task replacement. For example, <code>desiredCount</code> is four tasks, a minimum of 50%
     * allows the scheduler to stop two existing tasks before starting two new tasks. If the minimum is 100%, the
     * service scheduler can't remove existing tasks until the replacement tasks are considered healthy. Tasks for
     * services that do not use a load balancer are considered healthy if they're in the <code>RUNNING</code> state.
     * Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code> state
     * and are reported as healthy by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>maximumPercent</code> parameter represents an upper limit on the number of running tasks during task
     * replacement. You can use this to define the replacement batch size. For example, if <code>desiredCount</code> is
     * four tasks, a maximum of 200% starts four new tasks before stopping the four tasks to be drained, provided that
     * the cluster resources required to do this are available. If the maximum is 100%, then replacement tasks can't
     * start until the draining tasks have stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Any <code>PENDING</code> or <code>RUNNING</code> tasks that do not belong to a service aren't affected. You must
     * wait for them to finish or stop them manually.
     * </p>
     * <p>
     * A container instance has completed draining when it has no more <code>RUNNING</code> tasks. You can verify this
     * using <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListTasks.html">ListTasks</a>.
     * </p>
     * <p>
     * When a container instance has been drained, you can set a container instance to <code>ACTIVE</code> status and
     * once it has reached that status the Amazon ECS scheduler can begin scheduling tasks on the instance again.
     * </p>
     *
     * @param updateContainerInstancesStateRequest
     * @return A Java Future containing the result of the UpdateContainerInstancesState operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateContainerInstancesState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerInstancesState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContainerInstancesStateResponse> updateContainerInstancesState(
            UpdateContainerInstancesStateRequest updateContainerInstancesStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the status of an Amazon ECS container instance.
     * </p>
     * <p>
     * Once a container instance has reached an <code>ACTIVE</code> state, you can change the status of a container
     * instance to <code>DRAINING</code> to manually remove an instance from a cluster, for example to perform system
     * updates, update the Docker daemon, or scale down the cluster size.
     * </p>
     * <important>
     * <p>
     * A container instance can't be changed to <code>DRAINING</code> until it has reached an <code>ACTIVE</code>
     * status. If the instance is in any other status, an error will be received.
     * </p>
     * </important>
     * <p>
     * When you set a container instance to <code>DRAINING</code>, Amazon ECS prevents new tasks from being scheduled
     * for placement on the container instance and replacement service tasks are started on other container instances in
     * the cluster if the resources are available. Service tasks on the container instance that are in the
     * <code>PENDING</code> state are stopped immediately.
     * </p>
     * <p>
     * Service tasks on the container instance that are in the <code>RUNNING</code> state are stopped and replaced
     * according to the service's deployment configuration parameters, <code>minimumHealthyPercent</code> and
     * <code>maximumPercent</code>. You can change the deployment configuration of your service using <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>minimumHealthyPercent</code> is below 100%, the scheduler can ignore <code>desiredCount</code>
     * temporarily during task replacement. For example, <code>desiredCount</code> is four tasks, a minimum of 50%
     * allows the scheduler to stop two existing tasks before starting two new tasks. If the minimum is 100%, the
     * service scheduler can't remove existing tasks until the replacement tasks are considered healthy. Tasks for
     * services that do not use a load balancer are considered healthy if they're in the <code>RUNNING</code> state.
     * Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code> state
     * and are reported as healthy by the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>maximumPercent</code> parameter represents an upper limit on the number of running tasks during task
     * replacement. You can use this to define the replacement batch size. For example, if <code>desiredCount</code> is
     * four tasks, a maximum of 200% starts four new tasks before stopping the four tasks to be drained, provided that
     * the cluster resources required to do this are available. If the maximum is 100%, then replacement tasks can't
     * start until the draining tasks have stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Any <code>PENDING</code> or <code>RUNNING</code> tasks that do not belong to a service aren't affected. You must
     * wait for them to finish or stop them manually.
     * </p>
     * <p>
     * A container instance has completed draining when it has no more <code>RUNNING</code> tasks. You can verify this
     * using <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListTasks.html">ListTasks</a>.
     * </p>
     * <p>
     * When a container instance has been drained, you can set a container instance to <code>ACTIVE</code> status and
     * once it has reached that status the Amazon ECS scheduler can begin scheduling tasks on the instance again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContainerInstancesStateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateContainerInstancesStateRequest#builder()}
     * </p>
     *
     * @param updateContainerInstancesStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateContainerInstancesState operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateContainerInstancesState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateContainerInstancesState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContainerInstancesStateResponse> updateContainerInstancesState(
            Consumer<UpdateContainerInstancesStateRequest.Builder> updateContainerInstancesStateRequest) {
        return updateContainerInstancesState(UpdateContainerInstancesStateRequest.builder()
                .applyMutation(updateContainerInstancesStateRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a service.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note>
     * <p>
     * For services using the rolling update (<code>ECS</code>) you can update the desired count, deployment
     * configuration, network configuration, load balancers, service registries, enable ECS managed tags option,
     * propagate tags option, task placement constraints and strategies, and task definition. When you update any of
     * these parameters, Amazon ECS starts new tasks with the new configuration.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task,
     * or when creating or updating a service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. You can update your volume
     * configurations and trigger a new deployment. <code>volumeConfigurations</code> is only supported for REPLICA
     * service and not DAEMON service. If you leave <code>volumeConfigurations</code> <code>null</code>, it doesn't
     * trigger a new deployment. For more infomation on volumes, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * For services using the blue/green (<code>CODE_DEPLOY</code>) deployment controller, only the desired count,
     * deployment configuration, health check grace period, task placement constraints and strategies, enable ECS
     * managed tags option, and propagate tags can be updated using this API. If the network configuration, platform
     * version, task definition, or load balancer need to be updated, create a new CodeDeploy deployment. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a>
     * in the <i>CodeDeploy API Reference</i>.
     * </p>
     * <p>
     * For services using an external deployment controller, you can update only the desired count, task placement
     * constraints and strategies, health check grace period, enable ECS managed tags option, and propagate tags option,
     * using this API. If the launch type, load balancer, network configuration, platform version, or task definition
     * need to be updated, create a new task set For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
     * </p>
     * <p>
     * You can add to or subtract from the number of instantiations of a task definition in a service by specifying the
     * cluster that the service is running in and a new <code>desiredCount</code> parameter.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task,
     * or when creating or updating a service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If you have updated the container image of your application, you can create a new task definition with that image
     * and deploy it to your service. The service scheduler uses the minimum healthy percent and maximum percent
     * parameters (in the service's deployment configuration) to determine the deployment strategy.
     * </p>
     * <note>
     * <p>
     * If your updated Docker image uses the same tag as what is in the existing task definition for your service (for
     * example, <code>my_image:latest</code>), you don't need to create a new revision of your task definition. You can
     * update the service using the <code>forceNewDeployment</code> option. The new tasks launched by the deployment
     * pull the current image/tag combination from your repository when they start.
     * </p>
     * </note>
     * <p>
     * You can also update the deployment configuration of a service. When a deployment is triggered by updating the
     * task definition of a service, the service scheduler uses the deployment configuration parameters,
     * <code>minimumHealthyPercent</code> and <code>maximumPercent</code>, to determine the deployment strategy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>minimumHealthyPercent</code> is below 100%, the scheduler can ignore <code>desiredCount</code>
     * temporarily during a deployment. For example, if <code>desiredCount</code> is four tasks, a minimum of 50% allows
     * the scheduler to stop two existing tasks before starting two new tasks. Tasks for services that don't use a load
     * balancer are considered healthy if they're in the <code>RUNNING</code> state. Tasks for services that use a load
     * balancer are considered healthy if they're in the <code>RUNNING</code> state and are reported as healthy by the
     * load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>maximumPercent</code> parameter represents an upper limit on the number of running tasks during a
     * deployment. You can use it to define the deployment batch size. For example, if <code>desiredCount</code> is four
     * tasks, a maximum of 200% starts four new tasks before stopping the four older tasks (provided that the cluster
     * resources required to do this are available).
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>
     * stops a task during a deployment, the equivalent of <code>docker stop</code> is issued to the containers running
     * in the task. This results in a <code>SIGTERM</code> and a 30-second timeout. After this, <code>SIGKILL</code> is
     * sent and the containers are forcibly stopped. If the container handles the <code>SIGTERM</code> gracefully and
     * exits within 30 seconds from receiving it, no <code>SIGKILL</code> is sent.
     * </p>
     * <p>
     * When the service scheduler launches new tasks, it determines task placement in your cluster with the following
     * logic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Determine which of the container instances in your cluster can support your service's task definition. For
     * example, they have the required CPU, memory, ports, and container instance attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * By default, the service scheduler attempts to balance tasks across Availability Zones in this manner even though
     * you can choose a different placement strategy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sort the valid container instances by the fewest number of running tasks for this service in the same
     * Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each
     * have zero, valid container instances in either zone B or C are considered optimal for placement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Place the new service task on a valid container instance in an optimal Availability Zone (based on the previous
     * steps), favoring container instances with the fewest number of running tasks for this service.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * When the service scheduler stops running tasks, it attempts to maintain balance across the Availability Zones in
     * your cluster using the following logic:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sort the container instances by the largest number of running tasks for this service in the same Availability
     * Zone as the instance. For example, if zone A has one running service task and zones B and C each have two,
     * container instances in either zone B or C are considered optimal for termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stop the task on a container instance in an optimal Availability Zone (based on the previous steps), favoring
     * container instances with the largest number of running tasks for this service.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You must have a service-linked role when you update any of the following service properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>loadBalancers</code>,
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>serviceRegistries</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about the role see the <code>CreateService</code> request parameter <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
     * > <code>role</code> </a>.
     * </p>
     * </note>
     *
     * @param updateServiceRequest
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(UpdateServiceRequest updateServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a service.
     * </p>
     * <note>
     * <p>
     * On March 21, 2024, a change was made to resolve the task definition revision before authorization. When a task
     * definition revision is not specified, authorization will occur using the latest revision of a task definition.
     * </p>
     * </note>
     * <p>
     * For services using the rolling update (<code>ECS</code>) you can update the desired count, deployment
     * configuration, network configuration, load balancers, service registries, enable ECS managed tags option,
     * propagate tags option, task placement constraints and strategies, and task definition. When you update any of
     * these parameters, Amazon ECS starts new tasks with the new configuration.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task,
     * or when creating or updating a service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. You can update your volume
     * configurations and trigger a new deployment. <code>volumeConfigurations</code> is only supported for REPLICA
     * service and not DAEMON service. If you leave <code>volumeConfigurations</code> <code>null</code>, it doesn't
     * trigger a new deployment. For more infomation on volumes, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * For services using the blue/green (<code>CODE_DEPLOY</code>) deployment controller, only the desired count,
     * deployment configuration, health check grace period, task placement constraints and strategies, enable ECS
     * managed tags option, and propagate tags can be updated using this API. If the network configuration, platform
     * version, task definition, or load balancer need to be updated, create a new CodeDeploy deployment. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a>
     * in the <i>CodeDeploy API Reference</i>.
     * </p>
     * <p>
     * For services using an external deployment controller, you can update only the desired count, task placement
     * constraints and strategies, health check grace period, enable ECS managed tags option, and propagate tags option,
     * using this API. If the launch type, load balancer, network configuration, platform version, or task definition
     * need to be updated, create a new task set For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
     * </p>
     * <p>
     * You can add to or subtract from the number of instantiations of a task definition in a service by specifying the
     * cluster that the service is running in and a new <code>desiredCount</code> parameter.
     * </p>
     * <p>
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task,
     * or when creating or updating a service. For more infomation, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon EBS
     * volumes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If you have updated the container image of your application, you can create a new task definition with that image
     * and deploy it to your service. The service scheduler uses the minimum healthy percent and maximum percent
     * parameters (in the service's deployment configuration) to determine the deployment strategy.
     * </p>
     * <note>
     * <p>
     * If your updated Docker image uses the same tag as what is in the existing task definition for your service (for
     * example, <code>my_image:latest</code>), you don't need to create a new revision of your task definition. You can
     * update the service using the <code>forceNewDeployment</code> option. The new tasks launched by the deployment
     * pull the current image/tag combination from your repository when they start.
     * </p>
     * </note>
     * <p>
     * You can also update the deployment configuration of a service. When a deployment is triggered by updating the
     * task definition of a service, the service scheduler uses the deployment configuration parameters,
     * <code>minimumHealthyPercent</code> and <code>maximumPercent</code>, to determine the deployment strategy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>minimumHealthyPercent</code> is below 100%, the scheduler can ignore <code>desiredCount</code>
     * temporarily during a deployment. For example, if <code>desiredCount</code> is four tasks, a minimum of 50% allows
     * the scheduler to stop two existing tasks before starting two new tasks. Tasks for services that don't use a load
     * balancer are considered healthy if they're in the <code>RUNNING</code> state. Tasks for services that use a load
     * balancer are considered healthy if they're in the <code>RUNNING</code> state and are reported as healthy by the
     * load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>maximumPercent</code> parameter represents an upper limit on the number of running tasks during a
     * deployment. You can use it to define the deployment batch size. For example, if <code>desiredCount</code> is four
     * tasks, a maximum of 200% starts four new tasks before stopping the four older tasks (provided that the cluster
     * resources required to do this are available).
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>
     * stops a task during a deployment, the equivalent of <code>docker stop</code> is issued to the containers running
     * in the task. This results in a <code>SIGTERM</code> and a 30-second timeout. After this, <code>SIGKILL</code> is
     * sent and the containers are forcibly stopped. If the container handles the <code>SIGTERM</code> gracefully and
     * exits within 30 seconds from receiving it, no <code>SIGKILL</code> is sent.
     * </p>
     * <p>
     * When the service scheduler launches new tasks, it determines task placement in your cluster with the following
     * logic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Determine which of the container instances in your cluster can support your service's task definition. For
     * example, they have the required CPU, memory, ports, and container instance attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * By default, the service scheduler attempts to balance tasks across Availability Zones in this manner even though
     * you can choose a different placement strategy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sort the valid container instances by the fewest number of running tasks for this service in the same
     * Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each
     * have zero, valid container instances in either zone B or C are considered optimal for placement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Place the new service task on a valid container instance in an optimal Availability Zone (based on the previous
     * steps), favoring container instances with the fewest number of running tasks for this service.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * When the service scheduler stops running tasks, it attempts to maintain balance across the Availability Zones in
     * your cluster using the following logic:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sort the container instances by the largest number of running tasks for this service in the same Availability
     * Zone as the instance. For example, if zone A has one running service task and zones B and C each have two,
     * container instances in either zone B or C are considered optimal for termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stop the task on a container instance in an optimal Availability Zone (based on the previous steps), favoring
     * container instances with the largest number of running tasks for this service.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You must have a service-linked role when you update any of the following service properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>loadBalancers</code>,
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>serviceRegistries</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about the role see the <code>CreateService</code> request parameter <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role"
     * > <code>role</code> </a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServiceRequest#builder()}
     * </p>
     *
     * @param updateServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>PlatformUnknownException The specified platform version doesn't exist.</li>
     *         <li>PlatformTaskDefinitionIncompatibilityException The specified platform version doesn't satisfy the
     *         required capabilities of the task definition.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>NamespaceNotFoundException The specified namespace wasn't found.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest) {
        return updateService(UpdateServiceRequest.builder().applyMutation(updateServiceRequest).build());
    }

    /**
     * <p>
     * Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task
     * set in a service will transition to the service. This is used when a service uses the <code>EXTERNAL</code>
     * deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment
     * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param updateServicePrimaryTaskSetRequest
     * @return A Java Future containing the result of the UpdateServicePrimaryTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>TaskSetNotFoundException The specified task set wasn't found. You can view your available task sets
     *         with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTaskSets.html">
     *         DescribeTaskSets</a>. Task sets are specific to each cluster, service and Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateServicePrimaryTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateServicePrimaryTaskSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServicePrimaryTaskSetResponse> updateServicePrimaryTaskSet(
            UpdateServicePrimaryTaskSetRequest updateServicePrimaryTaskSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task
     * set in a service will transition to the service. This is used when a service uses the <code>EXTERNAL</code>
     * deployment controller type. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment
     * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServicePrimaryTaskSetRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServicePrimaryTaskSetRequest#builder()}
     * </p>
     *
     * @param updateServicePrimaryTaskSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServicePrimaryTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>TaskSetNotFoundException The specified task set wasn't found. You can view your available task sets
     *         with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTaskSets.html">
     *         DescribeTaskSets</a>. Task sets are specific to each cluster, service and Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateServicePrimaryTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateServicePrimaryTaskSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServicePrimaryTaskSetResponse> updateServicePrimaryTaskSet(
            Consumer<UpdateServicePrimaryTaskSetRequest.Builder> updateServicePrimaryTaskSetRequest) {
        return updateServicePrimaryTaskSet(UpdateServicePrimaryTaskSetRequest.builder()
                .applyMutation(updateServicePrimaryTaskSetRequest).build());
    }

    /**
     * <p>
     * Updates the protection status of a task. You can set <code>protectionEnabled</code> to <code>true</code> to
     * protect your task from termination during scale-in events from <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html">Service
     * Autoscaling</a> or <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">deployments</a>.
     * </p>
     * <p>
     * Task-protection, by default, expires after 2 hours at which point Amazon ECS clears the
     * <code>protectionEnabled</code> property making the task eligible for termination by a subsequent scale-in event.
     * </p>
     * <p>
     * You can specify a custom expiration period for task protection from 1 minute to up to 2,880 minutes (48 hours).
     * To specify the custom expiration period, set the <code>expiresInMinutes</code> property. The
     * <code>expiresInMinutes</code> property is always reset when you invoke this operation for a task that already has
     * <code>protectionEnabled</code> set to <code>true</code>. You can keep extending the protection expiration period
     * of a task by invoking this operation repeatedly.
     * </p>
     * <p>
     * To learn more about Amazon ECS task protection, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection.html">Task scale-in
     * protection</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * This operation is only supported for tasks belonging to an Amazon ECS service. Invoking this operation for a
     * standalone task will result in an <code>TASK_NOT_VALID</code> failure. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html">API failure
     * reasons</a>.
     * </p>
     * </note> <important>
     * <p>
     * If you prefer to set task protection from within the container, we recommend using the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection-endpoint.html">Task
     * scale-in protection endpoint</a>.
     * </p>
     * </important>
     *
     * @param updateTaskProtectionRequest
     * @return A Java Future containing the result of the UpdateTaskProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateTaskProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateTaskProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskProtectionResponse> updateTaskProtection(
            UpdateTaskProtectionRequest updateTaskProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the protection status of a task. You can set <code>protectionEnabled</code> to <code>true</code> to
     * protect your task from termination during scale-in events from <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html">Service
     * Autoscaling</a> or <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">deployments</a>.
     * </p>
     * <p>
     * Task-protection, by default, expires after 2 hours at which point Amazon ECS clears the
     * <code>protectionEnabled</code> property making the task eligible for termination by a subsequent scale-in event.
     * </p>
     * <p>
     * You can specify a custom expiration period for task protection from 1 minute to up to 2,880 minutes (48 hours).
     * To specify the custom expiration period, set the <code>expiresInMinutes</code> property. The
     * <code>expiresInMinutes</code> property is always reset when you invoke this operation for a task that already has
     * <code>protectionEnabled</code> set to <code>true</code>. You can keep extending the protection expiration period
     * of a task by invoking this operation repeatedly.
     * </p>
     * <p>
     * To learn more about Amazon ECS task protection, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection.html">Task scale-in
     * protection</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * This operation is only supported for tasks belonging to an Amazon ECS service. Invoking this operation for a
     * standalone task will result in an <code>TASK_NOT_VALID</code> failure. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html">API failure
     * reasons</a>.
     * </p>
     * </note> <important>
     * <p>
     * If you prefer to set task protection from within the container, we recommend using the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection-endpoint.html">Task
     * scale-in protection endpoint</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTaskProtectionRequest#builder()}
     * </p>
     *
     * @param updateTaskProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTaskProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateTaskProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateTaskProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskProtectionResponse> updateTaskProtection(
            Consumer<UpdateTaskProtectionRequest.Builder> updateTaskProtectionRequest) {
        return updateTaskProtection(UpdateTaskProtectionRequest.builder().applyMutation(updateTaskProtectionRequest).build());
    }

    /**
     * <p>
     * Modifies a task set. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment
     * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     *
     * @param updateTaskSetRequest
     * @return A Java Future containing the result of the UpdateTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>TaskSetNotFoundException The specified task set wasn't found. You can view your available task sets
     *         with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTaskSets.html">
     *         DescribeTaskSets</a>. Task sets are specific to each cluster, service and Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateTaskSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskSetResponse> updateTaskSet(UpdateTaskSetRequest updateTaskSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a task set. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment
     * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTaskSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTaskSetRequest#builder()}
     * </p>
     *
     * @param updateTaskSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTaskSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>ClientException These errors are usually caused by a client action. This client action might be using
     *         an action or resource on behalf of a user that doesn't have permissions to use the action or resource.
     *         Or, it might be specifying an identifier that isn't valid.</li>
     *         <li>InvalidParameterException The specified parameter isn't valid. Review the available parameters for
     *         the API request.</p>
     *         <p>
     *         For more information about service event errors, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-event-messages-list.html"
     *         >Amazon ECS service event messages</a>.</li>
     *         <li>ClusterNotFoundException The specified cluster wasn't found. You can view your available clusters
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListClusters.html">ListClusters</a>.
     *         Amazon ECS clusters are Region specific.</li>
     *         <li>UnsupportedFeatureException The specified task isn't supported in this Region.</li>
     *         <li>AccessDeniedException You don't have authorization to perform the requested action.</li>
     *         <li>ServiceNotFoundException The specified service wasn't found. You can view your available services
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html">ListServices</a>.
     *         Amazon ECS services are cluster specific and Region specific.</li>
     *         <li>ServiceNotActiveException The specified service isn't active. You can't update a service that's
     *         inactive. If you have previously deleted a service, you can re-create it with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
     *         >CreateService</a>.</li>
     *         <li>TaskSetNotFoundException The specified task set wasn't found. You can view your available task sets
     *         with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTaskSets.html">
     *         DescribeTaskSets</a>. Task sets are specific to each cluster, service and Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcsAsyncClient.UpdateTaskSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateTaskSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTaskSetResponse> updateTaskSet(Consumer<UpdateTaskSetRequest.Builder> updateTaskSetRequest) {
        return updateTaskSet(UpdateTaskSetRequest.builder().applyMutation(updateTaskSetRequest).build());
    }

    /**
     * Create an instance of {@link EcsAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link EcsAsyncWaiter}
     */
    default EcsAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default EcsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EcsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EcsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EcsAsyncClient}.
     */
    static EcsAsyncClientBuilder builder() {
        return new DefaultEcsAsyncClientBuilder();
    }
}
