/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.EcsServiceClientConfiguration;
import software.amazon.awssdk.services.ecs.internal.EcsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ecs.model.AccessDeniedException;
import software.amazon.awssdk.services.ecs.model.AttributeLimitExceededException;
import software.amazon.awssdk.services.ecs.model.BlockedException;
import software.amazon.awssdk.services.ecs.model.ClientException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsContainerInstancesException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsServicesException;
import software.amazon.awssdk.services.ecs.model.ClusterContainsTasksException;
import software.amazon.awssdk.services.ecs.model.ClusterNotFoundException;
import software.amazon.awssdk.services.ecs.model.ConflictException;
import software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.CreateClusterRequest;
import software.amazon.awssdk.services.ecs.model.CreateClusterResponse;
import software.amazon.awssdk.services.ecs.model.CreateServiceRequest;
import software.amazon.awssdk.services.ecs.model.CreateServiceResponse;
import software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest;
import software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse;
import software.amazon.awssdk.services.ecs.model.DeleteAttributesRequest;
import software.amazon.awssdk.services.ecs.model.DeleteAttributesResponse;
import software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.DeleteClusterRequest;
import software.amazon.awssdk.services.ecs.model.DeleteClusterResponse;
import software.amazon.awssdk.services.ecs.model.DeleteServiceRequest;
import software.amazon.awssdk.services.ecs.model.DeleteServiceResponse;
import software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse;
import software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.DeleteTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest;
import software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse;
import software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse;
import software.amazon.awssdk.services.ecs.model.DescribeClustersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeClustersResponse;
import software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServiceDeploymentsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServiceRevisionsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeServicesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTasksRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTasksResponse;
import software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest;
import software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse;
import software.amazon.awssdk.services.ecs.model.EcsException;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse;
import software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest;
import software.amazon.awssdk.services.ecs.model.GetTaskProtectionResponse;
import software.amazon.awssdk.services.ecs.model.InvalidParameterException;
import software.amazon.awssdk.services.ecs.model.LimitExceededException;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse;
import software.amazon.awssdk.services.ecs.model.ListAttributesRequest;
import software.amazon.awssdk.services.ecs.model.ListAttributesResponse;
import software.amazon.awssdk.services.ecs.model.ListClustersRequest;
import software.amazon.awssdk.services.ecs.model.ListClustersResponse;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse;
import software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsRequest;
import software.amazon.awssdk.services.ecs.model.ListServiceDeploymentsResponse;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse;
import software.amazon.awssdk.services.ecs.model.ListServicesRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesResponse;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse;
import software.amazon.awssdk.services.ecs.model.ListTasksRequest;
import software.amazon.awssdk.services.ecs.model.ListTasksResponse;
import software.amazon.awssdk.services.ecs.model.MissingVersionException;
import software.amazon.awssdk.services.ecs.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.ecs.model.NoUpdateAvailableException;
import software.amazon.awssdk.services.ecs.model.PlatformTaskDefinitionIncompatibilityException;
import software.amazon.awssdk.services.ecs.model.PlatformUnknownException;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest;
import software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse;
import software.amazon.awssdk.services.ecs.model.PutAttributesRequest;
import software.amazon.awssdk.services.ecs.model.PutAttributesResponse;
import software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest;
import software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersResponse;
import software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest;
import software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse;
import software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest;
import software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse;
import software.amazon.awssdk.services.ecs.model.ResourceInUseException;
import software.amazon.awssdk.services.ecs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ecs.model.RunTaskRequest;
import software.amazon.awssdk.services.ecs.model.RunTaskResponse;
import software.amazon.awssdk.services.ecs.model.ServerException;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentNotFoundException;
import software.amazon.awssdk.services.ecs.model.ServiceNotActiveException;
import software.amazon.awssdk.services.ecs.model.ServiceNotFoundException;
import software.amazon.awssdk.services.ecs.model.StartTaskRequest;
import software.amazon.awssdk.services.ecs.model.StartTaskResponse;
import software.amazon.awssdk.services.ecs.model.StopServiceDeploymentRequest;
import software.amazon.awssdk.services.ecs.model.StopServiceDeploymentResponse;
import software.amazon.awssdk.services.ecs.model.StopTaskRequest;
import software.amazon.awssdk.services.ecs.model.StopTaskResponse;
import software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest;
import software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse;
import software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest;
import software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse;
import software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest;
import software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeResponse;
import software.amazon.awssdk.services.ecs.model.TagResourceRequest;
import software.amazon.awssdk.services.ecs.model.TagResourceResponse;
import software.amazon.awssdk.services.ecs.model.TargetNotConnectedException;
import software.amazon.awssdk.services.ecs.model.TargetNotFoundException;
import software.amazon.awssdk.services.ecs.model.TaskSetNotFoundException;
import software.amazon.awssdk.services.ecs.model.UnsupportedFeatureException;
import software.amazon.awssdk.services.ecs.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecs.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest;
import software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse;
import software.amazon.awssdk.services.ecs.model.UpdateClusterRequest;
import software.amazon.awssdk.services.ecs.model.UpdateClusterResponse;
import software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest;
import software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse;
import software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest;
import software.amazon.awssdk.services.ecs.model.UpdateContainerAgentResponse;
import software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest;
import software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse;
import software.amazon.awssdk.services.ecs.model.UpdateInProgressException;
import software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse;
import software.amazon.awssdk.services.ecs.model.UpdateServiceRequest;
import software.amazon.awssdk.services.ecs.model.UpdateServiceResponse;
import software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest;
import software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse;
import software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest;
import software.amazon.awssdk.services.ecs.model.UpdateTaskSetResponse;
import software.amazon.awssdk.services.ecs.transform.CreateCapacityProviderRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.CreateTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteAccountSettingRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteAttributesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteCapacityProviderRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeleteTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeregisterContainerInstanceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DeregisterTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeCapacityProvidersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeContainerInstancesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeServiceRevisionsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeTaskSetsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DescribeTasksRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.DiscoverPollEndpointRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ExecuteCommandRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.GetTaskProtectionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListAttributesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListContainerInstancesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListServicesByNamespaceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTaskDefinitionFamiliesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTaskDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.ListTasksRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutAccountSettingDefaultRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutAccountSettingRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutAttributesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.PutClusterCapacityProvidersRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.RegisterContainerInstanceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.RegisterTaskDefinitionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.RunTaskRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.StartTaskRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.StopServiceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.StopTaskRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.SubmitAttachmentStateChangesRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.SubmitContainerStateChangeRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.SubmitTaskStateChangeRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateCapacityProviderRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateClusterSettingsRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateContainerAgentRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateContainerInstancesStateRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateServicePrimaryTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateTaskProtectionRequestMarshaller;
import software.amazon.awssdk.services.ecs.transform.UpdateTaskSetRequestMarshaller;
import software.amazon.awssdk.services.ecs.waiters.EcsAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultEcsAsyncClient
implements EcsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultEcsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultEcsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ECS#2.31.78").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<CreateCapacityProviderResponse> createCapacityProvider(CreateCapacityProviderRequest createCapacityProviderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCapacityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, createCapacityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCapacityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCapacityProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCapacityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCapacityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCapacityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$createCapacityProvider$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$createCapacityProvider$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$createCluster$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$createCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateServiceResponse> createService(CreateServiceRequest createServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, createServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$createService$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$createService$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTaskSetResponse> createTaskSet(CreateTaskSetRequest createTaskSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, createTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTaskSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTaskSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTaskSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$createTaskSet$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$createTaskSet$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccountSettingResponse> deleteAccountSetting(DeleteAccountSettingRequest deleteAccountSettingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccountSettingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAccountSettingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccountSetting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountSettingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccountSetting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAccountSettingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAccountSettingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteAccountSetting$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteAccountSetting$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAttributesResponse> deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteAttributes$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteAttributes$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCapacityProviderResponse> deleteCapacityProvider(DeleteCapacityProviderRequest deleteCapacityProviderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCapacityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCapacityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCapacityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCapacityProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCapacityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCapacityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCapacityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteCapacityProvider$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteCapacityProvider$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteCluster$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteCluster$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceResponse> deleteService(DeleteServiceRequest deleteServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteService$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteService$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTaskDefinitionsResponse> deleteTaskDefinitions(DeleteTaskDefinitionsRequest deleteTaskDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTaskDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTaskDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaskDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTaskDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTaskDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTaskDefinitionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteTaskDefinitions$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteTaskDefinitions$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTaskSetResponse> deleteTaskSet(DeleteTaskSetRequest deleteTaskSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTaskSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaskSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTaskSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deleteTaskSet$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deleteTaskSet$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterContainerInstanceResponse> deregisterContainerInstance(DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterContainerInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterContainerInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterContainerInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterContainerInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterContainerInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterContainerInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterContainerInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deregisterContainerInstance$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deregisterContainerInstance$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterTaskDefinitionResponse> deregisterTaskDefinition(DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterTaskDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterTaskDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterTaskDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterTaskDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterTaskDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterTaskDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$deregisterTaskDefinition$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$deregisterTaskDefinition$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCapacityProvidersResponse> describeCapacityProviders(DescribeCapacityProvidersRequest describeCapacityProvidersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCapacityProvidersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeCapacityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCapacityProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCapacityProvidersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCapacityProviders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCapacityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCapacityProvidersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeCapacityProviders$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeCapacityProviders$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeClusters$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeClusters$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeContainerInstancesResponse> describeContainerInstances(DescribeContainerInstancesRequest describeContainerInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContainerInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeContainerInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContainerInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContainerInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContainerInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeContainerInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeContainerInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeContainerInstances$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeContainerInstances$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeServiceDeploymentsResponse> describeServiceDeployments(DescribeServiceDeploymentsRequest describeServiceDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceDeploymentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceDeployments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeServiceDeploymentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeServiceDeployments$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeServiceDeployments$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeServiceRevisionsResponse> describeServiceRevisions(DescribeServiceRevisionsRequest describeServiceRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceRevisionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeServiceRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceRevisionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceRevisions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeServiceRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeServiceRevisionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeServiceRevisions$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeServiceRevisions$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeServicesResponse> describeServices(DescribeServicesRequest describeServicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeServices$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeServices$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTaskDefinitionResponse> describeTaskDefinition(DescribeTaskDefinitionRequest describeTaskDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTaskDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeTaskDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTaskDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTaskDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTaskDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTaskDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeTaskDefinition$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeTaskDefinition$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTaskSetsResponse> describeTaskSets(DescribeTaskSetsRequest describeTaskSetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTaskSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeTaskSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTaskSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTaskSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTaskSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTaskSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTaskSetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeTaskSets$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeTaskSets$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTasksResponse> describeTasks(DescribeTasksRequest describeTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, describeTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$describeTasks$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$describeTasks$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DiscoverPollEndpointResponse> discoverPollEndpoint(DiscoverPollEndpointRequest discoverPollEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverPollEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, discoverPollEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverPollEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverPollEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverPollEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DiscoverPollEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)discoverPollEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$discoverPollEndpoint$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$discoverPollEndpoint$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecuteCommandResponse> executeCommand(ExecuteCommandRequest executeCommandRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeCommandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, executeCommandRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteCommand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteCommandResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteCommand").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExecuteCommandRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)executeCommandRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$executeCommand$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$executeCommand$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTaskProtectionResponse> getTaskProtection(GetTaskProtectionRequest getTaskProtectionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaskProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, getTaskProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaskProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaskProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaskProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTaskProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTaskProtectionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$getTaskProtection$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$getTaskProtection$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccountSettingsResponse> listAccountSettings(ListAccountSettingsRequest listAccountSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAccountSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listAccountSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAccountSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listAccountSettings$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listAccountSettings$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAttributesResponse> listAttributes(ListAttributesRequest listAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listAttributes$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listAttributes$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listClusters$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listClusters$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListContainerInstancesResponse> listContainerInstances(ListContainerInstancesRequest listContainerInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContainerInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listContainerInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContainerInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContainerInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContainerInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListContainerInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listContainerInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listContainerInstances$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listContainerInstances$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServiceDeploymentsResponse> listServiceDeployments(ListServiceDeploymentsRequest listServiceDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceDeploymentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceDeployments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServiceDeploymentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listServiceDeployments$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listServiceDeployments$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listServices$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listServices$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServicesByNamespaceResponse> listServicesByNamespace(ListServicesByNamespaceRequest listServicesByNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesByNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listServicesByNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServicesByNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesByNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServicesByNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServicesByNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServicesByNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listServicesByNamespace$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listServicesByNamespace$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listTagsForResource$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listTagsForResource$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTaskDefinitionFamiliesResponse> listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaskDefinitionFamiliesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listTaskDefinitionFamiliesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaskDefinitionFamilies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaskDefinitionFamiliesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaskDefinitionFamilies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTaskDefinitionFamiliesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTaskDefinitionFamiliesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listTaskDefinitionFamilies$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listTaskDefinitionFamilies$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTaskDefinitionsResponse> listTaskDefinitions(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaskDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listTaskDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaskDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaskDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaskDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTaskDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTaskDefinitionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listTaskDefinitions$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listTaskDefinitions$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTasksResponse> listTasks(ListTasksRequest listTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, listTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$listTasks$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$listTasks$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccountSettingResponse> putAccountSetting(PutAccountSettingRequest putAccountSettingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSettingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, putAccountSettingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSetting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSettingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSetting").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAccountSettingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccountSettingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$putAccountSetting$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$putAccountSetting$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccountSettingDefaultResponse> putAccountSettingDefault(PutAccountSettingDefaultRequest putAccountSettingDefaultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountSettingDefaultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, putAccountSettingDefaultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountSettingDefault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSettingDefaultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSettingDefault").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAccountSettingDefaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccountSettingDefaultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$putAccountSettingDefault$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$putAccountSettingDefault$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAttributesResponse> putAttributes(PutAttributesRequest putAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, putAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$putAttributes$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$putAttributes$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutClusterCapacityProvidersResponse> putClusterCapacityProviders(PutClusterCapacityProvidersRequest putClusterCapacityProvidersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putClusterCapacityProvidersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, putClusterCapacityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutClusterCapacityProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutClusterCapacityProvidersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutClusterCapacityProviders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutClusterCapacityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putClusterCapacityProvidersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$putClusterCapacityProviders$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$putClusterCapacityProviders$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterContainerInstanceResponse> registerContainerInstance(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerContainerInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, registerContainerInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterContainerInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterContainerInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterContainerInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterContainerInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerContainerInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$registerContainerInstance$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$registerContainerInstance$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterTaskDefinitionResponse> registerTaskDefinition(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerTaskDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, registerTaskDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterTaskDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterTaskDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterTaskDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterTaskDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerTaskDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$registerTaskDefinition$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$registerTaskDefinition$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RunTaskResponse> runTask(RunTaskRequest runTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)runTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, runTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RunTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RunTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RunTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RunTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)runTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$runTask$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$runTask$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartTaskResponse> startTask(StartTaskRequest startTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, startTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$startTask$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$startTask$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopServiceDeploymentResponse> stopServiceDeployment(StopServiceDeploymentRequest stopServiceDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopServiceDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, stopServiceDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopServiceDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopServiceDeploymentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopServiceDeployment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopServiceDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopServiceDeploymentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$stopServiceDeployment$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$stopServiceDeployment$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTaskResponse> stopTask(StopTaskRequest stopTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, stopTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$stopTask$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$stopTask$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SubmitAttachmentStateChangesResponse> submitAttachmentStateChanges(SubmitAttachmentStateChangesRequest submitAttachmentStateChangesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitAttachmentStateChangesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, submitAttachmentStateChangesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitAttachmentStateChanges");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitAttachmentStateChangesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitAttachmentStateChanges").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SubmitAttachmentStateChangesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)submitAttachmentStateChangesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$submitAttachmentStateChanges$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$submitAttachmentStateChanges$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SubmitContainerStateChangeResponse> submitContainerStateChange(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitContainerStateChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, submitContainerStateChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitContainerStateChange");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitContainerStateChangeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitContainerStateChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SubmitContainerStateChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)submitContainerStateChangeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$submitContainerStateChange$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$submitContainerStateChange$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SubmitTaskStateChangeResponse> submitTaskStateChange(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitTaskStateChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, submitTaskStateChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitTaskStateChange");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitTaskStateChangeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitTaskStateChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SubmitTaskStateChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)submitTaskStateChangeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$submitTaskStateChange$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$submitTaskStateChange$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$tagResource$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$tagResource$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$untagResource$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$untagResource$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCapacityProviderResponse> updateCapacityProvider(UpdateCapacityProviderRequest updateCapacityProviderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCapacityProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateCapacityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCapacityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCapacityProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCapacityProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCapacityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCapacityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateCapacityProvider$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateCapacityProvider$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateCluster$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateCluster$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateClusterSettingsResponse> updateClusterSettings(UpdateClusterSettingsRequest updateClusterSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateClusterSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateClusterSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateClusterSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateClusterSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateClusterSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateClusterSettings$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateClusterSettings$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContainerAgentResponse> updateContainerAgent(UpdateContainerAgentRequest updateContainerAgentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContainerAgentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateContainerAgentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerAgent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerAgentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerAgent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateContainerAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContainerAgentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateContainerAgent$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateContainerAgent$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContainerInstancesStateResponse> updateContainerInstancesState(UpdateContainerInstancesStateRequest updateContainerInstancesStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContainerInstancesStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateContainerInstancesStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerInstancesState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerInstancesStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerInstancesState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateContainerInstancesStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContainerInstancesStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateContainerInstancesState$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateContainerInstancesState$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateServiceResponse> updateService(UpdateServiceRequest updateServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateService$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateService$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateServicePrimaryTaskSetResponse> updateServicePrimaryTaskSet(UpdateServicePrimaryTaskSetRequest updateServicePrimaryTaskSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServicePrimaryTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateServicePrimaryTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServicePrimaryTaskSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServicePrimaryTaskSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServicePrimaryTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateServicePrimaryTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateServicePrimaryTaskSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateServicePrimaryTaskSet$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateServicePrimaryTaskSet$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTaskProtectionResponse> updateTaskProtection(UpdateTaskProtectionRequest updateTaskProtectionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTaskProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateTaskProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTaskProtection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTaskProtectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTaskProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTaskProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTaskProtectionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateTaskProtection$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateTaskProtection$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTaskSetResponse> updateTaskSet(UpdateTaskSetRequest updateTaskSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTaskSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcsAsyncClient.resolveMetricPublishers(clientConfiguration, updateTaskSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTaskSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTaskSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "BlockedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BlockedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BlockedException::builder).build());
                    }
                    case "TargetNotConnectedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
                    }
                    case "ClusterContainsServicesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsServicesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsServicesException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                    }
                    case "PlatformUnknownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformUnknownException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformUnknownException::builder).build());
                    }
                    case "UpdateInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UpdateInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpdateInProgressException::builder).build());
                    }
                    case "NamespaceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "ClusterContainsTasksException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsTasksException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsTasksException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "NoUpdateAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoUpdateAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoUpdateAvailableException::builder).build());
                    }
                    case "PlatformTaskDefinitionIncompatibilityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformTaskDefinitionIncompatibilityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformTaskDefinitionIncompatibilityException::builder).build());
                    }
                    case "MissingVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingVersionException::builder).build());
                    }
                    case "ClusterContainsContainerInstancesException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterContainsContainerInstancesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterContainsContainerInstancesException::builder).build());
                    }
                    case "ServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "TaskSetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskSetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskSetNotFoundException::builder).build());
                    }
                    case "AttributeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttributeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttributeLimitExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotActiveException::builder).build());
                    }
                    case "ServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                    }
                    case "TargetNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TargetNotFoundException::builder).build());
                    }
                    case "ServiceDeploymentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceDeploymentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceDeploymentNotFoundException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTaskSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTaskSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTaskSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcsAsyncClient.lambda$updateTaskSet$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcsAsyncClient.lambda$updateTaskSet$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public EcsAsyncWaiter waiter() {
        return EcsAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final EcsServiceClientConfiguration serviceClientConfiguration() {
        return new EcsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "ecs";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EcsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        EcsServiceClientConfigurationBuilder serviceConfigBuilder = new EcsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTaskSet$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTaskSet$238(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTaskSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTaskProtection$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTaskProtection$234(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTaskProtectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateServicePrimaryTaskSet$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServicePrimaryTaskSet$230(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateServicePrimaryTaskSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateService$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateService$226(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContainerInstancesState$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerInstancesState$222(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContainerInstancesStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContainerAgent$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerAgent$218(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContainerAgentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateClusterSettings$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateClusterSettings$214(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateClusterSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCluster$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$210(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCapacityProvider$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCapacityProvider$206(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCapacityProviderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$202(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$198(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$submitTaskStateChange$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitTaskStateChange$194(List metricPublishers, MetricCollector apiCallMetricCollector, SubmitTaskStateChangeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$submitContainerStateChange$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitContainerStateChange$190(List metricPublishers, MetricCollector apiCallMetricCollector, SubmitContainerStateChangeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$submitAttachmentStateChanges$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitAttachmentStateChanges$186(List metricPublishers, MetricCollector apiCallMetricCollector, SubmitAttachmentStateChangesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopTask$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTask$182(List metricPublishers, MetricCollector apiCallMetricCollector, StopTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopServiceDeployment$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopServiceDeployment$178(List metricPublishers, MetricCollector apiCallMetricCollector, StopServiceDeploymentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startTask$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTask$174(List metricPublishers, MetricCollector apiCallMetricCollector, StartTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$runTask$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$runTask$170(List metricPublishers, MetricCollector apiCallMetricCollector, RunTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerTaskDefinition$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerTaskDefinition$166(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterTaskDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerContainerInstance$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerContainerInstance$162(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterContainerInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putClusterCapacityProviders$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putClusterCapacityProviders$158(List metricPublishers, MetricCollector apiCallMetricCollector, PutClusterCapacityProvidersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAttributes$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAttributes$154(List metricPublishers, MetricCollector apiCallMetricCollector, PutAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccountSettingDefault$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSettingDefault$150(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccountSettingDefaultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccountSetting$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountSetting$146(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccountSettingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTasks$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTasks$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTaskDefinitions$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaskDefinitions$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListTaskDefinitionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTaskDefinitionFamilies$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaskDefinitionFamilies$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListTaskDefinitionFamiliesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServicesByNamespace$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServicesByNamespace$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListServicesByNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServices$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServiceDeployments$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceDeployments$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListServiceDeploymentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listContainerInstances$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContainerInstances$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListContainerInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listClusters$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$110(List metricPublishers, MetricCollector apiCallMetricCollector, ListClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAttributes$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttributes$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccountSettings$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccountSettings$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccountSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTaskProtection$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaskProtection$98(List metricPublishers, MetricCollector apiCallMetricCollector, GetTaskProtectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$executeCommand$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeCommand$94(List metricPublishers, MetricCollector apiCallMetricCollector, ExecuteCommandResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$discoverPollEndpoint$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverPollEndpoint$90(List metricPublishers, MetricCollector apiCallMetricCollector, DiscoverPollEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTasks$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTasks$86(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTaskSets$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTaskSets$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTaskSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTaskDefinition$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTaskDefinition$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTaskDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeServices$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServices$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeServiceRevisions$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceRevisions$70(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeServiceRevisionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeServiceDeployments$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceDeployments$66(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeServiceDeploymentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeContainerInstances$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContainerInstances$62(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeContainerInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusters$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCapacityProviders$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCapacityProviders$54(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCapacityProvidersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterTaskDefinition$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterTaskDefinition$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterTaskDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterContainerInstance$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterContainerInstance$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterContainerInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTaskSet$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTaskSet$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTaskSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTaskDefinitions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTaskDefinitions$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTaskDefinitionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteService$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteService$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCluster$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCapacityProvider$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCapacityProvider$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCapacityProviderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAttributes$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAttributes$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccountSetting$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccountSetting$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccountSettingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTaskSet$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTaskSet$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTaskSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createService$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createService$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCapacityProvider$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCapacityProvider$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCapacityProviderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

