/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest;
import software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse;

public class ListContainerInstancesIterable
implements SdkIterable<ListContainerInstancesResponse> {
    private final EcsClient client;
    private final ListContainerInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContainerInstancesIterable(EcsClient client, ListContainerInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContainerInstancesResponseFetcher();
    }

    public Iterator<ListContainerInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> containerInstanceArns() {
        Function<ListContainerInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerInstanceArns() != null) {
                return response.containerInstanceArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContainerInstancesResponseFetcher
    implements SyncPageFetcher<ListContainerInstancesResponse> {
        private ListContainerInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContainerInstancesResponse nextPage(ListContainerInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListContainerInstancesIterable.this.client.listContainerInstances(ListContainerInstancesIterable.this.firstRequest);
            }
            return ListContainerInstancesIterable.this.client.listContainerInstances((ListContainerInstancesRequest)((Object)ListContainerInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

