/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.DeploymentLifecycleHookStage;
import software.amazon.awssdk.services.ecs.model.DeploymentLifecycleHookStageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentLifecycleHook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentLifecycleHook> {
    private static final SdkField<String> HOOK_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hookTargetArn").getter(DeploymentLifecycleHook.getter(DeploymentLifecycleHook::hookTargetArn)).setter(DeploymentLifecycleHook.setter(Builder::hookTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hookTargetArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DeploymentLifecycleHook.getter(DeploymentLifecycleHook::roleArn)).setter(DeploymentLifecycleHook.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<String>> LIFECYCLE_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecycleStages").getter(DeploymentLifecycleHook.getter(DeploymentLifecycleHook::lifecycleStagesAsStrings)).setter(DeploymentLifecycleHook.setter(Builder::lifecycleStagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOK_TARGET_ARN_FIELD, ROLE_ARN_FIELD, LIFECYCLE_STAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentLifecycleHook.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hookTargetArn;
    private final String roleArn;
    private final List<String> lifecycleStages;

    private DeploymentLifecycleHook(BuilderImpl builder) {
        this.hookTargetArn = builder.hookTargetArn;
        this.roleArn = builder.roleArn;
        this.lifecycleStages = builder.lifecycleStages;
    }

    public final String hookTargetArn() {
        return this.hookTargetArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final List<DeploymentLifecycleHookStage> lifecycleStages() {
        return DeploymentLifecycleHookStageListCopier.copyStringToEnum(this.lifecycleStages);
    }

    public final boolean hasLifecycleStages() {
        return this.lifecycleStages != null && !(this.lifecycleStages instanceof SdkAutoConstructList);
    }

    public final List<String> lifecycleStagesAsStrings() {
        return this.lifecycleStages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hookTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleStages() ? this.lifecycleStagesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentLifecycleHook)) {
            return false;
        }
        DeploymentLifecycleHook other = (DeploymentLifecycleHook)obj;
        return Objects.equals(this.hookTargetArn(), other.hookTargetArn()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasLifecycleStages() == other.hasLifecycleStages() && Objects.equals(this.lifecycleStagesAsStrings(), other.lifecycleStagesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentLifecycleHook").add("HookTargetArn", (Object)this.hookTargetArn()).add("RoleArn", (Object)this.roleArn()).add("LifecycleStages", this.hasLifecycleStages() ? this.lifecycleStagesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hookTargetArn": {
                return Optional.ofNullable(clazz.cast(this.hookTargetArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "lifecycleStages": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStagesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hookTargetArn", HOOK_TARGET_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("lifecycleStages", LIFECYCLE_STAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentLifecycleHook, T> g) {
        return obj -> g.apply((DeploymentLifecycleHook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hookTargetArn;
        private String roleArn;
        private List<String> lifecycleStages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentLifecycleHook model) {
            this.hookTargetArn(model.hookTargetArn);
            this.roleArn(model.roleArn);
            this.lifecycleStagesWithStrings(model.lifecycleStages);
        }

        public final String getHookTargetArn() {
            return this.hookTargetArn;
        }

        public final void setHookTargetArn(String hookTargetArn) {
            this.hookTargetArn = hookTargetArn;
        }

        @Override
        public final Builder hookTargetArn(String hookTargetArn) {
            this.hookTargetArn = hookTargetArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getLifecycleStages() {
            if (this.lifecycleStages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleStages;
        }

        public final void setLifecycleStages(Collection<String> lifecycleStages) {
            this.lifecycleStages = DeploymentLifecycleHookStageListCopier.copy(lifecycleStages);
        }

        @Override
        public final Builder lifecycleStagesWithStrings(Collection<String> lifecycleStages) {
            this.lifecycleStages = DeploymentLifecycleHookStageListCopier.copy(lifecycleStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleStagesWithStrings(String ... lifecycleStages) {
            this.lifecycleStagesWithStrings(Arrays.asList(lifecycleStages));
            return this;
        }

        @Override
        public final Builder lifecycleStages(Collection<DeploymentLifecycleHookStage> lifecycleStages) {
            this.lifecycleStages = DeploymentLifecycleHookStageListCopier.copyEnumToString(lifecycleStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleStages(DeploymentLifecycleHookStage ... lifecycleStages) {
            this.lifecycleStages(Arrays.asList(lifecycleStages));
            return this;
        }

        public DeploymentLifecycleHook build() {
            return new DeploymentLifecycleHook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentLifecycleHook> {
        public Builder hookTargetArn(String var1);

        public Builder roleArn(String var1);

        public Builder lifecycleStagesWithStrings(Collection<String> var1);

        public Builder lifecycleStagesWithStrings(String ... var1);

        public Builder lifecycleStages(Collection<DeploymentLifecycleHookStage> var1);

        public Builder lifecycleStages(DeploymentLifecycleHookStage ... var1);
    }
}

