/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the execute command configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteCommandConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecuteCommandConfiguration.Builder, ExecuteCommandConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ExecuteCommandConfiguration::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> LOGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logging")
            .getter(getter(ExecuteCommandConfiguration::loggingAsString)).setter(setter(Builder::logging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<ExecuteCommandLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<ExecuteCommandLogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(ExecuteCommandConfiguration::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(ExecuteCommandLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            LOGGING_FIELD, LOG_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String logging;

    private final ExecuteCommandLogConfiguration logConfiguration;

    private ExecuteCommandConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.logging = builder.logging;
        this.logConfiguration = builder.logConfiguration;
    }

    /**
     * <p>
     * Specify an Key Management Service key ID to encrypt the data between the local client and the container.
     * </p>
     * 
     * @return Specify an Key Management Service key ID to encrypt the data between the local client and the container.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The log setting to use for redirecting logs for your execute command results. The following log settings are
     * available.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: The execute command session is not logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no logging
     * parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the
     * task definition, the output won't be logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
     * <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logging} will
     * return {@link ExecuteCommandLogging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #loggingAsString}.
     * </p>
     * 
     * @return The log setting to use for redirecting logs for your execute command results. The following log settings
     *         are available.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The execute command session is not logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no
     *         logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is
     *         configured in the task definition, the output won't be logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
     *         <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
     *         </p>
     *         </li>
     * @see ExecuteCommandLogging
     */
    public final ExecuteCommandLogging logging() {
        return ExecuteCommandLogging.fromValue(logging);
    }

    /**
     * <p>
     * The log setting to use for redirecting logs for your execute command results. The following log settings are
     * available.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: The execute command session is not logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no logging
     * parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the
     * task definition, the output won't be logged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
     * <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logging} will
     * return {@link ExecuteCommandLogging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #loggingAsString}.
     * </p>
     * 
     * @return The log setting to use for redirecting logs for your execute command results. The following log settings
     *         are available.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The execute command session is not logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no
     *         logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is
     *         configured in the task definition, the output won't be logged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
     *         <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
     *         </p>
     *         </li>
     * @see ExecuteCommandLogging
     */
    public final String loggingAsString() {
        return logging;
    }

    /**
     * <p>
     * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or
     * an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must be
     * provided.
     * </p>
     * 
     * @return The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch
     *         Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a
     *         <code>logConfiguration</code> must be provided.
     */
    public final ExecuteCommandLogConfiguration logConfiguration() {
        return logConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(loggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandConfiguration)) {
            return false;
        }
        ExecuteCommandConfiguration other = (ExecuteCommandConfiguration) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(loggingAsString(), other.loggingAsString())
                && Objects.equals(logConfiguration(), other.logConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteCommandConfiguration").add("KmsKeyId", kmsKeyId()).add("Logging", loggingAsString())
                .add("LogConfiguration", logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "logging":
            return Optional.ofNullable(clazz.cast(loggingAsString()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("logging", LOGGING_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandConfiguration, T> g) {
        return obj -> g.apply((ExecuteCommandConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecuteCommandConfiguration> {
        /**
         * <p>
         * Specify an Key Management Service key ID to encrypt the data between the local client and the container.
         * </p>
         * 
         * @param kmsKeyId
         *        Specify an Key Management Service key ID to encrypt the data between the local client and the
         *        container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The log setting to use for redirecting logs for your execute command results. The following log settings are
         * available.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: The execute command session is not logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no logging
         * parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the
         * task definition, the output won't be logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
         * <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
         * </p>
         * </li>
         * </ul>
         * 
         * @param logging
         *        The log setting to use for redirecting logs for your execute command results. The following log
         *        settings are available.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The execute command session is not logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no
         *        logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is
         *        configured in the task definition, the output won't be logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
         *        <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
         *        </p>
         *        </li>
         * @see ExecuteCommandLogging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecuteCommandLogging
         */
        Builder logging(String logging);

        /**
         * <p>
         * The log setting to use for redirecting logs for your execute command results. The following log settings are
         * available.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: The execute command session is not logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no logging
         * parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is configured in the
         * task definition, the output won't be logged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
         * <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
         * </p>
         * </li>
         * </ul>
         * 
         * @param logging
         *        The log setting to use for redirecting logs for your execute command results. The following log
         *        settings are available.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The execute command session is not logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task definition is used. If no
         *        logging parameter is specified, it defaults to this value. If no <code>awslogs</code> log driver is
         *        configured in the task definition, the output won't be logged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERRIDE</code>: Specify the logging details as a part of <code>logConfiguration</code>. If the
         *        <code>OVERRIDE</code> logging option is specified, the <code>logConfiguration</code> is required.
         *        </p>
         *        </li>
         * @see ExecuteCommandLogging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecuteCommandLogging
         */
        Builder logging(ExecuteCommandLogging logging);

        /**
         * <p>
         * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs
         * or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must
         * be provided.
         * </p>
         * 
         * @param logConfiguration
         *        The log configuration for the results of the execute command actions. The logs can be sent to
         *        CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a
         *        <code>logConfiguration</code> must be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(ExecuteCommandLogConfiguration logConfiguration);

        /**
         * <p>
         * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs
         * or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is specified, a <code>logConfiguration</code> must
         * be provided.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecuteCommandLogConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExecuteCommandLogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecuteCommandLogConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logConfiguration(ExecuteCommandLogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link ExecuteCommandLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(ExecuteCommandLogConfiguration)
         */
        default Builder logConfiguration(Consumer<ExecuteCommandLogConfiguration.Builder> logConfiguration) {
            return logConfiguration(ExecuteCommandLogConfiguration.builder().applyMutation(logConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String logging;

        private ExecuteCommandLogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandConfiguration model) {
            kmsKeyId(model.kmsKeyId);
            logging(model.logging);
            logConfiguration(model.logConfiguration);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLogging() {
            return logging;
        }

        public final void setLogging(String logging) {
            this.logging = logging;
        }

        @Override
        public final Builder logging(String logging) {
            this.logging = logging;
            return this;
        }

        @Override
        public final Builder logging(ExecuteCommandLogging logging) {
            this.logging(logging == null ? null : logging.toString());
            return this;
        }

        public final ExecuteCommandLogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(ExecuteCommandLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(ExecuteCommandLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        @Override
        public ExecuteCommandConfiguration build() {
            return new ExecuteCommandConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
