/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayRepositoryCredentials;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceAwsLogsConfiguration;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.Secret;
import software.amazon.awssdk.services.ecs.model.SecretListCopier;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpressGatewayContainer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpressGatewayContainer> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::image)).setter(ExpressGatewayContainer.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("containerPort").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::containerPort)).setter(ExpressGatewayContainer.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final SdkField<ExpressGatewayServiceAwsLogsConfiguration> AWS_LOGS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsLogsConfiguration").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::awsLogsConfiguration)).setter(ExpressGatewayContainer.setter(Builder::awsLogsConfiguration)).constructor(ExpressGatewayServiceAwsLogsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogsConfiguration").build()}).build();
    private static final SdkField<ExpressGatewayRepositoryCredentials> REPOSITORY_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryCredentials").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::repositoryCredentials)).setter(ExpressGatewayContainer.setter(Builder::repositoryCredentials)).constructor(ExpressGatewayRepositoryCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCredentials").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::command)).setter(ExpressGatewayContainer.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environment").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::environment)).setter(ExpressGatewayContainer.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secrets").getter(ExpressGatewayContainer.getter(ExpressGatewayContainer::secrets)).setter(ExpressGatewayContainer.setter(Builder::secrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, CONTAINER_PORT_FIELD, AWS_LOGS_CONFIGURATION_FIELD, REPOSITORY_CREDENTIALS_FIELD, COMMAND_FIELD, ENVIRONMENT_FIELD, SECRETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpressGatewayContainer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String image;
    private final Integer containerPort;
    private final ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration;
    private final ExpressGatewayRepositoryCredentials repositoryCredentials;
    private final List<String> command;
    private final List<KeyValuePair> environment;
    private final List<Secret> secrets;

    private ExpressGatewayContainer(BuilderImpl builder) {
        this.image = builder.image;
        this.containerPort = builder.containerPort;
        this.awsLogsConfiguration = builder.awsLogsConfiguration;
        this.repositoryCredentials = builder.repositoryCredentials;
        this.command = builder.command;
        this.environment = builder.environment;
        this.secrets = builder.secrets;
    }

    public final String image() {
        return this.image;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public final ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration() {
        return this.awsLogsConfiguration;
    }

    public final ExpressGatewayRepositoryCredentials repositoryCredentials() {
        return this.repositoryCredentials;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> environment() {
        return this.environment;
    }

    public final boolean hasSecrets() {
        return this.secrets != null && !(this.secrets instanceof SdkAutoConstructList);
    }

    public final List<Secret> secrets() {
        return this.secrets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecrets() ? this.secrets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressGatewayContainer)) {
            return false;
        }
        ExpressGatewayContainer other = (ExpressGatewayContainer)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.awsLogsConfiguration(), other.awsLogsConfiguration()) && Objects.equals(this.repositoryCredentials(), other.repositoryCredentials()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && this.hasSecrets() == other.hasSecrets() && Objects.equals(this.secrets(), other.secrets());
    }

    public final String toString() {
        return ToString.builder((String)"ExpressGatewayContainer").add("Image", (Object)this.image()).add("ContainerPort", (Object)this.containerPort()).add("AwsLogsConfiguration", (Object)this.awsLogsConfiguration()).add("RepositoryCredentials", (Object)this.repositoryCredentials()).add("Command", this.hasCommand() ? this.command() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("Secrets", this.hasSecrets() ? this.secrets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "awsLogsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.awsLogsConfiguration()));
            }
            case "repositoryCredentials": {
                return Optional.ofNullable(clazz.cast(this.repositoryCredentials()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "secrets": {
                return Optional.ofNullable(clazz.cast(this.secrets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("image", IMAGE_FIELD);
        map.put("containerPort", CONTAINER_PORT_FIELD);
        map.put("awsLogsConfiguration", AWS_LOGS_CONFIGURATION_FIELD);
        map.put("repositoryCredentials", REPOSITORY_CREDENTIALS_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("secrets", SECRETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressGatewayContainer, T> g) {
        return obj -> g.apply((ExpressGatewayContainer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private Integer containerPort;
        private ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration;
        private ExpressGatewayRepositoryCredentials repositoryCredentials;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressGatewayContainer model) {
            this.image(model.image);
            this.containerPort(model.containerPort);
            this.awsLogsConfiguration(model.awsLogsConfiguration);
            this.repositoryCredentials(model.repositoryCredentials);
            this.command(model.command);
            this.environment(model.environment);
            this.secrets(model.secrets);
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final ExpressGatewayServiceAwsLogsConfiguration.Builder getAwsLogsConfiguration() {
            return this.awsLogsConfiguration != null ? this.awsLogsConfiguration.toBuilder() : null;
        }

        public final void setAwsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration.BuilderImpl awsLogsConfiguration) {
            this.awsLogsConfiguration = awsLogsConfiguration != null ? awsLogsConfiguration.build() : null;
        }

        @Override
        public final Builder awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration awsLogsConfiguration) {
            this.awsLogsConfiguration = awsLogsConfiguration;
            return this;
        }

        public final ExpressGatewayRepositoryCredentials.Builder getRepositoryCredentials() {
            return this.repositoryCredentials != null ? this.repositoryCredentials.toBuilder() : null;
        }

        public final void setRepositoryCredentials(ExpressGatewayRepositoryCredentials.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        @Override
        public final Builder repositoryCredentials(ExpressGatewayRepositoryCredentials repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final List<KeyValuePair.Builder> getEnvironment() {
            List<KeyValuePair.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Secret.Builder> getSecrets() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.secrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret ... secrets) {
            this.secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder> ... secrets) {
            this.secrets(Stream.of(secrets).map(c -> (Secret)((Secret.Builder)Secret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExpressGatewayContainer build() {
            return new ExpressGatewayContainer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpressGatewayContainer> {
        public Builder image(String var1);

        public Builder containerPort(Integer var1);

        public Builder awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfiguration var1);

        default public Builder awsLogsConfiguration(Consumer<ExpressGatewayServiceAwsLogsConfiguration.Builder> awsLogsConfiguration) {
            return this.awsLogsConfiguration((ExpressGatewayServiceAwsLogsConfiguration)((ExpressGatewayServiceAwsLogsConfiguration.Builder)ExpressGatewayServiceAwsLogsConfiguration.builder().applyMutation(awsLogsConfiguration)).build());
        }

        public Builder repositoryCredentials(ExpressGatewayRepositoryCredentials var1);

        default public Builder repositoryCredentials(Consumer<ExpressGatewayRepositoryCredentials.Builder> repositoryCredentials) {
            return this.repositoryCredentials((ExpressGatewayRepositoryCredentials)((ExpressGatewayRepositoryCredentials.Builder)ExpressGatewayRepositoryCredentials.builder().applyMutation(repositoryCredentials)).build());
        }

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder secrets(Collection<Secret> var1);

        public Builder secrets(Secret ... var1);

        public Builder secrets(Consumer<Secret.Builder> ... var1);
    }
}

