/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a Amazon ECS Managed Instances provider. Amazon ECS uses this configuration to automatically
 * launch, manage, and terminate Amazon EC2 instances on your behalf. Managed instances provide access to the full range
 * of Amazon EC2 instance types and features while offloading infrastructure management to Amazon Web Services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedInstancesProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedInstancesProvider.Builder, ManagedInstancesProvider> {
    private static final SdkField<String> INFRASTRUCTURE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("infrastructureRoleArn").getter(getter(ManagedInstancesProvider::infrastructureRoleArn))
            .setter(setter(Builder::infrastructureRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureRoleArn").build())
            .build();

    private static final SdkField<InstanceLaunchTemplate> INSTANCE_LAUNCH_TEMPLATE_FIELD = SdkField
            .<InstanceLaunchTemplate> builder(MarshallingType.SDK_POJO).memberName("instanceLaunchTemplate")
            .getter(getter(ManagedInstancesProvider::instanceLaunchTemplate)).setter(setter(Builder::instanceLaunchTemplate))
            .constructor(InstanceLaunchTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceLaunchTemplate").build())
            .build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propagateTags").getter(getter(ManagedInstancesProvider::propagateTagsAsString))
            .setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final SdkField<InfrastructureOptimization> INFRASTRUCTURE_OPTIMIZATION_FIELD = SdkField
            .<InfrastructureOptimization> builder(MarshallingType.SDK_POJO)
            .memberName("infrastructureOptimization")
            .getter(getter(ManagedInstancesProvider::infrastructureOptimization))
            .setter(setter(Builder::infrastructureOptimization))
            .constructor(InfrastructureOptimization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureOptimization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFRASTRUCTURE_ROLE_ARN_FIELD,
            INSTANCE_LAUNCH_TEMPLATE_FIELD, PROPAGATE_TAGS_FIELD, INFRASTRUCTURE_OPTIMIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String infrastructureRoleArn;

    private final InstanceLaunchTemplate instanceLaunchTemplate;

    private final String propagateTags;

    private final InfrastructureOptimization infrastructureOptimization;

    private ManagedInstancesProvider(BuilderImpl builder) {
        this.infrastructureRoleArn = builder.infrastructureRoleArn;
        this.instanceLaunchTemplate = builder.instanceLaunchTemplate;
        this.propagateTags = builder.propagateTags;
        this.infrastructureOptimization = builder.infrastructureOptimization;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure role that Amazon ECS assumes to manage instances. This role
     * must include permissions for Amazon EC2 instance lifecycle management, networking, and any additional Amazon Web
     * Services services required for your workloads.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon ECS
     * infrastructure IAM role</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure role that Amazon ECS assumes to manage instances.
     *         This role must include permissions for Amazon EC2 instance lifecycle management, networking, and any
     *         additional Amazon Web Services services required for your workloads.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon
     *         ECS infrastructure IAM role</a> in the <i>Amazon ECS Developer Guide</i>.
     */
    public final String infrastructureRoleArn() {
        return infrastructureRoleArn;
    }

    /**
     * <p>
     * The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This includes the instance
     * profile for your tasks, network and storage configuration, and instance requirements that determine which Amazon
     * EC2 instance types can be used.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch
     * parameters in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This includes the
     *         instance profile for your tasks, network and storage configuration, and instance requirements that
     *         determine which Amazon EC2 instance types can be used.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance
     *         launch parameters in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final InstanceLaunchTemplate instanceLaunchTemplate() {
        return instanceLaunchTemplate;
    }

    /**
     * <p>
     * Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed Instances.
     * This helps with cost allocation and resource management by ensuring consistent tagging across your
     * infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateMITags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed
     *         Instances. This helps with cost allocation and resource management by ensuring consistent tagging across
     *         your infrastructure.
     * @see PropagateMITags
     */
    public final PropagateMITags propagateTags() {
        return PropagateMITags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed Instances.
     * This helps with cost allocation and resource management by ensuring consistent tagging across your
     * infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateMITags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed
     *         Instances. This helps with cost allocation and resource management by ensuring consistent tagging across
     *         your infrastructure.
     * @see PropagateMITags
     */
    public final String propagateTagsAsString() {
        return propagateTags;
    }

    /**
     * <p>
     * Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider. Configure it
     * to turn on or off the infrastructure optimization in your capacity provider, and to control the idle or
     * underutilized EC2 instances optimization delay.
     * </p>
     * 
     * @return Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider.
     *         Configure it to turn on or off the infrastructure optimization in your capacity provider, and to control
     *         the idle or underutilized EC2 instances optimization delay.
     */
    public final InfrastructureOptimization infrastructureOptimization() {
        return infrastructureOptimization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureOptimization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedInstancesProvider)) {
            return false;
        }
        ManagedInstancesProvider other = (ManagedInstancesProvider) obj;
        return Objects.equals(infrastructureRoleArn(), other.infrastructureRoleArn())
                && Objects.equals(instanceLaunchTemplate(), other.instanceLaunchTemplate())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString())
                && Objects.equals(infrastructureOptimization(), other.infrastructureOptimization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedInstancesProvider").add("InfrastructureRoleArn", infrastructureRoleArn())
                .add("InstanceLaunchTemplate", instanceLaunchTemplate()).add("PropagateTags", propagateTagsAsString())
                .add("InfrastructureOptimization", infrastructureOptimization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "infrastructureRoleArn":
            return Optional.ofNullable(clazz.cast(infrastructureRoleArn()));
        case "instanceLaunchTemplate":
            return Optional.ofNullable(clazz.cast(instanceLaunchTemplate()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        case "infrastructureOptimization":
            return Optional.ofNullable(clazz.cast(infrastructureOptimization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("infrastructureRoleArn", INFRASTRUCTURE_ROLE_ARN_FIELD);
        map.put("instanceLaunchTemplate", INSTANCE_LAUNCH_TEMPLATE_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        map.put("infrastructureOptimization", INFRASTRUCTURE_OPTIMIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedInstancesProvider, T> g) {
        return obj -> g.apply((ManagedInstancesProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedInstancesProvider> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure role that Amazon ECS assumes to manage instances. This
         * role must include permissions for Amazon EC2 instance lifecycle management, networking, and any additional
         * Amazon Web Services services required for your workloads.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon ECS
         * infrastructure IAM role</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * 
         * @param infrastructureRoleArn
         *        The Amazon Resource Name (ARN) of the infrastructure role that Amazon ECS assumes to manage instances.
         *        This role must include permissions for Amazon EC2 instance lifecycle management, networking, and any
         *        additional Amazon Web Services services required for your workloads.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon
         *        ECS infrastructure IAM role</a> in the <i>Amazon ECS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureRoleArn(String infrastructureRoleArn);

        /**
         * <p>
         * The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This includes the
         * instance profile for your tasks, network and storage configuration, and instance requirements that determine
         * which Amazon EC2 instance types can be used.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch
         * parameters in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceLaunchTemplate
         *        The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This includes
         *        the instance profile for your tasks, network and storage configuration, and instance requirements that
         *        determine which Amazon EC2 instance types can be used.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance
         *        launch parameters in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceLaunchTemplate(InstanceLaunchTemplate instanceLaunchTemplate);

        /**
         * <p>
         * The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This includes the
         * instance profile for your tasks, network and storage configuration, and instance requirements that determine
         * which Amazon EC2 instance types can be used.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch
         * parameters in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceLaunchTemplate.Builder} avoiding
         * the need to create one manually via {@link InstanceLaunchTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceLaunchTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceLaunchTemplate(InstanceLaunchTemplate)}.
         * 
         * @param instanceLaunchTemplate
         *        a consumer that will call methods on {@link InstanceLaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceLaunchTemplate(InstanceLaunchTemplate)
         */
        default Builder instanceLaunchTemplate(Consumer<InstanceLaunchTemplate.Builder> instanceLaunchTemplate) {
            return instanceLaunchTemplate(InstanceLaunchTemplate.builder().applyMutation(instanceLaunchTemplate).build());
        }

        /**
         * <p>
         * Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed Instances.
         * This helps with cost allocation and resource management by ensuring consistent tagging across your
         * infrastructure.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed
         *        Instances. This helps with cost allocation and resource management by ensuring consistent tagging
         *        across your infrastructure.
         * @see PropagateMITags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateMITags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed Instances.
         * This helps with cost allocation and resource management by ensuring consistent tagging across your
         * infrastructure.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed
         *        Instances. This helps with cost allocation and resource management by ensuring consistent tagging
         *        across your infrastructure.
         * @see PropagateMITags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateMITags
         */
        Builder propagateTags(PropagateMITags propagateTags);

        /**
         * <p>
         * Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider. Configure
         * it to turn on or off the infrastructure optimization in your capacity provider, and to control the idle or
         * underutilized EC2 instances optimization delay.
         * </p>
         * 
         * @param infrastructureOptimization
         *        Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider.
         *        Configure it to turn on or off the infrastructure optimization in your capacity provider, and to
         *        control the idle or underutilized EC2 instances optimization delay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureOptimization(InfrastructureOptimization infrastructureOptimization);

        /**
         * <p>
         * Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider. Configure
         * it to turn on or off the infrastructure optimization in your capacity provider, and to control the idle or
         * underutilized EC2 instances optimization delay.
         * </p>
         * This is a convenience method that creates an instance of the {@link InfrastructureOptimization.Builder}
         * avoiding the need to create one manually via {@link InfrastructureOptimization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InfrastructureOptimization.Builder#build()} is called immediately
         * and its result is passed to {@link #infrastructureOptimization(InfrastructureOptimization)}.
         * 
         * @param infrastructureOptimization
         *        a consumer that will call methods on {@link InfrastructureOptimization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infrastructureOptimization(InfrastructureOptimization)
         */
        default Builder infrastructureOptimization(Consumer<InfrastructureOptimization.Builder> infrastructureOptimization) {
            return infrastructureOptimization(InfrastructureOptimization.builder().applyMutation(infrastructureOptimization)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String infrastructureRoleArn;

        private InstanceLaunchTemplate instanceLaunchTemplate;

        private String propagateTags;

        private InfrastructureOptimization infrastructureOptimization;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedInstancesProvider model) {
            infrastructureRoleArn(model.infrastructureRoleArn);
            instanceLaunchTemplate(model.instanceLaunchTemplate);
            propagateTags(model.propagateTags);
            infrastructureOptimization(model.infrastructureOptimization);
        }

        public final String getInfrastructureRoleArn() {
            return infrastructureRoleArn;
        }

        public final void setInfrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
        }

        @Override
        public final Builder infrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
            return this;
        }

        public final InstanceLaunchTemplate.Builder getInstanceLaunchTemplate() {
            return instanceLaunchTemplate != null ? instanceLaunchTemplate.toBuilder() : null;
        }

        public final void setInstanceLaunchTemplate(InstanceLaunchTemplate.BuilderImpl instanceLaunchTemplate) {
            this.instanceLaunchTemplate = instanceLaunchTemplate != null ? instanceLaunchTemplate.build() : null;
        }

        @Override
        public final Builder instanceLaunchTemplate(InstanceLaunchTemplate instanceLaunchTemplate) {
            this.instanceLaunchTemplate = instanceLaunchTemplate;
            return this;
        }

        public final String getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateMITags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final InfrastructureOptimization.Builder getInfrastructureOptimization() {
            return infrastructureOptimization != null ? infrastructureOptimization.toBuilder() : null;
        }

        public final void setInfrastructureOptimization(InfrastructureOptimization.BuilderImpl infrastructureOptimization) {
            this.infrastructureOptimization = infrastructureOptimization != null ? infrastructureOptimization.build() : null;
        }

        @Override
        public final Builder infrastructureOptimization(InfrastructureOptimization infrastructureOptimization) {
            this.infrastructureOptimization = infrastructureOptimization;
            return this;
        }

        @Override
        public ManagedInstancesProvider build() {
            return new ManagedInstancesProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
