/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum and maximum amount of memory per vCPU in gibibytes (GiB). This helps ensure that instance types have the
 * appropriate memory-to-CPU ratio for your workloads.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryGiBPerVCpuRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MemoryGiBPerVCpuRequest.Builder, MemoryGiBPerVCpuRequest> {
    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("min")
            .getter(getter(MemoryGiBPerVCpuRequest::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("max")
            .getter(getter(MemoryGiBPerVCpuRequest::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_FIELD, MAX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double min;

    private final Double max;

    private MemoryGiBPerVCpuRequest(BuilderImpl builder) {
        this.min = builder.min;
        this.max = builder.max;
    }

    /**
     * <p>
     * The minimum amount of memory per vCPU in GiB. Instance types with a lower memory-to-vCPU ratio are excluded from
     * selection.
     * </p>
     * 
     * @return The minimum amount of memory per vCPU in GiB. Instance types with a lower memory-to-vCPU ratio are
     *         excluded from selection.
     */
    public final Double min() {
        return min;
    }

    /**
     * <p>
     * The maximum amount of memory per vCPU in GiB. Instance types with a higher memory-to-vCPU ratio are excluded from
     * selection.
     * </p>
     * 
     * @return The maximum amount of memory per vCPU in GiB. Instance types with a higher memory-to-vCPU ratio are
     *         excluded from selection.
     */
    public final Double max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryGiBPerVCpuRequest)) {
            return false;
        }
        MemoryGiBPerVCpuRequest other = (MemoryGiBPerVCpuRequest) obj;
        return Objects.equals(min(), other.min()) && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemoryGiBPerVCpuRequest").add("Min", min()).add("Max", max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("min", MIN_FIELD);
        map.put("max", MAX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryGiBPerVCpuRequest, T> g) {
        return obj -> g.apply((MemoryGiBPerVCpuRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryGiBPerVCpuRequest> {
        /**
         * <p>
         * The minimum amount of memory per vCPU in GiB. Instance types with a lower memory-to-vCPU ratio are excluded
         * from selection.
         * </p>
         * 
         * @param min
         *        The minimum amount of memory per vCPU in GiB. Instance types with a lower memory-to-vCPU ratio are
         *        excluded from selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);

        /**
         * <p>
         * The maximum amount of memory per vCPU in GiB. Instance types with a higher memory-to-vCPU ratio are excluded
         * from selection.
         * </p>
         * 
         * @param max
         *        The maximum amount of memory per vCPU in GiB. Instance types with a higher memory-to-vCPU ratio are
         *        excluded from selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);
    }

    static final class BuilderImpl implements Builder {
        private Double min;

        private Double max;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryGiBPerVCpuRequest model) {
            min(model.min);
            max(model.max);
        }

        public final Double getMin() {
            return min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        @Override
        public MemoryGiBPerVCpuRequest build() {
            return new MemoryGiBPerVCpuRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
