/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The HTTP header rules used to identify and route test traffic during Amazon ECS blue/green deployments. These rules
 * specify which HTTP headers to examine and what values to match for routing decisions.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect-blue-green.html">Service Connect
 * for Amazon ECS blue/green deployments</a> in the <i> Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectTestTrafficHeaderRules implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectTestTrafficHeaderRules.Builder, ServiceConnectTestTrafficHeaderRules> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceConnectTestTrafficHeaderRules::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ServiceConnectTestTrafficHeaderMatchRules> VALUE_FIELD = SdkField
            .<ServiceConnectTestTrafficHeaderMatchRules> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(ServiceConnectTestTrafficHeaderRules::value)).setter(setter(Builder::value))
            .constructor(ServiceConnectTestTrafficHeaderMatchRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ServiceConnectTestTrafficHeaderMatchRules value;

    private ServiceConnectTestTrafficHeaderRules(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the HTTP header to examine for test traffic routing. Common examples include custom headers like
     * <code>X-Test-Version</code> or <code>X-Canary-Request</code> that can be used to identify test traffic.
     * </p>
     * 
     * @return The name of the HTTP header to examine for test traffic routing. Common examples include custom headers
     *         like <code>X-Test-Version</code> or <code>X-Canary-Request</code> that can be used to identify test
     *         traffic.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The header value matching configuration that determines how the HTTP header value is evaluated for test traffic
     * routing decisions.
     * </p>
     * 
     * @return The header value matching configuration that determines how the HTTP header value is evaluated for test
     *         traffic routing decisions.
     */
    public final ServiceConnectTestTrafficHeaderMatchRules value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectTestTrafficHeaderRules)) {
            return false;
        }
        ServiceConnectTestTrafficHeaderRules other = (ServiceConnectTestTrafficHeaderRules) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectTestTrafficHeaderRules").add("Name", name()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectTestTrafficHeaderRules, T> g) {
        return obj -> g.apply((ServiceConnectTestTrafficHeaderRules) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectTestTrafficHeaderRules> {
        /**
         * <p>
         * The name of the HTTP header to examine for test traffic routing. Common examples include custom headers like
         * <code>X-Test-Version</code> or <code>X-Canary-Request</code> that can be used to identify test traffic.
         * </p>
         * 
         * @param name
         *        The name of the HTTP header to examine for test traffic routing. Common examples include custom
         *        headers like <code>X-Test-Version</code> or <code>X-Canary-Request</code> that can be used to identify
         *        test traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The header value matching configuration that determines how the HTTP header value is evaluated for test
         * traffic routing decisions.
         * </p>
         * 
         * @param value
         *        The header value matching configuration that determines how the HTTP header value is evaluated for
         *        test traffic routing decisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(ServiceConnectTestTrafficHeaderMatchRules value);

        /**
         * <p>
         * The header value matching configuration that determines how the HTTP header value is evaluated for test
         * traffic routing decisions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceConnectTestTrafficHeaderMatchRules.Builder} avoiding the need to create one manually via
         * {@link ServiceConnectTestTrafficHeaderMatchRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectTestTrafficHeaderMatchRules.Builder#build()} is
         * called immediately and its result is passed to {@link #value(ServiceConnectTestTrafficHeaderMatchRules)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link ServiceConnectTestTrafficHeaderMatchRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(ServiceConnectTestTrafficHeaderMatchRules)
         */
        default Builder value(Consumer<ServiceConnectTestTrafficHeaderMatchRules.Builder> value) {
            return value(ServiceConnectTestTrafficHeaderMatchRules.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ServiceConnectTestTrafficHeaderMatchRules value;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectTestTrafficHeaderRules model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServiceConnectTestTrafficHeaderMatchRules.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(ServiceConnectTestTrafficHeaderMatchRules.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(ServiceConnectTestTrafficHeaderMatchRules value) {
            this.value = value;
            return this;
        }

        @Override
        public ServiceConnectTestTrafficHeaderRules build() {
            return new ServiceConnectTestTrafficHeaderRules(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
