/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the number of requested, pending, and running tasks for a service revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceRevisionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceRevisionSummary.Builder, ServiceRevisionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ServiceRevisionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> REQUESTED_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("requestedTaskCount").getter(getter(ServiceRevisionSummary::requestedTaskCount))
            .setter(setter(Builder::requestedTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTaskCount").build())
            .build();

    private static final SdkField<Integer> RUNNING_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("runningTaskCount").getter(getter(ServiceRevisionSummary::runningTaskCount))
            .setter(setter(Builder::runningTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTaskCount").build()).build();

    private static final SdkField<Integer> PENDING_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pendingTaskCount").getter(getter(ServiceRevisionSummary::pendingTaskCount))
            .setter(setter(Builder::pendingTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTaskCount").build()).build();

    private static final SdkField<Double> REQUESTED_TEST_TRAFFIC_WEIGHT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("requestedTestTrafficWeight")
            .getter(getter(ServiceRevisionSummary::requestedTestTrafficWeight))
            .setter(setter(Builder::requestedTestTrafficWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTestTrafficWeight").build())
            .build();

    private static final SdkField<Double> REQUESTED_PRODUCTION_TRAFFIC_WEIGHT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("requestedProductionTrafficWeight")
            .getter(getter(ServiceRevisionSummary::requestedProductionTrafficWeight))
            .setter(setter(Builder::requestedProductionTrafficWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedProductionTrafficWeight")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            REQUESTED_TASK_COUNT_FIELD, RUNNING_TASK_COUNT_FIELD, PENDING_TASK_COUNT_FIELD, REQUESTED_TEST_TRAFFIC_WEIGHT_FIELD,
            REQUESTED_PRODUCTION_TRAFFIC_WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Integer requestedTaskCount;

    private final Integer runningTaskCount;

    private final Integer pendingTaskCount;

    private final Double requestedTestTrafficWeight;

    private final Double requestedProductionTrafficWeight;

    private ServiceRevisionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.requestedTaskCount = builder.requestedTaskCount;
        this.runningTaskCount = builder.runningTaskCount;
        this.pendingTaskCount = builder.pendingTaskCount;
        this.requestedTestTrafficWeight = builder.requestedTestTrafficWeight;
        this.requestedProductionTrafficWeight = builder.requestedProductionTrafficWeight;
    }

    /**
     * <p>
     * The ARN of the service revision.
     * </p>
     * 
     * @return The ARN of the service revision.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of requested tasks for the service revision.
     * </p>
     * 
     * @return The number of requested tasks for the service revision.
     */
    public final Integer requestedTaskCount() {
        return requestedTaskCount;
    }

    /**
     * <p>
     * The number of running tasks for the service revision.
     * </p>
     * 
     * @return The number of running tasks for the service revision.
     */
    public final Integer runningTaskCount() {
        return runningTaskCount;
    }

    /**
     * <p>
     * The number of pending tasks for the service revision.
     * </p>
     * 
     * @return The number of pending tasks for the service revision.
     */
    public final Integer pendingTaskCount() {
        return pendingTaskCount;
    }

    /**
     * <p>
     * The percentage of test traffic that is directed to this service revision. This value represents a snapshot of the
     * traffic distribution and may not reflect real-time changes during active deployments. Valid values are 0.0 to
     * 100.0.
     * </p>
     * 
     * @return The percentage of test traffic that is directed to this service revision. This value represents a
     *         snapshot of the traffic distribution and may not reflect real-time changes during active deployments.
     *         Valid values are 0.0 to 100.0.
     */
    public final Double requestedTestTrafficWeight() {
        return requestedTestTrafficWeight;
    }

    /**
     * <p>
     * The percentage of production traffic that is directed to this service revision. This value represents a snapshot
     * of the traffic distribution and may not reflect real-time changes during active deployments. Valid values are 0.0
     * to 100.0.
     * </p>
     * 
     * @return The percentage of production traffic that is directed to this service revision. This value represents a
     *         snapshot of the traffic distribution and may not reflect real-time changes during active deployments.
     *         Valid values are 0.0 to 100.0.
     */
    public final Double requestedProductionTrafficWeight() {
        return requestedProductionTrafficWeight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(requestedTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(requestedTestTrafficWeight());
        hashCode = 31 * hashCode + Objects.hashCode(requestedProductionTrafficWeight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceRevisionSummary)) {
            return false;
        }
        ServiceRevisionSummary other = (ServiceRevisionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(requestedTaskCount(), other.requestedTaskCount())
                && Objects.equals(runningTaskCount(), other.runningTaskCount())
                && Objects.equals(pendingTaskCount(), other.pendingTaskCount())
                && Objects.equals(requestedTestTrafficWeight(), other.requestedTestTrafficWeight())
                && Objects.equals(requestedProductionTrafficWeight(), other.requestedProductionTrafficWeight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceRevisionSummary").add("Arn", arn()).add("RequestedTaskCount", requestedTaskCount())
                .add("RunningTaskCount", runningTaskCount()).add("PendingTaskCount", pendingTaskCount())
                .add("RequestedTestTrafficWeight", requestedTestTrafficWeight())
                .add("RequestedProductionTrafficWeight", requestedProductionTrafficWeight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "requestedTaskCount":
            return Optional.ofNullable(clazz.cast(requestedTaskCount()));
        case "runningTaskCount":
            return Optional.ofNullable(clazz.cast(runningTaskCount()));
        case "pendingTaskCount":
            return Optional.ofNullable(clazz.cast(pendingTaskCount()));
        case "requestedTestTrafficWeight":
            return Optional.ofNullable(clazz.cast(requestedTestTrafficWeight()));
        case "requestedProductionTrafficWeight":
            return Optional.ofNullable(clazz.cast(requestedProductionTrafficWeight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("requestedTaskCount", REQUESTED_TASK_COUNT_FIELD);
        map.put("runningTaskCount", RUNNING_TASK_COUNT_FIELD);
        map.put("pendingTaskCount", PENDING_TASK_COUNT_FIELD);
        map.put("requestedTestTrafficWeight", REQUESTED_TEST_TRAFFIC_WEIGHT_FIELD);
        map.put("requestedProductionTrafficWeight", REQUESTED_PRODUCTION_TRAFFIC_WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceRevisionSummary, T> g) {
        return obj -> g.apply((ServiceRevisionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceRevisionSummary> {
        /**
         * <p>
         * The ARN of the service revision.
         * </p>
         * 
         * @param arn
         *        The ARN of the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of requested tasks for the service revision.
         * </p>
         * 
         * @param requestedTaskCount
         *        The number of requested tasks for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedTaskCount(Integer requestedTaskCount);

        /**
         * <p>
         * The number of running tasks for the service revision.
         * </p>
         * 
         * @param runningTaskCount
         *        The number of running tasks for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningTaskCount(Integer runningTaskCount);

        /**
         * <p>
         * The number of pending tasks for the service revision.
         * </p>
         * 
         * @param pendingTaskCount
         *        The number of pending tasks for the service revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingTaskCount(Integer pendingTaskCount);

        /**
         * <p>
         * The percentage of test traffic that is directed to this service revision. This value represents a snapshot of
         * the traffic distribution and may not reflect real-time changes during active deployments. Valid values are
         * 0.0 to 100.0.
         * </p>
         * 
         * @param requestedTestTrafficWeight
         *        The percentage of test traffic that is directed to this service revision. This value represents a
         *        snapshot of the traffic distribution and may not reflect real-time changes during active deployments.
         *        Valid values are 0.0 to 100.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedTestTrafficWeight(Double requestedTestTrafficWeight);

        /**
         * <p>
         * The percentage of production traffic that is directed to this service revision. This value represents a
         * snapshot of the traffic distribution and may not reflect real-time changes during active deployments. Valid
         * values are 0.0 to 100.0.
         * </p>
         * 
         * @param requestedProductionTrafficWeight
         *        The percentage of production traffic that is directed to this service revision. This value represents
         *        a snapshot of the traffic distribution and may not reflect real-time changes during active
         *        deployments. Valid values are 0.0 to 100.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedProductionTrafficWeight(Double requestedProductionTrafficWeight);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Integer requestedTaskCount;

        private Integer runningTaskCount;

        private Integer pendingTaskCount;

        private Double requestedTestTrafficWeight;

        private Double requestedProductionTrafficWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceRevisionSummary model) {
            arn(model.arn);
            requestedTaskCount(model.requestedTaskCount);
            runningTaskCount(model.runningTaskCount);
            pendingTaskCount(model.pendingTaskCount);
            requestedTestTrafficWeight(model.requestedTestTrafficWeight);
            requestedProductionTrafficWeight(model.requestedProductionTrafficWeight);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getRequestedTaskCount() {
            return requestedTaskCount;
        }

        public final void setRequestedTaskCount(Integer requestedTaskCount) {
            this.requestedTaskCount = requestedTaskCount;
        }

        @Override
        public final Builder requestedTaskCount(Integer requestedTaskCount) {
            this.requestedTaskCount = requestedTaskCount;
            return this;
        }

        public final Integer getRunningTaskCount() {
            return runningTaskCount;
        }

        public final void setRunningTaskCount(Integer runningTaskCount) {
            this.runningTaskCount = runningTaskCount;
        }

        @Override
        public final Builder runningTaskCount(Integer runningTaskCount) {
            this.runningTaskCount = runningTaskCount;
            return this;
        }

        public final Integer getPendingTaskCount() {
            return pendingTaskCount;
        }

        public final void setPendingTaskCount(Integer pendingTaskCount) {
            this.pendingTaskCount = pendingTaskCount;
        }

        @Override
        public final Builder pendingTaskCount(Integer pendingTaskCount) {
            this.pendingTaskCount = pendingTaskCount;
            return this;
        }

        public final Double getRequestedTestTrafficWeight() {
            return requestedTestTrafficWeight;
        }

        public final void setRequestedTestTrafficWeight(Double requestedTestTrafficWeight) {
            this.requestedTestTrafficWeight = requestedTestTrafficWeight;
        }

        @Override
        public final Builder requestedTestTrafficWeight(Double requestedTestTrafficWeight) {
            this.requestedTestTrafficWeight = requestedTestTrafficWeight;
            return this;
        }

        public final Double getRequestedProductionTrafficWeight() {
            return requestedProductionTrafficWeight;
        }

        public final void setRequestedProductionTrafficWeight(Double requestedProductionTrafficWeight) {
            this.requestedProductionTrafficWeight = requestedProductionTrafficWeight;
        }

        @Override
        public final Builder requestedProductionTrafficWeight(Double requestedProductionTrafficWeight) {
            this.requestedProductionTrafficWeight = requestedProductionTrafficWeight;
            return this;
        }

        @Override
        public ServiceRevisionSummary build() {
            return new ServiceRevisionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
