/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ClusterSetting;
import software.amazon.awssdk.services.ecs.model.ClusterSettingsCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateClusterRequest.getter(CreateClusterRequest::settings)).setter(CreateClusterRequest.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, TAGS_FIELD, SETTINGS_FIELD));
    private final String clusterName;
    private final List<Tag> tags;
    private final List<ClusterSetting> settings;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.tags = builder.tags;
        this.settings = builder.settings;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<ClusterSetting> settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.settings(), other.settings());
    }

    public String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("Tags", this.tags()).add("Settings", this.settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.tags(model.tags);
            this.settings(model.settings);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<ClusterSetting.Builder> getSettings() {
            return this.settings != null ? (Collection)this.settings.stream().map(ClusterSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(ClusterSetting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (ClusterSetting)((ClusterSetting.Builder)ClusterSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder settings(Collection<ClusterSetting> var1);

        public Builder settings(ClusterSetting ... var1);

        public Builder settings(Consumer<ClusterSetting.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

