/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KernelCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KernelCapabilities> {
    private static final SdkField<List<String>> ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(KernelCapabilities.getter(KernelCapabilities::add)).setter(KernelCapabilities.setter(Builder::add)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("add").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DROP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(KernelCapabilities.getter(KernelCapabilities::drop)).setter(KernelCapabilities.setter(Builder::drop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drop").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_FIELD, DROP_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> add;
    private final List<String> drop;

    private KernelCapabilities(BuilderImpl builder) {
        this.add = builder.add;
        this.drop = builder.drop;
    }

    public List<String> add() {
        return this.add;
    }

    public List<String> drop() {
        return this.drop;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.add());
        hashCode = 31 * hashCode + Objects.hashCode(this.drop());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KernelCapabilities)) {
            return false;
        }
        KernelCapabilities other = (KernelCapabilities)obj;
        return Objects.equals(this.add(), other.add()) && Objects.equals(this.drop(), other.drop());
    }

    public String toString() {
        return ToString.builder((String)"KernelCapabilities").add("Add", this.add()).add("Drop", this.drop()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "add": {
                return Optional.ofNullable(clazz.cast(this.add()));
            }
            case "drop": {
                return Optional.ofNullable(clazz.cast(this.drop()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KernelCapabilities, T> g) {
        return obj -> g.apply((KernelCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> add = DefaultSdkAutoConstructList.getInstance();
        private List<String> drop = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KernelCapabilities model) {
            this.add(model.add);
            this.drop(model.drop);
        }

        public final Collection<String> getAdd() {
            return this.add;
        }

        @Override
        public final Builder add(Collection<String> add) {
            this.add = StringListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(String ... add) {
            this.add(Arrays.asList(add));
            return this;
        }

        public final void setAdd(Collection<String> add) {
            this.add = StringListCopier.copy(add);
        }

        public final Collection<String> getDrop() {
            return this.drop;
        }

        @Override
        public final Builder drop(Collection<String> drop) {
            this.drop = StringListCopier.copy(drop);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder drop(String ... drop) {
            this.drop(Arrays.asList(drop));
            return this;
        }

        public final void setDrop(Collection<String> drop) {
            this.drop = StringListCopier.copy(drop);
        }

        public KernelCapabilities build() {
            return new KernelCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KernelCapabilities> {
        public Builder add(Collection<String> var1);

        public Builder add(String ... var1);

        public Builder drop(Collection<String> var1);

        public Builder drop(String ... var1);
    }
}

