/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskOverride;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunTaskRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, RunTaskRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::cluster)).setter(RunTaskRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::taskDefinition)).setter(RunTaskRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<TaskOverride> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RunTaskRequest.getter(RunTaskRequest::overrides)).setter(RunTaskRequest.setter(Builder::overrides)).constructor(TaskOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RunTaskRequest.getter(RunTaskRequest::count)).setter(RunTaskRequest.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::startedBy)).setter(RunTaskRequest.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::group)).setter(RunTaskRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RunTaskRequest.getter(RunTaskRequest::placementConstraints)).setter(RunTaskRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RunTaskRequest.getter(RunTaskRequest::placementStrategy)).setter(RunTaskRequest.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::launchTypeAsString)).setter(RunTaskRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::platformVersion)).setter(RunTaskRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RunTaskRequest.getter(RunTaskRequest::networkConfiguration)).setter(RunTaskRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RunTaskRequest.getter(RunTaskRequest::tags)).setter(RunTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RunTaskRequest.getter(RunTaskRequest::enableECSManagedTags)).setter(RunTaskRequest.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunTaskRequest.getter(RunTaskRequest::propagateTagsAsString)).setter(RunTaskRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_DEFINITION_FIELD, OVERRIDES_FIELD, COUNT_FIELD, STARTED_BY_FIELD, GROUP_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, NETWORK_CONFIGURATION_FIELD, TAGS_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD));
    private final String cluster;
    private final String taskDefinition;
    private final TaskOverride overrides;
    private final Integer count;
    private final String startedBy;
    private final String group;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final String launchType;
    private final String platformVersion;
    private final NetworkConfiguration networkConfiguration;
    private final List<Tag> tags;
    private final Boolean enableECSManagedTags;
    private final String propagateTags;

    private RunTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.taskDefinition = builder.taskDefinition;
        this.overrides = builder.overrides;
        this.count = builder.count;
        this.startedBy = builder.startedBy;
        this.group = builder.group;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.networkConfiguration = builder.networkConfiguration;
        this.tags = builder.tags;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
    }

    public String cluster() {
        return this.cluster;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public TaskOverride overrides() {
        return this.overrides;
    }

    public Integer count() {
        return this.count;
    }

    public String startedBy() {
        return this.startedBy;
    }

    public String group() {
        return this.group;
    }

    public List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public String propagateTagsAsString() {
        return this.propagateTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunTaskRequest)) {
            return false;
        }
        RunTaskRequest other = (RunTaskRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString());
    }

    public String toString() {
        return ToString.builder((String)"RunTaskRequest").add("Cluster", (Object)this.cluster()).add("TaskDefinition", (Object)this.taskDefinition()).add("Overrides", (Object)this.overrides()).add("Count", (Object)this.count()).add("StartedBy", (Object)this.startedBy()).add("Group", (Object)this.group()).add("PlacementConstraints", this.placementConstraints()).add("PlacementStrategy", this.placementStrategy()).add("LaunchType", (Object)this.launchTypeAsString()).add("PlatformVersion", (Object)this.platformVersion()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Tags", this.tags()).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("PropagateTags", (Object)this.propagateTagsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunTaskRequest, T> g) {
        return obj -> g.apply((RunTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String taskDefinition;
        private TaskOverride overrides;
        private Integer count;
        private String startedBy;
        private String group;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private String launchType;
        private String platformVersion;
        private NetworkConfiguration networkConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableECSManagedTags;
        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(RunTaskRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.taskDefinition(model.taskDefinition);
            this.overrides(model.overrides);
            this.count(model.count);
            this.startedBy(model.startedBy);
            this.group(model.group);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.launchType(model.launchType);
            this.platformVersion(model.platformVersion);
            this.networkConfiguration(model.networkConfiguration);
            this.tags(model.tags);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.propagateTags(model.propagateTags);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final TaskOverride.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(TaskOverride overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(TaskOverride.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            return this.placementConstraints != null ? (Collection)this.placementConstraints.stream().map(PlacementConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            return this.placementStrategy != null ? (Collection)this.placementStrategy.stream().map(PlacementStrategy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final String getLaunchTypeAsString() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final String getPropagateTagsAsString() {
            return this.propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunTaskRequest build() {
            return new RunTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunTaskRequest> {
        public Builder cluster(String var1);

        public Builder taskDefinition(String var1);

        public Builder overrides(TaskOverride var1);

        default public Builder overrides(Consumer<TaskOverride.Builder> overrides) {
            return this.overrides((TaskOverride)((TaskOverride.Builder)TaskOverride.builder().applyMutation(overrides)).build());
        }

        public Builder count(Integer var1);

        public Builder startedBy(String var1);

        public Builder group(String var1);

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder platformVersion(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

