/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Deployment;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.DeploymentController;
import software.amazon.awssdk.services.ecs.model.DeploymentsCopier;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.SchedulingStrategy;
import software.amazon.awssdk.services.ecs.model.ServiceEvent;
import software.amazon.awssdk.services.ecs.model.ServiceEventsCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskSet;
import software.amazon.awssdk.services.ecs.model.TaskSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::serviceArn)).setter(Service.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::serviceName)).setter(Service.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::clusterArn)).setter(Service.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::loadBalancers)).setter(Service.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::serviceRegistries)).setter(Service.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::status)).setter(Service.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Service.getter(Service::desiredCount)).setter(Service.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<Integer> RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Service.getter(Service::runningCount)).setter(Service.setter(Builder::runningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()}).build();
    private static final SdkField<Integer> PENDING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Service.getter(Service::pendingCount)).setter(Service.setter(Builder::pendingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::launchTypeAsString)).setter(Service.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::platformVersion)).setter(Service.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::taskDefinition)).setter(Service.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Service.getter(Service::deploymentConfiguration)).setter(Service.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<List<TaskSet>> TASK_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::taskSets)).setter(Service.setter(Builder::taskSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Deployment>> DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::deployments)).setter(Service.setter(Builder::deployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Deployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::roleArn)).setter(Service.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<ServiceEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::events)).setter(Service.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Service.getter(Service::createdAt)).setter(Service.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::placementConstraints)).setter(Service.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::placementStrategy)).setter(Service.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Service.getter(Service::networkConfiguration)).setter(Service.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Service.getter(Service::healthCheckGracePeriodSeconds)).setter(Service.setter(Builder::healthCheckGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds").build()}).build();
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::schedulingStrategyAsString)).setter(Service.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build()}).build();
    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Service.getter(Service::deploymentController)).setter(Service.setter(Builder::deploymentController)).constructor(DeploymentController::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Service.getter(Service::tags)).setter(Service.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::createdBy)).setter(Service.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Service.getter(Service::enableECSManagedTags)).setter(Service.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Service.getter(Service::propagateTagsAsString)).setter(Service.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD, SERVICE_NAME_FIELD, CLUSTER_ARN_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, STATUS_FIELD, DESIRED_COUNT_FIELD, RUNNING_COUNT_FIELD, PENDING_COUNT_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD, TASK_DEFINITION_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, TASK_SETS_FIELD, DEPLOYMENTS_FIELD, ROLE_ARN_FIELD, EVENTS_FIELD, CREATED_AT_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD, CREATED_BY_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceArn;
    private final String serviceName;
    private final String clusterArn;
    private final List<LoadBalancer> loadBalancers;
    private final List<ServiceRegistry> serviceRegistries;
    private final String status;
    private final Integer desiredCount;
    private final Integer runningCount;
    private final Integer pendingCount;
    private final String launchType;
    private final String platformVersion;
    private final String taskDefinition;
    private final DeploymentConfiguration deploymentConfiguration;
    private final List<TaskSet> taskSets;
    private final List<Deployment> deployments;
    private final String roleArn;
    private final List<ServiceEvent> events;
    private final Instant createdAt;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final NetworkConfiguration networkConfiguration;
    private final Integer healthCheckGracePeriodSeconds;
    private final String schedulingStrategy;
    private final DeploymentController deploymentController;
    private final List<Tag> tags;
    private final String createdBy;
    private final Boolean enableECSManagedTags;
    private final String propagateTags;

    private Service(BuilderImpl builder) {
        this.serviceArn = builder.serviceArn;
        this.serviceName = builder.serviceName;
        this.clusterArn = builder.clusterArn;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.status = builder.status;
        this.desiredCount = builder.desiredCount;
        this.runningCount = builder.runningCount;
        this.pendingCount = builder.pendingCount;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.taskDefinition = builder.taskDefinition;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.taskSets = builder.taskSets;
        this.deployments = builder.deployments;
        this.roleArn = builder.roleArn;
        this.events = builder.events;
        this.createdAt = builder.createdAt;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.createdBy = builder.createdBy;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
    }

    public String serviceArn() {
        return this.serviceArn;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public String status() {
        return this.status;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public Integer runningCount() {
        return this.runningCount;
    }

    public Integer pendingCount() {
        return this.pendingCount;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String taskDefinition() {
        return this.taskDefinition;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public List<TaskSet> taskSets() {
        return this.taskSets;
    }

    public List<Deployment> deployments() {
        return this.deployments;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<ServiceEvent> events() {
        return this.events;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public Integer healthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    public SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    public DeploymentController deploymentController() {
        return this.deploymentController;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public String propagateTagsAsString() {
        return this.propagateTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRegistries());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployments());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.loadBalancers(), other.loadBalancers()) && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.runningCount(), other.runningCount()) && Objects.equals(this.pendingCount(), other.pendingCount()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.taskSets(), other.taskSets()) && Objects.equals(this.deployments(), other.deployments()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.events(), other.events()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds()) && Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString()) && Objects.equals(this.deploymentController(), other.deploymentController()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString());
    }

    public String toString() {
        return ToString.builder((String)"Service").add("ServiceArn", (Object)this.serviceArn()).add("ServiceName", (Object)this.serviceName()).add("ClusterArn", (Object)this.clusterArn()).add("LoadBalancers", this.loadBalancers()).add("ServiceRegistries", this.serviceRegistries()).add("Status", (Object)this.status()).add("DesiredCount", (Object)this.desiredCount()).add("RunningCount", (Object)this.runningCount()).add("PendingCount", (Object)this.pendingCount()).add("LaunchType", (Object)this.launchTypeAsString()).add("PlatformVersion", (Object)this.platformVersion()).add("TaskDefinition", (Object)this.taskDefinition()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("TaskSets", this.taskSets()).add("Deployments", this.deployments()).add("RoleArn", (Object)this.roleArn()).add("Events", this.events()).add("CreatedAt", (Object)this.createdAt()).add("PlacementConstraints", this.placementConstraints()).add("PlacementStrategy", this.placementStrategy()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("HealthCheckGracePeriodSeconds", (Object)this.healthCheckGracePeriodSeconds()).add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).add("DeploymentController", (Object)this.deploymentController()).add("Tags", this.tags()).add("CreatedBy", (Object)this.createdBy()).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("PropagateTags", (Object)this.propagateTagsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "runningCount": {
                return Optional.ofNullable(clazz.cast(this.runningCount()));
            }
            case "pendingCount": {
                return Optional.ofNullable(clazz.cast(this.pendingCount()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "taskSets": {
                return Optional.ofNullable(clazz.cast(this.taskSets()));
            }
            case "deployments": {
                return Optional.ofNullable(clazz.cast(this.deployments()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "healthCheckGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriodSeconds()));
            }
            case "schedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
            case "deploymentController": {
                return Optional.ofNullable(clazz.cast(this.deploymentController()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceArn;
        private String serviceName;
        private String clusterArn;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Integer desiredCount;
        private Integer runningCount;
        private Integer pendingCount;
        private String launchType;
        private String platformVersion;
        private String taskDefinition;
        private DeploymentConfiguration deploymentConfiguration;
        private List<TaskSet> taskSets = DefaultSdkAutoConstructList.getInstance();
        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private List<ServiceEvent> events = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private NetworkConfiguration networkConfiguration;
        private Integer healthCheckGracePeriodSeconds;
        private String schedulingStrategy;
        private DeploymentController deploymentController;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String createdBy;
        private Boolean enableECSManagedTags;
        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.serviceArn(model.serviceArn);
            this.serviceName(model.serviceName);
            this.clusterArn(model.clusterArn);
            this.loadBalancers(model.loadBalancers);
            this.serviceRegistries(model.serviceRegistries);
            this.status(model.status);
            this.desiredCount(model.desiredCount);
            this.runningCount(model.runningCount);
            this.pendingCount(model.pendingCount);
            this.launchType(model.launchType);
            this.platformVersion(model.platformVersion);
            this.taskDefinition(model.taskDefinition);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.taskSets(model.taskSets);
            this.deployments(model.deployments);
            this.roleArn(model.roleArn);
            this.events(model.events);
            this.createdAt(model.createdAt);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.networkConfiguration(model.networkConfiguration);
            this.healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            this.schedulingStrategy(model.schedulingStrategy);
            this.deploymentController(model.deploymentController);
            this.tags(model.tags);
            this.createdBy(model.createdBy);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.propagateTags(model.propagateTags);
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return this.loadBalancers != null ? (Collection)this.loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<ServiceRegistry.Builder> getServiceRegistries() {
            return this.serviceRegistries != null ? (Collection)this.serviceRegistries.stream().map(ServiceRegistry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final Integer getRunningCount() {
            return this.runningCount;
        }

        @Override
        public final Builder runningCount(Integer runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        public final Integer getPendingCount() {
            return this.pendingCount;
        }

        @Override
        public final Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final void setPendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
        }

        public final String getLaunchTypeAsString() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final Collection<TaskSet.Builder> getTaskSets() {
            return this.taskSets != null ? (Collection)this.taskSets.stream().map(TaskSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taskSets(Collection<TaskSet> taskSets) {
            this.taskSets = TaskSetsCopier.copy(taskSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(TaskSet ... taskSets) {
            this.taskSets(Arrays.asList(taskSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(Consumer<TaskSet.Builder> ... taskSets) {
            this.taskSets(Stream.of(taskSets).map(c -> (TaskSet)((TaskSet.Builder)TaskSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaskSets(Collection<TaskSet.BuilderImpl> taskSets) {
            this.taskSets = TaskSetsCopier.copyFromBuilder(taskSets);
        }

        public final Collection<Deployment.Builder> getDeployments() {
            return this.deployments != null ? (Collection)this.deployments.stream().map(Deployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder> ... deployments) {
            this.deployments(Stream.of(deployments).map(c -> (Deployment)((Deployment.Builder)Deployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<ServiceEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(ServiceEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<ServiceEvent> events) {
            this.events = ServiceEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ServiceEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ServiceEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (ServiceEvent)((ServiceEvent.Builder)ServiceEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<ServiceEvent.BuilderImpl> events) {
            this.events = ServiceEventsCopier.copyFromBuilder(events);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            return this.placementConstraints != null ? (Collection)this.placementConstraints.stream().map(PlacementConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            return this.placementStrategy != null ? (Collection)this.placementStrategy.stream().map(PlacementStrategy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return this.healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        public final String getSchedulingStrategyAsString() {
            return this.schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return this.deploymentController != null ? this.deploymentController.toBuilder() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final String getPropagateTagsAsString() {
            return this.propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder serviceArn(String var1);

        public Builder serviceName(String var1);

        public Builder clusterArn(String var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder status(String var1);

        public Builder desiredCount(Integer var1);

        public Builder runningCount(Integer var1);

        public Builder pendingCount(Integer var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder platformVersion(String var1);

        public Builder taskDefinition(String var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder taskSets(Collection<TaskSet> var1);

        public Builder taskSets(TaskSet ... var1);

        public Builder taskSets(Consumer<TaskSet.Builder> ... var1);

        public Builder deployments(Collection<Deployment> var1);

        public Builder deployments(Deployment ... var1);

        public Builder deployments(Consumer<Deployment.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder events(Collection<ServiceEvent> var1);

        public Builder events(ServiceEvent ... var1);

        public Builder events(Consumer<ServiceEvent.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder healthCheckGracePeriodSeconds(Integer var1);

        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(SchedulingStrategy var1);

        public Builder deploymentController(DeploymentController var1);

        default public Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return this.deploymentController((DeploymentController)((DeploymentController.Builder)DeploymentController.builder().applyMutation(deploymentController)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdBy(String var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);
    }
}

