/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskSetsRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeTaskSetsRequest.Builder, DescribeTaskSetsRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTaskSetsRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTaskSetsRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<List<String>> TASK_SETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTaskSetsRequest::taskSets))
            .setter(setter(Builder::taskSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD,
            TASK_SETS_FIELD));

    private final String cluster;

    private final String service;

    private final List<String> taskSets;

    private DescribeTaskSetsRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.taskSets = builder.taskSets;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist
     * in.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
     *         sets exist in.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.
     */
    public String service() {
        return service;
    }

    /**
     * <p>
     * The ID or full Amazon Resource Name (ARN) of task sets to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID or full Amazon Resource Name (ARN) of task sets to describe.
     */
    public List<String> taskSets() {
        return taskSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(taskSets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskSetsRequest)) {
            return false;
        }
        DescribeTaskSetsRequest other = (DescribeTaskSetsRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(service(), other.service())
                && Objects.equals(taskSets(), other.taskSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTaskSetsRequest").add("Cluster", cluster()).add("Service", service())
                .add("TaskSets", taskSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "taskSets":
            return Optional.ofNullable(clazz.cast(taskSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskSetsRequest, T> g) {
        return obj -> g.apply((DescribeTaskSetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTaskSetsRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets
         * exist in.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
         *        sets exist in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.
         * </p>
         * 
         * @param service
         *        The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The ID or full Amazon Resource Name (ARN) of task sets to describe.
         * </p>
         * 
         * @param taskSets
         *        The ID or full Amazon Resource Name (ARN) of task sets to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(Collection<String> taskSets);

        /**
         * <p>
         * The ID or full Amazon Resource Name (ARN) of task sets to describe.
         * </p>
         * 
         * @param taskSets
         *        The ID or full Amazon Resource Name (ARN) of task sets to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(String... taskSets);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String service;

        private List<String> taskSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskSetsRequest model) {
            super(model);
            cluster(model.cluster);
            service(model.service);
            taskSets(model.taskSets);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final Collection<String> getTaskSets() {
            return taskSets;
        }

        @Override
        public final Builder taskSets(Collection<String> taskSets) {
            this.taskSets = StringListCopier.copy(taskSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(String... taskSets) {
            taskSets(Arrays.asList(taskSets));
            return this;
        }

        public final void setTaskSets(Collection<String> taskSets) {
            this.taskSets = StringListCopier.copy(taskSets);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTaskSetsRequest build() {
            return new DescribeTaskSetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
